<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Getstk ServiceType
 * @subpackage Services
 */
class Getstk extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named getstkKoliMik
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetstkKoliMik $parameters
     * @return \StructType\GetstkKoliMikResponse|bool
     */
    public function getstkKoliMik(\StructType\GetstkKoliMik $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getstkKoliMik($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\GetstkKoliMikResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
