<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SetSipiptal StructType
 * @subpackage Structs
 */
class SetSipiptal extends AbstractStructBase
{
    /**
     * The SipNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SipNo;
    /**
     * The reference
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $reference;
    /**
     * Constructor method for SetSipiptal
     * @uses SetSipiptal::setSipNo()
     * @uses SetSipiptal::setReference()
     * @param string $sipNo
     * @param string $reference
     */
    public function __construct($sipNo = null, $reference = null)
    {
        $this
            ->setSipNo($sipNo)
            ->setReference($reference);
    }
    /**
     * Get SipNo value
     * @return string|null
     */
    public function getSipNo()
    {
        return $this->SipNo;
    }
    /**
     * Set SipNo value
     * @param string $sipNo
     * @return \StructType\SetSipiptal
     */
    public function setSipNo($sipNo = null)
    {
        // validation for constraint: string
        if (!is_null($sipNo) && !is_string($sipNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sipNo, true), gettype($sipNo)), __LINE__);
        }
        $this->SipNo = $sipNo;
        return $this;
    }
    /**
     * Get reference value
     * @return string|null
     */
    public function getReference()
    {
        return $this->reference;
    }
    /**
     * Set reference value
     * @param string $reference
     * @return \StructType\SetSipiptal
     */
    public function setReference($reference = null)
    {
        // validation for constraint: string
        if (!is_null($reference) && !is_string($reference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reference, true), gettype($reference)), __LINE__);
        }
        $this->reference = $reference;
        return $this;
    }
}
