<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Qeratacom ServiceType
 * @subpackage Services
 */
class Qeratacom extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named qeratacomXml
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\QeratacomXml $parameters
     * @return \StructType\QeratacomXmlResponse|bool
     */
    public function qeratacomXml(\StructType\QeratacomXml $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->qeratacomXml($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\QeratacomXmlResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
