<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Whatismyip ServiceType
 * @subpackage Services
 */
class Whatismyip extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named whatismyip
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Whatismyip $parameters
     * @return \StructType\WhatismyipResponse|bool
     */
    public function whatismyip(\StructType\Whatismyip $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->whatismyip($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\WhatismyipResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
