<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named getAllKoliTip
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetAllKoliTip $parameters
     * @return \StructType\GetAllKoliTipResponse|bool
     */
    public function getAllKoliTip(\StructType\GetAllKoliTip $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getAllKoliTip($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getStokKoli
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetStokKoli $parameters
     * @return \StructType\GetStokKoliResponse|bool
     */
    public function getStokKoli(\StructType\GetStokKoli $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getStokKoli($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getURTMarka
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetURTMarka $parameters
     * @return \StructType\GetURTMarkaResponse|bool
     */
    public function getURTMarka(\StructType\GetURTMarka $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getURTMarka($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getURTTip
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetURTTip $parameters
     * @return \StructType\GetURTTipResponse|bool
     */
    public function getURTTip(\StructType\GetURTTip $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getURTTip($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getStokGrup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetStokGrup $parameters
     * @return \StructType\GetStokGrupResponse|bool
     */
    public function getStokGrup(\StructType\GetStokGrup $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getStokGrup($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getStokTip
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetStokTip $parameters
     * @return \StructType\GetStokTipResponse|bool
     */
    public function getStokTip(\StructType\GetStokTip $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getStokTip($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetWebModulKategori
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetWebModulKategori $parameters
     * @return \StructType\GetWebModulKategoriResponse|bool
     */
    public function GetWebModulKategori(\StructType\GetWebModulKategori $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetWebModulKategori($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAllUlke
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetAllUlke $parameters
     * @return \StructType\GetAllUlkeResponse|bool
     */
    public function GetAllUlke(\StructType\GetAllUlke $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetAllUlke($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAllUlkeSehir
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetAllUlkeSehir $parameters
     * @return \StructType\GetAllUlkeSehirResponse|bool
     */
    public function GetAllUlkeSehir(\StructType\GetAllUlkeSehir $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetAllUlkeSehir($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAllUlkeSehirilce
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetAllUlkeSehirilce $parameters
     * @return \StructType\GetAllUlkeSehirilceResponse|bool
     */
    public function GetAllUlkeSehirilce(\StructType\GetAllUlkeSehirilce $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetAllUlkeSehirilce($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAllUlkeSehirilceSemt
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetAllUlkeSehirilceSemt $parameters
     * @return \StructType\GetAllUlkeSehirilceSemtResponse|bool
     */
    public function GetAllUlkeSehirilceSemt(\StructType\GetAllUlkeSehirilceSemt $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetAllUlkeSehirilceSemt($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getStokBarcodeS
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetStokBarcodeS $parameters
     * @return \StructType\GetStokBarcodeSResponse|bool
     */
    public function getStokBarcodeS(\StructType\GetStokBarcodeS $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getStokBarcodeS($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getKoliBarcodeS
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetKoliBarcodeS $parameters
     * @return \StructType\GetKoliBarcodeSResponse|bool
     */
    public function getKoliBarcodeS(\StructType\GetKoliBarcodeS $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getKoliBarcodeS($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAllRnkList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetAllRnkList $parameters
     * @return \StructType\GetAllRnkListResponse|bool
     */
    public function GetAllRnkList(\StructType\GetAllRnkList $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetAllRnkList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAllBdnList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetAllBdnList $parameters
     * @return \StructType\GetAllBdnListResponse|bool
     */
    public function GetAllBdnList(\StructType\GetAllBdnList $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetAllBdnList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAllMuafiyet
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetAllMuafiyet $parameters
     * @return \StructType\GetAllMuafiyetResponse|bool
     */
    public function GetAllMuafiyet(\StructType\GetAllMuafiyet $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetAllMuafiyet($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetWebStkMevDetail
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetWebStkMevDetail $parameters
     * @return \StructType\GetWebStkMevDetailResponse|bool
     */
    public function GetWebStkMevDetail(\StructType\GetWebStkMevDetail $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetWebStkMevDetail($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetWeb_Full_info_Stk_in_MevDet
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetWeb_Full_info_Stk_in_MevDet $parameters
     * @return \StructType\GetWeb_Full_info_Stk_in_MevDetResponse|bool
     */
    public function GetWeb_Full_info_Stk_in_MevDet(\StructType\GetWeb_Full_info_Stk_in_MevDet $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetWeb_Full_info_Stk_in_MevDet($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * GetWeb_Full_info_Stk_in_MevDet_LocDetail
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetWeb_Full_info_Stk_in_MevDet_LocDetail $parameters
     * @return \StructType\GetWeb_Full_info_Stk_in_MevDet_LocDetailResponse|bool
     */
    public function GetWeb_Full_info_Stk_in_MevDet_LocDetail(\StructType\GetWeb_Full_info_Stk_in_MevDet_LocDetail $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetWeb_Full_info_Stk_in_MevDet_LocDetail($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetWeb_Full_info_Stk
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetWeb_Full_info_Stk $parameters
     * @return \StructType\GetWeb_Full_info_StkResponse|bool
     */
    public function GetWeb_Full_info_Stk(\StructType\GetWeb_Full_info_Stk $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetWeb_Full_info_Stk($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetStokRnk
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetStokRnk $parameters
     * @return \StructType\GetStokRnkResponse|bool
     */
    public function GetStokRnk(\StructType\GetStokRnk $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetStokRnk($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetStokBdn
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetStokBdn $parameters
     * @return \StructType\GetStokBdnResponse|bool
     */
    public function GetStokBdn(\StructType\GetStokBdn $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetStokBdn($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetStokAsorti
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetStokAsorti $parameters
     * @return \StructType\GetStokAsortiResponse|bool
     */
    public function GetStokAsorti(\StructType\GetStokAsorti $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetStokAsorti($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetSatFiyTipList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetSatFiyTipList $parameters
     * @return \StructType\GetSatFiyTipListResponse|bool
     */
    public function GetSatFiyTipList(\StructType\GetSatFiyTipList $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetSatFiyTipList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetStokRnkBdn
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetStokRnkBdn $parameters
     * @return \StructType\GetStokRnkBdnResponse|bool
     */
    public function GetStokRnkBdn(\StructType\GetStokRnkBdn $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetStokRnkBdn($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetWebStkLocMevDetail
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetWebStkLocMevDetail $parameters
     * @return \StructType\GetWebStkLocMevDetailResponse|bool
     */
    public function GetWebStkLocMevDetail(\StructType\GetWebStkLocMevDetail $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetWebStkLocMevDetail($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetStokDocument
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetStokDocument $parameters
     * @return \StructType\GetStokDocumentResponse|bool
     */
    public function GetStokDocument(\StructType\GetStokDocument $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetStokDocument($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetWebPPStkLocMevDetail
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetWebPPStkLocMevDetail $parameters
     * @return \StructType\GetWebPPStkLocMevDetailResponse|bool
     */
    public function GetWebPPStkLocMevDetail(\StructType\GetWebPPStkLocMevDetail $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetWebPPStkLocMevDetail($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetStokResim
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetStokResim $parameters
     * @return \StructType\GetStokResimResponse|bool
     */
    public function GetStokResim(\StructType\GetStokResim $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetStokResim($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetWeb_UpToDate_MevDet
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetWeb_UpToDate_MevDet $parameters
     * @return \StructType\GetWeb_UpToDate_MevDetResponse|bool
     */
    public function GetWeb_UpToDate_MevDet(\StructType\GetWeb_UpToDate_MevDet $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetWeb_UpToDate_MevDet($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Get_Puan
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Get_Puan $parameters
     * @return \StructType\Get_PuanResponse|bool
     */
    public function Get_Puan(\StructType\Get_Puan $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->Get_Puan($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCariAdress
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCariAdress $parameters
     * @return \StructType\GetCariAdressResponse|bool
     */
    public function GetCariAdress(\StructType\GetCariAdress $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetCariAdress($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCariYetkili
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCariYetkili $parameters
     * @return \StructType\GetCariYetkiliResponse|bool
     */
    public function GetCariYetkili(\StructType\GetCariYetkili $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetCariYetkili($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCariEkstre
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCariEkstre $parameters
     * @return \StructType\GetCariEkstreResponse|bool
     */
    public function GetCariEkstre(\StructType\GetCariEkstre $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetCariEkstre($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetSipDurum
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetSipDurum $parameters
     * @return \StructType\GetSipDurumResponse|bool
     */
    public function GetSipDurum(\StructType\GetSipDurum $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetSipDurum($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetSipOzellik
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetSipOzellik $parameters
     * @return \StructType\GetSipOzellikResponse|bool
     */
    public function GetSipOzellik(\StructType\GetSipOzellik $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetSipOzellik($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetOdeSekil
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetOdeSekil $parameters
     * @return \StructType\GetOdeSekilResponse|bool
     */
    public function GetOdeSekil(\StructType\GetOdeSekil $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetOdeSekil($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAllFisOdeTip
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetAllFisOdeTip $parameters
     * @return \StructType\GetAllFisOdeTipResponse|bool
     */
    public function GetAllFisOdeTip(\StructType\GetAllFisOdeTip $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetAllFisOdeTip($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetKprFis
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetKprFis $parameters
     * @return \StructType\GetKprFisResponse|bool
     */
    public function GetKprFis(\StructType\GetKprFis $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetKprFis($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetIrsaliye
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetIrsaliye $parameters
     * @return \StructType\GetIrsaliyeResponse|bool
     */
    public function GetIrsaliye(\StructType\GetIrsaliye $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetIrsaliye($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetFatura
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetFatura $parameters
     * @return \StructType\GetFaturaResponse|bool
     */
    public function GetFatura(\StructType\GetFatura $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetFatura($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetDahili
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetDahili $parameters
     * @return \StructType\GetDahiliResponse|bool
     */
    public function GetDahili(\StructType\GetDahili $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetDahili($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetTamirHar
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetTamirHar $parameters
     * @return \StructType\GetTamirHarResponse|bool
     */
    public function GetTamirHar(\StructType\GetTamirHar $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetTamirHar($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetHC
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetHC $parameters
     * @return \StructType\GetHCResponse|bool
     */
    public function GetHC(\StructType\GetHC $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetHC($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetPerakende
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetPerakende $parameters
     * @return \StructType\GetPerakendeResponse|bool
     */
    public function GetPerakende(\StructType\GetPerakende $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetPerakende($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCari
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCari $parameters
     * @return \StructType\GetCariResponse|bool
     */
    public function GetCari(\StructType\GetCari $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetCari($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetSatFis
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetSatFis $parameters
     * @return \StructType\GetSatFisResponse|bool
     */
    public function GetSatFis(\StructType\GetSatFis $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetSatFis($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetMusteriKart
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetMusteriKart $parameters
     * @return \StructType\GetMusteriKartResponse|bool
     */
    public function GetMusteriKart(\StructType\GetMusteriKart $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetMusteriKart($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCurrencyByDate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCurrencyByDate $parameters
     * @return \StructType\GetCurrencyByDateResponse|bool
     */
    public function GetCurrencyByDate(\StructType\GetCurrencyByDate $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetCurrencyByDate($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetWebStkKart
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetWebStkKart $parameters
     * @return \StructType\GetWebStkKartResponse|bool
     */
    public function GetWebStkKart(\StructType\GetWebStkKart $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetWebStkKart($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\GetAllBdnListResponse|\StructType\GetAllFisOdeTipResponse|\StructType\GetAllKoliTipResponse|\StructType\GetAllMuafiyetResponse|\StructType\GetAllRnkListResponse|\StructType\GetAllUlkeResponse|\StructType\GetAllUlkeSehirilceResponse|\StructType\GetAllUlkeSehirilceSemtResponse|\StructType\GetAllUlkeSehirResponse|\StructType\GetCariAdressResponse|\StructType\GetCariEkstreResponse|\StructType\GetCariResponse|\StructType\GetCariYetkiliResponse|\StructType\GetCurrencyByDateResponse|\StructType\GetDahiliResponse|\StructType\GetFaturaResponse|\StructType\GetHCResponse|\StructType\GetIrsaliyeResponse|\StructType\GetKoliBarcodeSResponse|\StructType\GetKprFisResponse|\StructType\GetMusteriKartResponse|\StructType\GetOdeSekilResponse|\StructType\GetPerakendeResponse|\StructType\GetSatFisResponse|\StructType\GetSatFiyTipListResponse|\StructType\GetSipDurumResponse|\StructType\GetSipOzellikResponse|\StructType\GetStokAsortiResponse|\StructType\GetStokBarcodeSResponse|\StructType\GetStokBdnResponse|\StructType\GetStokDocumentResponse|\StructType\GetStokGrupResponse|\StructType\GetStokKoliResponse|\StructType\GetStokResimResponse|\StructType\GetStokRnkBdnResponse|\StructType\GetStokRnkResponse|\StructType\GetStokTipResponse|\StructType\GetTamirHarResponse|\StructType\GetURTMarkaResponse|\StructType\GetURTTipResponse|\StructType\GetWebModulKategoriResponse|\StructType\GetWebPPStkLocMevDetailResponse|\StructType\GetWebStkKartResponse|\StructType\GetWebStkLocMevDetailResponse|\StructType\GetWebStkMevDetailResponse|\StructType\GetWeb_Full_info_StkResponse|\StructType\GetWeb_Full_info_Stk_in_MevDetResponse|\StructType\GetWeb_Full_info_Stk_in_MevDet_LocDetailResponse|\StructType\GetWeb_UpToDate_MevDetResponse|\StructType\Get_PuanResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
