<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetMusteriKart StructType
 * @subpackage Structs
 */
class GetMusteriKart extends AbstractStructBase
{
    /**
     * The MKod
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MKod;
    /**
     * The TC
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TC;
    /**
     * Constructor method for GetMusteriKart
     * @uses GetMusteriKart::setMKod()
     * @uses GetMusteriKart::setTC()
     * @param string $mKod
     * @param string $tC
     */
    public function __construct($mKod = null, $tC = null)
    {
        $this
            ->setMKod($mKod)
            ->setTC($tC);
    }
    /**
     * Get MKod value
     * @return string|null
     */
    public function getMKod()
    {
        return $this->MKod;
    }
    /**
     * Set MKod value
     * @param string $mKod
     * @return \StructType\GetMusteriKart
     */
    public function setMKod($mKod = null)
    {
        // validation for constraint: string
        if (!is_null($mKod) && !is_string($mKod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mKod, true), gettype($mKod)), __LINE__);
        }
        $this->MKod = $mKod;
        return $this;
    }
    /**
     * Get TC value
     * @return string|null
     */
    public function getTC()
    {
        return $this->TC;
    }
    /**
     * Set TC value
     * @param string $tC
     * @return \StructType\GetMusteriKart
     */
    public function setTC($tC = null)
    {
        // validation for constraint: string
        if (!is_null($tC) && !is_string($tC)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tC, true), gettype($tC)), __LINE__);
        }
        $this->TC = $tC;
        return $this;
    }
}
