<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Veiculo StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Veiculo
 * @subpackage Structs
 */
class Veiculo extends AbstractStructBase
{
    /**
     * The CPFCNPJ
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CPFCNPJ;
    /**
     * The Municipio
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Municipio;
    /**
     * The MunicipioDescricao
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MunicipioDescricao;
    /**
     * The Placa
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Placa;
    /**
     * The Proprietario
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Proprietario;
    /**
     * The Renavam
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Renavam;
    /**
     * The UF
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UF;
    /**
     * Constructor method for Veiculo
     * @uses Veiculo::setCPFCNPJ()
     * @uses Veiculo::setMunicipio()
     * @uses Veiculo::setMunicipioDescricao()
     * @uses Veiculo::setPlaca()
     * @uses Veiculo::setProprietario()
     * @uses Veiculo::setRenavam()
     * @uses Veiculo::setUF()
     * @param string $cPFCNPJ
     * @param int $municipio
     * @param string $municipioDescricao
     * @param string $placa
     * @param string $proprietario
     * @param string $renavam
     * @param string $uF
     */
    public function __construct($cPFCNPJ = null, $municipio = null, $municipioDescricao = null, $placa = null, $proprietario = null, $renavam = null, $uF = null)
    {
        $this
            ->setCPFCNPJ($cPFCNPJ)
            ->setMunicipio($municipio)
            ->setMunicipioDescricao($municipioDescricao)
            ->setPlaca($placa)
            ->setProprietario($proprietario)
            ->setRenavam($renavam)
            ->setUF($uF);
    }
    /**
     * Get CPFCNPJ value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCPFCNPJ()
    {
        return isset($this->CPFCNPJ) ? $this->CPFCNPJ : null;
    }
    /**
     * Set CPFCNPJ value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cPFCNPJ
     * @return \StructType\Veiculo
     */
    public function setCPFCNPJ($cPFCNPJ = null)
    {
        // validation for constraint: string
        if (!is_null($cPFCNPJ) && !is_string($cPFCNPJ)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cPFCNPJ, true), gettype($cPFCNPJ)), __LINE__);
        }
        if (is_null($cPFCNPJ) || (is_array($cPFCNPJ) && empty($cPFCNPJ))) {
            unset($this->CPFCNPJ);
        } else {
            $this->CPFCNPJ = $cPFCNPJ;
        }
        return $this;
    }
    /**
     * Get Municipio value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMunicipio()
    {
        return isset($this->Municipio) ? $this->Municipio : null;
    }
    /**
     * Set Municipio value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $municipio
     * @return \StructType\Veiculo
     */
    public function setMunicipio($municipio = null)
    {
        // validation for constraint: int
        if (!is_null($municipio) && !(is_int($municipio) || ctype_digit($municipio))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($municipio, true), gettype($municipio)), __LINE__);
        }
        if (is_null($municipio) || (is_array($municipio) && empty($municipio))) {
            unset($this->Municipio);
        } else {
            $this->Municipio = $municipio;
        }
        return $this;
    }
    /**
     * Get MunicipioDescricao value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMunicipioDescricao()
    {
        return isset($this->MunicipioDescricao) ? $this->MunicipioDescricao : null;
    }
    /**
     * Set MunicipioDescricao value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $municipioDescricao
     * @return \StructType\Veiculo
     */
    public function setMunicipioDescricao($municipioDescricao = null)
    {
        // validation for constraint: string
        if (!is_null($municipioDescricao) && !is_string($municipioDescricao)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($municipioDescricao, true), gettype($municipioDescricao)), __LINE__);
        }
        if (is_null($municipioDescricao) || (is_array($municipioDescricao) && empty($municipioDescricao))) {
            unset($this->MunicipioDescricao);
        } else {
            $this->MunicipioDescricao = $municipioDescricao;
        }
        return $this;
    }
    /**
     * Get Placa value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPlaca()
    {
        return isset($this->Placa) ? $this->Placa : null;
    }
    /**
     * Set Placa value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $placa
     * @return \StructType\Veiculo
     */
    public function setPlaca($placa = null)
    {
        // validation for constraint: string
        if (!is_null($placa) && !is_string($placa)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($placa, true), gettype($placa)), __LINE__);
        }
        if (is_null($placa) || (is_array($placa) && empty($placa))) {
            unset($this->Placa);
        } else {
            $this->Placa = $placa;
        }
        return $this;
    }
    /**
     * Get Proprietario value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProprietario()
    {
        return isset($this->Proprietario) ? $this->Proprietario : null;
    }
    /**
     * Set Proprietario value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $proprietario
     * @return \StructType\Veiculo
     */
    public function setProprietario($proprietario = null)
    {
        // validation for constraint: string
        if (!is_null($proprietario) && !is_string($proprietario)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($proprietario, true), gettype($proprietario)), __LINE__);
        }
        if (is_null($proprietario) || (is_array($proprietario) && empty($proprietario))) {
            unset($this->Proprietario);
        } else {
            $this->Proprietario = $proprietario;
        }
        return $this;
    }
    /**
     * Get Renavam value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRenavam()
    {
        return isset($this->Renavam) ? $this->Renavam : null;
    }
    /**
     * Set Renavam value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $renavam
     * @return \StructType\Veiculo
     */
    public function setRenavam($renavam = null)
    {
        // validation for constraint: string
        if (!is_null($renavam) && !is_string($renavam)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($renavam, true), gettype($renavam)), __LINE__);
        }
        if (is_null($renavam) || (is_array($renavam) && empty($renavam))) {
            unset($this->Renavam);
        } else {
            $this->Renavam = $renavam;
        }
        return $this;
    }
    /**
     * Get UF value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUF()
    {
        return isset($this->UF) ? $this->UF : null;
    }
    /**
     * Set UF value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $uF
     * @return \StructType\Veiculo
     */
    public function setUF($uF = null)
    {
        // validation for constraint: string
        if (!is_null($uF) && !is_string($uF)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uF, true), gettype($uF)), __LINE__);
        }
        if (is_null($uF) || (is_array($uF) && empty($uF))) {
            unset($this->UF);
        } else {
            $this->UF = $uF;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Veiculo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
