<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ItemPagamentoMulta StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ItemPagamentoMulta
 * @subpackage Structs
 */
class ItemPagamentoMulta extends AbstractStructBase
{
    /**
     * The AIIP
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AIIP;
    /**
     * The CodigoOrgaoAutuador
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $CodigoOrgaoAutuador;
    /**
     * The CodigoReceitaInfracao
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $CodigoReceitaInfracao;
    /**
     * The DataInfracao
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DataInfracao;
    /**
     * The DescricaoEnquadramento
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DescricaoEnquadramento;
    /**
     * The Empresa
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Empresa;
    /**
     * The Enquadramento
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Enquadramento;
    /**
     * The Guia
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Guia;
    /**
     * The HoraInfracao
     * Meta information extracted from the WSDL
     * - base: xs:duration
     * - maxInclusive: P10675199DT2H48M5.4775807S
     * - minInclusive: -P10675199DT2H48M5.4775808S
     * - minOccurs: 0
     * - nillable: true
     * - pattern: \-?P(\d*D)?(T(\d*H)?(\d*M)?(\d*(\.\d*)?S)?)?
     * - type: tns:duration
     * @var string
     */
    public $HoraInfracao;
    /**
     * The LocalInfracao
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LocalInfracao;
    /**
     * The MunicipioInfracao
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MunicipioInfracao;
    /**
     * The Municipio_Id
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Municipio_Id;
    /**
     * The OrgaoAutuador
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OrgaoAutuador;
    /**
     * The Vencimento
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Vencimento;
    /**
     * Constructor method for ItemPagamentoMulta
     * @uses ItemPagamentoMulta::setAIIP()
     * @uses ItemPagamentoMulta::setCodigoOrgaoAutuador()
     * @uses ItemPagamentoMulta::setCodigoReceitaInfracao()
     * @uses ItemPagamentoMulta::setDataInfracao()
     * @uses ItemPagamentoMulta::setDescricaoEnquadramento()
     * @uses ItemPagamentoMulta::setEmpresa()
     * @uses ItemPagamentoMulta::setEnquadramento()
     * @uses ItemPagamentoMulta::setGuia()
     * @uses ItemPagamentoMulta::setHoraInfracao()
     * @uses ItemPagamentoMulta::setLocalInfracao()
     * @uses ItemPagamentoMulta::setMunicipioInfracao()
     * @uses ItemPagamentoMulta::setMunicipio_Id()
     * @uses ItemPagamentoMulta::setOrgaoAutuador()
     * @uses ItemPagamentoMulta::setVencimento()
     * @param string $aIIP
     * @param int $codigoOrgaoAutuador
     * @param int $codigoReceitaInfracao
     * @param string $dataInfracao
     * @param string $descricaoEnquadramento
     * @param int $empresa
     * @param int $enquadramento
     * @param int $guia
     * @param string $horaInfracao
     * @param string $localInfracao
     * @param string $municipioInfracao
     * @param int $municipio_Id
     * @param string $orgaoAutuador
     * @param string $vencimento
     */
    public function __construct($aIIP = null, $codigoOrgaoAutuador = null, $codigoReceitaInfracao = null, $dataInfracao = null, $descricaoEnquadramento = null, $empresa = null, $enquadramento = null, $guia = null, $horaInfracao = null, $localInfracao = null, $municipioInfracao = null, $municipio_Id = null, $orgaoAutuador = null, $vencimento = null)
    {
        $this
            ->setAIIP($aIIP)
            ->setCodigoOrgaoAutuador($codigoOrgaoAutuador)
            ->setCodigoReceitaInfracao($codigoReceitaInfracao)
            ->setDataInfracao($dataInfracao)
            ->setDescricaoEnquadramento($descricaoEnquadramento)
            ->setEmpresa($empresa)
            ->setEnquadramento($enquadramento)
            ->setGuia($guia)
            ->setHoraInfracao($horaInfracao)
            ->setLocalInfracao($localInfracao)
            ->setMunicipioInfracao($municipioInfracao)
            ->setMunicipio_Id($municipio_Id)
            ->setOrgaoAutuador($orgaoAutuador)
            ->setVencimento($vencimento);
    }
    /**
     * Get AIIP value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAIIP()
    {
        return isset($this->AIIP) ? $this->AIIP : null;
    }
    /**
     * Set AIIP value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $aIIP
     * @return \StructType\ItemPagamentoMulta
     */
    public function setAIIP($aIIP = null)
    {
        // validation for constraint: string
        if (!is_null($aIIP) && !is_string($aIIP)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aIIP, true), gettype($aIIP)), __LINE__);
        }
        if (is_null($aIIP) || (is_array($aIIP) && empty($aIIP))) {
            unset($this->AIIP);
        } else {
            $this->AIIP = $aIIP;
        }
        return $this;
    }
    /**
     * Get CodigoOrgaoAutuador value
     * @return int|null
     */
    public function getCodigoOrgaoAutuador()
    {
        return $this->CodigoOrgaoAutuador;
    }
    /**
     * Set CodigoOrgaoAutuador value
     * @param int $codigoOrgaoAutuador
     * @return \StructType\ItemPagamentoMulta
     */
    public function setCodigoOrgaoAutuador($codigoOrgaoAutuador = null)
    {
        // validation for constraint: int
        if (!is_null($codigoOrgaoAutuador) && !(is_int($codigoOrgaoAutuador) || ctype_digit($codigoOrgaoAutuador))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($codigoOrgaoAutuador, true), gettype($codigoOrgaoAutuador)), __LINE__);
        }
        $this->CodigoOrgaoAutuador = $codigoOrgaoAutuador;
        return $this;
    }
    /**
     * Get CodigoReceitaInfracao value
     * @return int|null
     */
    public function getCodigoReceitaInfracao()
    {
        return $this->CodigoReceitaInfracao;
    }
    /**
     * Set CodigoReceitaInfracao value
     * @param int $codigoReceitaInfracao
     * @return \StructType\ItemPagamentoMulta
     */
    public function setCodigoReceitaInfracao($codigoReceitaInfracao = null)
    {
        // validation for constraint: int
        if (!is_null($codigoReceitaInfracao) && !(is_int($codigoReceitaInfracao) || ctype_digit($codigoReceitaInfracao))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($codigoReceitaInfracao, true), gettype($codigoReceitaInfracao)), __LINE__);
        }
        $this->CodigoReceitaInfracao = $codigoReceitaInfracao;
        return $this;
    }
    /**
     * Get DataInfracao value
     * @return string|null
     */
    public function getDataInfracao()
    {
        return $this->DataInfracao;
    }
    /**
     * Set DataInfracao value
     * @param string $dataInfracao
     * @return \StructType\ItemPagamentoMulta
     */
    public function setDataInfracao($dataInfracao = null)
    {
        // validation for constraint: string
        if (!is_null($dataInfracao) && !is_string($dataInfracao)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dataInfracao, true), gettype($dataInfracao)), __LINE__);
        }
        $this->DataInfracao = $dataInfracao;
        return $this;
    }
    /**
     * Get DescricaoEnquadramento value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDescricaoEnquadramento()
    {
        return isset($this->DescricaoEnquadramento) ? $this->DescricaoEnquadramento : null;
    }
    /**
     * Set DescricaoEnquadramento value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $descricaoEnquadramento
     * @return \StructType\ItemPagamentoMulta
     */
    public function setDescricaoEnquadramento($descricaoEnquadramento = null)
    {
        // validation for constraint: string
        if (!is_null($descricaoEnquadramento) && !is_string($descricaoEnquadramento)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($descricaoEnquadramento, true), gettype($descricaoEnquadramento)), __LINE__);
        }
        if (is_null($descricaoEnquadramento) || (is_array($descricaoEnquadramento) && empty($descricaoEnquadramento))) {
            unset($this->DescricaoEnquadramento);
        } else {
            $this->DescricaoEnquadramento = $descricaoEnquadramento;
        }
        return $this;
    }
    /**
     * Get Empresa value
     * @return int|null
     */
    public function getEmpresa()
    {
        return $this->Empresa;
    }
    /**
     * Set Empresa value
     * @param int $empresa
     * @return \StructType\ItemPagamentoMulta
     */
    public function setEmpresa($empresa = null)
    {
        // validation for constraint: int
        if (!is_null($empresa) && !(is_int($empresa) || ctype_digit($empresa))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($empresa, true), gettype($empresa)), __LINE__);
        }
        $this->Empresa = $empresa;
        return $this;
    }
    /**
     * Get Enquadramento value
     * @return int|null
     */
    public function getEnquadramento()
    {
        return $this->Enquadramento;
    }
    /**
     * Set Enquadramento value
     * @param int $enquadramento
     * @return \StructType\ItemPagamentoMulta
     */
    public function setEnquadramento($enquadramento = null)
    {
        // validation for constraint: int
        if (!is_null($enquadramento) && !(is_int($enquadramento) || ctype_digit($enquadramento))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($enquadramento, true), gettype($enquadramento)), __LINE__);
        }
        $this->Enquadramento = $enquadramento;
        return $this;
    }
    /**
     * Get Guia value
     * @return int|null
     */
    public function getGuia()
    {
        return $this->Guia;
    }
    /**
     * Set Guia value
     * @param int $guia
     * @return \StructType\ItemPagamentoMulta
     */
    public function setGuia($guia = null)
    {
        // validation for constraint: int
        if (!is_null($guia) && !(is_int($guia) || ctype_digit($guia))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($guia, true), gettype($guia)), __LINE__);
        }
        $this->Guia = $guia;
        return $this;
    }
    /**
     * Get HoraInfracao value
     * @return string|null
     */
    public function getHoraInfracao()
    {
        return $this->HoraInfracao;
    }
    /**
     * Set HoraInfracao value
     * @param string $horaInfracao
     * @return \StructType\ItemPagamentoMulta
     */
    public function setHoraInfracao($horaInfracao = null)
    {
        // validation for constraint: string
        if (!is_null($horaInfracao) && !is_string($horaInfracao)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($horaInfracao, true), gettype($horaInfracao)), __LINE__);
        }
        // validation for constraint: maxInclusive(P10675199DT2H48M5.4775807S)
        if (!is_null($horaInfracao) && false === mb_strpos($horaInfracao, '-') && ($time = (string) time()) && \DateTime::createFromFormat('U', $time)->add(new \DateInterval(preg_replace('/(.*)(\.[0-9]*S)/', '$1S', str_replace('-', '', $horaInfracao)))) > \DateTime::createFromFormat('U', $time)->add(new \DateInterval(preg_replace('/(.*)(\.[0-9]*S)/', '$1S', 'P10675199DT2H48M5.4775807S')))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be chronologically less than or equal to P10675199DT2H48M5.4775807S', var_export($horaInfracao, true)), __LINE__);
        }
        // validation for constraint: minInclusive(-P10675199DT2H48M5.4775808S)
        if (!is_null($horaInfracao) && false !== mb_strpos($horaInfracao, '-') && ($time = (string) time()) && \DateTime::createFromFormat('U', $time)->sub(new \DateInterval(preg_replace('/(.*)(\.[0-9]*S)/', '$1S', str_replace('-', '', $horaInfracao)))) < \DateTime::createFromFormat('U', $time)->sub(new \DateInterval(preg_replace('/(.*)(\.[0-9]*S)/', '$1S', 'P10675199DT2H48M5.4775808S')))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be chronologically greater than or equal to -P10675199DT2H48M5.4775808S', var_export($horaInfracao, true)), __LINE__);
        }
        // validation for constraint: pattern(\-?P(\d*D)?(T(\d*H)?(\d*M)?(\d*(\.\d*)?S)?)?)
        if (!is_null($horaInfracao) && !preg_match('/\\-?P(\\d*D)?(T(\\d*H)?(\\d*M)?(\\d*(\\.\\d*)?S)?)?/', $horaInfracao)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \-?P(\d*D)?(T(\d*H)?(\d*M)?(\d*(\.\d*)?S)?)?', var_export($horaInfracao, true)), __LINE__);
        }
        $this->HoraInfracao = $horaInfracao;
        return $this;
    }
    /**
     * Get LocalInfracao value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLocalInfracao()
    {
        return isset($this->LocalInfracao) ? $this->LocalInfracao : null;
    }
    /**
     * Set LocalInfracao value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $localInfracao
     * @return \StructType\ItemPagamentoMulta
     */
    public function setLocalInfracao($localInfracao = null)
    {
        // validation for constraint: string
        if (!is_null($localInfracao) && !is_string($localInfracao)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($localInfracao, true), gettype($localInfracao)), __LINE__);
        }
        if (is_null($localInfracao) || (is_array($localInfracao) && empty($localInfracao))) {
            unset($this->LocalInfracao);
        } else {
            $this->LocalInfracao = $localInfracao;
        }
        return $this;
    }
    /**
     * Get MunicipioInfracao value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMunicipioInfracao()
    {
        return isset($this->MunicipioInfracao) ? $this->MunicipioInfracao : null;
    }
    /**
     * Set MunicipioInfracao value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $municipioInfracao
     * @return \StructType\ItemPagamentoMulta
     */
    public function setMunicipioInfracao($municipioInfracao = null)
    {
        // validation for constraint: string
        if (!is_null($municipioInfracao) && !is_string($municipioInfracao)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($municipioInfracao, true), gettype($municipioInfracao)), __LINE__);
        }
        if (is_null($municipioInfracao) || (is_array($municipioInfracao) && empty($municipioInfracao))) {
            unset($this->MunicipioInfracao);
        } else {
            $this->MunicipioInfracao = $municipioInfracao;
        }
        return $this;
    }
    /**
     * Get Municipio_Id value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMunicipio_Id()
    {
        return isset($this->Municipio_Id) ? $this->Municipio_Id : null;
    }
    /**
     * Set Municipio_Id value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $municipio_Id
     * @return \StructType\ItemPagamentoMulta
     */
    public function setMunicipio_Id($municipio_Id = null)
    {
        // validation for constraint: int
        if (!is_null($municipio_Id) && !(is_int($municipio_Id) || ctype_digit($municipio_Id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($municipio_Id, true), gettype($municipio_Id)), __LINE__);
        }
        if (is_null($municipio_Id) || (is_array($municipio_Id) && empty($municipio_Id))) {
            unset($this->Municipio_Id);
        } else {
            $this->Municipio_Id = $municipio_Id;
        }
        return $this;
    }
    /**
     * Get OrgaoAutuador value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrgaoAutuador()
    {
        return isset($this->OrgaoAutuador) ? $this->OrgaoAutuador : null;
    }
    /**
     * Set OrgaoAutuador value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $orgaoAutuador
     * @return \StructType\ItemPagamentoMulta
     */
    public function setOrgaoAutuador($orgaoAutuador = null)
    {
        // validation for constraint: string
        if (!is_null($orgaoAutuador) && !is_string($orgaoAutuador)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orgaoAutuador, true), gettype($orgaoAutuador)), __LINE__);
        }
        if (is_null($orgaoAutuador) || (is_array($orgaoAutuador) && empty($orgaoAutuador))) {
            unset($this->OrgaoAutuador);
        } else {
            $this->OrgaoAutuador = $orgaoAutuador;
        }
        return $this;
    }
    /**
     * Get Vencimento value
     * @return string|null
     */
    public function getVencimento()
    {
        return $this->Vencimento;
    }
    /**
     * Set Vencimento value
     * @param string $vencimento
     * @return \StructType\ItemPagamentoMulta
     */
    public function setVencimento($vencimento = null)
    {
        // validation for constraint: string
        if (!is_null($vencimento) && !is_string($vencimento)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vencimento, true), gettype($vencimento)), __LINE__);
        }
        $this->Vencimento = $vencimento;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ItemPagamentoMulta
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
