<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for IPVA StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:IPVA
 * @subpackage Structs
 */
class IPVA extends ItemPagamento
{
    /**
     * The Valor
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Valor;
    /**
     * The Vencimento
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Vencimento;
    /**
     * Constructor method for IPVA
     * @uses IPVA::setValor()
     * @uses IPVA::setVencimento()
     * @param int $valor
     * @param string $vencimento
     */
    public function __construct($valor = null, $vencimento = null)
    {
        $this
            ->setValor($valor)
            ->setVencimento($vencimento);
    }
    /**
     * Get Valor value
     * @return int|null
     */
    public function getValor()
    {
        return $this->Valor;
    }
    /**
     * Set Valor value
     * @param int $valor
     * @return \StructType\IPVA
     */
    public function setValor($valor = null)
    {
        // validation for constraint: int
        if (!is_null($valor) && !(is_int($valor) || ctype_digit($valor))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($valor, true), gettype($valor)), __LINE__);
        }
        $this->Valor = $valor;
        return $this;
    }
    /**
     * Get Vencimento value
     * @return string|null
     */
    public function getVencimento()
    {
        return $this->Vencimento;
    }
    /**
     * Set Vencimento value
     * @param string $vencimento
     * @return \StructType\IPVA
     */
    public function setVencimento($vencimento = null)
    {
        // validation for constraint: string
        if (!is_null($vencimento) && !is_string($vencimento)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vencimento, true), gettype($vencimento)), __LINE__);
        }
        $this->Vencimento = $vencimento;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\IPVA
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
