<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Debito StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Debito
 * @subpackage Structs
 */
class Debito extends DebitoBase
{
    /**
     * The DPVATs
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfDPVAT
     */
    public $DPVATs;
    /**
     * The IPVAs
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfIPVA
     */
    public $IPVAs;
    /**
     * The Multas
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfMulta
     */
    public $Multas;
    /**
     * Constructor method for Debito
     * @uses Debito::setDPVATs()
     * @uses Debito::setIPVAs()
     * @uses Debito::setMultas()
     * @param \ArrayType\ArrayOfDPVAT $dPVATs
     * @param \ArrayType\ArrayOfIPVA $iPVAs
     * @param \ArrayType\ArrayOfMulta $multas
     */
    public function __construct(\ArrayType\ArrayOfDPVAT $dPVATs = null, \ArrayType\ArrayOfIPVA $iPVAs = null, \ArrayType\ArrayOfMulta $multas = null)
    {
        $this
            ->setDPVATs($dPVATs)
            ->setIPVAs($iPVAs)
            ->setMultas($multas);
    }
    /**
     * Get DPVATs value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfDPVAT|null
     */
    public function getDPVATs()
    {
        return isset($this->DPVATs) ? $this->DPVATs : null;
    }
    /**
     * Set DPVATs value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfDPVAT $dPVATs
     * @return \StructType\Debito
     */
    public function setDPVATs(\ArrayType\ArrayOfDPVAT $dPVATs = null)
    {
        if (is_null($dPVATs) || (is_array($dPVATs) && empty($dPVATs))) {
            unset($this->DPVATs);
        } else {
            $this->DPVATs = $dPVATs;
        }
        return $this;
    }
    /**
     * Get IPVAs value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfIPVA|null
     */
    public function getIPVAs()
    {
        return isset($this->IPVAs) ? $this->IPVAs : null;
    }
    /**
     * Set IPVAs value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfIPVA $iPVAs
     * @return \StructType\Debito
     */
    public function setIPVAs(\ArrayType\ArrayOfIPVA $iPVAs = null)
    {
        if (is_null($iPVAs) || (is_array($iPVAs) && empty($iPVAs))) {
            unset($this->IPVAs);
        } else {
            $this->IPVAs = $iPVAs;
        }
        return $this;
    }
    /**
     * Get Multas value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfMulta|null
     */
    public function getMultas()
    {
        return isset($this->Multas) ? $this->Multas : null;
    }
    /**
     * Set Multas value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfMulta $multas
     * @return \StructType\Debito
     */
    public function setMultas(\ArrayType\ArrayOfMulta $multas = null)
    {
        if (is_null($multas) || (is_array($multas) && empty($multas))) {
            unset($this->Multas);
        } else {
            $this->Multas = $multas;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Debito
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
