<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DPVAT StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:DPVAT
 * @subpackage Structs
 */
class DPVAT extends AbstractStructBase
{
    /**
     * The Categoria
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Categoria;
    /**
     * The Exercicio
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Exercicio;
    /**
     * The IdentificacaoVeiculo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $IdentificacaoVeiculo;
    /**
     * The NumeroParcela
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $NumeroParcela;
    /**
     * The Valor
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Valor;
    /**
     * The Vencimento
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Vencimento;
    /**
     * Constructor method for DPVAT
     * @uses DPVAT::setCategoria()
     * @uses DPVAT::setExercicio()
     * @uses DPVAT::setIdentificacaoVeiculo()
     * @uses DPVAT::setNumeroParcela()
     * @uses DPVAT::setValor()
     * @uses DPVAT::setVencimento()
     * @param string $categoria
     * @param int $exercicio
     * @param string $identificacaoVeiculo
     * @param int $numeroParcela
     * @param int $valor
     * @param string $vencimento
     */
    public function __construct($categoria = null, $exercicio = null, $identificacaoVeiculo = null, $numeroParcela = null, $valor = null, $vencimento = null)
    {
        $this
            ->setCategoria($categoria)
            ->setExercicio($exercicio)
            ->setIdentificacaoVeiculo($identificacaoVeiculo)
            ->setNumeroParcela($numeroParcela)
            ->setValor($valor)
            ->setVencimento($vencimento);
    }
    /**
     * Get Categoria value
     * @return string|null
     */
    public function getCategoria()
    {
        return $this->Categoria;
    }
    /**
     * Set Categoria value
     * @uses \EnumType\CategoriaDPVAT::valueIsValid()
     * @uses \EnumType\CategoriaDPVAT::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $categoria
     * @return \StructType\DPVAT
     */
    public function setCategoria($categoria = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\CategoriaDPVAT::valueIsValid($categoria)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\CategoriaDPVAT', is_array($categoria) ? implode(', ', $categoria) : var_export($categoria, true), implode(', ', \EnumType\CategoriaDPVAT::getValidValues())), __LINE__);
        }
        $this->Categoria = $categoria;
        return $this;
    }
    /**
     * Get Exercicio value
     * @return int|null
     */
    public function getExercicio()
    {
        return $this->Exercicio;
    }
    /**
     * Set Exercicio value
     * @param int $exercicio
     * @return \StructType\DPVAT
     */
    public function setExercicio($exercicio = null)
    {
        // validation for constraint: int
        if (!is_null($exercicio) && !(is_int($exercicio) || ctype_digit($exercicio))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($exercicio, true), gettype($exercicio)), __LINE__);
        }
        $this->Exercicio = $exercicio;
        return $this;
    }
    /**
     * Get IdentificacaoVeiculo value
     * @return string|null
     */
    public function getIdentificacaoVeiculo()
    {
        return $this->IdentificacaoVeiculo;
    }
    /**
     * Set IdentificacaoVeiculo value
     * @uses \EnumType\IdentificacaoVeiculoDPVAT::valueIsValid()
     * @uses \EnumType\IdentificacaoVeiculoDPVAT::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $identificacaoVeiculo
     * @return \StructType\DPVAT
     */
    public function setIdentificacaoVeiculo($identificacaoVeiculo = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\IdentificacaoVeiculoDPVAT::valueIsValid($identificacaoVeiculo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\IdentificacaoVeiculoDPVAT', is_array($identificacaoVeiculo) ? implode(', ', $identificacaoVeiculo) : var_export($identificacaoVeiculo, true), implode(', ', \EnumType\IdentificacaoVeiculoDPVAT::getValidValues())), __LINE__);
        }
        $this->IdentificacaoVeiculo = $identificacaoVeiculo;
        return $this;
    }
    /**
     * Get NumeroParcela value
     * @return int|null
     */
    public function getNumeroParcela()
    {
        return $this->NumeroParcela;
    }
    /**
     * Set NumeroParcela value
     * @param int $numeroParcela
     * @return \StructType\DPVAT
     */
    public function setNumeroParcela($numeroParcela = null)
    {
        // validation for constraint: int
        if (!is_null($numeroParcela) && !(is_int($numeroParcela) || ctype_digit($numeroParcela))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numeroParcela, true), gettype($numeroParcela)), __LINE__);
        }
        $this->NumeroParcela = $numeroParcela;
        return $this;
    }
    /**
     * Get Valor value
     * @return int|null
     */
    public function getValor()
    {
        return $this->Valor;
    }
    /**
     * Set Valor value
     * @param int $valor
     * @return \StructType\DPVAT
     */
    public function setValor($valor = null)
    {
        // validation for constraint: int
        if (!is_null($valor) && !(is_int($valor) || ctype_digit($valor))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($valor, true), gettype($valor)), __LINE__);
        }
        $this->Valor = $valor;
        return $this;
    }
    /**
     * Get Vencimento value
     * @return string|null
     */
    public function getVencimento()
    {
        return $this->Vencimento;
    }
    /**
     * Set Vencimento value
     * @param string $vencimento
     * @return \StructType\DPVAT
     */
    public function setVencimento($vencimento = null)
    {
        // validation for constraint: string
        if (!is_null($vencimento) && !is_string($vencimento)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vencimento, true), gettype($vencimento)), __LINE__);
        }
        $this->Vencimento = $vencimento;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DPVAT
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
