<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ConsultaTaxasDETRAN StructType
 * @subpackage Structs
 */
class ConsultaTaxasDETRAN extends AbstractStructBase
{
    /**
     * The SubServico
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $SubServico;
    /**
     * The TrocaCheque
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $TrocaCheque;
    /**
     * The Chave
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Chave;
    /**
     * Constructor method for ConsultaTaxasDETRAN
     * @uses ConsultaTaxasDETRAN::setSubServico()
     * @uses ConsultaTaxasDETRAN::setTrocaCheque()
     * @uses ConsultaTaxasDETRAN::setChave()
     * @param int $subServico
     * @param bool $trocaCheque
     * @param string $chave
     */
    public function __construct($subServico = null, $trocaCheque = null, $chave = null)
    {
        $this
            ->setSubServico($subServico)
            ->setTrocaCheque($trocaCheque)
            ->setChave($chave);
    }
    /**
     * Get SubServico value
     * @return int|null
     */
    public function getSubServico()
    {
        return $this->SubServico;
    }
    /**
     * Set SubServico value
     * @param int $subServico
     * @return \StructType\ConsultaTaxasDETRAN
     */
    public function setSubServico($subServico = null)
    {
        // validation for constraint: int
        if (!is_null($subServico) && !(is_int($subServico) || ctype_digit($subServico))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($subServico, true), gettype($subServico)), __LINE__);
        }
        $this->SubServico = $subServico;
        return $this;
    }
    /**
     * Get TrocaCheque value
     * @return bool|null
     */
    public function getTrocaCheque()
    {
        return $this->TrocaCheque;
    }
    /**
     * Set TrocaCheque value
     * @param bool $trocaCheque
     * @return \StructType\ConsultaTaxasDETRAN
     */
    public function setTrocaCheque($trocaCheque = null)
    {
        // validation for constraint: boolean
        if (!is_null($trocaCheque) && !is_bool($trocaCheque)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($trocaCheque, true), gettype($trocaCheque)), __LINE__);
        }
        $this->TrocaCheque = $trocaCheque;
        return $this;
    }
    /**
     * Get Chave value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getChave()
    {
        return isset($this->Chave) ? $this->Chave : null;
    }
    /**
     * Set Chave value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $chave
     * @return \StructType\ConsultaTaxasDETRAN
     */
    public function setChave($chave = null)
    {
        // validation for constraint: string
        if (!is_null($chave) && !is_string($chave)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($chave, true), gettype($chave)), __LINE__);
        }
        if (is_null($chave) || (is_array($chave) && empty($chave))) {
            unset($this->Chave);
        } else {
            $this->Chave = $chave;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ConsultaTaxasDETRAN
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
