<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BuscarRecibosDTO StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:BuscarRecibosDTO
 * @subpackage Structs
 */
class BuscarRecibosDTO extends AbstractStructBase
{
    /**
     * The DataContabil
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DataContabil;
    /**
     * The Servico
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Servico;
    /**
     * The ServicoDescricao
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ServicoDescricao;
    /**
     * The URL
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $URL;
    /**
     * The Valor
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Valor;
    /**
     * Constructor method for BuscarRecibosDTO
     * @uses BuscarRecibosDTO::setDataContabil()
     * @uses BuscarRecibosDTO::setServico()
     * @uses BuscarRecibosDTO::setServicoDescricao()
     * @uses BuscarRecibosDTO::setURL()
     * @uses BuscarRecibosDTO::setValor()
     * @param string $dataContabil
     * @param int $servico
     * @param string $servicoDescricao
     * @param string $uRL
     * @param int $valor
     */
    public function __construct($dataContabil = null, $servico = null, $servicoDescricao = null, $uRL = null, $valor = null)
    {
        $this
            ->setDataContabil($dataContabil)
            ->setServico($servico)
            ->setServicoDescricao($servicoDescricao)
            ->setURL($uRL)
            ->setValor($valor);
    }
    /**
     * Get DataContabil value
     * @return string|null
     */
    public function getDataContabil()
    {
        return $this->DataContabil;
    }
    /**
     * Set DataContabil value
     * @param string $dataContabil
     * @return \StructType\BuscarRecibosDTO
     */
    public function setDataContabil($dataContabil = null)
    {
        // validation for constraint: string
        if (!is_null($dataContabil) && !is_string($dataContabil)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dataContabil, true), gettype($dataContabil)), __LINE__);
        }
        $this->DataContabil = $dataContabil;
        return $this;
    }
    /**
     * Get Servico value
     * @return int|null
     */
    public function getServico()
    {
        return $this->Servico;
    }
    /**
     * Set Servico value
     * @param int $servico
     * @return \StructType\BuscarRecibosDTO
     */
    public function setServico($servico = null)
    {
        // validation for constraint: int
        if (!is_null($servico) && !(is_int($servico) || ctype_digit($servico))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($servico, true), gettype($servico)), __LINE__);
        }
        $this->Servico = $servico;
        return $this;
    }
    /**
     * Get ServicoDescricao value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getServicoDescricao()
    {
        return isset($this->ServicoDescricao) ? $this->ServicoDescricao : null;
    }
    /**
     * Set ServicoDescricao value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $servicoDescricao
     * @return \StructType\BuscarRecibosDTO
     */
    public function setServicoDescricao($servicoDescricao = null)
    {
        // validation for constraint: string
        if (!is_null($servicoDescricao) && !is_string($servicoDescricao)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($servicoDescricao, true), gettype($servicoDescricao)), __LINE__);
        }
        if (is_null($servicoDescricao) || (is_array($servicoDescricao) && empty($servicoDescricao))) {
            unset($this->ServicoDescricao);
        } else {
            $this->ServicoDescricao = $servicoDescricao;
        }
        return $this;
    }
    /**
     * Get URL value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getURL()
    {
        return isset($this->URL) ? $this->URL : null;
    }
    /**
     * Set URL value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $uRL
     * @return \StructType\BuscarRecibosDTO
     */
    public function setURL($uRL = null)
    {
        // validation for constraint: string
        if (!is_null($uRL) && !is_string($uRL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uRL, true), gettype($uRL)), __LINE__);
        }
        if (is_null($uRL) || (is_array($uRL) && empty($uRL))) {
            unset($this->URL);
        } else {
            $this->URL = $uRL;
        }
        return $this;
    }
    /**
     * Get Valor value
     * @return int|null
     */
    public function getValor()
    {
        return $this->Valor;
    }
    /**
     * Set Valor value
     * @param int $valor
     * @return \StructType\BuscarRecibosDTO
     */
    public function setValor($valor = null)
    {
        // validation for constraint: int
        if (!is_null($valor) && !(is_int($valor) || ctype_digit($valor))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($valor, true), gettype($valor)), __LINE__);
        }
        $this->Valor = $valor;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BuscarRecibosDTO
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
