<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BuscarRecibos StructType
 * @subpackage Structs
 */
class BuscarRecibos extends AbstractStructBase
{
    /**
     * The CPFCNPJ
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CPFCNPJ;
    /**
     * The renavam
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $renavam;
    /**
     * The servico
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $servico;
    /**
     * The chave
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $chave;
    /**
     * Constructor method for BuscarRecibos
     * @uses BuscarRecibos::setCPFCNPJ()
     * @uses BuscarRecibos::setRenavam()
     * @uses BuscarRecibos::setServico()
     * @uses BuscarRecibos::setChave()
     * @param string $cPFCNPJ
     * @param string $renavam
     * @param int $servico
     * @param string $chave
     */
    public function __construct($cPFCNPJ = null, $renavam = null, $servico = null, $chave = null)
    {
        $this
            ->setCPFCNPJ($cPFCNPJ)
            ->setRenavam($renavam)
            ->setServico($servico)
            ->setChave($chave);
    }
    /**
     * Get CPFCNPJ value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCPFCNPJ()
    {
        return isset($this->CPFCNPJ) ? $this->CPFCNPJ : null;
    }
    /**
     * Set CPFCNPJ value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cPFCNPJ
     * @return \StructType\BuscarRecibos
     */
    public function setCPFCNPJ($cPFCNPJ = null)
    {
        // validation for constraint: string
        if (!is_null($cPFCNPJ) && !is_string($cPFCNPJ)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cPFCNPJ, true), gettype($cPFCNPJ)), __LINE__);
        }
        if (is_null($cPFCNPJ) || (is_array($cPFCNPJ) && empty($cPFCNPJ))) {
            unset($this->CPFCNPJ);
        } else {
            $this->CPFCNPJ = $cPFCNPJ;
        }
        return $this;
    }
    /**
     * Get renavam value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRenavam()
    {
        return isset($this->renavam) ? $this->renavam : null;
    }
    /**
     * Set renavam value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $renavam
     * @return \StructType\BuscarRecibos
     */
    public function setRenavam($renavam = null)
    {
        // validation for constraint: string
        if (!is_null($renavam) && !is_string($renavam)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($renavam, true), gettype($renavam)), __LINE__);
        }
        if (is_null($renavam) || (is_array($renavam) && empty($renavam))) {
            unset($this->renavam);
        } else {
            $this->renavam = $renavam;
        }
        return $this;
    }
    /**
     * Get servico value
     * @return int|null
     */
    public function getServico()
    {
        return $this->servico;
    }
    /**
     * Set servico value
     * @param int $servico
     * @return \StructType\BuscarRecibos
     */
    public function setServico($servico = null)
    {
        // validation for constraint: int
        if (!is_null($servico) && !(is_int($servico) || ctype_digit($servico))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($servico, true), gettype($servico)), __LINE__);
        }
        $this->servico = $servico;
        return $this;
    }
    /**
     * Get chave value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getChave()
    {
        return isset($this->chave) ? $this->chave : null;
    }
    /**
     * Set chave value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $chave
     * @return \StructType\BuscarRecibos
     */
    public function setChave($chave = null)
    {
        // validation for constraint: string
        if (!is_null($chave) && !is_string($chave)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($chave, true), gettype($chave)), __LINE__);
        }
        if (is_null($chave) || (is_array($chave) && empty($chave))) {
            unset($this->chave);
        } else {
            $this->chave = $chave;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BuscarRecibos
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
