<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Paga ServiceType
 * @subpackage Services
 */
class Paga extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named PagaIPVA
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\PagaIPVA $parameters
     * @return \StructType\PagaIPVAResponse|bool
     */
    public function PagaIPVA(\StructType\PagaIPVA $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->PagaIPVA($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named PagaDPVAT
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\PagaDPVAT $parameters
     * @return \StructType\PagaDPVATResponse|bool
     */
    public function PagaDPVAT(\StructType\PagaDPVAT $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->PagaDPVAT($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named PagaMultas
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\PagaMultas $parameters
     * @return \StructType\PagaMultasResponse|bool
     */
    public function PagaMultas(\StructType\PagaMultas $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->PagaMultas($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named PagaMultasRENAINF
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\PagaMultasRENAINF $parameters
     * @return \StructType\PagaMultasRENAINFResponse|bool
     */
    public function PagaMultasRENAINF(\StructType\PagaMultasRENAINF $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->PagaMultasRENAINF($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named PagaTransferencia
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\PagaTransferencia $parameters
     * @return \StructType\PagaTransferenciaResponse|bool
     */
    public function PagaTransferencia(\StructType\PagaTransferencia $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->PagaTransferencia($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named PagaLicenciamento
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\PagaLicenciamento $parameters
     * @return \StructType\PagaLicenciamentoResponse|bool
     */
    public function PagaLicenciamento(\StructType\PagaLicenciamento $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->PagaLicenciamento($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named PagaPrimeiroRegistro
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\PagaPrimeiroRegistro $parameters
     * @return \StructType\PagaPrimeiroRegistroResponse|bool
     */
    public function PagaPrimeiroRegistro(\StructType\PagaPrimeiroRegistro $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->PagaPrimeiroRegistro($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named PagaDPVATPrimeiroRegistro
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\PagaDPVATPrimeiroRegistro $parameters
     * @return \StructType\PagaDPVATPrimeiroRegistroResponse|bool
     */
    public function PagaDPVATPrimeiroRegistro(\StructType\PagaDPVATPrimeiroRegistro $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->PagaDPVATPrimeiroRegistro($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named PagaDebitos
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\PagaDebitos $parameters
     * @return \StructType\PagaDebitosResponse|bool
     */
    public function PagaDebitos(\StructType\PagaDebitos $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->PagaDebitos($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named PagaTaxasDETRAN
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\PagaTaxasDETRAN $parameters
     * @return \StructType\PagaTaxasDETRANResponse|bool
     */
    public function PagaTaxasDETRAN(\StructType\PagaTaxasDETRAN $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->PagaTaxasDETRAN($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\PagaDebitosResponse|\StructType\PagaDPVATPrimeiroRegistroResponse|\StructType\PagaDPVATResponse|\StructType\PagaIPVAResponse|\StructType\PagaLicenciamentoResponse|\StructType\PagaMultasRENAINFResponse|\StructType\PagaMultasResponse|\StructType\PagaPrimeiroRegistroResponse|\StructType\PagaTaxasDETRANResponse|\StructType\PagaTransferenciaResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
