<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Consulta ServiceType
 * @subpackage Services
 */
class Consulta extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named ConsultaDPVAT
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ConsultaDPVAT $parameters
     * @return \StructType\ConsultaDPVATResponse|bool
     */
    public function ConsultaDPVAT(\StructType\ConsultaDPVAT $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ConsultaDPVAT($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ConsultaIPVA
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ConsultaIPVA $parameters
     * @return \StructType\ConsultaIPVAResponse|bool
     */
    public function ConsultaIPVA(\StructType\ConsultaIPVA $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ConsultaIPVA($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ConsultaMultas
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ConsultaMultas $parameters
     * @return \StructType\ConsultaMultasResponse|bool
     */
    public function ConsultaMultas(\StructType\ConsultaMultas $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ConsultaMultas($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ConsultaMultasRENAINF
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ConsultaMultasRENAINF $parameters
     * @return \StructType\ConsultaMultasRENAINFResponse|bool
     */
    public function ConsultaMultasRENAINF(\StructType\ConsultaMultasRENAINF $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ConsultaMultasRENAINF($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ConsultaTransferencia
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ConsultaTransferencia $parameters
     * @return \StructType\ConsultaTransferenciaResponse|bool
     */
    public function ConsultaTransferencia(\StructType\ConsultaTransferencia $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ConsultaTransferencia($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * ConsultaTransferenciaComLicenciamento
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ConsultaTransferenciaComLicenciamento $parameters
     * @return \StructType\ConsultaTransferenciaComLicenciamentoResponse|bool
     */
    public function ConsultaTransferenciaComLicenciamento(\StructType\ConsultaTransferenciaComLicenciamento $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ConsultaTransferenciaComLicenciamento($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ConsultaLicenciamento
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ConsultaLicenciamento $parameters
     * @return \StructType\ConsultaLicenciamentoResponse|bool
     */
    public function ConsultaLicenciamento(\StructType\ConsultaLicenciamento $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ConsultaLicenciamento($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ConsultaDebitos
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ConsultaDebitos $parameters
     * @return \StructType\ConsultaDebitosResponse|bool
     */
    public function ConsultaDebitos(\StructType\ConsultaDebitos $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ConsultaDebitos($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ConsultaPrimeiroRegistro
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ConsultaPrimeiroRegistro $parameters
     * @return \StructType\ConsultaPrimeiroRegistroResponse|bool
     */
    public function ConsultaPrimeiroRegistro(\StructType\ConsultaPrimeiroRegistro $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ConsultaPrimeiroRegistro($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ConsultaTaxasDETRAN
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ConsultaTaxasDETRAN $parameters
     * @return \StructType\ConsultaTaxasDETRANResponse|bool
     */
    public function ConsultaTaxasDETRAN(\StructType\ConsultaTaxasDETRAN $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ConsultaTaxasDETRAN($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ConsultaDebitosResponse|\StructType\ConsultaDPVATResponse|\StructType\ConsultaIPVAResponse|\StructType\ConsultaLicenciamentoResponse|\StructType\ConsultaMultasRENAINFResponse|\StructType\ConsultaMultasResponse|\StructType\ConsultaPrimeiroRegistroResponse|\StructType\ConsultaTaxasDETRANResponse|\StructType\ConsultaTransferenciaComLicenciamentoResponse|\StructType\ConsultaTransferenciaResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
