<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://www.rendimentonline.com.br/Servicos/ServPagamentosDebitosVeiculares.svc?wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://www.rendimentonline.com.br/Servicos/ServPagamentosDebitosVeiculares.svc?wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Paga ServiceType
 */
$paga = new \ServiceType\Paga($options);
/**
 * Sample call for PagaIPVA operation/method
 */
if ($paga->PagaIPVA(new \StructType\PagaIPVA()) !== false) {
    print_r($paga->getResult());
} else {
    print_r($paga->getLastError());
}
/**
 * Sample call for PagaDPVAT operation/method
 */
if ($paga->PagaDPVAT(new \StructType\PagaDPVAT()) !== false) {
    print_r($paga->getResult());
} else {
    print_r($paga->getLastError());
}
/**
 * Sample call for PagaMultas operation/method
 */
if ($paga->PagaMultas(new \StructType\PagaMultas()) !== false) {
    print_r($paga->getResult());
} else {
    print_r($paga->getLastError());
}
/**
 * Sample call for PagaMultasRENAINF operation/method
 */
if ($paga->PagaMultasRENAINF(new \StructType\PagaMultasRENAINF()) !== false) {
    print_r($paga->getResult());
} else {
    print_r($paga->getLastError());
}
/**
 * Sample call for PagaTransferencia operation/method
 */
if ($paga->PagaTransferencia(new \StructType\PagaTransferencia()) !== false) {
    print_r($paga->getResult());
} else {
    print_r($paga->getLastError());
}
/**
 * Sample call for PagaLicenciamento operation/method
 */
if ($paga->PagaLicenciamento(new \StructType\PagaLicenciamento()) !== false) {
    print_r($paga->getResult());
} else {
    print_r($paga->getLastError());
}
/**
 * Sample call for PagaPrimeiroRegistro operation/method
 */
if ($paga->PagaPrimeiroRegistro(new \StructType\PagaPrimeiroRegistro()) !== false) {
    print_r($paga->getResult());
} else {
    print_r($paga->getLastError());
}
/**
 * Sample call for PagaDPVATPrimeiroRegistro operation/method
 */
if ($paga->PagaDPVATPrimeiroRegistro(new \StructType\PagaDPVATPrimeiroRegistro()) !== false) {
    print_r($paga->getResult());
} else {
    print_r($paga->getLastError());
}
/**
 * Sample call for PagaDebitos operation/method
 */
if ($paga->PagaDebitos(new \StructType\PagaDebitos()) !== false) {
    print_r($paga->getResult());
} else {
    print_r($paga->getLastError());
}
/**
 * Sample call for PagaTaxasDETRAN operation/method
 */
if ($paga->PagaTaxasDETRAN(new \StructType\PagaTaxasDETRAN()) !== false) {
    print_r($paga->getResult());
} else {
    print_r($paga->getLastError());
}
/**
 * Samples for URLR ServiceType
 */
$uRLR = new \ServiceType\URLR($options);
/**
 * Sample call for URLRecibos operation/method
 */
if ($uRLR->URLRecibos(new \StructType\URLRecibos()) !== false) {
    print_r($uRLR->getResult());
} else {
    print_r($uRLR->getLastError());
}
/**
 * Samples for Consulta ServiceType
 */
$consulta = new \ServiceType\Consulta($options);
/**
 * Sample call for ConsultaDPVAT operation/method
 */
if ($consulta->ConsultaDPVAT(new \StructType\ConsultaDPVAT()) !== false) {
    print_r($consulta->getResult());
} else {
    print_r($consulta->getLastError());
}
/**
 * Sample call for ConsultaIPVA operation/method
 */
if ($consulta->ConsultaIPVA(new \StructType\ConsultaIPVA()) !== false) {
    print_r($consulta->getResult());
} else {
    print_r($consulta->getLastError());
}
/**
 * Sample call for ConsultaMultas operation/method
 */
if ($consulta->ConsultaMultas(new \StructType\ConsultaMultas()) !== false) {
    print_r($consulta->getResult());
} else {
    print_r($consulta->getLastError());
}
/**
 * Sample call for ConsultaMultasRENAINF operation/method
 */
if ($consulta->ConsultaMultasRENAINF(new \StructType\ConsultaMultasRENAINF()) !== false) {
    print_r($consulta->getResult());
} else {
    print_r($consulta->getLastError());
}
/**
 * Sample call for ConsultaTransferencia operation/method
 */
if ($consulta->ConsultaTransferencia(new \StructType\ConsultaTransferencia()) !== false) {
    print_r($consulta->getResult());
} else {
    print_r($consulta->getLastError());
}
/**
 * Sample call for ConsultaTransferenciaComLicenciamento operation/method
 */
if ($consulta->ConsultaTransferenciaComLicenciamento(new \StructType\ConsultaTransferenciaComLicenciamento()) !== false) {
    print_r($consulta->getResult());
} else {
    print_r($consulta->getLastError());
}
/**
 * Sample call for ConsultaLicenciamento operation/method
 */
if ($consulta->ConsultaLicenciamento(new \StructType\ConsultaLicenciamento()) !== false) {
    print_r($consulta->getResult());
} else {
    print_r($consulta->getLastError());
}
/**
 * Sample call for ConsultaDebitos operation/method
 */
if ($consulta->ConsultaDebitos(new \StructType\ConsultaDebitos()) !== false) {
    print_r($consulta->getResult());
} else {
    print_r($consulta->getLastError());
}
/**
 * Sample call for ConsultaPrimeiroRegistro operation/method
 */
if ($consulta->ConsultaPrimeiroRegistro(new \StructType\ConsultaPrimeiroRegistro()) !== false) {
    print_r($consulta->getResult());
} else {
    print_r($consulta->getLastError());
}
/**
 * Sample call for ConsultaTaxasDETRAN operation/method
 */
if ($consulta->ConsultaTaxasDETRAN(new \StructType\ConsultaTaxasDETRAN()) !== false) {
    print_r($consulta->getResult());
} else {
    print_r($consulta->getLastError());
}
/**
 * Samples for Buscar ServiceType
 */
$buscar = new \ServiceType\Buscar($options);
/**
 * Sample call for BuscarRecibos operation/method
 */
if ($buscar->BuscarRecibos(new \StructType\BuscarRecibos()) !== false) {
    print_r($buscar->getResult());
} else {
    print_r($buscar->getLastError());
}
