<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TaxaDETRANDTO StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:TaxaDETRANDTO
 * @subpackage Structs
 */
class TaxaDETRANDTO extends AbstractStructBase
{
    /**
     * The CodigoReceita
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $CodigoReceita;
    /**
     * The CodigoSubServico
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $CodigoSubServico;
    /**
     * The CodigoTipoSubServico
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $CodigoTipoSubServico;
    /**
     * The DescricaoTipoSubServico
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DescricaoTipoSubServico;
    /**
     * The TipoIdentificador
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $TipoIdentificador;
    /**
     * The TipoSubServicoAutenticacaoDigital
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $TipoSubServicoAutenticacaoDigital;
    /**
     * The Valor
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Valor;
    /**
     * The ValorTaxaCorreio
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ValorTaxaCorreio;
    /**
     * The ValorTotal
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ValorTotal;
    /**
     * Constructor method for TaxaDETRANDTO
     * @uses TaxaDETRANDTO::setCodigoReceita()
     * @uses TaxaDETRANDTO::setCodigoSubServico()
     * @uses TaxaDETRANDTO::setCodigoTipoSubServico()
     * @uses TaxaDETRANDTO::setDescricaoTipoSubServico()
     * @uses TaxaDETRANDTO::setTipoIdentificador()
     * @uses TaxaDETRANDTO::setTipoSubServicoAutenticacaoDigital()
     * @uses TaxaDETRANDTO::setValor()
     * @uses TaxaDETRANDTO::setValorTaxaCorreio()
     * @uses TaxaDETRANDTO::setValorTotal()
     * @param int $codigoReceita
     * @param int $codigoSubServico
     * @param int $codigoTipoSubServico
     * @param string $descricaoTipoSubServico
     * @param string $tipoIdentificador
     * @param int $tipoSubServicoAutenticacaoDigital
     * @param int $valor
     * @param int $valorTaxaCorreio
     * @param int $valorTotal
     */
    public function __construct($codigoReceita = null, $codigoSubServico = null, $codigoTipoSubServico = null, $descricaoTipoSubServico = null, $tipoIdentificador = null, $tipoSubServicoAutenticacaoDigital = null, $valor = null, $valorTaxaCorreio = null, $valorTotal = null)
    {
        $this
            ->setCodigoReceita($codigoReceita)
            ->setCodigoSubServico($codigoSubServico)
            ->setCodigoTipoSubServico($codigoTipoSubServico)
            ->setDescricaoTipoSubServico($descricaoTipoSubServico)
            ->setTipoIdentificador($tipoIdentificador)
            ->setTipoSubServicoAutenticacaoDigital($tipoSubServicoAutenticacaoDigital)
            ->setValor($valor)
            ->setValorTaxaCorreio($valorTaxaCorreio)
            ->setValorTotal($valorTotal);
    }
    /**
     * Get CodigoReceita value
     * @return int|null
     */
    public function getCodigoReceita()
    {
        return $this->CodigoReceita;
    }
    /**
     * Set CodigoReceita value
     * @param int $codigoReceita
     * @return \StructType\TaxaDETRANDTO
     */
    public function setCodigoReceita($codigoReceita = null)
    {
        // validation for constraint: int
        if (!is_null($codigoReceita) && !(is_int($codigoReceita) || ctype_digit($codigoReceita))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($codigoReceita, true), gettype($codigoReceita)), __LINE__);
        }
        $this->CodigoReceita = $codigoReceita;
        return $this;
    }
    /**
     * Get CodigoSubServico value
     * @return int|null
     */
    public function getCodigoSubServico()
    {
        return $this->CodigoSubServico;
    }
    /**
     * Set CodigoSubServico value
     * @param int $codigoSubServico
     * @return \StructType\TaxaDETRANDTO
     */
    public function setCodigoSubServico($codigoSubServico = null)
    {
        // validation for constraint: int
        if (!is_null($codigoSubServico) && !(is_int($codigoSubServico) || ctype_digit($codigoSubServico))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($codigoSubServico, true), gettype($codigoSubServico)), __LINE__);
        }
        $this->CodigoSubServico = $codigoSubServico;
        return $this;
    }
    /**
     * Get CodigoTipoSubServico value
     * @return int|null
     */
    public function getCodigoTipoSubServico()
    {
        return $this->CodigoTipoSubServico;
    }
    /**
     * Set CodigoTipoSubServico value
     * @param int $codigoTipoSubServico
     * @return \StructType\TaxaDETRANDTO
     */
    public function setCodigoTipoSubServico($codigoTipoSubServico = null)
    {
        // validation for constraint: int
        if (!is_null($codigoTipoSubServico) && !(is_int($codigoTipoSubServico) || ctype_digit($codigoTipoSubServico))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($codigoTipoSubServico, true), gettype($codigoTipoSubServico)), __LINE__);
        }
        $this->CodigoTipoSubServico = $codigoTipoSubServico;
        return $this;
    }
    /**
     * Get DescricaoTipoSubServico value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDescricaoTipoSubServico()
    {
        return isset($this->DescricaoTipoSubServico) ? $this->DescricaoTipoSubServico : null;
    }
    /**
     * Set DescricaoTipoSubServico value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $descricaoTipoSubServico
     * @return \StructType\TaxaDETRANDTO
     */
    public function setDescricaoTipoSubServico($descricaoTipoSubServico = null)
    {
        // validation for constraint: string
        if (!is_null($descricaoTipoSubServico) && !is_string($descricaoTipoSubServico)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($descricaoTipoSubServico, true), gettype($descricaoTipoSubServico)), __LINE__);
        }
        if (is_null($descricaoTipoSubServico) || (is_array($descricaoTipoSubServico) && empty($descricaoTipoSubServico))) {
            unset($this->DescricaoTipoSubServico);
        } else {
            $this->DescricaoTipoSubServico = $descricaoTipoSubServico;
        }
        return $this;
    }
    /**
     * Get TipoIdentificador value
     * @return string|null
     */
    public function getTipoIdentificador()
    {
        return $this->TipoIdentificador;
    }
    /**
     * Set TipoIdentificador value
     * @uses \EnumType\TipoIdentificador::valueIsValid()
     * @uses \EnumType\TipoIdentificador::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $tipoIdentificador
     * @return \StructType\TaxaDETRANDTO
     */
    public function setTipoIdentificador($tipoIdentificador = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TipoIdentificador::valueIsValid($tipoIdentificador)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\TipoIdentificador', is_array($tipoIdentificador) ? implode(', ', $tipoIdentificador) : var_export($tipoIdentificador, true), implode(', ', \EnumType\TipoIdentificador::getValidValues())), __LINE__);
        }
        $this->TipoIdentificador = $tipoIdentificador;
        return $this;
    }
    /**
     * Get TipoSubServicoAutenticacaoDigital value
     * @return int|null
     */
    public function getTipoSubServicoAutenticacaoDigital()
    {
        return $this->TipoSubServicoAutenticacaoDigital;
    }
    /**
     * Set TipoSubServicoAutenticacaoDigital value
     * @param int $tipoSubServicoAutenticacaoDigital
     * @return \StructType\TaxaDETRANDTO
     */
    public function setTipoSubServicoAutenticacaoDigital($tipoSubServicoAutenticacaoDigital = null)
    {
        // validation for constraint: int
        if (!is_null($tipoSubServicoAutenticacaoDigital) && !(is_int($tipoSubServicoAutenticacaoDigital) || ctype_digit($tipoSubServicoAutenticacaoDigital))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($tipoSubServicoAutenticacaoDigital, true), gettype($tipoSubServicoAutenticacaoDigital)), __LINE__);
        }
        $this->TipoSubServicoAutenticacaoDigital = $tipoSubServicoAutenticacaoDigital;
        return $this;
    }
    /**
     * Get Valor value
     * @return int|null
     */
    public function getValor()
    {
        return $this->Valor;
    }
    /**
     * Set Valor value
     * @param int $valor
     * @return \StructType\TaxaDETRANDTO
     */
    public function setValor($valor = null)
    {
        // validation for constraint: int
        if (!is_null($valor) && !(is_int($valor) || ctype_digit($valor))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($valor, true), gettype($valor)), __LINE__);
        }
        $this->Valor = $valor;
        return $this;
    }
    /**
     * Get ValorTaxaCorreio value
     * @return int|null
     */
    public function getValorTaxaCorreio()
    {
        return $this->ValorTaxaCorreio;
    }
    /**
     * Set ValorTaxaCorreio value
     * @param int $valorTaxaCorreio
     * @return \StructType\TaxaDETRANDTO
     */
    public function setValorTaxaCorreio($valorTaxaCorreio = null)
    {
        // validation for constraint: int
        if (!is_null($valorTaxaCorreio) && !(is_int($valorTaxaCorreio) || ctype_digit($valorTaxaCorreio))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($valorTaxaCorreio, true), gettype($valorTaxaCorreio)), __LINE__);
        }
        $this->ValorTaxaCorreio = $valorTaxaCorreio;
        return $this;
    }
    /**
     * Get ValorTotal value
     * @return int|null
     */
    public function getValorTotal()
    {
        return $this->ValorTotal;
    }
    /**
     * Set ValorTotal value
     * @param int $valorTotal
     * @return \StructType\TaxaDETRANDTO
     */
    public function setValorTotal($valorTotal = null)
    {
        // validation for constraint: int
        if (!is_null($valorTotal) && !(is_int($valorTotal) || ctype_digit($valorTotal))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($valorTotal, true), gettype($valorTotal)), __LINE__);
        }
        $this->ValorTotal = $valorTotal;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TaxaDETRANDTO
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
