<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RetornoPagamento StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:RetornoPagamento
 * @subpackage Structs
 */
class RetornoPagamento extends AbstractStructBase
{
    /**
     * The AutenticacaoDigital
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AutenticacaoDigital;
    /**
     * The CodigoAcesso
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $CodigoAcesso;
    /**
     * The CodigoOcorrencia
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CodigoOcorrencia;
    /**
     * The Ocorrencia
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Ocorrencia;
    /**
     * The ReciboTrocaCheque_Id
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ReciboTrocaCheque_Id;
    /**
     * The Recibo_Id
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Recibo_Id;
    /**
     * Constructor method for RetornoPagamento
     * @uses RetornoPagamento::setAutenticacaoDigital()
     * @uses RetornoPagamento::setCodigoAcesso()
     * @uses RetornoPagamento::setCodigoOcorrencia()
     * @uses RetornoPagamento::setOcorrencia()
     * @uses RetornoPagamento::setReciboTrocaCheque_Id()
     * @uses RetornoPagamento::setRecibo_Id()
     * @param string $autenticacaoDigital
     * @param int $codigoAcesso
     * @param string $codigoOcorrencia
     * @param string $ocorrencia
     * @param int $reciboTrocaCheque_Id
     * @param int $recibo_Id
     */
    public function __construct($autenticacaoDigital = null, $codigoAcesso = null, $codigoOcorrencia = null, $ocorrencia = null, $reciboTrocaCheque_Id = null, $recibo_Id = null)
    {
        $this
            ->setAutenticacaoDigital($autenticacaoDigital)
            ->setCodigoAcesso($codigoAcesso)
            ->setCodigoOcorrencia($codigoOcorrencia)
            ->setOcorrencia($ocorrencia)
            ->setReciboTrocaCheque_Id($reciboTrocaCheque_Id)
            ->setRecibo_Id($recibo_Id);
    }
    /**
     * Get AutenticacaoDigital value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAutenticacaoDigital()
    {
        return isset($this->AutenticacaoDigital) ? $this->AutenticacaoDigital : null;
    }
    /**
     * Set AutenticacaoDigital value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $autenticacaoDigital
     * @return \StructType\RetornoPagamento
     */
    public function setAutenticacaoDigital($autenticacaoDigital = null)
    {
        // validation for constraint: string
        if (!is_null($autenticacaoDigital) && !is_string($autenticacaoDigital)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($autenticacaoDigital, true), gettype($autenticacaoDigital)), __LINE__);
        }
        if (is_null($autenticacaoDigital) || (is_array($autenticacaoDigital) && empty($autenticacaoDigital))) {
            unset($this->AutenticacaoDigital);
        } else {
            $this->AutenticacaoDigital = $autenticacaoDigital;
        }
        return $this;
    }
    /**
     * Get CodigoAcesso value
     * @return int|null
     */
    public function getCodigoAcesso()
    {
        return $this->CodigoAcesso;
    }
    /**
     * Set CodigoAcesso value
     * @param int $codigoAcesso
     * @return \StructType\RetornoPagamento
     */
    public function setCodigoAcesso($codigoAcesso = null)
    {
        // validation for constraint: int
        if (!is_null($codigoAcesso) && !(is_int($codigoAcesso) || ctype_digit($codigoAcesso))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($codigoAcesso, true), gettype($codigoAcesso)), __LINE__);
        }
        $this->CodigoAcesso = $codigoAcesso;
        return $this;
    }
    /**
     * Get CodigoOcorrencia value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCodigoOcorrencia()
    {
        return isset($this->CodigoOcorrencia) ? $this->CodigoOcorrencia : null;
    }
    /**
     * Set CodigoOcorrencia value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $codigoOcorrencia
     * @return \StructType\RetornoPagamento
     */
    public function setCodigoOcorrencia($codigoOcorrencia = null)
    {
        // validation for constraint: string
        if (!is_null($codigoOcorrencia) && !is_string($codigoOcorrencia)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codigoOcorrencia, true), gettype($codigoOcorrencia)), __LINE__);
        }
        if (is_null($codigoOcorrencia) || (is_array($codigoOcorrencia) && empty($codigoOcorrencia))) {
            unset($this->CodigoOcorrencia);
        } else {
            $this->CodigoOcorrencia = $codigoOcorrencia;
        }
        return $this;
    }
    /**
     * Get Ocorrencia value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOcorrencia()
    {
        return isset($this->Ocorrencia) ? $this->Ocorrencia : null;
    }
    /**
     * Set Ocorrencia value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ocorrencia
     * @return \StructType\RetornoPagamento
     */
    public function setOcorrencia($ocorrencia = null)
    {
        // validation for constraint: string
        if (!is_null($ocorrencia) && !is_string($ocorrencia)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ocorrencia, true), gettype($ocorrencia)), __LINE__);
        }
        if (is_null($ocorrencia) || (is_array($ocorrencia) && empty($ocorrencia))) {
            unset($this->Ocorrencia);
        } else {
            $this->Ocorrencia = $ocorrencia;
        }
        return $this;
    }
    /**
     * Get ReciboTrocaCheque_Id value
     * @return int|null
     */
    public function getReciboTrocaCheque_Id()
    {
        return $this->ReciboTrocaCheque_Id;
    }
    /**
     * Set ReciboTrocaCheque_Id value
     * @param int $reciboTrocaCheque_Id
     * @return \StructType\RetornoPagamento
     */
    public function setReciboTrocaCheque_Id($reciboTrocaCheque_Id = null)
    {
        // validation for constraint: int
        if (!is_null($reciboTrocaCheque_Id) && !(is_int($reciboTrocaCheque_Id) || ctype_digit($reciboTrocaCheque_Id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($reciboTrocaCheque_Id, true), gettype($reciboTrocaCheque_Id)), __LINE__);
        }
        $this->ReciboTrocaCheque_Id = $reciboTrocaCheque_Id;
        return $this;
    }
    /**
     * Get Recibo_Id value
     * @return int|null
     */
    public function getRecibo_Id()
    {
        return $this->Recibo_Id;
    }
    /**
     * Set Recibo_Id value
     * @param int $recibo_Id
     * @return \StructType\RetornoPagamento
     */
    public function setRecibo_Id($recibo_Id = null)
    {
        // validation for constraint: int
        if (!is_null($recibo_Id) && !(is_int($recibo_Id) || ctype_digit($recibo_Id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($recibo_Id, true), gettype($recibo_Id)), __LINE__);
        }
        $this->Recibo_Id = $recibo_Id;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RetornoPagamento
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
