<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RetornoDPVAT StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:RetornoDPVAT
 * @subpackage Structs
 */
class RetornoDPVAT extends DebitoBase
{
    /**
     * The DPVATs
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfDPVAT
     */
    public $DPVATs;
    /**
     * Constructor method for RetornoDPVAT
     * @uses RetornoDPVAT::setDPVATs()
     * @param \ArrayType\ArrayOfDPVAT $dPVATs
     */
    public function __construct(\ArrayType\ArrayOfDPVAT $dPVATs = null)
    {
        $this
            ->setDPVATs($dPVATs);
    }
    /**
     * Get DPVATs value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfDPVAT|null
     */
    public function getDPVATs()
    {
        return isset($this->DPVATs) ? $this->DPVATs : null;
    }
    /**
     * Set DPVATs value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfDPVAT $dPVATs
     * @return \StructType\RetornoDPVAT
     */
    public function setDPVATs(\ArrayType\ArrayOfDPVAT $dPVATs = null)
    {
        if (is_null($dPVATs) || (is_array($dPVATs) && empty($dPVATs))) {
            unset($this->DPVATs);
        } else {
            $this->DPVATs = $dPVATs;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RetornoDPVAT
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
