<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PagaTaxasDETRAN StructType
 * @subpackage Structs
 */
class PagaTaxasDETRAN extends AbstractStructBase
{
    /**
     * The Taxa
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\TaxaDETRANDTO
     */
    public $Taxa;
    /**
     * The Identificador
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Identificador;
    /**
     * The Placa
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Placa;
    /**
     * The TrocaCheque
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $TrocaCheque;
    /**
     * The ValidarDuplicidade
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $ValidarDuplicidade;
    /**
     * The Chave
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Chave;
    /**
     * Constructor method for PagaTaxasDETRAN
     * @uses PagaTaxasDETRAN::setTaxa()
     * @uses PagaTaxasDETRAN::setIdentificador()
     * @uses PagaTaxasDETRAN::setPlaca()
     * @uses PagaTaxasDETRAN::setTrocaCheque()
     * @uses PagaTaxasDETRAN::setValidarDuplicidade()
     * @uses PagaTaxasDETRAN::setChave()
     * @param \StructType\TaxaDETRANDTO $taxa
     * @param string $identificador
     * @param string $placa
     * @param bool $trocaCheque
     * @param bool $validarDuplicidade
     * @param string $chave
     */
    public function __construct(\StructType\TaxaDETRANDTO $taxa = null, $identificador = null, $placa = null, $trocaCheque = null, $validarDuplicidade = null, $chave = null)
    {
        $this
            ->setTaxa($taxa)
            ->setIdentificador($identificador)
            ->setPlaca($placa)
            ->setTrocaCheque($trocaCheque)
            ->setValidarDuplicidade($validarDuplicidade)
            ->setChave($chave);
    }
    /**
     * Get Taxa value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\TaxaDETRANDTO|null
     */
    public function getTaxa()
    {
        return isset($this->Taxa) ? $this->Taxa : null;
    }
    /**
     * Set Taxa value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\TaxaDETRANDTO $taxa
     * @return \StructType\PagaTaxasDETRAN
     */
    public function setTaxa(\StructType\TaxaDETRANDTO $taxa = null)
    {
        if (is_null($taxa) || (is_array($taxa) && empty($taxa))) {
            unset($this->Taxa);
        } else {
            $this->Taxa = $taxa;
        }
        return $this;
    }
    /**
     * Get Identificador value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIdentificador()
    {
        return isset($this->Identificador) ? $this->Identificador : null;
    }
    /**
     * Set Identificador value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $identificador
     * @return \StructType\PagaTaxasDETRAN
     */
    public function setIdentificador($identificador = null)
    {
        // validation for constraint: string
        if (!is_null($identificador) && !is_string($identificador)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($identificador, true), gettype($identificador)), __LINE__);
        }
        if (is_null($identificador) || (is_array($identificador) && empty($identificador))) {
            unset($this->Identificador);
        } else {
            $this->Identificador = $identificador;
        }
        return $this;
    }
    /**
     * Get Placa value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPlaca()
    {
        return isset($this->Placa) ? $this->Placa : null;
    }
    /**
     * Set Placa value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $placa
     * @return \StructType\PagaTaxasDETRAN
     */
    public function setPlaca($placa = null)
    {
        // validation for constraint: string
        if (!is_null($placa) && !is_string($placa)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($placa, true), gettype($placa)), __LINE__);
        }
        if (is_null($placa) || (is_array($placa) && empty($placa))) {
            unset($this->Placa);
        } else {
            $this->Placa = $placa;
        }
        return $this;
    }
    /**
     * Get TrocaCheque value
     * @return bool|null
     */
    public function getTrocaCheque()
    {
        return $this->TrocaCheque;
    }
    /**
     * Set TrocaCheque value
     * @param bool $trocaCheque
     * @return \StructType\PagaTaxasDETRAN
     */
    public function setTrocaCheque($trocaCheque = null)
    {
        // validation for constraint: boolean
        if (!is_null($trocaCheque) && !is_bool($trocaCheque)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($trocaCheque, true), gettype($trocaCheque)), __LINE__);
        }
        $this->TrocaCheque = $trocaCheque;
        return $this;
    }
    /**
     * Get ValidarDuplicidade value
     * @return bool|null
     */
    public function getValidarDuplicidade()
    {
        return $this->ValidarDuplicidade;
    }
    /**
     * Set ValidarDuplicidade value
     * @param bool $validarDuplicidade
     * @return \StructType\PagaTaxasDETRAN
     */
    public function setValidarDuplicidade($validarDuplicidade = null)
    {
        // validation for constraint: boolean
        if (!is_null($validarDuplicidade) && !is_bool($validarDuplicidade)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($validarDuplicidade, true), gettype($validarDuplicidade)), __LINE__);
        }
        $this->ValidarDuplicidade = $validarDuplicidade;
        return $this;
    }
    /**
     * Get Chave value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getChave()
    {
        return isset($this->Chave) ? $this->Chave : null;
    }
    /**
     * Set Chave value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $chave
     * @return \StructType\PagaTaxasDETRAN
     */
    public function setChave($chave = null)
    {
        // validation for constraint: string
        if (!is_null($chave) && !is_string($chave)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($chave, true), gettype($chave)), __LINE__);
        }
        if (is_null($chave) || (is_array($chave) && empty($chave))) {
            unset($this->Chave);
        } else {
            $this->Chave = $chave;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PagaTaxasDETRAN
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
