<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Multa StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Multa
 * @subpackage Structs
 */
class Multa extends ItemPagamentoMulta
{
    /**
     * The Valor
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Valor;
    /**
     * Constructor method for Multa
     * @uses Multa::setValor()
     * @param int $valor
     */
    public function __construct($valor = null)
    {
        $this
            ->setValor($valor);
    }
    /**
     * Get Valor value
     * @return int|null
     */
    public function getValor()
    {
        return $this->Valor;
    }
    /**
     * Set Valor value
     * @param int $valor
     * @return \StructType\Multa
     */
    public function setValor($valor = null)
    {
        // validation for constraint: int
        if (!is_null($valor) && !(is_int($valor) || ctype_digit($valor))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($valor, true), gettype($valor)), __LINE__);
        }
        $this->Valor = $valor;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Multa
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
