<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Licenciamento StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Licenciamento
 * @subpackage Structs
 */
class Licenciamento extends DebitoBase
{
    /**
     * The DPVATs
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfDPVAT
     */
    public $DPVATs;
    /**
     * The Exercicio
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Exercicio;
    /**
     * The FlagTaxaCorreio
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $FlagTaxaCorreio;
    /**
     * The IPVAs
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfIPVA
     */
    public $IPVAs;
    /**
     * The Multas
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfMulta
     */
    public $Multas;
    /**
     * The TaxaCorreios
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $TaxaCorreios;
    /**
     * The TaxaLicenciamento
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $TaxaLicenciamento;
    /**
     * The TipoEntrega
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $TipoEntrega;
    /**
     * Constructor method for Licenciamento
     * @uses Licenciamento::setDPVATs()
     * @uses Licenciamento::setExercicio()
     * @uses Licenciamento::setFlagTaxaCorreio()
     * @uses Licenciamento::setIPVAs()
     * @uses Licenciamento::setMultas()
     * @uses Licenciamento::setTaxaCorreios()
     * @uses Licenciamento::setTaxaLicenciamento()
     * @uses Licenciamento::setTipoEntrega()
     * @param \ArrayType\ArrayOfDPVAT $dPVATs
     * @param int $exercicio
     * @param string $flagTaxaCorreio
     * @param \ArrayType\ArrayOfIPVA $iPVAs
     * @param \ArrayType\ArrayOfMulta $multas
     * @param int $taxaCorreios
     * @param int $taxaLicenciamento
     * @param string $tipoEntrega
     */
    public function __construct(\ArrayType\ArrayOfDPVAT $dPVATs = null, $exercicio = null, $flagTaxaCorreio = null, \ArrayType\ArrayOfIPVA $iPVAs = null, \ArrayType\ArrayOfMulta $multas = null, $taxaCorreios = null, $taxaLicenciamento = null, $tipoEntrega = null)
    {
        $this
            ->setDPVATs($dPVATs)
            ->setExercicio($exercicio)
            ->setFlagTaxaCorreio($flagTaxaCorreio)
            ->setIPVAs($iPVAs)
            ->setMultas($multas)
            ->setTaxaCorreios($taxaCorreios)
            ->setTaxaLicenciamento($taxaLicenciamento)
            ->setTipoEntrega($tipoEntrega);
    }
    /**
     * Get DPVATs value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfDPVAT|null
     */
    public function getDPVATs()
    {
        return isset($this->DPVATs) ? $this->DPVATs : null;
    }
    /**
     * Set DPVATs value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfDPVAT $dPVATs
     * @return \StructType\Licenciamento
     */
    public function setDPVATs(\ArrayType\ArrayOfDPVAT $dPVATs = null)
    {
        if (is_null($dPVATs) || (is_array($dPVATs) && empty($dPVATs))) {
            unset($this->DPVATs);
        } else {
            $this->DPVATs = $dPVATs;
        }
        return $this;
    }
    /**
     * Get Exercicio value
     * @return int|null
     */
    public function getExercicio()
    {
        return $this->Exercicio;
    }
    /**
     * Set Exercicio value
     * @param int $exercicio
     * @return \StructType\Licenciamento
     */
    public function setExercicio($exercicio = null)
    {
        // validation for constraint: int
        if (!is_null($exercicio) && !(is_int($exercicio) || ctype_digit($exercicio))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($exercicio, true), gettype($exercicio)), __LINE__);
        }
        $this->Exercicio = $exercicio;
        return $this;
    }
    /**
     * Get FlagTaxaCorreio value
     * @return string|null
     */
    public function getFlagTaxaCorreio()
    {
        return $this->FlagTaxaCorreio;
    }
    /**
     * Set FlagTaxaCorreio value
     * @uses \EnumType\TaxaCorreio::valueIsValid()
     * @uses \EnumType\TaxaCorreio::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $flagTaxaCorreio
     * @return \StructType\Licenciamento
     */
    public function setFlagTaxaCorreio($flagTaxaCorreio = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TaxaCorreio::valueIsValid($flagTaxaCorreio)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\TaxaCorreio', is_array($flagTaxaCorreio) ? implode(', ', $flagTaxaCorreio) : var_export($flagTaxaCorreio, true), implode(', ', \EnumType\TaxaCorreio::getValidValues())), __LINE__);
        }
        $this->FlagTaxaCorreio = $flagTaxaCorreio;
        return $this;
    }
    /**
     * Get IPVAs value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfIPVA|null
     */
    public function getIPVAs()
    {
        return isset($this->IPVAs) ? $this->IPVAs : null;
    }
    /**
     * Set IPVAs value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfIPVA $iPVAs
     * @return \StructType\Licenciamento
     */
    public function setIPVAs(\ArrayType\ArrayOfIPVA $iPVAs = null)
    {
        if (is_null($iPVAs) || (is_array($iPVAs) && empty($iPVAs))) {
            unset($this->IPVAs);
        } else {
            $this->IPVAs = $iPVAs;
        }
        return $this;
    }
    /**
     * Get Multas value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfMulta|null
     */
    public function getMultas()
    {
        return isset($this->Multas) ? $this->Multas : null;
    }
    /**
     * Set Multas value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfMulta $multas
     * @return \StructType\Licenciamento
     */
    public function setMultas(\ArrayType\ArrayOfMulta $multas = null)
    {
        if (is_null($multas) || (is_array($multas) && empty($multas))) {
            unset($this->Multas);
        } else {
            $this->Multas = $multas;
        }
        return $this;
    }
    /**
     * Get TaxaCorreios value
     * @return int|null
     */
    public function getTaxaCorreios()
    {
        return $this->TaxaCorreios;
    }
    /**
     * Set TaxaCorreios value
     * @param int $taxaCorreios
     * @return \StructType\Licenciamento
     */
    public function setTaxaCorreios($taxaCorreios = null)
    {
        // validation for constraint: int
        if (!is_null($taxaCorreios) && !(is_int($taxaCorreios) || ctype_digit($taxaCorreios))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($taxaCorreios, true), gettype($taxaCorreios)), __LINE__);
        }
        $this->TaxaCorreios = $taxaCorreios;
        return $this;
    }
    /**
     * Get TaxaLicenciamento value
     * @return int|null
     */
    public function getTaxaLicenciamento()
    {
        return $this->TaxaLicenciamento;
    }
    /**
     * Set TaxaLicenciamento value
     * @param int $taxaLicenciamento
     * @return \StructType\Licenciamento
     */
    public function setTaxaLicenciamento($taxaLicenciamento = null)
    {
        // validation for constraint: int
        if (!is_null($taxaLicenciamento) && !(is_int($taxaLicenciamento) || ctype_digit($taxaLicenciamento))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($taxaLicenciamento, true), gettype($taxaLicenciamento)), __LINE__);
        }
        $this->TaxaLicenciamento = $taxaLicenciamento;
        return $this;
    }
    /**
     * Get TipoEntrega value
     * @return string|null
     */
    public function getTipoEntrega()
    {
        return $this->TipoEntrega;
    }
    /**
     * Set TipoEntrega value
     * @uses \EnumType\TipoEntrega::valueIsValid()
     * @uses \EnumType\TipoEntrega::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $tipoEntrega
     * @return \StructType\Licenciamento
     */
    public function setTipoEntrega($tipoEntrega = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TipoEntrega::valueIsValid($tipoEntrega)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\TipoEntrega', is_array($tipoEntrega) ? implode(', ', $tipoEntrega) : var_export($tipoEntrega, true), implode(', ', \EnumType\TipoEntrega::getValidValues())), __LINE__);
        }
        $this->TipoEntrega = $tipoEntrega;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Licenciamento
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
