<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ItemPagamento StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ItemPagamento
 * @subpackage Structs
 */
class ItemPagamento extends AbstractStructBase
{
    /**
     * The Cota
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Cota;
    /**
     * The Exercicio
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Exercicio;
    /**
     * Constructor method for ItemPagamento
     * @uses ItemPagamento::setCota()
     * @uses ItemPagamento::setExercicio()
     * @param int $cota
     * @param int $exercicio
     */
    public function __construct($cota = null, $exercicio = null)
    {
        $this
            ->setCota($cota)
            ->setExercicio($exercicio);
    }
    /**
     * Get Cota value
     * @return int|null
     */
    public function getCota()
    {
        return $this->Cota;
    }
    /**
     * Set Cota value
     * @param int $cota
     * @return \StructType\ItemPagamento
     */
    public function setCota($cota = null)
    {
        // validation for constraint: int
        if (!is_null($cota) && !(is_int($cota) || ctype_digit($cota))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($cota, true), gettype($cota)), __LINE__);
        }
        $this->Cota = $cota;
        return $this;
    }
    /**
     * Get Exercicio value
     * @return int|null
     */
    public function getExercicio()
    {
        return $this->Exercicio;
    }
    /**
     * Set Exercicio value
     * @param int $exercicio
     * @return \StructType\ItemPagamento
     */
    public function setExercicio($exercicio = null)
    {
        // validation for constraint: int
        if (!is_null($exercicio) && !(is_int($exercicio) || ctype_digit($exercicio))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($exercicio, true), gettype($exercicio)), __LINE__);
        }
        $this->Exercicio = $exercicio;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ItemPagamento
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
