<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DebitoBase StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:DebitoBase
 * @subpackage Structs
 */
class DebitoBase extends AbstractStructBase
{
    /**
     * The CodigoOcorrencia
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CodigoOcorrencia;
    /**
     * The CodigoReceptora
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $CodigoReceptora;
    /**
     * The Identificador
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Identificador;
    /**
     * The LoteOnline
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $LoteOnline;
    /**
     * The NumeroPRODESP
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $NumeroPRODESP;
    /**
     * The NumeroTransacao
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $NumeroTransacao;
    /**
     * The Ocorrencia
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Ocorrencia;
    /**
     * The Servico
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Servico;
    /**
     * The TrocaCheque
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $TrocaCheque;
    /**
     * The ValorTotal
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ValorTotal;
    /**
     * The Veiculo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Veiculo
     */
    public $Veiculo;
    /**
     * Constructor method for DebitoBase
     * @uses DebitoBase::setCodigoOcorrencia()
     * @uses DebitoBase::setCodigoReceptora()
     * @uses DebitoBase::setIdentificador()
     * @uses DebitoBase::setLoteOnline()
     * @uses DebitoBase::setNumeroPRODESP()
     * @uses DebitoBase::setNumeroTransacao()
     * @uses DebitoBase::setOcorrencia()
     * @uses DebitoBase::setServico()
     * @uses DebitoBase::setTrocaCheque()
     * @uses DebitoBase::setValorTotal()
     * @uses DebitoBase::setVeiculo()
     * @param string $codigoOcorrencia
     * @param int $codigoReceptora
     * @param string $identificador
     * @param bool $loteOnline
     * @param int $numeroPRODESP
     * @param int $numeroTransacao
     * @param string $ocorrencia
     * @param string $servico
     * @param bool $trocaCheque
     * @param int $valorTotal
     * @param \StructType\Veiculo $veiculo
     */
    public function __construct($codigoOcorrencia = null, $codigoReceptora = null, $identificador = null, $loteOnline = null, $numeroPRODESP = null, $numeroTransacao = null, $ocorrencia = null, $servico = null, $trocaCheque = null, $valorTotal = null, \StructType\Veiculo $veiculo = null)
    {
        $this
            ->setCodigoOcorrencia($codigoOcorrencia)
            ->setCodigoReceptora($codigoReceptora)
            ->setIdentificador($identificador)
            ->setLoteOnline($loteOnline)
            ->setNumeroPRODESP($numeroPRODESP)
            ->setNumeroTransacao($numeroTransacao)
            ->setOcorrencia($ocorrencia)
            ->setServico($servico)
            ->setTrocaCheque($trocaCheque)
            ->setValorTotal($valorTotal)
            ->setVeiculo($veiculo);
    }
    /**
     * Get CodigoOcorrencia value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCodigoOcorrencia()
    {
        return isset($this->CodigoOcorrencia) ? $this->CodigoOcorrencia : null;
    }
    /**
     * Set CodigoOcorrencia value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $codigoOcorrencia
     * @return \StructType\DebitoBase
     */
    public function setCodigoOcorrencia($codigoOcorrencia = null)
    {
        // validation for constraint: string
        if (!is_null($codigoOcorrencia) && !is_string($codigoOcorrencia)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codigoOcorrencia, true), gettype($codigoOcorrencia)), __LINE__);
        }
        if (is_null($codigoOcorrencia) || (is_array($codigoOcorrencia) && empty($codigoOcorrencia))) {
            unset($this->CodigoOcorrencia);
        } else {
            $this->CodigoOcorrencia = $codigoOcorrencia;
        }
        return $this;
    }
    /**
     * Get CodigoReceptora value
     * @return int|null
     */
    public function getCodigoReceptora()
    {
        return $this->CodigoReceptora;
    }
    /**
     * Set CodigoReceptora value
     * @param int $codigoReceptora
     * @return \StructType\DebitoBase
     */
    public function setCodigoReceptora($codigoReceptora = null)
    {
        // validation for constraint: int
        if (!is_null($codigoReceptora) && !(is_int($codigoReceptora) || ctype_digit($codigoReceptora))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($codigoReceptora, true), gettype($codigoReceptora)), __LINE__);
        }
        $this->CodigoReceptora = $codigoReceptora;
        return $this;
    }
    /**
     * Get Identificador value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIdentificador()
    {
        return isset($this->Identificador) ? $this->Identificador : null;
    }
    /**
     * Set Identificador value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $identificador
     * @return \StructType\DebitoBase
     */
    public function setIdentificador($identificador = null)
    {
        // validation for constraint: string
        if (!is_null($identificador) && !is_string($identificador)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($identificador, true), gettype($identificador)), __LINE__);
        }
        if (is_null($identificador) || (is_array($identificador) && empty($identificador))) {
            unset($this->Identificador);
        } else {
            $this->Identificador = $identificador;
        }
        return $this;
    }
    /**
     * Get LoteOnline value
     * @return bool|null
     */
    public function getLoteOnline()
    {
        return $this->LoteOnline;
    }
    /**
     * Set LoteOnline value
     * @param bool $loteOnline
     * @return \StructType\DebitoBase
     */
    public function setLoteOnline($loteOnline = null)
    {
        // validation for constraint: boolean
        if (!is_null($loteOnline) && !is_bool($loteOnline)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($loteOnline, true), gettype($loteOnline)), __LINE__);
        }
        $this->LoteOnline = $loteOnline;
        return $this;
    }
    /**
     * Get NumeroPRODESP value
     * @return int|null
     */
    public function getNumeroPRODESP()
    {
        return $this->NumeroPRODESP;
    }
    /**
     * Set NumeroPRODESP value
     * @param int $numeroPRODESP
     * @return \StructType\DebitoBase
     */
    public function setNumeroPRODESP($numeroPRODESP = null)
    {
        // validation for constraint: int
        if (!is_null($numeroPRODESP) && !(is_int($numeroPRODESP) || ctype_digit($numeroPRODESP))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numeroPRODESP, true), gettype($numeroPRODESP)), __LINE__);
        }
        $this->NumeroPRODESP = $numeroPRODESP;
        return $this;
    }
    /**
     * Get NumeroTransacao value
     * @return int|null
     */
    public function getNumeroTransacao()
    {
        return $this->NumeroTransacao;
    }
    /**
     * Set NumeroTransacao value
     * @param int $numeroTransacao
     * @return \StructType\DebitoBase
     */
    public function setNumeroTransacao($numeroTransacao = null)
    {
        // validation for constraint: int
        if (!is_null($numeroTransacao) && !(is_int($numeroTransacao) || ctype_digit($numeroTransacao))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numeroTransacao, true), gettype($numeroTransacao)), __LINE__);
        }
        $this->NumeroTransacao = $numeroTransacao;
        return $this;
    }
    /**
     * Get Ocorrencia value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOcorrencia()
    {
        return isset($this->Ocorrencia) ? $this->Ocorrencia : null;
    }
    /**
     * Set Ocorrencia value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ocorrencia
     * @return \StructType\DebitoBase
     */
    public function setOcorrencia($ocorrencia = null)
    {
        // validation for constraint: string
        if (!is_null($ocorrencia) && !is_string($ocorrencia)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ocorrencia, true), gettype($ocorrencia)), __LINE__);
        }
        if (is_null($ocorrencia) || (is_array($ocorrencia) && empty($ocorrencia))) {
            unset($this->Ocorrencia);
        } else {
            $this->Ocorrencia = $ocorrencia;
        }
        return $this;
    }
    /**
     * Get Servico value
     * @return string|null
     */
    public function getServico()
    {
        return $this->Servico;
    }
    /**
     * Set Servico value
     * @uses \EnumType\TipoServico::valueIsValid()
     * @uses \EnumType\TipoServico::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $servico
     * @return \StructType\DebitoBase
     */
    public function setServico($servico = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TipoServico::valueIsValid($servico)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\TipoServico', is_array($servico) ? implode(', ', $servico) : var_export($servico, true), implode(', ', \EnumType\TipoServico::getValidValues())), __LINE__);
        }
        $this->Servico = $servico;
        return $this;
    }
    /**
     * Get TrocaCheque value
     * @return bool|null
     */
    public function getTrocaCheque()
    {
        return $this->TrocaCheque;
    }
    /**
     * Set TrocaCheque value
     * @param bool $trocaCheque
     * @return \StructType\DebitoBase
     */
    public function setTrocaCheque($trocaCheque = null)
    {
        // validation for constraint: boolean
        if (!is_null($trocaCheque) && !is_bool($trocaCheque)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($trocaCheque, true), gettype($trocaCheque)), __LINE__);
        }
        $this->TrocaCheque = $trocaCheque;
        return $this;
    }
    /**
     * Get ValorTotal value
     * @return int|null
     */
    public function getValorTotal()
    {
        return $this->ValorTotal;
    }
    /**
     * Set ValorTotal value
     * @param int $valorTotal
     * @return \StructType\DebitoBase
     */
    public function setValorTotal($valorTotal = null)
    {
        // validation for constraint: int
        if (!is_null($valorTotal) && !(is_int($valorTotal) || ctype_digit($valorTotal))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($valorTotal, true), gettype($valorTotal)), __LINE__);
        }
        $this->ValorTotal = $valorTotal;
        return $this;
    }
    /**
     * Get Veiculo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Veiculo|null
     */
    public function getVeiculo()
    {
        return isset($this->Veiculo) ? $this->Veiculo : null;
    }
    /**
     * Set Veiculo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Veiculo $veiculo
     * @return \StructType\DebitoBase
     */
    public function setVeiculo(\StructType\Veiculo $veiculo = null)
    {
        if (is_null($veiculo) || (is_array($veiculo) && empty($veiculo))) {
            unset($this->Veiculo);
        } else {
            $this->Veiculo = $veiculo;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DebitoBase
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
