<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DPVATPrimeiroRegistro StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:DPVATPrimeiroRegistro
 * @subpackage Structs
 */
class DPVATPrimeiroRegistro extends RetornoDPVAT
{
    /**
     * The DataNotaFiscal
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DataNotaFiscal;
    /**
     * The VeiculoZero
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $VeiculoZero;
    /**
     * Constructor method for DPVATPrimeiroRegistro
     * @uses DPVATPrimeiroRegistro::setDataNotaFiscal()
     * @uses DPVATPrimeiroRegistro::setVeiculoZero()
     * @param string $dataNotaFiscal
     * @param bool $veiculoZero
     */
    public function __construct($dataNotaFiscal = null, $veiculoZero = null)
    {
        $this
            ->setDataNotaFiscal($dataNotaFiscal)
            ->setVeiculoZero($veiculoZero);
    }
    /**
     * Get DataNotaFiscal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDataNotaFiscal()
    {
        return isset($this->DataNotaFiscal) ? $this->DataNotaFiscal : null;
    }
    /**
     * Set DataNotaFiscal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dataNotaFiscal
     * @return \StructType\DPVATPrimeiroRegistro
     */
    public function setDataNotaFiscal($dataNotaFiscal = null)
    {
        // validation for constraint: string
        if (!is_null($dataNotaFiscal) && !is_string($dataNotaFiscal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dataNotaFiscal, true), gettype($dataNotaFiscal)), __LINE__);
        }
        if (is_null($dataNotaFiscal) || (is_array($dataNotaFiscal) && empty($dataNotaFiscal))) {
            unset($this->DataNotaFiscal);
        } else {
            $this->DataNotaFiscal = $dataNotaFiscal;
        }
        return $this;
    }
    /**
     * Get VeiculoZero value
     * @return bool|null
     */
    public function getVeiculoZero()
    {
        return $this->VeiculoZero;
    }
    /**
     * Set VeiculoZero value
     * @param bool $veiculoZero
     * @return \StructType\DPVATPrimeiroRegistro
     */
    public function setVeiculoZero($veiculoZero = null)
    {
        // validation for constraint: boolean
        if (!is_null($veiculoZero) && !is_bool($veiculoZero)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($veiculoZero, true), gettype($veiculoZero)), __LINE__);
        }
        $this->VeiculoZero = $veiculoZero;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DPVATPrimeiroRegistro
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
