<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ConsultaTaxasDETRANDTO StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ConsultaTaxasDETRANDTO
 * @subpackage Structs
 */
class ConsultaTaxasDETRANDTO extends AbstractStructBase
{
    /**
     * The CodigoOcorrencia
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CodigoOcorrencia;
    /**
     * The CodigoSubServico
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $CodigoSubServico;
    /**
     * The Ocorrencia
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Ocorrencia;
    /**
     * The SubTaxas
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfTaxaDETRANDTO
     */
    public $SubTaxas;
    /**
     * Constructor method for ConsultaTaxasDETRANDTO
     * @uses ConsultaTaxasDETRANDTO::setCodigoOcorrencia()
     * @uses ConsultaTaxasDETRANDTO::setCodigoSubServico()
     * @uses ConsultaTaxasDETRANDTO::setOcorrencia()
     * @uses ConsultaTaxasDETRANDTO::setSubTaxas()
     * @param string $codigoOcorrencia
     * @param int $codigoSubServico
     * @param string $ocorrencia
     * @param \ArrayType\ArrayOfTaxaDETRANDTO $subTaxas
     */
    public function __construct($codigoOcorrencia = null, $codigoSubServico = null, $ocorrencia = null, \ArrayType\ArrayOfTaxaDETRANDTO $subTaxas = null)
    {
        $this
            ->setCodigoOcorrencia($codigoOcorrencia)
            ->setCodigoSubServico($codigoSubServico)
            ->setOcorrencia($ocorrencia)
            ->setSubTaxas($subTaxas);
    }
    /**
     * Get CodigoOcorrencia value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCodigoOcorrencia()
    {
        return isset($this->CodigoOcorrencia) ? $this->CodigoOcorrencia : null;
    }
    /**
     * Set CodigoOcorrencia value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $codigoOcorrencia
     * @return \StructType\ConsultaTaxasDETRANDTO
     */
    public function setCodigoOcorrencia($codigoOcorrencia = null)
    {
        // validation for constraint: string
        if (!is_null($codigoOcorrencia) && !is_string($codigoOcorrencia)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codigoOcorrencia, true), gettype($codigoOcorrencia)), __LINE__);
        }
        if (is_null($codigoOcorrencia) || (is_array($codigoOcorrencia) && empty($codigoOcorrencia))) {
            unset($this->CodigoOcorrencia);
        } else {
            $this->CodigoOcorrencia = $codigoOcorrencia;
        }
        return $this;
    }
    /**
     * Get CodigoSubServico value
     * @return int|null
     */
    public function getCodigoSubServico()
    {
        return $this->CodigoSubServico;
    }
    /**
     * Set CodigoSubServico value
     * @param int $codigoSubServico
     * @return \StructType\ConsultaTaxasDETRANDTO
     */
    public function setCodigoSubServico($codigoSubServico = null)
    {
        // validation for constraint: int
        if (!is_null($codigoSubServico) && !(is_int($codigoSubServico) || ctype_digit($codigoSubServico))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($codigoSubServico, true), gettype($codigoSubServico)), __LINE__);
        }
        $this->CodigoSubServico = $codigoSubServico;
        return $this;
    }
    /**
     * Get Ocorrencia value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOcorrencia()
    {
        return isset($this->Ocorrencia) ? $this->Ocorrencia : null;
    }
    /**
     * Set Ocorrencia value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ocorrencia
     * @return \StructType\ConsultaTaxasDETRANDTO
     */
    public function setOcorrencia($ocorrencia = null)
    {
        // validation for constraint: string
        if (!is_null($ocorrencia) && !is_string($ocorrencia)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ocorrencia, true), gettype($ocorrencia)), __LINE__);
        }
        if (is_null($ocorrencia) || (is_array($ocorrencia) && empty($ocorrencia))) {
            unset($this->Ocorrencia);
        } else {
            $this->Ocorrencia = $ocorrencia;
        }
        return $this;
    }
    /**
     * Get SubTaxas value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfTaxaDETRANDTO|null
     */
    public function getSubTaxas()
    {
        return isset($this->SubTaxas) ? $this->SubTaxas : null;
    }
    /**
     * Set SubTaxas value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfTaxaDETRANDTO $subTaxas
     * @return \StructType\ConsultaTaxasDETRANDTO
     */
    public function setSubTaxas(\ArrayType\ArrayOfTaxaDETRANDTO $subTaxas = null)
    {
        if (is_null($subTaxas) || (is_array($subTaxas) && empty($subTaxas))) {
            unset($this->SubTaxas);
        } else {
            $this->SubTaxas = $subTaxas;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ConsultaTaxasDETRANDTO
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
