<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for URLR ServiceType
 * @subpackage Services
 */
class URLR extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named URLRecibos
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\URLRecibos $parameters
     * @return \StructType\URLRecibosResponse|bool
     */
    public function URLRecibos(\StructType\URLRecibos $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->URLRecibos($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\URLRecibosResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
