<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Buscar ServiceType
 * @subpackage Services
 */
class Buscar extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named BuscarRecibos
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\BuscarRecibos $parameters
     * @return \StructType\BuscarRecibosResponse|bool
     */
    public function BuscarRecibos(\StructType\BuscarRecibos $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->BuscarRecibos($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\BuscarRecibosResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
