<?php

namespace EnumType;

/**
 * This class stands for TipoServico EnumType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:TipoServico
 * @subpackage Enumerations
 */
class TipoServico
{
    /**
     * Constant for value 'Transferencia'
     * @return string 'Transferencia'
     */
    const VALUE_TRANSFERENCIA = 'Transferencia';
    /**
     * Constant for value 'Licenciamento'
     * @return string 'Licenciamento'
     */
    const VALUE_LICENCIAMENTO = 'Licenciamento';
    /**
     * Constant for value 'TransferenciaComLicenciamento'
     * @return string 'TransferenciaComLicenciamento'
     */
    const VALUE_TRANSFERENCIA_COM_LICENCIAMENTO = 'TransferenciaComLicenciamento';
    /**
     * Constant for value 'SegundaViaCRLV'
     * @return string 'SegundaViaCRLV'
     */
    const VALUE_SEGUNDA_VIA_CRLV = 'SegundaViaCRLV';
    /**
     * Constant for value 'PrimeiroRegistro'
     * @return string 'PrimeiroRegistro'
     */
    const VALUE_PRIMEIRO_REGISTRO = 'PrimeiroRegistro';
    /**
     * Constant for value 'DebitosPendentes'
     * @return string 'DebitosPendentes'
     */
    const VALUE_DEBITOS_PENDENTES = 'DebitosPendentes';
    /**
     * Constant for value 'IPVA'
     * @return string 'IPVA'
     */
    const VALUE_IPVA = 'IPVA';
    /**
     * Constant for value 'DPVAT'
     * @return string 'DPVAT'
     */
    const VALUE_DPVAT = 'DPVAT';
    /**
     * Constant for value 'Multas'
     * @return string 'Multas'
     */
    const VALUE_MULTAS = 'Multas';
    /**
     * Constant for value 'Renainf'
     * @return string 'Renainf'
     */
    const VALUE_RENAINF = 'Renainf';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_TRANSFERENCIA
     * @uses self::VALUE_LICENCIAMENTO
     * @uses self::VALUE_TRANSFERENCIA_COM_LICENCIAMENTO
     * @uses self::VALUE_SEGUNDA_VIA_CRLV
     * @uses self::VALUE_PRIMEIRO_REGISTRO
     * @uses self::VALUE_DEBITOS_PENDENTES
     * @uses self::VALUE_IPVA
     * @uses self::VALUE_DPVAT
     * @uses self::VALUE_MULTAS
     * @uses self::VALUE_RENAINF
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_TRANSFERENCIA,
            self::VALUE_LICENCIAMENTO,
            self::VALUE_TRANSFERENCIA_COM_LICENCIAMENTO,
            self::VALUE_SEGUNDA_VIA_CRLV,
            self::VALUE_PRIMEIRO_REGISTRO,
            self::VALUE_DEBITOS_PENDENTES,
            self::VALUE_IPVA,
            self::VALUE_DPVAT,
            self::VALUE_MULTAS,
            self::VALUE_RENAINF,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
