<?php

namespace EnumType;

/**
 * This class stands for TipoIdentificador EnumType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:TipoIdentificador
 * @subpackage Enumerations
 */
class TipoIdentificador
{
    /**
     * Constant for value 'CPFCNPJ'
     * @return string 'CPFCNPJ'
     */
    const VALUE_CPFCNPJ = 'CPFCNPJ';
    /**
     * Constant for value 'Renavam'
     * @return string 'Renavam'
     */
    const VALUE_RENAVAM = 'Renavam';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_CPFCNPJ
     * @uses self::VALUE_RENAVAM
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_CPFCNPJ,
            self::VALUE_RENAVAM,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
