<?php

namespace EnumType;

/**
 * This class stands for TaxaCorreio EnumType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:TaxaCorreio
 * @subpackage Enumerations
 */
class TaxaCorreio
{
    /**
     * Constant for value 'Mensagem210'
     * @return string 'Mensagem210'
     */
    const VALUE_MENSAGEM_210 = 'Mensagem210';
    /**
     * Constant for value 'Obrigatorio'
     * @return string 'Obrigatorio'
     */
    const VALUE_OBRIGATORIO = 'Obrigatorio';
    /**
     * Constant for value 'NaoPodeReceberEmCasa'
     * @return string 'NaoPodeReceberEmCasa'
     */
    const VALUE_NAO_PODE_RECEBER_EM_CASA = 'NaoPodeReceberEmCasa';
    /**
     * Constant for value 'Opcional'
     * @return string 'Opcional'
     */
    const VALUE_OPCIONAL = 'Opcional';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_MENSAGEM_210
     * @uses self::VALUE_OBRIGATORIO
     * @uses self::VALUE_NAO_PODE_RECEBER_EM_CASA
     * @uses self::VALUE_OPCIONAL
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_MENSAGEM_210,
            self::VALUE_OBRIGATORIO,
            self::VALUE_NAO_PODE_RECEBER_EM_CASA,
            self::VALUE_OPCIONAL,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
