<?php

namespace EnumType;

/**
 * This class stands for IdentificacaoVeiculoDPVAT EnumType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:IdentificacaoVeiculoDPVAT
 * @subpackage Enumerations
 */
class IdentificacaoVeiculoDPVAT
{
    /**
     * Constant for value 'Oficial'
     * @return string 'Oficial'
     */
    const VALUE_OFICIAL = 'Oficial';
    /**
     * Constant for value 'Outros'
     * @return string 'Outros'
     */
    const VALUE_OUTROS = 'Outros';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_OFICIAL
     * @uses self::VALUE_OUTROS
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_OFICIAL,
            self::VALUE_OUTROS,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
