<?php

namespace EnumType;

/**
 * This class stands for CategoriaDPVAT EnumType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:CategoriaDPVAT
 * @subpackage Enumerations
 */
class CategoriaDPVAT
{
    /**
     * Constant for value 'Automoveis'
     * @return string 'Automoveis'
     */
    const VALUE_AUTOMOVEIS = 'Automoveis';
    /**
     * Constant for value 'AutomoveisAluguelAprendizagem'
     * @return string 'AutomoveisAluguelAprendizagem'
     */
    const VALUE_AUTOMOVEIS_ALUGUEL_APRENDIZAGEM = 'AutomoveisAluguelAprendizagem';
    /**
     * Constant for value 'OnibusMicroOnibusAluguelAprendizagem'
     * @return string 'OnibusMicroOnibusAluguelAprendizagem'
     */
    const VALUE_ONIBUS_MICRO_ONIBUS_ALUGUEL_APRENDIZAGEM = 'OnibusMicroOnibusAluguelAprendizagem';
    /**
     * Constant for value 'OnibusMicroOnibus'
     * @return string 'OnibusMicroOnibus'
     */
    const VALUE_ONIBUS_MICRO_ONIBUS = 'OnibusMicroOnibus';
    /**
     * Constant for value 'Ciclomotor'
     * @return string 'Ciclomotor'
     */
    const VALUE_CICLOMOTOR = 'Ciclomotor';
    /**
     * Constant for value 'CiclomotorMotonetaMotocicleta'
     * @return string 'CiclomotorMotonetaMotocicleta'
     */
    const VALUE_CICLOMOTOR_MOTONETA_MOTOCICLETA = 'CiclomotorMotonetaMotocicleta';
    /**
     * Constant for value 'CaminhaoCaminhonteTrator'
     * @return string 'CaminhaoCaminhonteTrator'
     */
    const VALUE_CAMINHAO_CAMINHONTE_TRATOR = 'CaminhaoCaminhonteTrator';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_AUTOMOVEIS
     * @uses self::VALUE_AUTOMOVEIS_ALUGUEL_APRENDIZAGEM
     * @uses self::VALUE_ONIBUS_MICRO_ONIBUS_ALUGUEL_APRENDIZAGEM
     * @uses self::VALUE_ONIBUS_MICRO_ONIBUS
     * @uses self::VALUE_CICLOMOTOR
     * @uses self::VALUE_CICLOMOTOR_MOTONETA_MOTOCICLETA
     * @uses self::VALUE_CAMINHAO_CAMINHONTE_TRATOR
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_AUTOMOVEIS,
            self::VALUE_AUTOMOVEIS_ALUGUEL_APRENDIZAGEM,
            self::VALUE_ONIBUS_MICRO_ONIBUS_ALUGUEL_APRENDIZAGEM,
            self::VALUE_ONIBUS_MICRO_ONIBUS,
            self::VALUE_CICLOMOTOR,
            self::VALUE_CICLOMOTOR_MOTONETA_MOTOCICLETA,
            self::VALUE_CAMINHAO_CAMINHONTE_TRATOR,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
