<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfDPVAT ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfDPVAT
 * @subpackage Arrays
 */
class ArrayOfDPVAT extends AbstractStructArrayBase
{
    /**
     * The DPVAT
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DPVAT[]
     */
    public $DPVAT;
    /**
     * Constructor method for ArrayOfDPVAT
     * @uses ArrayOfDPVAT::setDPVAT()
     * @param \StructType\DPVAT[] $dPVAT
     */
    public function __construct(array $dPVAT = array())
    {
        $this
            ->setDPVAT($dPVAT);
    }
    /**
     * Get DPVAT value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DPVAT[]|null
     */
    public function getDPVAT()
    {
        return isset($this->DPVAT) ? $this->DPVAT : null;
    }
    /**
     * This method is responsible for validating the values passed to the setDPVAT method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDPVAT method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDPVATForArrayConstraintsFromSetDPVAT(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfDPVATDPVATItem) {
            // validation for constraint: itemType
            if (!$arrayOfDPVATDPVATItem instanceof \StructType\DPVAT) {
                $invalidValues[] = is_object($arrayOfDPVATDPVATItem) ? get_class($arrayOfDPVATDPVATItem) : sprintf('%s(%s)', gettype($arrayOfDPVATDPVATItem), var_export($arrayOfDPVATDPVATItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The DPVAT property can only contain items of type \StructType\DPVAT, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set DPVAT value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\DPVAT[] $dPVAT
     * @return \ArrayType\ArrayOfDPVAT
     */
    public function setDPVAT(array $dPVAT = array())
    {
        // validation for constraint: array
        if ('' !== ($dPVATArrayErrorMessage = self::validateDPVATForArrayConstraintsFromSetDPVAT($dPVAT))) {
            throw new \InvalidArgumentException($dPVATArrayErrorMessage, __LINE__);
        }
        if (is_null($dPVAT) || (is_array($dPVAT) && empty($dPVAT))) {
            unset($this->DPVAT);
        } else {
            $this->DPVAT = $dPVAT;
        }
        return $this;
    }
    /**
     * Add item to DPVAT value
     * @throws \InvalidArgumentException
     * @param \StructType\DPVAT $item
     * @return \ArrayType\ArrayOfDPVAT
     */
    public function addToDPVAT(\StructType\DPVAT $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DPVAT) {
            throw new \InvalidArgumentException(sprintf('The DPVAT property can only contain items of type \StructType\DPVAT, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->DPVAT[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\DPVAT|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\DPVAT|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\DPVAT|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\DPVAT|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\DPVAT|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string DPVAT
     */
    public function getAttributeName()
    {
        return 'DPVAT';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfDPVAT
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
