<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SendTransaction StructType
 * @subpackage Structs
 */
class SendTransaction extends AbstractStructBase
{
    /**
     * The Transaction
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Transaction
     */
    public $Transaction;
    /**
     * The source
     * @var string
     */
    public $source;
    /**
     * The erpId
     * @var string
     */
    public $erpId;
    /**
     * The nodeName
     * @var string
     */
    public $nodeName;
    /**
     * The licenseId
     * @var string
     */
    public $licenseId;
    /**
     * Constructor method for SendTransaction
     * @uses SendTransaction::setTransaction()
     * @uses SendTransaction::setSource()
     * @uses SendTransaction::setErpId()
     * @uses SendTransaction::setNodeName()
     * @uses SendTransaction::setLicenseId()
     * @param \StructType\Transaction $transaction
     * @param string $source
     * @param string $erpId
     * @param string $nodeName
     * @param string $licenseId
     */
    public function __construct(\StructType\Transaction $transaction = null, $source = null, $erpId = null, $nodeName = null, $licenseId = null)
    {
        $this
            ->setTransaction($transaction)
            ->setSource($source)
            ->setErpId($erpId)
            ->setNodeName($nodeName)
            ->setLicenseId($licenseId);
    }
    /**
     * Get Transaction value
     * @return \StructType\Transaction|null
     */
    public function getTransaction()
    {
        return $this->Transaction;
    }
    /**
     * Set Transaction value
     * @param \StructType\Transaction $transaction
     * @return \StructType\SendTransaction
     */
    public function setTransaction(\StructType\Transaction $transaction = null)
    {
        $this->Transaction = $transaction;
        return $this;
    }
    /**
     * Get source value
     * @return string|null
     */
    public function getSource()
    {
        return $this->source;
    }
    /**
     * Set source value
     * @param string $source
     * @return \StructType\SendTransaction
     */
    public function setSource($source = null)
    {
        // validation for constraint: string
        if (!is_null($source) && !is_string($source)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($source, true), gettype($source)), __LINE__);
        }
        $this->source = $source;
        return $this;
    }
    /**
     * Get erpId value
     * @return string|null
     */
    public function getErpId()
    {
        return $this->erpId;
    }
    /**
     * Set erpId value
     * @param string $erpId
     * @return \StructType\SendTransaction
     */
    public function setErpId($erpId = null)
    {
        // validation for constraint: string
        if (!is_null($erpId) && !is_string($erpId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($erpId, true), gettype($erpId)), __LINE__);
        }
        $this->erpId = $erpId;
        return $this;
    }
    /**
     * Get nodeName value
     * @return string|null
     */
    public function getNodeName()
    {
        return $this->nodeName;
    }
    /**
     * Set nodeName value
     * @param string $nodeName
     * @return \StructType\SendTransaction
     */
    public function setNodeName($nodeName = null)
    {
        // validation for constraint: string
        if (!is_null($nodeName) && !is_string($nodeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nodeName, true), gettype($nodeName)), __LINE__);
        }
        $this->nodeName = $nodeName;
        return $this;
    }
    /**
     * Get licenseId value
     * @return string|null
     */
    public function getLicenseId()
    {
        return $this->licenseId;
    }
    /**
     * Set licenseId value
     * @param string $licenseId
     * @return \StructType\SendTransaction
     */
    public function setLicenseId($licenseId = null)
    {
        // validation for constraint: string
        if (!is_null($licenseId) && !is_string($licenseId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($licenseId, true), gettype($licenseId)), __LINE__);
        }
        $this->licenseId = $licenseId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SendTransaction
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
