<?php

namespace LewisLarsen\Ebay\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Add ServiceType
 * @subpackage Services
 */
class Add extends AbstractSoapClientBase
{
    /**
     * Sets the RequesterCredentials SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \LewisLarsen\Ebay\StructType\CustomSecurityHeaderType $requesterCredentials
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderRequesterCredentials(\LewisLarsen\Ebay\StructType\CustomSecurityHeaderType $requesterCredentials, $nameSpace = 'urn:ebay:apis:eBLBaseComponents', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'RequesterCredentials', $requesterCredentials, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named AddDispute
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: RequesterCredentials
     * - SOAPHeaderNamespaces: urn:ebay:apis:eBLBaseComponents
     * - SOAPHeaderTypes: \LewisLarsen\Ebay\StructType\CustomSecurityHeaderType
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \LewisLarsen\Ebay\StructType\AddDisputeRequestType $addDisputeRequest
     * @return \LewisLarsen\Ebay\StructType\AddDisputeResponseType|bool
     */
    public function AddDispute(\LewisLarsen\Ebay\StructType\AddDisputeRequestType $addDisputeRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->AddDispute($addDisputeRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddDisputeResponse
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: RequesterCredentials
     * - SOAPHeaderNamespaces: urn:ebay:apis:eBLBaseComponents
     * - SOAPHeaderTypes: \LewisLarsen\Ebay\StructType\CustomSecurityHeaderType
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \LewisLarsen\Ebay\StructType\AddDisputeResponseRequestType $addDisputeResponseRequest
     * @return \LewisLarsen\Ebay\StructType\AddDisputeResponseResponseType|bool
     */
    public function AddDisputeResponse(\LewisLarsen\Ebay\StructType\AddDisputeResponseRequestType $addDisputeResponseRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->AddDisputeResponse($addDisputeResponseRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddFixedPriceItem
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: RequesterCredentials
     * - SOAPHeaderNamespaces: urn:ebay:apis:eBLBaseComponents
     * - SOAPHeaderTypes: \LewisLarsen\Ebay\StructType\CustomSecurityHeaderType
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \LewisLarsen\Ebay\StructType\AddFixedPriceItemRequestType $addFixedPriceItemRequest
     * @return \LewisLarsen\Ebay\StructType\AddFixedPriceItemResponseType|bool
     */
    public function AddFixedPriceItem(\LewisLarsen\Ebay\StructType\AddFixedPriceItemRequestType $addFixedPriceItemRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->AddFixedPriceItem($addFixedPriceItemRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddItem
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: RequesterCredentials
     * - SOAPHeaderNamespaces: urn:ebay:apis:eBLBaseComponents
     * - SOAPHeaderTypes: \LewisLarsen\Ebay\StructType\CustomSecurityHeaderType
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \LewisLarsen\Ebay\StructType\AddItemRequestType $addItemRequest
     * @return \LewisLarsen\Ebay\StructType\AddItemResponseType|bool
     */
    public function AddItem(\LewisLarsen\Ebay\StructType\AddItemRequestType $addItemRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->AddItem($addItemRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddItems
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: RequesterCredentials
     * - SOAPHeaderNamespaces: urn:ebay:apis:eBLBaseComponents
     * - SOAPHeaderTypes: \LewisLarsen\Ebay\StructType\CustomSecurityHeaderType
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \LewisLarsen\Ebay\StructType\AddItemsRequestType $addItemsRequest
     * @return \LewisLarsen\Ebay\StructType\AddItemsResponseType|bool
     */
    public function AddItems(\LewisLarsen\Ebay\StructType\AddItemsRequestType $addItemsRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->AddItems($addItemsRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddMemberMessageAAQToPartner
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: RequesterCredentials
     * - SOAPHeaderNamespaces: urn:ebay:apis:eBLBaseComponents
     * - SOAPHeaderTypes: \LewisLarsen\Ebay\StructType\CustomSecurityHeaderType
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \LewisLarsen\Ebay\StructType\AddMemberMessageAAQToPartnerRequestType $addMemberMessageAAQToPartnerRequest
     * @return \LewisLarsen\Ebay\StructType\AddMemberMessageAAQToPartnerResponseType|bool
     */
    public function AddMemberMessageAAQToPartner(\LewisLarsen\Ebay\StructType\AddMemberMessageAAQToPartnerRequestType $addMemberMessageAAQToPartnerRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->AddMemberMessageAAQToPartner($addMemberMessageAAQToPartnerRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddMemberMessageRTQ
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: RequesterCredentials
     * - SOAPHeaderNamespaces: urn:ebay:apis:eBLBaseComponents
     * - SOAPHeaderTypes: \LewisLarsen\Ebay\StructType\CustomSecurityHeaderType
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \LewisLarsen\Ebay\StructType\AddMemberMessageRTQRequestType $addMemberMessageRTQRequest
     * @return \LewisLarsen\Ebay\StructType\AddMemberMessageRTQResponseType|bool
     */
    public function AddMemberMessageRTQ(\LewisLarsen\Ebay\StructType\AddMemberMessageRTQRequestType $addMemberMessageRTQRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->AddMemberMessageRTQ($addMemberMessageRTQRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddMemberMessagesAAQToBidder
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: RequesterCredentials
     * - SOAPHeaderNamespaces: urn:ebay:apis:eBLBaseComponents
     * - SOAPHeaderTypes: \LewisLarsen\Ebay\StructType\CustomSecurityHeaderType
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \LewisLarsen\Ebay\StructType\AddMemberMessagesAAQToBidderRequestType $addMemberMessagesAAQToBidderRequest
     * @return \LewisLarsen\Ebay\StructType\AddMemberMessagesAAQToBidderResponseType|bool
     */
    public function AddMemberMessagesAAQToBidder(\LewisLarsen\Ebay\StructType\AddMemberMessagesAAQToBidderRequestType $addMemberMessagesAAQToBidderRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->AddMemberMessagesAAQToBidder($addMemberMessagesAAQToBidderRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddOrder
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: RequesterCredentials
     * - SOAPHeaderNamespaces: urn:ebay:apis:eBLBaseComponents
     * - SOAPHeaderTypes: \LewisLarsen\Ebay\StructType\CustomSecurityHeaderType
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \LewisLarsen\Ebay\StructType\AddOrderRequestType $addOrderRequest
     * @return \LewisLarsen\Ebay\StructType\AddOrderResponseType|bool
     */
    public function AddOrder(\LewisLarsen\Ebay\StructType\AddOrderRequestType $addOrderRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->AddOrder($addOrderRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddSecondChanceItem
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: RequesterCredentials
     * - SOAPHeaderNamespaces: urn:ebay:apis:eBLBaseComponents
     * - SOAPHeaderTypes: \LewisLarsen\Ebay\StructType\CustomSecurityHeaderType
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \LewisLarsen\Ebay\StructType\AddSecondChanceItemRequestType $addSecondChanceItemRequest
     * @return \LewisLarsen\Ebay\StructType\AddSecondChanceItemResponseType|bool
     */
    public function AddSecondChanceItem(\LewisLarsen\Ebay\StructType\AddSecondChanceItemRequestType $addSecondChanceItemRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->AddSecondChanceItem($addSecondChanceItemRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddToItemDescription
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: RequesterCredentials
     * - SOAPHeaderNamespaces: urn:ebay:apis:eBLBaseComponents
     * - SOAPHeaderTypes: \LewisLarsen\Ebay\StructType\CustomSecurityHeaderType
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \LewisLarsen\Ebay\StructType\AddToItemDescriptionRequestType $addToItemDescriptionRequest
     * @return \LewisLarsen\Ebay\StructType\AddToItemDescriptionResponseType|bool
     */
    public function AddToItemDescription(\LewisLarsen\Ebay\StructType\AddToItemDescriptionRequestType $addToItemDescriptionRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->AddToItemDescription($addToItemDescriptionRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddToWatchList
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: RequesterCredentials
     * - SOAPHeaderNamespaces: urn:ebay:apis:eBLBaseComponents
     * - SOAPHeaderTypes: \LewisLarsen\Ebay\StructType\CustomSecurityHeaderType
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \LewisLarsen\Ebay\StructType\AddToWatchListRequestType $addToWatchListRequest
     * @return \LewisLarsen\Ebay\StructType\AddToWatchListResponseType|bool
     */
    public function AddToWatchList(\LewisLarsen\Ebay\StructType\AddToWatchListRequestType $addToWatchListRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->AddToWatchList($addToWatchListRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddTransactionConfirmationItem
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: RequesterCredentials
     * - SOAPHeaderNamespaces: urn:ebay:apis:eBLBaseComponents
     * - SOAPHeaderTypes: \LewisLarsen\Ebay\StructType\CustomSecurityHeaderType
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \LewisLarsen\Ebay\StructType\AddTransactionConfirmationItemRequestType $addTransactionConfirmationItemRequest
     * @return \LewisLarsen\Ebay\StructType\AddTransactionConfirmationItemResponseType|bool
     */
    public function AddTransactionConfirmationItem(\LewisLarsen\Ebay\StructType\AddTransactionConfirmationItemRequestType $addTransactionConfirmationItemRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->AddTransactionConfirmationItem($addTransactionConfirmationItemRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \LewisLarsen\Ebay\StructType\AddDisputeResponseResponseType|\LewisLarsen\Ebay\StructType\AddDisputeResponseType|\LewisLarsen\Ebay\StructType\AddFixedPriceItemResponseType|\LewisLarsen\Ebay\StructType\AddItemResponseType|\LewisLarsen\Ebay\StructType\AddItemsResponseType|\LewisLarsen\Ebay\StructType\AddMemberMessageAAQToPartnerResponseType|\LewisLarsen\Ebay\StructType\AddMemberMessageRTQResponseType|\LewisLarsen\Ebay\StructType\AddMemberMessagesAAQToBidderResponseType|\LewisLarsen\Ebay\StructType\AddOrderResponseType|\LewisLarsen\Ebay\StructType\AddSecondChanceItemResponseType|\LewisLarsen\Ebay\StructType\AddToItemDescriptionResponseType|\LewisLarsen\Ebay\StructType\AddToWatchListResponseType|\LewisLarsen\Ebay\StructType\AddTransactionConfirmationItemResponseType
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
