<?php

namespace LewisLarsen\Ebay\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Relist ServiceType
 * @subpackage Services
 */
class Relist extends AbstractSoapClientBase
{
    /**
     * Sets the RequesterCredentials SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \LewisLarsen\Ebay\StructType\CustomSecurityHeaderType $requesterCredentials
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderRequesterCredentials(\LewisLarsen\Ebay\StructType\CustomSecurityHeaderType $requesterCredentials, $nameSpace = 'urn:ebay:apis:eBLBaseComponents', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'RequesterCredentials', $requesterCredentials, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named RelistFixedPriceItem
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: RequesterCredentials
     * - SOAPHeaderNamespaces: urn:ebay:apis:eBLBaseComponents
     * - SOAPHeaderTypes: \LewisLarsen\Ebay\StructType\CustomSecurityHeaderType
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \LewisLarsen\Ebay\StructType\RelistFixedPriceItemRequestType $relistFixedPriceItemRequest
     * @return \LewisLarsen\Ebay\StructType\RelistFixedPriceItemResponseType|bool
     */
    public function RelistFixedPriceItem(\LewisLarsen\Ebay\StructType\RelistFixedPriceItemRequestType $relistFixedPriceItemRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->RelistFixedPriceItem($relistFixedPriceItemRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RelistItem
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: RequesterCredentials
     * - SOAPHeaderNamespaces: urn:ebay:apis:eBLBaseComponents
     * - SOAPHeaderTypes: \LewisLarsen\Ebay\StructType\CustomSecurityHeaderType
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \LewisLarsen\Ebay\StructType\RelistItemRequestType $relistItemRequest
     * @return \LewisLarsen\Ebay\StructType\RelistItemResponseType|bool
     */
    public function RelistItem(\LewisLarsen\Ebay\StructType\RelistItemRequestType $relistItemRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->RelistItem($relistItemRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \LewisLarsen\Ebay\StructType\RelistFixedPriceItemResponseType|\LewisLarsen\Ebay\StructType\RelistItemResponseType
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
