<?php

namespace LewisLarsen\Ebay\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetTokenStatusResponseType StructType
 * Meta information extracted from the WSDL
 * - documentation: The base response of the <b>GetTokenStatus</b> call. This call retrieves the status of a user token.
 * @subpackage Structs
 */
class GetTokenStatusResponseType extends AbstractResponseType
{
    /**
     * The TokenStatus
     * Meta information extracted from the WSDL
     * - documentation: This container value indicates the status and expiration date of a user token. If a user token was revoked, the date/time of the revocation is also returned under this container.
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\TokenStatusType
     */
    public $TokenStatus;
    /**
     * Constructor method for GetTokenStatusResponseType
     * @uses GetTokenStatusResponseType::setTokenStatus()
     * @param \LewisLarsen\Ebay\StructType\TokenStatusType $tokenStatus
     */
    public function __construct(\LewisLarsen\Ebay\StructType\TokenStatusType $tokenStatus = null)
    {
        $this
            ->setTokenStatus($tokenStatus);
    }
    /**
     * Get TokenStatus value
     * @return \LewisLarsen\Ebay\StructType\TokenStatusType|null
     */
    public function getTokenStatus()
    {
        return $this->TokenStatus;
    }
    /**
     * Set TokenStatus value
     * @param \LewisLarsen\Ebay\StructType\TokenStatusType $tokenStatus
     * @return \LewisLarsen\Ebay\StructType\GetTokenStatusResponseType
     */
    public function setTokenStatus(\LewisLarsen\Ebay\StructType\TokenStatusType $tokenStatus = null)
    {
        $this->TokenStatus = $tokenStatus;
        return $this;
    }
}
