<?php

namespace LewisLarsen\Ebay\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for StoreCustomPageArrayType ArrayType
 * Meta information extracted from the WSDL
 * - documentation: Set of Store custom pages.
 * @subpackage Arrays
 */
class StoreCustomPageArrayType extends AbstractStructArrayBase
{
    /**
     * The CustomPage
     * Meta information extracted from the WSDL
     * - documentation: A Store custom page.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\StoreCustomPageType[]
     */
    public $CustomPage;
    /**
     * Constructor method for StoreCustomPageArrayType
     * @uses StoreCustomPageArrayType::setCustomPage()
     * @param \LewisLarsen\Ebay\StructType\StoreCustomPageType[] $customPage
     */
    public function __construct(array $customPage = array())
    {
        $this
            ->setCustomPage($customPage);
    }
    /**
     * Get CustomPage value
     * @return \LewisLarsen\Ebay\StructType\StoreCustomPageType[]|null
     */
    public function getCustomPage()
    {
        return $this->CustomPage;
    }
    /**
     * This method is responsible for validating the values passed to the setCustomPage method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCustomPage method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCustomPageForArrayConstraintsFromSetCustomPage(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $storeCustomPageArrayTypeCustomPageItem) {
            // validation for constraint: itemType
            if (!$storeCustomPageArrayTypeCustomPageItem instanceof \LewisLarsen\Ebay\StructType\StoreCustomPageType) {
                $invalidValues[] = is_object($storeCustomPageArrayTypeCustomPageItem) ? get_class($storeCustomPageArrayTypeCustomPageItem) : sprintf('%s(%s)', gettype($storeCustomPageArrayTypeCustomPageItem), var_export($storeCustomPageArrayTypeCustomPageItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CustomPage property can only contain items of type \LewisLarsen\Ebay\StructType\StoreCustomPageType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CustomPage value
     * @throws \InvalidArgumentException
     * @param \LewisLarsen\Ebay\StructType\StoreCustomPageType[] $customPage
     * @return \LewisLarsen\Ebay\ArrayType\StoreCustomPageArrayType
     */
    public function setCustomPage(array $customPage = array())
    {
        // validation for constraint: array
        if ('' !== ($customPageArrayErrorMessage = self::validateCustomPageForArrayConstraintsFromSetCustomPage($customPage))) {
            throw new \InvalidArgumentException($customPageArrayErrorMessage, __LINE__);
        }
        $this->CustomPage = $customPage;
        return $this;
    }
    /**
     * Add item to CustomPage value
     * @throws \InvalidArgumentException
     * @param \LewisLarsen\Ebay\StructType\StoreCustomPageType $item
     * @return \LewisLarsen\Ebay\ArrayType\StoreCustomPageArrayType
     */
    public function addToCustomPage(\LewisLarsen\Ebay\StructType\StoreCustomPageType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \LewisLarsen\Ebay\StructType\StoreCustomPageType) {
            throw new \InvalidArgumentException(sprintf('The CustomPage property can only contain items of type \LewisLarsen\Ebay\StructType\StoreCustomPageType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->CustomPage[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \LewisLarsen\Ebay\StructType\StoreCustomPageType|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \LewisLarsen\Ebay\StructType\StoreCustomPageType|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \LewisLarsen\Ebay\StructType\StoreCustomPageType|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \LewisLarsen\Ebay\StructType\StoreCustomPageType|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \LewisLarsen\Ebay\StructType\StoreCustomPageType|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string CustomPage
     */
    public function getAttributeName()
    {
        return 'CustomPage';
    }
}
