<?php

namespace LewisLarsen\Ebay\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SetStorePreferencesRequestType StructType
 * Meta information extracted from the WSDL
 * - documentation: Sets the preferences for a user's eBay Store. Sellers must have an eBay Store subscription in order to use this call.
 * @subpackage Structs
 */
class SetStorePreferencesRequestType extends AbstractRequestType
{
    /**
     * The StorePreferences
     * Meta information extracted from the WSDL
     * - documentation: This container is used to set the eBay Store's preferences. Currently, the only applicable eBay Store preferences are Store vacation preferences.
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\StorePreferencesType
     */
    public $StorePreferences;
    /**
     * Constructor method for SetStorePreferencesRequestType
     * @uses SetStorePreferencesRequestType::setStorePreferences()
     * @param \LewisLarsen\Ebay\StructType\StorePreferencesType $storePreferences
     */
    public function __construct(\LewisLarsen\Ebay\StructType\StorePreferencesType $storePreferences = null)
    {
        $this
            ->setStorePreferences($storePreferences);
    }
    /**
     * Get StorePreferences value
     * @return \LewisLarsen\Ebay\StructType\StorePreferencesType|null
     */
    public function getStorePreferences()
    {
        return $this->StorePreferences;
    }
    /**
     * Set StorePreferences value
     * @param \LewisLarsen\Ebay\StructType\StorePreferencesType $storePreferences
     * @return \LewisLarsen\Ebay\StructType\SetStorePreferencesRequestType
     */
    public function setStorePreferences(\LewisLarsen\Ebay\StructType\StorePreferencesType $storePreferences = null)
    {
        $this->StorePreferences = $storePreferences;
        return $this;
    }
}
