<?php

namespace LewisLarsen\Ebay\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FeatureDefinitionsType StructType
 * Meta information extracted from the WSDL
 * - documentation: This type is used by the <b>FeatureDefinitions</b> container that is returned in the <b>GetCategoryFeatures</b> response to indicate which eBay features are available on one more eBay API-enabled sites. If no <b>FeatureID</b> field
 * is included in the call request, all eBay features available for one more eBay API-enabled sites are returned. If one or more <b>FeatureID</b> fields are included in the call request, only those eBay features specified in each <b>FeatureID</b> field
 * are returned in the response.
 * @subpackage Structs
 */
class FeatureDefinitionsType extends AbstractStructBase
{
    /**
     * The ListingDurations
     * Meta information extracted from the WSDL
     * - documentation: This field is returned as an empty element (a boolean value is not returned) if one or more eBay API-enabled sites support multiple listing durations. Listing durations will vary based on the selling format (auction, fixed-price, or
     * classified ad) and the eBay category. This field will not be returned if one or more <b>FeatureID</b> fields are included in the call request and <code>ListingDurations</code> is not one of the values passed into those <a
     * href="types/FeatureIDCodeType.html">FeatureID</a> fields.
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\ListingDurationDefinitionsType
     */
    public $ListingDurations;
    /**
     * The ShippingTermsRequired
     * Meta information extracted from the WSDL
     * - documentation: This field is returned as an empty element (a boolean value is not returned) if one or more eBay API-enabled sites require shipping terms at listing time, whiche includesat least one domestic shipping service option and its
     * associated costs. This field will not be returned if one or more <b>FeatureID</b> fields are included in the call request and <code>ShippingTermsRequired</code> is not one of the values passed into those <a
     * href="types/FeatureIDCodeType.html">FeatureID</a> fields.
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\ShippingTermRequiredDefinitionType
     */
    public $ShippingTermsRequired;
    /**
     * The BestOfferEnabled
     * Meta information extracted from the WSDL
     * - documentation: This field is returned as an empty element (a boolean value is not returned) if one or more eBay API-enabled sites support the Best Offer feature. The Best Offer feature allows buyers and sellers to negotiate the price of the item.
     * This field will not be returned if one or more <b>FeatureID</b> fields are included in the call request and <code>BestOfferEnabled</code> is not one of the values passed into those <a href="types/FeatureIDCodeType.html">FeatureID</a> fields.
     * <br/><br/> <span class="tablenote"><b>Note: </b> The Best Offer feature is now available for auction listings on the following sites: US, Canada, UK, Germany, Australia, France, Italy, and Spain. However, sellers must choose between offering Best
     * Offer or Buy It Now on an auction listing, as both features cannot be enabled on the same auction listing. </span>
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\BestOfferEnabledDefinitionType
     */
    public $BestOfferEnabled;
    /**
     * The DutchBINEnabled
     * Meta information extracted from the WSDL
     * - documentation: This field is deprecated.
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\DutchBINEnabledDefinitionType
     */
    public $DutchBINEnabled;
    /**
     * The UserConsentRequired
     * Meta information extracted from the WSDL
     * - documentation: This field is deprecated.
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\UserConsentRequiredDefinitionType
     */
    public $UserConsentRequired;
    /**
     * The HomePageFeaturedEnabled
     * Meta information extracted from the WSDL
     * - documentation: This field is returned as an empty element (a boolean value is not returned) if one or more eBay API-enabled sites support the temporary display of a seller's listing on a section of the eBay Home Page. This field will not be
     * returned if one or more <b>FeatureID</b> fields are included in the call request and <code>HomePageFeaturedEnabled</code> is not one of the values passed into those <a href="types/FeatureIDCodeType.html">FeatureID</a> fields.
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\HomePageFeaturedEnabledDefinitionType
     */
    public $HomePageFeaturedEnabled;
    /**
     * The ProPackEnabled
     * Meta information extracted from the WSDL
     * - documentation: This field is returned as an empty element (a boolean value is not returned) if one or more eBay API-enabled sites support the Pro Pack listing upgrade bundle. This field will not be returned if one or more <b>FeatureID</b> fields
     * are included in the call request and <code>ProPackEnabled</code> is not one of the values passed into those <a href="types/FeatureIDCodeType.html">FeatureID</a> fields.
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\ProPackEnabledDefinitionType
     */
    public $ProPackEnabled;
    /**
     * The BasicUpgradePackEnabled
     * Meta information extracted from the WSDL
     * - documentation: This field is deprecated.
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\BasicUpgradePackEnabledDefinitionType
     */
    public $BasicUpgradePackEnabled;
    /**
     * The ValuePackEnabled
     * Meta information extracted from the WSDL
     * - documentation: This field is returned as an empty element (a boolean value is not returned) if one or more eBay API-enabled sites support the Value Pack listing upgrade bundle. This field will not be returned if one or more <b>FeatureID</b> fields
     * are included in the call request and <code>ValuePackEnabled</code> is not one of the values passed into those <a href="types/FeatureIDCodeType.html">FeatureID</a> fields.
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\ValuePackEnabledDefinitionType
     */
    public $ValuePackEnabled;
    /**
     * The ProPackPlusEnabled
     * Meta information extracted from the WSDL
     * - documentation: This field is returned as an empty element (a boolean value is not returned) if one or more eBay API-enabled sites support the Pro Pack Plus listing upgrade bundle. This field will not be returned if one or more <b>FeatureID</b>
     * fields are included in the call request and <code>ProPackPlusEnabled</code> is not one of the values passed into those <a href="types/FeatureIDCodeType.html">FeatureID</a> fields.
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\ProPackPlusEnabledDefinitionType
     */
    public $ProPackPlusEnabled;
    /**
     * The AdFormatEnabled
     * Meta information extracted from the WSDL
     * - documentation: This field is returned as an empty element (a boolean value is not returned) if one or more eBay API-enabled sites support Classified Ad listings. This field will not be returned if one or more <b>FeatureID</b> fields are included in
     * the call request and <code>AdFormatEnabled</code> is not one of the values passed into those <a href="types/FeatureIDCodeType.html">FeatureID</a> fields.
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\AdFormatEnabledDefinitionType
     */
    public $AdFormatEnabled;
    /**
     * The BestOfferCounterEnabled
     * Meta information extracted from the WSDL
     * - documentation: This field is returned as an empty element (a boolean value is not returned) if one or more eBay API-enabled sites support counter offers to Best Offers. The Best Offer feature allows buyers and sellers to negotiate the price of the
     * item, and once a Best Offer price is proposed, the seller can send the buyer a counter offer, and a buyer may even send another counter offer to the seller's counter offer. This field will not be returned if one or more <b>FeatureID</b> fields are
     * included in the call request and <code>BestOfferCounterEnabled</code> is not one of the values passed into those <a href="types/FeatureIDCodeType.html">FeatureID</a> fields. <br/><br/> <span class="tablenote"><b>Note: </b> The Best Offer feature is
     * now available for auction listings on the following sites: US, Canada, UK, Germany, Australia, France, Italy, and Spain. However, sellers must choose between offering Best Offer or Buy It Now on an auction listing, as both features cannot be enabled
     * on the same auction listing. </span>
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\BestOfferCounterEnabledDefinitionType
     */
    public $BestOfferCounterEnabled;
    /**
     * The BestOfferAutoDeclineEnabled
     * Meta information extracted from the WSDL
     * - documentation: This field is returned as an empty element (a boolean value is not returned) if one or more eBay API-enabled sites support the Best Offer Auto-Decline feature. The Best Offer Auto-Decline feature allows a seller to set a lower
     * threshold dollar value on a listing, and any Best Offer amount below this amount is automatically declined by the eBay system. This field will not be returned if one or more <b>FeatureID</b> fields are included in the call request and
     * <code>BestOfferAutoDeclineEnabled</code> is not one of the values passed into those <a href="types/FeatureIDCodeType.html">FeatureID</a> fields. <br/><br/> <span class="tablenote"><b>Note: </b> The Best Offer feature is now available for auction
     * listings on the following sites: US, Canada, UK, Germany, Australia, France, Italy, and Spain. However, sellers must choose between offering Best Offer or Buy It Now on an auction listing, as both features cannot be enabled on the same auction
     * listing. </span>
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\BestOfferAutoDeclineEnabledDefinitionType
     */
    public $BestOfferAutoDeclineEnabled;
    /**
     * The LocalMarketSpecialitySubscription
     * Meta information extracted from the WSDL
     * - documentation: This field is returned as an empty element (a boolean value is not returned) if one or more eBay API-enabled sites support Motors Local Market listings for dealership subscribers with a specialty subscription. This field will not be
     * returned if one or more <b>FeatureID</b> fields are included in the call request and <code>LocalMarketSpecialitySubscription</code> is not one of the values passed into those <a href="types/FeatureIDCodeType.html">FeatureID</a> fields. <br><br> See
     * the <a href=" http://pages.ebay.com/help/sell/formats.html#market" target="_blank">Motors Local Market listing help topic</a> for more information.
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\LocalMarketSpecialitySubscriptionDefinitionType
     */
    public $LocalMarketSpecialitySubscription;
    /**
     * The LocalMarketRegularSubscription
     * Meta information extracted from the WSDL
     * - documentation: TThis field is returned as an empty element (a boolean value is not returned) if one or more eBay API-enabled sites support Motors Local Market listings for dealership subscribers with a regular subscription. This field will not be
     * returned if one or more <b>FeatureID</b> fields are included in the call request and <code>LocalMarketRegularSubscription</code> is not one of the values passed into those <a href="types/FeatureIDCodeType.html">FeatureID</a> fields. <br><br> See the
     * <a href=" http://pages.ebay.com/help/sell/formats.html#market" target="_blank">Motors Local Market listing help topic</a> for more information.
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\LocalMarketRegularSubscriptionDefinitionType
     */
    public $LocalMarketRegularSubscription;
    /**
     * The LocalMarketPremiumSubscription
     * Meta information extracted from the WSDL
     * - documentation: This field is returned as an empty element (a boolean value is not returned) if one or more eBay API-enabled sites support Motors Local Market listings for dealership subscribers with a premium subscription. This field will not be
     * returned if one or more <b>FeatureID</b> fields are included in the call request and <code>LocalMarketPremiumSubscription</code> is not one of the values passed into those <a href="types/FeatureIDCodeType.html">FeatureID</a> fields. <br><br> See the
     * <a href=" http://pages.ebay.com/help/sell/formats.html#market" target="_blank">Motors Local Market listing help topic</a> for more information.
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\LocalMarketPremiumSubscriptionDefinitionType
     */
    public $LocalMarketPremiumSubscription;
    /**
     * The LocalMarketNonSubscription
     * Meta information extracted from the WSDL
     * - documentation: This field is returned as an empty element (a boolean value is not returned) if one or more eBay API-enabled sites support Motors Local Market listings for dealerships without a subscription. This field will not be returned if one or
     * more <b>FeatureID</b> fields are included in the call request and <code>LocalMarketNonSubscription</code> is not one of the values passed into those <a href="types/FeatureIDCodeType.html">FeatureID</a> fields. <br><br> See the <a href="
     * http://pages.ebay.com/help/sell/formats.html#market" target="_blank">Motors Local Market listing help topic</a> for more information.
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\LocalMarketNonSubscriptionDefinitionType
     */
    public $LocalMarketNonSubscription;
    /**
     * The ExpressEnabled
     * Meta information extracted from the WSDL
     * - documentation: This field is deprecated.
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\ExpressEnabledDefinitionType
     */
    public $ExpressEnabled;
    /**
     * The ExpressPicturesRequired
     * Meta information extracted from the WSDL
     * - documentation: This field is deprecated.
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\ExpressPicturesRequiredDefinitionType
     */
    public $ExpressPicturesRequired;
    /**
     * The ExpressConditionRequired
     * Meta information extracted from the WSDL
     * - documentation: This field is deprecated.
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\ExpressConditionRequiredDefinitionType
     */
    public $ExpressConditionRequired;
    /**
     * The MinimumReservePrice
     * Meta information extracted from the WSDL
     * - documentation: This field is returned as an empty element (a boolean value is not returned) if one or more eBay API-enabled sites require a minimum reserve price for an auction item. This feature is only applicable to auction listings. This field
     * will not be returned if one or more <b>FeatureID</b> fields are included in the call request and <code>MinimumReservePrice</code> is not one of the values passed into those <a href="types/FeatureIDCodeType.html">FeatureID</a> fields.
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\MinimumReservePriceDefinitionType
     */
    public $MinimumReservePrice;
    /**
     * The TransactionConfirmationRequestEnabled
     * Meta information extracted from the WSDL
     * - documentation: This field is deprecated.
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\TCREnabledDefinitionType
     */
    public $TransactionConfirmationRequestEnabled;
    /**
     * The SellerContactDetailsEnabled
     * Meta information extracted from the WSDL
     * - documentation: This field is returned as an empty element (a boolean value is not returned) if one or more eBay API-enabled sites allow the seller to provide contact information at listing time for a classified ad listing. This feature is only
     * applicable to classified ad listings. This field will not be returned if one or more <b>FeatureID</b> fields are included in the call request and <code>SellerContactDetailsEnabled</code> is not one of the values passed into those <a
     * href="types/FeatureIDCodeType.html">FeatureID</a> fields.
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\SellerContactDetailsEnabledDefinitionType
     */
    public $SellerContactDetailsEnabled;
    /**
     * The StoreInventoryEnabled
     * Meta information extracted from the WSDL
     * - documentation: This field is deprecated.
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\StoreInventoryEnabledDefinitionType
     */
    public $StoreInventoryEnabled;
    /**
     * The SkypeMeTransactionalEnabled
     * Meta information extracted from the WSDL
     * - documentation: This field is deprecated.
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\SkypeMeTransactionalEnabledDefinitionType
     */
    public $SkypeMeTransactionalEnabled;
    /**
     * The SkypeMeNonTransactionalEnabled
     * Meta information extracted from the WSDL
     * - documentation: This field is deprecated.
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\SkypeMeNonTransactionalEnabledDefinitionType
     */
    public $SkypeMeNonTransactionalEnabled;
    /**
     * The LocalListingDistancesRegular
     * Meta information extracted from the WSDL
     * - documentation: This field is returned as an empty element (a boolean value is not returned) if one or more eBay API-enabled sites support allow dealership subscribers with a regular subscription to specify local market radius for Motors Local
     * Market listings. This field will not be returned if one or more <b>FeatureID</b> fields are included in the call request and <code>LocalListingDistancesRegular</code> is not one of the values passed into those <a
     * href="types/FeatureIDCodeType.html">FeatureID</a> fields.
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\LocalListingDistancesRegularDefinitionType
     */
    public $LocalListingDistancesRegular;
    /**
     * The LocalListingDistancesSpecialty
     * Meta information extracted from the WSDL
     * - documentation: This field is returned as an empty element (a boolean value is not returned) if one or more eBay API-enabled sites allow dealership subscribers with a specialty subscription to specify local market radius for Motors Local Market
     * listings. This field will not be returned if one or more <b>FeatureID</b> fields are included in the call request and <code>LocalListingDistancesSpecialty</code> is not one of the values passed into those <a
     * href="types/FeatureIDCodeType.html">FeatureID</a> fields.
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\LocalListingDistancesSpecialtyDefinitionType
     */
    public $LocalListingDistancesSpecialty;
    /**
     * The LocalListingDistancesNonSubscription
     * Meta information extracted from the WSDL
     * - documentation: This field is returned as an empty element (a boolean value is not returned) if one or more eBay API-enabled sites allow dealership subscribers without a subscription to specify local market radius for Motors Local Market listings.
     * This field will not be returned if one or more <b>FeatureID</b> fields are included in the call request and <code>LocalListingDistancesNonSubscription</code> is not one of the values passed into those <a
     * href="types/FeatureIDCodeType.html">FeatureID</a> fields.
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\LocalListingDistancesNonSubscriptionDefinitionType
     */
    public $LocalListingDistancesNonSubscription;
    /**
     * The ClassifiedAdPaymentMethodEnabled
     * Meta information extracted from the WSDL
     * - documentation: This field is returned as an empty element (a boolean value is not returned) if one or more eBay API-enabled sites allow for the display of acceptable payment methods for classified ad listings. This field will not be returned if one
     * or more <b>FeatureID</b> fields are included in the call request and <code>ClassifiedAdPaymentMethodEnabled</code> is not one of the values passed into those <a href="types/FeatureIDCodeType.html">FeatureID</a> fields.
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\ClassifiedAdPaymentMethodEnabledDefinitionType
     */
    public $ClassifiedAdPaymentMethodEnabled;
    /**
     * The ClassifiedAdShippingMethodEnabled
     * Meta information extracted from the WSDL
     * - documentation: This field is returned as an empty element (a boolean value is not returned) if one or more eBay API-enabled sites allow for the display of shipping service options for classified ad listings. This field will not be returned if one
     * or more <b>FeatureID</b> fields are included in the call request and <code>ClassifiedAdShippingMethodEnabled</code> is not one of the values passed into those <a href="types/FeatureIDCodeType.html">FeatureID</a> fields.
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\ClassifiedAdShippingMethodEnabledDefinitionType
     */
    public $ClassifiedAdShippingMethodEnabled;
    /**
     * The ClassifiedAdBestOfferEnabled
     * Meta information extracted from the WSDL
     * - documentation: This field is returned as an empty element (a boolean value is not returned) if one or more eBay API-enabled sites support the Best Offer feature for classified ad listings. The Best Offer feature allows buyers and sellers to
     * negotiate the price of the item. This field will not be returned if one or more <b>FeatureID</b> fields are included in the call request and <code>ClassifiedAdBestOfferEnabled</code> is not one of the values passed into those <a
     * href="types/FeatureIDCodeType.html">FeatureID</a> fields.
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\ClassifiedAdBestOfferEnabledDefinitionType
     */
    public $ClassifiedAdBestOfferEnabled;
    /**
     * The ClassifiedAdCounterOfferEnabled
     * Meta information extracted from the WSDL
     * - documentation: This field is returned as an empty element (a boolean value is not returned) if one or more eBay API-enabled sites support counter offers to Best Offers for classified ad listings. The Best Offer feature allows buyers and sellers to
     * negotiate the price of the item, and once a Best Offer price is proposed, the seller can send the buyer a counter offer, and a buyer may even send another counter offer to the seller's counter offer. This field will not be returned if one or more
     * <b>FeatureID</b> fields are included in the call request and <code>ClassifiedAdCounterOfferEnabled</code> is not one of the values passed into those <a href="types/FeatureIDCodeType.html">FeatureID</a> fields.
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\ClassifiedAdCounterOfferEnabledDefinitionType
     */
    public $ClassifiedAdCounterOfferEnabled;
    /**
     * The ClassifiedAdAutoDeclineEnabled
     * Meta information extracted from the WSDL
     * - documentation: This field is returned as an empty element (a boolean value is not returned) if one or more eBay API-enabled sites support the Best Offer Auto-Decline feature for classified ad listings. The Best Offer Auto-Decline feature allows a
     * seller to set a lower threshold dollar value on a listing, and any Best Offer amount below this amount is automatically declined by the eBay system. This field will not be returned if one or more <b>FeatureID</b> fields are included in the call
     * request and <code>ClassifiedAdAutoDeclineEnabled</code> is not one of the values passed into those <a href="types/FeatureIDCodeType.html">FeatureID</a> fields.
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\ClassifiedAdAutoDeclineEnabledDefinitionType
     */
    public $ClassifiedAdAutoDeclineEnabled;
    /**
     * The ClassifiedAdContactByPhoneEnabled
     * Meta information extracted from the WSDL
     * - documentation: This field is returned as an empty element (a boolean value is not returned) if one or more eBay API-enabled sites support the use of a phone number when contacting the seller about a classified ad listing. This field will not be
     * returned if one or more <b>FeatureID</b> fields are included in the call request and <code>ClassifiedAdContactByPhoneEnabled</code> is not one of the values passed into those <a href="types/FeatureIDCodeType.html">FeatureID</a> fields.
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\ClassifiedAdContactByPhoneEnabledDefinitionType
     */
    public $ClassifiedAdContactByPhoneEnabled;
    /**
     * The ClassifiedAdContactByEmailEnabled
     * Meta information extracted from the WSDL
     * - documentation: This field is returned as an empty element (a boolean value is not returned) if one or more eBay API-enabled sites support the use of an email address when contacting the seller about a classified ad listing. This field will not be
     * returned if one or more <b>FeatureID</b> fields are included in the call request and <code>ClassifiedAdContactByEmailEnabled</code> is not one of the values passed into those <a href="types/FeatureIDCodeType.html">FeatureID</a> fields.
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\ClassifiedAdContactByEmailEnabledDefintionType
     */
    public $ClassifiedAdContactByEmailEnabled;
    /**
     * The SafePaymentRequired
     * Meta information extracted from the WSDL
     * - documentation: This field is returned as an empty element (a boolean value is not returned) if one or more eBay API-enabled sites require at least one form of safe payment. This field will not be returned if one or more <b>FeatureID</b> fields are
     * included in the call request and <code>SafePaymentRequired</code> is not one of the values passed into those <a href="types/FeatureIDCodeType.html">FeatureID</a> fields. <br><br> For the US, Canada and Australia sites, users registered after January
     * 17, 2007 are required to offer at least one safe payment method (i.e. PayPal/PaisaPay, or one of the credit cards specified in <b>Item.PaymentMethods</b>). <br><br> If a seller has a <code>SafePaymentExempt</code> status, they are exempt from the
     * requirement to offer at least one safe payment method when listing an item on a site that has the safe payment requirement. <br> The safe payment requirement also applies to two-category listings that have one ship-to or available-to location in the
     * US, Canada, or Australia. The French Canadian (CAFR) site is a special case, because listings on the CAFR site with ship-to or available-to locations in Canada do not require a Safe Payment method, yet listings on the CAFR site with ship-to or
     * available-to locations in the US or Australia do require a Safe Payment method. <br><br> The Business and Industrial, Motors, Real Estate, and Mature Audiences categories, and all listings that don't support the <b>Item.PaymentMethods</b> field are
     * exempt from this requirement. Therefore, listings in those categories do not require a safe payment method.
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\SafePaymentRequiredDefinitionType
     */
    public $SafePaymentRequired;
    /**
     * The ClassifiedAdPayPerLeadEnabled
     * Meta information extracted from the WSDL
     * - documentation: This field is deprecated.
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\ClassifiedAdPayPerLeadEnabledDefinitionType
     */
    public $ClassifiedAdPayPerLeadEnabled;
    /**
     * The ItemSpecificsEnabled
     * Meta information extracted from the WSDL
     * - documentation: This field is returned as an empty element (a boolean value is not returned) if one or more eBay API-enabled sites support the use of Item Specifics in listings. Item Specifics are typical aspects that items in a specific category
     * tend to have, and they allow sellers to provide descriptive details of an item in a structured manner. For example, in a jewelry category, sellers might describe lockets with Item Specifics name-value pairs like "Chain Length=18 in." and "Main
     * Shape=Heart", or in a Washers & Dryers category, sellers might include "Type=Top-Loading". This field will not be returned if one or more <b>FeatureID</b> fields are included in the call request and <code>ItemSpecificsEnabled</code> is not one of the
     * values passed into those <a href="types/FeatureIDCodeType.html">FeatureID</a> fields.
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\ItemSpecificsEnabledDefinitionType
     */
    public $ItemSpecificsEnabled;
    /**
     * The PaisaPayFullEscrowEnabled
     * Meta information extracted from the WSDL
     * - documentation: This field is returned as an empty element (a boolean value is not returned) if one or more eBay API-enabled sites support the use of PaisaPay Full Escrow as a payment method. This field will not be returned if one or more
     * <b>FeatureID</b> fields are included in the call request and <code>PaisaPayFullEscrowEnabled</code> is not one of the values passed into those <a href="types/FeatureIDCodeType.html">FeatureID</a> fields.
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\PaisaPayFullEscrowEnabledDefinitionType
     */
    public $PaisaPayFullEscrowEnabled;
    /**
     * The ISBNIdentifierEnabled
     * Meta information extracted from the WSDL
     * - documentation: This field is deprecated.
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\ISBNIdentifierEnabledDefinitionType
     */
    public $ISBNIdentifierEnabled;
    /**
     * The UPCIdentifierEnabled
     * Meta information extracted from the WSDL
     * - documentation: This field is deprecated.
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\UPCIdentifierEnabledDefinitionType
     */
    public $UPCIdentifierEnabled;
    /**
     * The EANIdentifierEnabled
     * Meta information extracted from the WSDL
     * - documentation: This field is deprecated.
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\EANIdentifierEnabledDefinitionType
     */
    public $EANIdentifierEnabled;
    /**
     * The BrandMPNIdentifierEnabled
     * Meta information extracted from the WSDL
     * - documentation: This field is returned as an empty element (a boolean value is not returned) if one or more eBay API-enabled sites support the use of Brand and MPN (Manufacturer Part Number) to identify a product. This field will not be returned if
     * one or more <b>FeatureID</b> fields are included in the call request and <code>BrandMPNIdentifierEnabled</code> is not one of the values passed into those <a href="types/FeatureIDCodeType.html">FeatureID</a> fields.
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\BrandMPNIdentifierEnabledDefinitionType
     */
    public $BrandMPNIdentifierEnabled;
    /**
     * The BestOfferAutoAcceptEnabled
     * Meta information extracted from the WSDL
     * - documentation: This field is returned as an empty element (a boolean value is not returned) if one or more eBay API-enabled sites support the Best Offer Auto-Accept feature. The Best Offer Auto-Accept feature allows a seller to set a threshold
     * dollar value on a listing, and any Best Offer amount at or above this amount is automatically accepted by the eBay system. This field will not be returned if one or more <b>FeatureID</b> fields are included in the call request and
     * <code>BestOfferAutoAcceptEnabled</code> is not one of the values passed into those <a href="types/FeatureIDCodeType.html">FeatureID</a> fields. <br/><br/> <span class="tablenote"><b>Note: </b> The Best Offer feature is now available for auction
     * listings on the following sites: US, Canada, UK, Germany, Australia, France, Italy, and Spain. However, sellers must choose between offering Best Offer or Buy It Now on an auction listing, as both features cannot be enabled on the same auction
     * listing. </span>
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\BestOfferAutoAcceptEnabledDefinitionType
     */
    public $BestOfferAutoAcceptEnabled;
    /**
     * The ClassifiedAdAutoAcceptEnabled
     * Meta information extracted from the WSDL
     * - documentation: This field is returned as an empty element (a boolean value is not returned) if one or more eBay API-enabled sites support the Best Offer Auto-Accept feature for classified ad listings. The Best Offer Auto-Accept feature allows a
     * seller to set a threshold dollar value on a listing, and any Best Offer amount at or above this amount is automatically accepted by the eBay system. This field will not be returned if one or more <b>FeatureID</b> fields are included in the call
     * request and <code>ClassifiedAdAutoAcceptEnabled</code> is not one of the values passed into those <a href="types/FeatureIDCodeType.html">FeatureID</a> fields.
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\ClassifiedAdAutoAcceptEnabledDefinitionType
     */
    public $ClassifiedAdAutoAcceptEnabled;
    /**
     * The CrossBorderTradeNorthAmericaEnabled
     * Meta information extracted from the WSDL
     * - documentation: This field is returned as an empty element (a boolean value is not returned) if one or more eBay API-enabled sites support cross-border trading on the US and CA (English) sites. In cross-border trading, also referred to as
     * International site visibility, a seller is able to post a listing to an additional eBay site for an additional small fee. This field will not be returned if one or more <b>FeatureID</b> fields are included in the call request and
     * <code>CrossBorderTradeNorthAmericaEnabled</code> is not one of the values passed into those <a href="types/FeatureIDCodeType.html">FeatureID</a> fields.
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\CrossBorderTradeNorthAmericaEnabledDefinitionType
     */
    public $CrossBorderTradeNorthAmericaEnabled;
    /**
     * The CrossBorderTradeGBEnabled
     * Meta information extracted from the WSDL
     * - documentation: This field is returned as an empty element (a boolean value is not returned) if one or more eBay API-enabled sites support cross-border trading on the UK and Ireland sites. In cross-border trading, also referred to as International
     * site visibility, a seller is able to post a listing to an additional eBay site for an additional small fee. This field will not be returned if one or more <b>FeatureID</b> fields are included in the call request and
     * <code>CrossBorderTradeGBEnabled</code> is not one of the values passed into those <a href="types/FeatureIDCodeType.html">FeatureID</a> fields.
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\CrossBorderTradeGBEnabledDefinitionType
     */
    public $CrossBorderTradeGBEnabled;
    /**
     * The CrossBorderTradeAustraliaEnabled
     * Meta information extracted from the WSDL
     * - documentation: This field is for future use, as cross-border trading (aka International site visibility) is not currently supported for Australia.
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\CrossBorderTradeAustraliaEnabledDefinitionType
     */
    public $CrossBorderTradeAustraliaEnabled;
    /**
     * The PayPalBuyerProtectionEnabled
     * Meta information extracted from the WSDL
     * - documentation: This field is returned as an empty element (a boolean value is not returned) if one or more eBay API-enabled sites support PayPal Purchase Protection. This field will not be returned if one or more <b>FeatureID</b> fields are
     * included in the call request and <code>PayPalBuyerProtectionEnabled</code> is not one of the values passed into those <a href="types/FeatureIDCodeType.html">FeatureID</a> fields.
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\PayPalBuyerProtectionEnabledDefinitionType
     */
    public $PayPalBuyerProtectionEnabled;
    /**
     * The BuyerGuaranteeEnabled
     * Meta information extracted from the WSDL
     * - documentation: This field is deprecated.
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\BuyerGuaranteeEnabledDefinitionType
     */
    public $BuyerGuaranteeEnabled;
    /**
     * The CombinedFixedPriceTreatmentEnabled
     * Meta information extracted from the WSDL
     * - documentation: This field is deprecated.
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\CombinedFixedPriceTreatmentEnabledDefinitionType
     */
    public $CombinedFixedPriceTreatmentEnabled;
    /**
     * The GalleryFeaturedDurations
     * Meta information extracted from the WSDL
     * - documentation: This field is deprecated.
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\ListingEnhancementDurationDefinitionType
     */
    public $GalleryFeaturedDurations;
    /**
     * The INEscrowWorkflowTimeline
     * Meta information extracted from the WSDL
     * - documentation: This field is returned as an empty element (a boolean value is not returned) if one or more eBay API-enabled sites support PaisaPay Full Escrow workflow timeline.This field will not be returned if one or more <b>FeatureID</b> fields
     * are included in the call request and <code>INEscrowWorkflowTimeline</code> is not one of the values passed into those <a href="types/FeatureIDCodeType.html">FeatureID</a> fields.
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\INEscrowWorkflowTimelineDefinitionType
     */
    public $INEscrowWorkflowTimeline;
    /**
     * The PayPalRequired
     * Meta information extracted from the WSDL
     * - documentation: This field is returned as an empty element (a boolean value is not returned) if one or more eBay API-enabled sites require that PayPal is included as an accepted payment method. This is not applicable to classified ad listings, as
     * payment is handled by the buyer and seller, and not eBay. This field will not be returned if one or more <b>FeatureID</b> fields are included in the call request and <code>PayPalRequired</code> is not one of the values passed into those <a
     * href="types/FeatureIDCodeType.html">FeatureID</a> fields.
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\PayPalRequiredDefinitionType
     */
    public $PayPalRequired;
    /**
     * The eBayMotorsProAdFormatEnabled
     * Meta information extracted from the WSDL
     * - documentation: This field is returned as an empty element (a boolean value is not returned) if one or more eBay API-enabled sites support motor vehicle classified ad listings. This field will not be returned if one or more <b>FeatureID</b> fields
     * are included in the call request and <code>eBayMotorsProAdFormatEnabled</code> is not one of the values passed into those <a href="types/FeatureIDCodeType.html">FeatureID</a> fields.
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\EBayMotorsProAdFormatEnabledDefinitionType
     */
    public $eBayMotorsProAdFormatEnabled;
    /**
     * The eBayMotorsProContactByPhoneEnabled
     * Meta information extracted from the WSDL
     * - documentation: This field is returned as an empty element (a boolean value is not returned) if one or more eBay API-enabled sites support the use of a phone number when contacting the seller about a motor vehicle classified ad listing. This field
     * will not be returned if one or more <b>FeatureID</b> fields are included in the call request and <code>eBayMotorsProContactByPhoneEnabled</code> is not one of the values passed into those <a href="types/FeatureIDCodeType.html">FeatureID</a> fields.
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\EBayMotorsProContactByPhoneEnabledDefinitionType
     */
    public $eBayMotorsProContactByPhoneEnabled;
    /**
     * The eBayMotorsProPhoneCount
     * Meta information extracted from the WSDL
     * - documentation: This field is returned as an empty element (a boolean value is not returned) if one or more eBay API-enabled sites support the use of multiple phone numbers for the seller for a motor vehicle classified ad listing. This field will
     * not be returned if one or more <b>FeatureID</b> fields are included in the call request and <code>eBayMotorsProContactByPhoneEnabled</code> is not one of the values passed into those <a href="types/FeatureIDCodeType.html">FeatureID</a> fields.
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\EBayMotorsProPhoneCountDefinitionType
     */
    public $eBayMotorsProPhoneCount;
    /**
     * The eBayMotorsProContactByAddressEnabled
     * Meta information extracted from the WSDL
     * - documentation: TThis field is returned as an empty element (a boolean value is not returned) if one or more eBay API-enabled sites support the use of an address when contacting the seller about a motor vehicle classified ad listing. This field will
     * not be returned if one or more <b>FeatureID</b> fields are included in the call request and <code>eBayMotorsProContactByAddressEnabled</code> is not one of the values passed into those <a href="types/FeatureIDCodeType.html">FeatureID</a> fields.
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\EBayMotorsProContactByAddressEnabledDefinitionType
     */
    public $eBayMotorsProContactByAddressEnabled;
    /**
     * The eBayMotorsProStreetCount
     * Meta information extracted from the WSDL
     * - documentation: This field is returned as an empty element (a boolean value is not returned) if one or more eBay API-enabled sites support the use of multiple street address for the seller for a motor vehicle classified ad listing. This field will
     * not be returned if one or more <b>FeatureID</b> fields are included in the call request and <code>eBayMotorsProContactByAddressEnabled</code> is not one of the values passed into those <a href="types/FeatureIDCodeType.html">FeatureID</a> fields.
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\EBayMotorsProStreetCountDefinitionType
     */
    public $eBayMotorsProStreetCount;
    /**
     * The eBayMotorsProCompanyNameEnabled
     * Meta information extracted from the WSDL
     * - documentation: This field is returned as an empty element (a boolean value is not returned) if one or more eBay API-enabled sites support the use of a company name when contacting the seller about a motor vehicle classified ad listing. This field
     * will not be returned if one or more <b>FeatureID</b> fields are included in the call request and <code>eBayMotorsProCompanyNameEnabled</code> is not one of the values passed into those <a href="types/FeatureIDCodeType.html">FeatureID</a> fields.
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\EBayMotorsProCompanyNameEnabledDefinitionType
     */
    public $eBayMotorsProCompanyNameEnabled;
    /**
     * The eBayMotorsProContactByEmailEnabled
     * Meta information extracted from the WSDL
     * - documentation: This field is returned as an empty element (a boolean value is not returned) if one or more eBay API-enabled sites support the use of an email address when contacting the seller about a motor vehicle classified ad listing. This field
     * will not be returned if one or more <b>FeatureID</b> fields are included in the call request and <code>eBayMotorsProContactByEmailEnabled</code> is not one of the values passed into those <a href="types/FeatureIDCodeType.html">FeatureID</a> fields.
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\EBayMotorsProContactByEmailEnabledDefinitionType
     */
    public $eBayMotorsProContactByEmailEnabled;
    /**
     * The eBayMotorsProBestOfferEnabled
     * Meta information extracted from the WSDL
     * - documentation: This field is returned as an empty element (a boolean value is not returned) if one or more eBay API-enabled sites support the Best Offer feature is for motor vehicle classified ad listings. The Best Offer feature allows buyers and
     * sellers to negotiate the price of the item. This field will not be returned if one or more <b>FeatureID</b> fields are included in the call request and <code>eBayMotorsProBestOfferEnabled</code> is not one of the values passed into those <a
     * href="types/FeatureIDCodeType.html">FeatureID</a> fields.
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\EBayMotorsProBestOfferEnabledDefinitionType
     */
    public $eBayMotorsProBestOfferEnabled;
    /**
     * The eBayMotorsProAutoAcceptEnabled
     * Meta information extracted from the WSDL
     * - documentation: This field is returned as an empty element (a boolean value is not returned) if one or more eBay API-enabled sites support the Best Offer Auto-Accept feature for motor vehicle classified ad listings. The Best Offer Auto-Accept
     * feature allows a seller to set a threshold dollar value on a listing, and any Best Offer amount at or above this amount is automatically accepted by the eBay system. This field will not be returned if one or more <b>FeatureID</b> fields are included
     * in the call request and <code>eBayMotorsProAutoAcceptEnabled</code> is not one of the values passed into those <a href="types/FeatureIDCodeType.html">FeatureID</a> fields.
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\EBayMotorsProAutoAcceptEnabledDefinitionType
     */
    public $eBayMotorsProAutoAcceptEnabled;
    /**
     * The eBayMotorsProAutoDeclineEnabled
     * Meta information extracted from the WSDL
     * - documentation: This field is returned as an empty element (a boolean value is not returned) if one or more eBay API-enabled sites support the Best Offer Auto-Decline feature for motor vehicle classified ad listings. The Best Offer Auto-Decline
     * feature allows a seller to set a lower threshold dollar value on a listing, and any Best Offer amount below this amount is automatically declined by the eBay system. This field will not be returned if one or more <b>FeatureID</b> fields are included
     * in the call request and <code>eBayMotorsProAutoDeclineEnabled</code> is not one of the values passed into those <a href="types/FeatureIDCodeType.html">FeatureID</a> fields.
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\EBayMotorsProAutoDeclineEnabledDefinitionType
     */
    public $eBayMotorsProAutoDeclineEnabled;
    /**
     * The eBayMotorsProPaymentMethodCheckOutEnabled
     * Meta information extracted from the WSDL
     * - documentation: This field is returned as an empty element (a boolean value is not returned) if one or more eBay API-enabled sites allow for the display of acceptable payment methods for motor vehicle classified ad listings. This field will not be
     * returned if one or more <b>FeatureID</b> fields are included in the call request and <code>eBayMotorsProPaymentMethodCheckOutEnabled</code> is not one of the values passed into those <a href="types/FeatureIDCodeType.html">FeatureID</a> fields.
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\EBayMotorsProPaymentMethodCheckOutEnabledDefinitionType
     */
    public $eBayMotorsProPaymentMethodCheckOutEnabled;
    /**
     * The eBayMotorsProShippingMethodEnabled
     * Meta information extracted from the WSDL
     * - documentation: This field is returned as an empty element (a boolean value is not returned) if one or more eBay API-enabled sites allow for the display of shipping service options for motor vehicle classified ad listings. This field will not be
     * returned if one or more <b>FeatureID</b> fields are included in the call request and <code>eBayMotorsProShippingMethodEnabled</code> is not one of the values passed into those <a href="types/FeatureIDCodeType.html">FeatureID</a> fields.
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\EBayMotorsProShippingMethodEnabledDefinitionType
     */
    public $eBayMotorsProShippingMethodEnabled;
    /**
     * The eBayMotorsProCounterOfferEnabled
     * Meta information extracted from the WSDL
     * - documentation: This field is returned as an empty element (a boolean value is not returned) if one or more eBay API-enabled sites support counter offers to Best Offers for motor vehicle classified ad listings. The Best Offer feature allows buyers
     * and sellers to negotiate the price of the item, and once a Best Offer price is proposed, the seller can send the buyer a counter offer, and a buyer may even send another counter offer to the seller's counter offer. This field will not be returned if
     * one or more <b>FeatureID</b> fields are included in the call request and <code>eBayMotorsProCounterOfferEnabled</code> is not one of the values passed into those <a href="types/FeatureIDCodeType.html">FeatureID</a> fields.
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\EBayMotorsProCounterOfferEnabledDefinitionType
     */
    public $eBayMotorsProCounterOfferEnabled;
    /**
     * The eBayMotorsProSellerContactDetailsEnabled
     * Meta information extracted from the WSDL
     * - documentation: This field is returned as an empty element (a boolean value is not returned) if one or more eBay API-enabled sites allow the seller to provide contact information at listing time for a motor vehicle classified ad listing. This
     * feature is only applicable to motor vehicle classified ad listings. This field will not be returned if one or more <b>FeatureID</b> fields are included in the call request and <code>eBayMotorsProSellerContactDetailsEnabled</code> is not one of the
     * values passed into those <a href="types/FeatureIDCodeType.html">FeatureID</a> fields.
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\EBayMotorsProSellerContactDetailsEnabledDefinitionType
     */
    public $eBayMotorsProSellerContactDetailsEnabled;
    /**
     * The LocalMarketAdFormatEnabled
     * Meta information extracted from the WSDL
     * - documentation: This field is returned as an empty element (a boolean value is not returned) if one or more eBay API-enabled sites support Motors Local Market listings. This field will not be returned if one or more <b>FeatureID</b> fields are
     * included in the call request and <code>LocalMarketAdFormatEnabled</code> is not one of the values passed into those <a href="types/FeatureIDCodeType.html">FeatureID</a> fields.
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\LocalMarketAdFormatEnabledDefinitionType
     */
    public $LocalMarketAdFormatEnabled;
    /**
     * The LocalMarketContactByPhoneEnabled
     * Meta information extracted from the WSDL
     * - documentation: This field is returned as an empty element (a boolean value is not returned) if one or more eBay API-enabled sites allow the use of a phone number when contacting the seller about a Motors Local Market listing. This field will not be
     * returned if one or more <b>FeatureID</b> fields are included in the call request and <code>LocalMarketContactByPhoneEnabled</code> is not one of the values passed into those <a href="types/FeatureIDCodeType.html">FeatureID</a> fields.
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\LocalMarketContactByPhoneEnabledDefinitionType
     */
    public $LocalMarketContactByPhoneEnabled;
    /**
     * The LocalMarketPhoneCount
     * Meta information extracted from the WSDL
     * - documentation: This field is returned as an empty element (a boolean value is not returned) if one or more eBay API-enabled sites allow the use of multiple phone numbers for the seller for a Motors Local Market listing. This field will not be
     * returned if one or more <b>FeatureID</b> fields are included in the call request and <code>LocalMarketPhoneCount</code> is not one of the values passed into those <a href="types/FeatureIDCodeType.html">FeatureID</a> fields.
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\LocalMarketPhoneCountDefinitionType
     */
    public $LocalMarketPhoneCount;
    /**
     * The LocalMarketContactByAddressEnabled
     * Meta information extracted from the WSDL
     * - documentation: This field is returned as an empty element (a boolean value is not returned) if one or more eBay API-enabled sites allow the use of an address when contacting the seller about a Motors Local Market listing. This field will not be
     * returned if one or more <b>FeatureID</b> fields are included in the call request and <code>LocalMarketContactByAddressEnabled</code> is not one of the values passed into those <a href="types/FeatureIDCodeType.html">FeatureID</a> fields.
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\LocalMarketContactByAddressEnabledDefinitionType
     */
    public $LocalMarketContactByAddressEnabled;
    /**
     * The LocalMarketStreetCount
     * Meta information extracted from the WSDL
     * - documentation: This field is returned as an empty element (a boolean value is not returned) if one or more eBay API-enabled sites allow the use of multiple street address for the seller for a Motors Local Market listing. This field will not be
     * returned if one or more <b>FeatureID</b> fields are included in the call request and <code>LocalMarketStreetCount</code> is not one of the values passed into those <a href="types/FeatureIDCodeType.html">FeatureID</a> fields.
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\LocalMarketStreetCountDefinitionType
     */
    public $LocalMarketStreetCount;
    /**
     * The LocalMarketCompanyNameEnabled
     * Meta information extracted from the WSDL
     * - documentation: This field is returned as an empty element (a boolean value is not returned) if one or more eBay API-enabled sites support the use of a company name when contacting the seller about a Motors Local Market listing. This field will not
     * be returned if one or more <b>FeatureID</b> fields are included in the call request and <code>LocalMarketCompanyNameEnabled</code> is not one of the values passed into those <a href="types/FeatureIDCodeType.html">FeatureID</a> fields.
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\LocalMarketCompanyNameEnabledDefinitionType
     */
    public $LocalMarketCompanyNameEnabled;
    /**
     * The LocalMarketContactByEmailEnabled
     * Meta information extracted from the WSDL
     * - documentation: This field is returned as an empty element (a boolean value is not returned) if one or more eBay API-enabled sites support the use of an email address when contacting the seller about a Motors Local Market listing. This field will
     * not be returned if one or more <b>FeatureID</b> fields are included in the call request and <code>LocalMarketContactByEmailEnabled</code> is not one of the values passed into those <a href="types/FeatureIDCodeType.html">FeatureID</a> fields.
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\LocalMarketContactByEmailEnabledDefinitionType
     */
    public $LocalMarketContactByEmailEnabled;
    /**
     * The LocalMarketBestOfferEnabled
     * Meta information extracted from the WSDL
     * - documentation: This field is returned as an empty element (a boolean value is not returned) if one or more eBay API-enabled sites support the Best Offer feature is for Motors Local Market listings. The Best Offer feature allows buyers and sellers
     * to negotiate the price of the item. This field will not be returned if one or more <b>FeatureID</b> fields are included in the call request and <code>LocalMarketBestOfferEnabled</code> is not one of the values passed into those <a
     * href="types/FeatureIDCodeType.html">FeatureID</a> fields.
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\LocalMarketBestOfferEnabledDefinitionType
     */
    public $LocalMarketBestOfferEnabled;
    /**
     * The LocalMarketAutoAcceptEnabled
     * Meta information extracted from the WSDL
     * - documentation: This field is returned as an empty element (a boolean value is not returned) if one or more eBay API-enabled sites support the Best Offer Auto-Accept feature for Motors Local Market listings. The Best Offer Auto-Accept feature allows
     * a seller to set a threshold dollar value on a listing, and any Best Offer amount at or above this amount is automatically accepted by the eBay system. This field will not be returned if one or more <b>FeatureID</b> fields are included in the call
     * request and <code>LocalMarketAutoAcceptEnabled</code> is not one of the values passed into those <a href="types/FeatureIDCodeType.html">FeatureID</a> fields.
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\LocalMarketAutoAcceptEnabledDefinitionType
     */
    public $LocalMarketAutoAcceptEnabled;
    /**
     * The LocalMarketAutoDeclineEnabled
     * Meta information extracted from the WSDL
     * - documentation: This field is returned as an empty element (a boolean value is not returned) if one or more eBay API-enabled sites support the Best Offer Auto-Decline feature for Motors Local Market listings. The Best Offer Auto-Accept feature
     * allows a seller to set a threshold dollar value on a listing, and any Best Offer amount at or above this amount is automatically accepted by the eBay system. This field will not be returned if one or more <b>FeatureID</b> fields are included in the
     * call request and <code>LocalMarketAutoDeclineEnabled</code> is not one of the values passed into those <a href="types/FeatureIDCodeType.html">FeatureID</a> fields.
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\LocalMarketAutoDeclineEnabledDefinitionType
     */
    public $LocalMarketAutoDeclineEnabled;
    /**
     * The LocalMarketPaymentMethodCheckOutEnabled
     * Meta information extracted from the WSDL
     * - documentation: This field is returned as an empty element (a boolean value is not returned) if one or more eBay API-enabled sites allow for the display of acceptable payment methods for Motors Local Market listings. This field will not be returned
     * if one or more <b>FeatureID</b> fields are included in the call request and <code>LocalMarketPaymentMethodCheckOutEnabled</code> is not one of the values passed into those <a href="types/FeatureIDCodeType.html">FeatureID</a> fields.
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\LocalMarketPaymentMethodCheckOutEnabledDefinitionType
     */
    public $LocalMarketPaymentMethodCheckOutEnabled;
    /**
     * The LocalMarketShippingMethodEnabled
     * Meta information extracted from the WSDL
     * - documentation: This field is returned as an empty element (a boolean value is not returned) if one or more eBay API-enabled sites allow for the display of shipping service options for Motors Local Market listings. This field will not be returned if
     * one or more <b>FeatureID</b> fields are included in the call request and <code>LocalMarketShippingMethodEnabled</code> is not one of the values passed into those <a href="types/FeatureIDCodeType.html">FeatureID</a> fields.
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\LocalMarketShippingMethodEnabledDefinitionType
     */
    public $LocalMarketShippingMethodEnabled;
    /**
     * The LocalMarketCounterOfferEnabled
     * Meta information extracted from the WSDL
     * - documentation: This field is returned as an empty element (a boolean value is not returned) if one or more eBay API-enabled sites support counter offers to Best Offers for Motors Local Market listings. The Best Offer feature allows buyers and
     * sellers to negotiate the price of the item, and once a Best Offer price is proposed, the seller can send the buyer a counter offer, and a buyer may even send another counter offer to the seller's counter offer. This field will not be returned if one
     * or more <b>FeatureID</b> fields are included in the call request and <code>LocalMarketCounterOfferEnabled</code> is not one of the values passed into those <a href="types/FeatureIDCodeType.html">FeatureID</a> fields.
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\LocalMarketCounterOfferEnabledDefinitionType
     */
    public $LocalMarketCounterOfferEnabled;
    /**
     * The LocalMarketSellerContactDetailsEnabled
     * Meta information extracted from the WSDL
     * - documentation: This field is returned as an empty element (a boolean value is not returned) if one or more eBay API-enabled sites allow the seller to provide contact information at listing time for Motors Local Market listings. This feature is only
     * applicable to motor vehicle classified ad listings. This field will not be returned if one or more <b>FeatureID</b> fields are included in the call request and <code>LocalMarketSellerContactDetailsEnabled</code> is not one of the values passed into
     * those <a href="types/FeatureIDCodeType.html">FeatureID</a> fields.
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\LocalMarketSellerContactDetailsEnabledDefinitionType
     */
    public $LocalMarketSellerContactDetailsEnabled;
    /**
     * The ClassifiedAdPhoneCount
     * Meta information extracted from the WSDL
     * - documentation: This field is returned as an empty element (a boolean value is not returned) if one or more eBay API-enabled sites support the use of multiple phone numbers for the seller for a classified ad listing. This field will not be returned
     * if one or more <b>FeatureID</b> fields are included in the call request and <code>ClassifiedAdPhoneCount</code> is not one of the values passed into those <a href="types/FeatureIDCodeType.html">FeatureID</a> fields.
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\ClassifiedAdPhoneCountDefinitionType
     */
    public $ClassifiedAdPhoneCount;
    /**
     * The ClassifiedAdContactByAddressEnabled
     * Meta information extracted from the WSDL
     * - documentation: This field is returned as an empty element (a boolean value is not returned) if one or more eBay API-enabled sites support the use of an address when contacting the seller about a classified ad listing. This field will not be
     * returned if one or more <b>FeatureID</b> fields are included in the call request and <code>ClassifiedAdContactByAddressEnabled</code> is not one of the values passed into those <a href="types/FeatureIDCodeType.html">FeatureID</a>
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\ClassifiedAdContactByAddressEnabledDefinitionType
     */
    public $ClassifiedAdContactByAddressEnabled;
    /**
     * The ClassifiedAdStreetCount
     * Meta information extracted from the WSDL
     * - documentation: This field is returned as an empty element (a boolean value is not returned) if one or more eBay API-enabled sites support the use of multiple street addresses for the seller for a classified ad listing. This field will not be
     * returned if one or more <b>FeatureID</b> fields are included in the call request and <code>ClassifiedAdStreetCount</code> is not one of the values passed into those <a href="types/FeatureIDCodeType.html">FeatureID</a> fields.
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\ClassifiedAdStreetCountDefinitionType
     */
    public $ClassifiedAdStreetCount;
    /**
     * The ClassifiedAdCompanyNameEnabled
     * Meta information extracted from the WSDL
     * - documentation: This field is returned as an empty element (a boolean value is not returned) if one or more eBay API-enabled sites support the use of a company name when contacting the seller about a classified ad listing. This field will not be
     * returned if one or more <b>FeatureID</b> fields are included in the call request and <code>ClassifiedAdCompanyNameEnabled</code> is not one of the values passed into those <a href="types/FeatureIDCodeType.html">FeatureID</a> fields.
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\ClassifiedAdCompanyNameEnabledDefinitionType
     */
    public $ClassifiedAdCompanyNameEnabled;
    /**
     * The SpecialitySubscription
     * Meta information extracted from the WSDL
     * - documentation: This field is deprecated.
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\SpecialitySubscriptionDefinitionType
     */
    public $SpecialitySubscription;
    /**
     * The RegularSubscription
     * Meta information extracted from the WSDL
     * - documentation: This field is deprecated.
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\RegularSubscriptionDefinitionType
     */
    public $RegularSubscription;
    /**
     * The PremiumSubscription
     * Meta information extracted from the WSDL
     * - documentation: This field is deprecated.
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\PremiumSubscriptionDefinitionType
     */
    public $PremiumSubscription;
    /**
     * The NonSubscription
     * Meta information extracted from the WSDL
     * - documentation: This field is deprecated.
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\NonSubscriptionDefinitionType
     */
    public $NonSubscription;
    /**
     * The ReturnPolicyEnabled
     * Meta information extracted from the WSDL
     * - documentation: This field is returned as an empty element (a boolean value is not returned) if one or more eBay API-enabled sites support the use of return policies in listings. This field will not be returned if one or more <b>FeatureID</b> fields
     * are included in the call request and <code>ReturnPolicyEnabled</code> is not one of the values passed into those <a href="types/FeatureIDCodeType.html">FeatureID</a> fields.
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\ReturnPolicyEnabledDefinitionType
     */
    public $ReturnPolicyEnabled;
    /**
     * The HandlingTimeEnabled
     * Meta information extracted from the WSDL
     * - documentation: This field is returned as an empty element (a boolean value is not returned) if one or more eBay API-enabled sites support the use of a stated handling time in listings. The handling time is the maximum number of business days the
     * seller commits to for preparing an item to be shipped after receiving a cleared payment. The seller's handling time does not include the shipping time (the carrier's transit time). This field will not be returned if one or more <b>FeatureID</b>
     * fields are included in the call request and <code>HandlingTimeEnabled</code> is not one of the values passed into those <a href="types/FeatureIDCodeType.html">FeatureID</a> fields.
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\HandlingTimeEnabledDefinitionType
     */
    public $HandlingTimeEnabled;
    /**
     * The PayPalRequiredForStoreOwner
     * Meta information extracted from the WSDL
     * - documentation: This field is deprecated.
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\PayPalRequiredForStoreOwnerDefinitionType
     */
    public $PayPalRequiredForStoreOwner;
    /**
     * The ReviseQuantityAllowed
     * Meta information extracted from the WSDL
     * - documentation: This field is returned as an empty element (a boolean value is not returned) if one or more eBay API-enabled sites allow the quantity of a listing to be revised during the life of the listing. This feature is not applicable to
     * auction listings. This field will not be returned if one or more <b>FeatureID</b> fields are included in the call request and <code>ReviseQuantityAllowed</code> is not one of the values passed into those <a
     * href="types/FeatureIDCodeType.html">FeatureID</a> fields.
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\ReviseQuantityAllowedDefinitionType
     */
    public $ReviseQuantityAllowed;
    /**
     * The RevisePriceAllowed
     * Meta information extracted from the WSDL
     * - documentation: This field is returned as an empty element (a boolean value is not returned) if one or more eBay API-enabled sites allow the price of a listing to be revised during the life of the listing. This feature is not applicable to auction
     * listings. This field will not be returned if one or more <b>FeatureID</b> fields are included in the call request and <code>RevisePriceAllowed</code> is not one of the values passed into those <a href="types/FeatureIDCodeType.html">FeatureID</a>
     * fields.
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\RevisePriceAllowedDefinitionType
     */
    public $RevisePriceAllowed;
    /**
     * The StoreOwnerExtendedListingDurationsEnabled
     * Meta information extracted from the WSDL
     * - documentation: This field is returned as an empty element (a boolean value is not returned) if one or more eBay API-enabled sites support extended listing durations for eBay Business Sellers with eBay Stores. This field will not be returned if one
     * or more <b>FeatureID</b> fields are included in the call request and <code>RevisePriceAllowed</code> is not one of the values passed into those <a href="types/FeatureIDCodeType.html">FeatureID</a> fields.
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\StoreOwnerExtendedListingDurationsEnabledDefinitionType
     */
    public $StoreOwnerExtendedListingDurationsEnabled;
    /**
     * The StoreOwnerExtendedListingDurations
     * Meta information extracted from the WSDL
     * - documentation: This field is deprecated.
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\StoreOwnerExtendedListingDurationsDefinitionType
     */
    public $StoreOwnerExtendedListingDurations;
    /**
     * The PaymentMethod
     * Meta information extracted from the WSDL
     * - documentation: This field is returned as an empty element (a boolean value is not returned) if one or more eBay API-enabled sites allow for the display of acceptable payment methods in listings. This field will not be returned if one or more
     * <b>FeatureID</b> fields are included in the call request and <code>PaymentMethod</code> is not one of the values passed into those <a href="types/FeatureIDCodeType.html">FeatureID</a> fields.
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\PaymentMethodDefinitionType
     */
    public $PaymentMethod;
    /**
     * The Group1MaxFlatShippingCost
     * Meta information extracted from the WSDL
     * - documentation: This field is returned as an empty element (a boolean value is not returned) if one or more eBay API-enabled sites allow for the applicable max cap per shipping cost for shipping service group1. This field will not be returned if one
     * or more <b>FeatureID</b> fields are included in the call request and <code>Group1MaxFlatShippingCost</code> is not one of the values passed into those <a href="types/FeatureIDCodeType.html">FeatureID</a> fields.
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\Group1MaxFlatShippingCostDefinitionType
     */
    public $Group1MaxFlatShippingCost;
    /**
     * The Group2MaxFlatShippingCost
     * Meta information extracted from the WSDL
     * - documentation: This field is returned as an empty element (a boolean value is not returned) if one or more eBay API-enabled sites allow for the applicable max cap per shipping cost for shipping service group2. This field will not be returned if one
     * or more <b>FeatureID</b> fields are included in the call request and <code>Group2MaxFlatShippingCost</code> is not one of the values passed into those <a href="types/FeatureIDCodeType.html">FeatureID</a> fields.
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\Group2MaxFlatShippingCostDefinitionType
     */
    public $Group2MaxFlatShippingCost;
    /**
     * The Group3MaxFlatShippingCost
     * Meta information extracted from the WSDL
     * - documentation: TThis field is returned as an empty element (a boolean value is not returned) if one or more eBay API-enabled sites allow for the applicable max cap per shipping cost for shipping service group3. This field will not be returned if
     * one or more <b>FeatureID</b> fields are included in the call request and <code>Group3MaxFlatShippingCost</code> is not one of the values passed into those <a href="types/FeatureIDCodeType.html">FeatureID</a> fields.
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\Group3MaxFlatShippingCostDefinitionType
     */
    public $Group3MaxFlatShippingCost;
    /**
     * The MaxFlatShippingCostCBTExempt
     * Meta information extracted from the WSDL
     * - documentation: This field is returned as an empty element (a boolean value is not returned) if one or more eBay API-enabled sites do not impose a maximum flat-rate shipping cost if the item is being shipped internationally. This field will not be
     * returned if one or more <b>FeatureID</b> fields are included in the call request and <code>MaxFlatShippingCostCBTExempt</code> is not one of the values passed into those <a href="types/FeatureIDCodeType.html">FeatureID</a> fields.
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\MaxFlatShippingCostCBTExemptDefinitionType
     */
    public $MaxFlatShippingCostCBTExempt;
    /**
     * The MaxFlatShippingCost
     * Meta information extracted from the WSDL
     * - documentation: This field is returned as an empty element (a boolean value is not returned) if one or more eBay API-enabled sites do not impose a maximum flat-rate shipping cost. This field will not be returned if one or more <b>FeatureID</b>
     * fields are included in the call request and <code>MaxFlatShippingCost</code> is not one of the values passed into those <a href="types/FeatureIDCodeType.html">FeatureID</a> fields.
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\MaxFlatShippingCostDefinitionType
     */
    public $MaxFlatShippingCost;
    /**
     * The VariationsEnabled
     * Meta information extracted from the WSDL
     * - documentation: This field is returned as an empty element (a boolean value is not returned) if one or more eBay API-enabled sites support multiple-variation listings for some categories. Multiple-variation listings contain items that are logically
     * the same product, but that vary in color, size, or other aspect. For example, a particular brand and style of shirt could be available in different sizes and colors, such as "large blue" and "medium black" variations. This feature is only applicable
     * to fixed-price listings. This field will not be returned if one or more <b>FeatureID</b> fields are included in the call request and <code>VariationsEnabled</code> is not one of the values passed into those <a
     * href="types/FeatureIDCodeType.html">FeatureID</a> fields.
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\VariationsEnabledDefinitionType
     */
    public $VariationsEnabled;
    /**
     * The AttributeConversionEnabled
     * Meta information extracted from the WSDL
     * - documentation: This field is deprecated.
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\AttributeConversionEnabledFeatureDefinitionType
     */
    public $AttributeConversionEnabled;
    /**
     * The FreeGalleryPlusEnabled
     * Meta information extracted from the WSDL
     * - documentation: This field is returned as an empty element (a boolean value is not returned) if one or more eBay API-enabled sites support free, automatic upgrades for Gallery Plus for some categories. This field will not be returned if one or more
     * <b>FeatureID</b> fields are included in the call request and <code>FreeGalleryPlusEnabled</code> is not one of the values passed into those <a href="types/FeatureIDCodeType.html">FeatureID</a> fields.
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\FreeGalleryPlusEnabledDefinitionType
     */
    public $FreeGalleryPlusEnabled;
    /**
     * The FreePicturePackEnabled
     * Meta information extracted from the WSDL
     * - documentation: This field is returned as an empty element (a boolean value is not returned) if one or more eBay API-enabled sites support a free Picture Pack upgrade for some categories. This field will not be returned if one or more
     * <b>FeatureID</b> fields are included in the call request and <code>FreePicturePackEnabled</code> is not one of the values passed into those <a href="types/FeatureIDCodeType.html">FeatureID</a> fields.
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\FreePicturePackEnabledDefinitionType
     */
    public $FreePicturePackEnabled;
    /**
     * The ItemCompatibilityEnabled
     * Meta information extracted from the WSDL
     * - documentation: This field is returned as an empty element (a boolean value is not returned) if one or more eBay API-enabled sites support Parts Compatibility for some Parts & Accessories categories. Parts compatibility allows a seller to show a
     * list of all the vehicles that a part or accessory is compatible with in a listing. This field will not be returned if one or more <b>FeatureID</b> fields are included in the call request and <code>ItemCompatibilityEnabled</code> is not one of the
     * values passed into those <a href="types/FeatureIDCodeType.html">FeatureID</a> fields.
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\ItemCompatibilityEnabledDefinitionType
     */
    public $ItemCompatibilityEnabled;
    /**
     * The MaxItemCompatibility
     * Meta information extracted from the WSDL
     * - documentation: This field is returned as an empty element (a boolean value is not returned) if one or more eBay API-enabled sites define a maximum limit for the number of compatible applications for items listed with parts compatibilities by
     * application. Parts compatibility allows a seller to show a list of all the vehicles that a part or accessory is compatible with in a listing. This field will not be returned if one or more <b>FeatureID</b> fields are included in the call request and
     * <code>MaxItemCompatibility</code> is not one of the values passed into those <a href="types/FeatureIDCodeType.html">FeatureID</a> fields.
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\MaxItemCompatibilityDefinitionType
     */
    public $MaxItemCompatibility;
    /**
     * The MinItemCompatibility
     * Meta information extracted from the WSDL
     * - documentation: This field is returned as an empty element (a boolean value is not returned) if one or more eBay API-enabled sites define a minimum amount for the number of compatible applications for items listed with parts compatibilities by
     * application. Parts compatibility allows a seller to show a list of all the vehicles that a part or accessory is compatible with in a listing. This field will not be returned if one or more <b>FeatureID</b> fields are included in the call request and
     * <code>MinItemCompatibility</code> is not one of the values passed into those <a href="types/FeatureIDCodeType.html">FeatureID</a> fields.
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\MinItemCompatibilityDefinitionType
     */
    public $MinItemCompatibility;
    /**
     * The ConditionEnabled
     * Meta information extracted from the WSDL
     * - documentation: This field is returned as an empty element (a boolean value is not returned) if one or more eBay API-enabled sites support the textual description of an item's condition at listing time. This field will not be returned if one or more
     * <b>FeatureID</b> fields are included in the call request and <code>ConditionEnabled</code> is not one of the values passed into those <a href="types/FeatureIDCodeType.html">FeatureID</a> fields.
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\ConditionEnabledDefinitionType
     */
    public $ConditionEnabled;
    /**
     * The ConditionValues
     * Meta information extracted from the WSDL
     * - documentation: This field is returned as an empty element (a boolean value is not returned) if one or more eBay API-enabled sites support Condition IDs to specify an item's condition at listing time. This field will not be returned if one or more
     * <b>FeatureID</b> fields are included in the call request and <code>ConditionValues</code> is not one of the values passed into those <a href="types/FeatureIDCodeType.html">FeatureID</a> fields.
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\ConditionValuesDefinitionType
     */
    public $ConditionValues;
    /**
     * The ValueCategory
     * Meta information extracted from the WSDL
     * - documentation: This field is returned as an empty element (a boolean value is not returned) if one or more eBay API-enabled sites support value categories. A Value category will typically have lower listing fees or another eBay promotion. This
     * field will not be returned if one or more <b>FeatureID</b> fields are included in the call request and <code>ValueCategory</code> is not one of the values passed into those <a href="types/FeatureIDCodeType.html">FeatureID</a> fields.
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\ValueCategoryDefinitionType
     */
    public $ValueCategory;
    /**
     * The ProductCreationEnabled
     * Meta information extracted from the WSDL
     * - documentation: This field is returned as an empty element (a boolean value is not returned) if one or more eBay API-enabled sites support the creation of listings through the specification of Global Trade Identification Numbers (GTINs) like UPC,
     * ISBN, EAN, or Brand/MPN combination. If a GTIN is matched to a product in eBay product catalog, a listing will automatically be created using the eBay catalog product's images, product aspects, description, and title. This field will not be returned
     * if one or more <b>FeatureID</b> fields are included in the call request and <code>ProductCreationEnabled</code> is not one of the values passed into those <a href="types/FeatureIDCodeType.html">FeatureID</a> fields.
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\ProductCreationEnabledDefinitionType
     */
    public $ProductCreationEnabled;
    /**
     * The EANEnabled
     * Meta information extracted from the WSDL
     * - documentation: This field is returned as an empty element (a boolean value is not returned) if one or more eBay API-enabled sites support the EAN product identifying feature. This field will be returned as long as <b>EANEnabled</b> is included as a
     * <b>FeatureID</b> value in the call request or no <b>FeatureID</b> values are passed into the call request. <br> <br> To verify if a specific eBay site supports the EAN product identifying feature (for most categories), look for a <code>true</code>
     * value in the <b>SiteDefaults.EANEnabled</b> field. <br> <br> To verify if a specific category on a specific eBay site supports the EAN product identifying feature, pass in a <b>CategoryID</b> value in the request, and then look for a
     * <code>true</code> value in the <b>EANEnabled</b> field of the corresponding <b>Category</b> node (match up the <b>CategoryID</b> values if more than one Category IDs were passed in the request).
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\EANEnabledDefinitionType
     */
    public $EANEnabled;
    /**
     * The ISBNEnabled
     * Meta information extracted from the WSDL
     * - documentation: This field is returned as an empty element (a boolean value is not returned) if one or more eBay API-enabled sites support the ISBN product identifying feature. This field will be returned as long as <b>ISBNEnabled</b> is included as
     * a <b>FeatureID</b> value in the call request or no <b>FeatureID</b> values are passed into the call request. <br> <br> To verify if a specific eBay site supports the ISBN product identifying feature (for most categories), look for a <code>true</code>
     * value in the <b>SiteDefaults.ISBNEnabled</b> field. <br> <br> To verify if a specific category on a specific eBay site supports the ISBN product identifying feature, pass in a <b>CategoryID</b> value in the request, and then look for a
     * <code>true</code> value in the <b>ISBNEnabled</b> field of the corresponding <b>Category</b> node (match up the <b>CategoryID</b> values if more than one Category IDs were passed in the request).
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\ISBNEnabledDefinitionType
     */
    public $ISBNEnabled;
    /**
     * The UPCEnabled
     * Meta information extracted from the WSDL
     * - documentation: This field is returned as an empty element (a boolean value is not returned) if one or more eBay API-enabled sites support the UPC product identifying feature. This field will be returned as long as <b>UPCEnabled</b> is included as a
     * <b>FeatureID</b> value in the call request or no <b>FeatureID</b> values are passed into the call request. <br> <br> To verify if a specific eBay site supports the UPC product identifying feature (for most categories), look for a <code>true</code>
     * value in the <b>SiteDefaults.UPCEnabled</b> field. <br> <br> To verify if a specific category on a specific eBay site supports the UPC product identifying feature, pass in a <b>CategoryID</b> value in the request, and then look for a
     * <code>true</code> value in the <b>UPCEnabled</b> field of the corresponding <b>Category</b> node (match up the <b>CategoryID</b> values if more than one Category IDs were passed in the request).
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\UPCEnabledDefinitionType
     */
    public $UPCEnabled;
    /**
     * The CompatibleVehicleType
     * Meta information extracted from the WSDL
     * - documentation: This field is returned as an empty element (a boolean value is not returned) if one or more eBay API-enabled sites support the Parts Compatibility feature for motor vehicles. This field will not be returned if one or more
     * <b>FeatureID</b> fields are included in the call request and <code>CompatibleVehicleType</code> is not one of the values passed into those <a href="types/FeatureIDCodeType.html">FeatureID</a> fields.
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\CompatibleVehicleTypeDefinitionType
     */
    public $CompatibleVehicleType;
    /**
     * The MaxGranularFitmentCount
     * Meta information extracted from the WSDL
     * - documentation: This field is returned as an empty element (a boolean value is not returned) if one or more eBay API-enabled sites define a maximum limit for the number of fine-grained item compatibilities that can be applied to a listing. This
     * field will not be returned if one or more <b>FeatureID</b> fields are included in the call request and <code>MaxGranularFitmentCount</code> is not one of the values passed into those <a href="types/FeatureIDCodeType.html">FeatureID</a> fields.
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\MaxGranularFitmentCountDefinitionType
     */
    public $MaxGranularFitmentCount;
    /**
     * The PaymentOptionsGroup
     * Meta information extracted from the WSDL
     * - documentation: This field is deprecated.
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\PaymentOptionsGroupEnabledDefinitionType
     */
    public $PaymentOptionsGroup;
    /**
     * The ShippingProfileCategoryGroup
     * Meta information extracted from the WSDL
     * - documentation: This field is returned as an empty element (a boolean value is not returned) if one or more eBay API-enabled sites support the use of category groups in shipping business policies. This field will not be returned if one or more
     * <b>FeatureID</b> fields are included in the call request and <code>ShippingProfileCategoryGroup</code> is not one of the values passed into those <a href="types/FeatureIDCodeType.html">FeatureID</a> fields.
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\ProfileCategoryGroupDefinitionType
     */
    public $ShippingProfileCategoryGroup;
    /**
     * The PaymentProfileCategoryGroup
     * Meta information extracted from the WSDL
     * - documentation: TThis field is returned as an empty element (a boolean value is not returned) if one or more eBay API-enabled sites support the use of category groups in payment business policies. This field will not be returned if one or more
     * <b>FeatureID</b> fields are included in the call request and <code>PaymentProfileCategoryGroup</code> is not one of the values passed into those <a href="types/FeatureIDCodeType.html">FeatureID</a> fields.
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\ProfileCategoryGroupDefinitionType
     */
    public $PaymentProfileCategoryGroup;
    /**
     * The ReturnPolicyProfileCategoryGroup
     * Meta information extracted from the WSDL
     * - documentation: This field is returned as an empty element (a boolean value is not returned) if one or more eBay API-enabled sites support the use of category groups in return business policies. This field will not be returned if one or more
     * <b>FeatureID</b> fields are included in the call request and <code>ReturnPolicyProfileCategoryGroup</code> is not one of the values passed into those <a href="types/FeatureIDCodeType.html">FeatureID</a> fields.
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\ProfileCategoryGroupDefinitionType
     */
    public $ReturnPolicyProfileCategoryGroup;
    /**
     * The VINSupported
     * Meta information extracted from the WSDL
     * - documentation: This field is returned as an empty element (a boolean value is not returned) if one or more eBay API-enabled sites support the use of the VIN (Vehicle Identification Number) field to identify a motor vehicle and create a listing is
     * supported. VINs are supported on the US, Canada, Canada-French, and Australia sites. This field will not be returned if one or more <b>FeatureID</b> fields are included in the call request and <code>VINSupported</code> is not one of the values passed
     * into those <a href="types/FeatureIDCodeType.html">FeatureID</a> fields.
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\VINSupportedDefinitionType
     */
    public $VINSupported;
    /**
     * The VRMSupported
     * Meta information extracted from the WSDL
     * - documentation: This field is returned as an empty element (a boolean value is not returned) if one or more eBay API-enabled sites support the use of the VRM (Vehicle Registration Mark) field to identify a motor vehicle and create a listing is
     * supported. VRMs are only supported on the UK site. This field will not be returned if one or more <b>FeatureID</b> fields are included in the call request and <code>VRMSupported</code> is not one of the values passed into those <a
     * href="types/FeatureIDCodeType.html">FeatureID</a> fields.
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\VRMSupportedDefinitionType
     */
    public $VRMSupported;
    /**
     * The SellerProvidedTitleSupported
     * Meta information extracted from the WSDL
     * - documentation: This field is returned as an empty element (a boolean value is not returned) if one or more eBay API-enabled sites support seller-provided titles in motor vehicle listings. This field will not be returned if one or more
     * <b>FeatureID</b> fields are included in the call request and <code>SellerProvidedTitleSupported</code> is not one of the values passed into those <a href="types/FeatureIDCodeType.html">FeatureID</a> fields.
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\SellerProvidedTitleSupportedDefinitionType
     */
    public $SellerProvidedTitleSupported;
    /**
     * The DepositSupported
     * Meta information extracted from the WSDL
     * - documentation: This field is returned as an empty element (a boolean value is not returned) if one or more eBay API-enabled sites support deposits/down payments for motor vehicle listings. This field will not be returned if one or more
     * <b>FeatureID</b> fields are included in the call request and <code>DepositSupported</code> is not one of the values passed into those <a href="types/FeatureIDCodeType.html">FeatureID</a> fields.
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\DepositSupportedDefinitionType
     */
    public $DepositSupported;
    /**
     * The GlobalShippingEnabled
     * Meta information extracted from the WSDL
     * - documentation: This field is returned as an empty element (a boolean value is not returned) if one or more eBay API-enabled sites support the Global Shipping Program (GSP) as the method for shipping orders internationally. This field will not be
     * returned if one or more <b>FeatureID</b> fields are included in the call request and <code>GlobalShippingEnabled</code> is not one of the values passed into those <a href="types/FeatureIDCodeType.html">FeatureID</a> fields.
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\GlobalShippingEnabledDefinitionType
     */
    public $GlobalShippingEnabled;
    /**
     * The AdditionalCompatibilityEnabled
     * Meta information extracted from the WSDL
     * - documentation: This field is returned as an empty element (a boolean value is not returned) if one or more eBay API-enabled sites support the Boat and Motorcycle Parts Compatibility feature. This field will be returned as long as
     * <b>AdditionalCompatibilityEnabled</b> is included as a <b>FeatureID</b> value in the call request or no <a href="types/FeatureIDCodeType.html">FeatureID</a> values are passed into the call request. <br> <br> To verify if a specific eBay site supports
     * Boat or Motorcycle Parts Compatibility (for most categories), look for a <code>true</code> value in the <b>SiteDefaults.AdditionalCompatibilityEnabled</b> field. <br> <br> To verify if a specific category on a specific eBay site supports Boat and
     * Motorcycle Parts Compatibility, pass in a <b>CategoryID</b> value in the request, and then look for a <code>true</code> <br> value in the <b>AdditionalCompatibilityEnabled</b> field of the corresponding <b>Category</b> node (match up the
     * <b>CategoryID</b> values if more than one Category IDs were passed in the request).
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\AdditionalCompatibilityEnabledDefinitionType
     */
    public $AdditionalCompatibilityEnabled;
    /**
     * The any
     * @var \DOMDocument
     */
    public $any;
    /**
     * The PickupDropOffEnabled
     * Meta information extracted from the WSDL
     * - documentation: This field is returned as an empty element (a boolean value is not returned) if one or more eBay API-enabled sites support the Click and Collect feature. This field will be returned as long as <b>PickupDropOffEnabled</b> is included
     * as a <b>FeatureID</b> value in the call request or no <a href="types/FeatureIDCodeType.html">FeatureID</a> values are passed into the call request. <br> <br> To verify if a specific eBay site supports the Click and Collect feature (for most
     * categories), look for a <code>true</code> value in the <b>SiteDefaults.PickupDropOffEnabled</b> field. <br> <br> To verify if a specific category on a specific eBay site supports the Click and Collect feature, pass in a <b>CategoryID</b> value in the
     * request, and then look for a <code>true</code> value in the <b>PickupDropOffEnabled</b> field of the corresponding <b>Category</b> node (match up the <b>CategoryID</b> values if more than one Category IDs were passed in the request). <br> <br> <span
     * class="tablenote"><b>Note:</b> For Click and Collect eligible sellers, the Click and Collect feature can only be enabled at the account level, and then each of the seller's listings within an Click and Collect enabled category will be automatically
     * evaluated for Click and Collect eligibility. </span>
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\PickupDropOffEnabledDefinitionType
     */
    public $PickupDropOffEnabled;
    /**
     * The DigitalGoodDeliveryEnabled
     * Meta information extracted from the WSDL
     * - documentation: This field is returned as an empty element (a boolean value is not returned) if one or more eBay API-enabled sites support digital gift card listings. This field will be returned as long as <b>DigitalGoodDeliveryEnabled</b> is
     * included as a <b>FeatureID</b> value in the call request or no <a href="types/FeatureIDCodeType.html">FeatureID</a> values are passed into the call request. <br> <br> To verify if a specific eBay site supports digital gift card listings (for most
     * categories), look for a <code>true</code> value in the <b>SiteDefaults.DigitalGoodDeliveryEnabled</b> field. <br> <br> To verify if a specific category on a specific eBay site supports digital gift card listings, pass in a <b>CategoryID</b> value in
     * the request, and then look for a <code>true</code> value in the <b>DigitalGoodDeliveryEnabled</b> field of the corresponding <b>Category</b> node (match up the <b>CategoryID</b> values if more than one Category IDs were passed in the request). <br>
     * <br> Digital gift cards are currently only supported on the US site. There are some restrictions when it comes to selling gift cards, including the following: <ul> <li>Each seller can only have one gift card listing at any given time </li> <li>The
     * maximum dollar value of the gift card may not exceed 500.00</li> <li>Prepaid credit cards from American Express, Discover, MasterCard, or Visa are not allowed</li> </ul> For more information on eBay's Gift Card policy, see the <a href="
     * https://www.ebay.com/help/policies/prohibited-restricted-items/gift-cards-policy?id=4294" target="_blank">Gift cards policy</a> help page.
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\DigitalGoodDeliveryEnabledDefinitionType
     */
    public $DigitalGoodDeliveryEnabled;
    /**
     * The EpidSupported
     * Meta information extracted from the WSDL
     * - documentation: This field is returned as an empty element (a boolean value is not returned) if one or more eBay API-enabled sites support the use of an eBay Product ID (e.g. ePID) in an Add/Revise/Relist API call to identify which motorcycles
     * and/or scooters are compatible with a motor vehicle part or accessory. ePIDs can only be used to identify motorcycles and scooters on the Germany and UK sites. This field will be returned as long as <b>EpidSupported</b> is included as a
     * <b>FeatureID</b> value in the call request or no <a href="types/FeatureIDCodeType.html">FeatureID</a> values are passed into the call request. <br/><br/> For more information on using an ePID to identify a compatible motorcycle or scooter through an
     * Add/Revise/Relist API call on the Germany or UK site, see the documentation for the <a href="
     * https://developer.ebay.com/Devzone/XML/docs/Reference/eBay/AddItem.html#Request.Item.ItemCompatibilityList.Compatibility.NameValueList">Compatibility.NameValueList</a> container.
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\EpidSupportedDefinitionType
     */
    public $EpidSupported;
    /**
     * The KTypeSupported
     * Meta information extracted from the WSDL
     * - documentation: TThis field is returned as an empty element (a boolean value is not returned) if one or more eBay API-enabled sites support the use of a K Type vehicle number in an Add/Revise/Relist API call to identify which cars and/or trucks are
     * compatible with a motor vehicle part or accessory. K type vehicle numbers can only be used to identify cars and trucks on the Germany site. This field will be returned as long as <b>KTypeSupported</b> is included as a <b>FeatureID</b> value in the
     * call request or no <a href="types/FeatureIDCodeType.html">FeatureID</a> values are passed into the call request. <br/><br/> For more information on using a K Type vehicle number to identify a compatible car or truck through an Add/Revise/Relist API
     * call on the Germany site, see the documentation for the <a href=" https://developer.ebay.com/Devzone/XML/docs/Reference/eBay/AddItem.html#Request.Item.ItemCompatibilityList.Compatibility.NameValueList">Compatibility.NameValueList</a> container.
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\KTypeSupportedDefinitionType
     */
    public $KTypeSupported;
    /**
     * The ProductRequiredEnabled
     * Meta information extracted from the WSDL
     * - documentation: This field is returned as an empty element (a boolean value is not returned) if one or more eBay API-enabled sites supports Product-Based Shopping Experience listings (listings associated with eBay catalog products). <br><br> <span
     * class="tablenote"><b>Note:</b> Due to the rollback of the Product-Based Shopping Experience mandate for all eBay categories, association with an eBay catalog product will no longer be required for any categories on any eBay marketplace.</span>
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\ProductRequiredEnabledDefinitionType
     */
    public $ProductRequiredEnabled;
    /**
     * The DomesticReturnsAcceptedValues
     * Meta information extracted from the WSDL
     * - documentation: If present, this flag indicates the seller can set how to handle domestic returns.
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\DomesticReturnsAcceptedDefinitionType
     */
    public $DomesticReturnsAcceptedValues;
    /**
     * The InternationalReturnsAcceptedValues
     * Meta information extracted from the WSDL
     * - documentation: If present, this flag indicates the seller can set how to handle international returns.
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\InternationalReturnsAcceptedDefinitionType
     */
    public $InternationalReturnsAcceptedValues;
    /**
     * The DomesticReturnsDurationValues
     * Meta information extracted from the WSDL
     * - documentation: If present, this flag indicates the seller can set the time duration for domestic returns.
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\DomesticReturnsDurationDefinitionType
     */
    public $DomesticReturnsDurationValues;
    /**
     * The InternationalReturnsDurationValues
     * Meta information extracted from the WSDL
     * - documentation: If present, this flag indicates the seller can set the time duration for international returns.
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\InternationalReturnsDurationDefinitionType
     */
    public $InternationalReturnsDurationValues;
    /**
     * The DomesticReturnsShipmentPayeeValues
     * Meta information extracted from the WSDL
     * - documentation: If present, this flag indicates the seller can set who pays the shipping for domestic returns.
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\DomesticReturnsShipmentPayeeDefinitionType
     */
    public $DomesticReturnsShipmentPayeeValues;
    /**
     * The InternationalReturnsShipmentPayeeValues
     * Meta information extracted from the WSDL
     * - documentation: If present, this flag indicates the seller can set who pays the shipping for international returns.
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\InternationalReturnsShipmentPayeeDefinitionType
     */
    public $InternationalReturnsShipmentPayeeValues;
    /**
     * The DomesticRefundMethodValues
     * Meta information extracted from the WSDL
     * - documentation: If present, this flag indicates the seller can set the method they use to refund domestic returns.
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\DomesticRefundMethodCodeType
     */
    public $DomesticRefundMethodValues;
    /**
     * The InternationalRefundMethodValues
     * Meta information extracted from the WSDL
     * - documentation: If present, this flag indicates the seller can set the method they use to refund international returns.
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\InternationalRefundMethodCodeType
     */
    public $InternationalRefundMethodValues;
    /**
     * The ReturnPolicyDescriptionEnabled
     * Meta information extracted from the WSDL
     * - documentation: If present, this flag indicates the seller can choose to describe the return policy they offer (providing return-policy details is required in some EU countries).
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\ReturnPolicyDescriptionEnabledDefinitionType
     */
    public $ReturnPolicyDescriptionEnabled;
    /**
     * Constructor method for FeatureDefinitionsType
     * @uses FeatureDefinitionsType::setListingDurations()
     * @uses FeatureDefinitionsType::setShippingTermsRequired()
     * @uses FeatureDefinitionsType::setBestOfferEnabled()
     * @uses FeatureDefinitionsType::setDutchBINEnabled()
     * @uses FeatureDefinitionsType::setUserConsentRequired()
     * @uses FeatureDefinitionsType::setHomePageFeaturedEnabled()
     * @uses FeatureDefinitionsType::setProPackEnabled()
     * @uses FeatureDefinitionsType::setBasicUpgradePackEnabled()
     * @uses FeatureDefinitionsType::setValuePackEnabled()
     * @uses FeatureDefinitionsType::setProPackPlusEnabled()
     * @uses FeatureDefinitionsType::setAdFormatEnabled()
     * @uses FeatureDefinitionsType::setBestOfferCounterEnabled()
     * @uses FeatureDefinitionsType::setBestOfferAutoDeclineEnabled()
     * @uses FeatureDefinitionsType::setLocalMarketSpecialitySubscription()
     * @uses FeatureDefinitionsType::setLocalMarketRegularSubscription()
     * @uses FeatureDefinitionsType::setLocalMarketPremiumSubscription()
     * @uses FeatureDefinitionsType::setLocalMarketNonSubscription()
     * @uses FeatureDefinitionsType::setExpressEnabled()
     * @uses FeatureDefinitionsType::setExpressPicturesRequired()
     * @uses FeatureDefinitionsType::setExpressConditionRequired()
     * @uses FeatureDefinitionsType::setMinimumReservePrice()
     * @uses FeatureDefinitionsType::setTransactionConfirmationRequestEnabled()
     * @uses FeatureDefinitionsType::setSellerContactDetailsEnabled()
     * @uses FeatureDefinitionsType::setStoreInventoryEnabled()
     * @uses FeatureDefinitionsType::setSkypeMeTransactionalEnabled()
     * @uses FeatureDefinitionsType::setSkypeMeNonTransactionalEnabled()
     * @uses FeatureDefinitionsType::setLocalListingDistancesRegular()
     * @uses FeatureDefinitionsType::setLocalListingDistancesSpecialty()
     * @uses FeatureDefinitionsType::setLocalListingDistancesNonSubscription()
     * @uses FeatureDefinitionsType::setClassifiedAdPaymentMethodEnabled()
     * @uses FeatureDefinitionsType::setClassifiedAdShippingMethodEnabled()
     * @uses FeatureDefinitionsType::setClassifiedAdBestOfferEnabled()
     * @uses FeatureDefinitionsType::setClassifiedAdCounterOfferEnabled()
     * @uses FeatureDefinitionsType::setClassifiedAdAutoDeclineEnabled()
     * @uses FeatureDefinitionsType::setClassifiedAdContactByPhoneEnabled()
     * @uses FeatureDefinitionsType::setClassifiedAdContactByEmailEnabled()
     * @uses FeatureDefinitionsType::setSafePaymentRequired()
     * @uses FeatureDefinitionsType::setClassifiedAdPayPerLeadEnabled()
     * @uses FeatureDefinitionsType::setItemSpecificsEnabled()
     * @uses FeatureDefinitionsType::setPaisaPayFullEscrowEnabled()
     * @uses FeatureDefinitionsType::setISBNIdentifierEnabled()
     * @uses FeatureDefinitionsType::setUPCIdentifierEnabled()
     * @uses FeatureDefinitionsType::setEANIdentifierEnabled()
     * @uses FeatureDefinitionsType::setBrandMPNIdentifierEnabled()
     * @uses FeatureDefinitionsType::setBestOfferAutoAcceptEnabled()
     * @uses FeatureDefinitionsType::setClassifiedAdAutoAcceptEnabled()
     * @uses FeatureDefinitionsType::setCrossBorderTradeNorthAmericaEnabled()
     * @uses FeatureDefinitionsType::setCrossBorderTradeGBEnabled()
     * @uses FeatureDefinitionsType::setCrossBorderTradeAustraliaEnabled()
     * @uses FeatureDefinitionsType::setPayPalBuyerProtectionEnabled()
     * @uses FeatureDefinitionsType::setBuyerGuaranteeEnabled()
     * @uses FeatureDefinitionsType::setCombinedFixedPriceTreatmentEnabled()
     * @uses FeatureDefinitionsType::setGalleryFeaturedDurations()
     * @uses FeatureDefinitionsType::setINEscrowWorkflowTimeline()
     * @uses FeatureDefinitionsType::setPayPalRequired()
     * @uses FeatureDefinitionsType::setEBayMotorsProAdFormatEnabled()
     * @uses FeatureDefinitionsType::setEBayMotorsProContactByPhoneEnabled()
     * @uses FeatureDefinitionsType::setEBayMotorsProPhoneCount()
     * @uses FeatureDefinitionsType::setEBayMotorsProContactByAddressEnabled()
     * @uses FeatureDefinitionsType::setEBayMotorsProStreetCount()
     * @uses FeatureDefinitionsType::setEBayMotorsProCompanyNameEnabled()
     * @uses FeatureDefinitionsType::setEBayMotorsProContactByEmailEnabled()
     * @uses FeatureDefinitionsType::setEBayMotorsProBestOfferEnabled()
     * @uses FeatureDefinitionsType::setEBayMotorsProAutoAcceptEnabled()
     * @uses FeatureDefinitionsType::setEBayMotorsProAutoDeclineEnabled()
     * @uses FeatureDefinitionsType::setEBayMotorsProPaymentMethodCheckOutEnabled()
     * @uses FeatureDefinitionsType::setEBayMotorsProShippingMethodEnabled()
     * @uses FeatureDefinitionsType::setEBayMotorsProCounterOfferEnabled()
     * @uses FeatureDefinitionsType::setEBayMotorsProSellerContactDetailsEnabled()
     * @uses FeatureDefinitionsType::setLocalMarketAdFormatEnabled()
     * @uses FeatureDefinitionsType::setLocalMarketContactByPhoneEnabled()
     * @uses FeatureDefinitionsType::setLocalMarketPhoneCount()
     * @uses FeatureDefinitionsType::setLocalMarketContactByAddressEnabled()
     * @uses FeatureDefinitionsType::setLocalMarketStreetCount()
     * @uses FeatureDefinitionsType::setLocalMarketCompanyNameEnabled()
     * @uses FeatureDefinitionsType::setLocalMarketContactByEmailEnabled()
     * @uses FeatureDefinitionsType::setLocalMarketBestOfferEnabled()
     * @uses FeatureDefinitionsType::setLocalMarketAutoAcceptEnabled()
     * @uses FeatureDefinitionsType::setLocalMarketAutoDeclineEnabled()
     * @uses FeatureDefinitionsType::setLocalMarketPaymentMethodCheckOutEnabled()
     * @uses FeatureDefinitionsType::setLocalMarketShippingMethodEnabled()
     * @uses FeatureDefinitionsType::setLocalMarketCounterOfferEnabled()
     * @uses FeatureDefinitionsType::setLocalMarketSellerContactDetailsEnabled()
     * @uses FeatureDefinitionsType::setClassifiedAdPhoneCount()
     * @uses FeatureDefinitionsType::setClassifiedAdContactByAddressEnabled()
     * @uses FeatureDefinitionsType::setClassifiedAdStreetCount()
     * @uses FeatureDefinitionsType::setClassifiedAdCompanyNameEnabled()
     * @uses FeatureDefinitionsType::setSpecialitySubscription()
     * @uses FeatureDefinitionsType::setRegularSubscription()
     * @uses FeatureDefinitionsType::setPremiumSubscription()
     * @uses FeatureDefinitionsType::setNonSubscription()
     * @uses FeatureDefinitionsType::setReturnPolicyEnabled()
     * @uses FeatureDefinitionsType::setHandlingTimeEnabled()
     * @uses FeatureDefinitionsType::setPayPalRequiredForStoreOwner()
     * @uses FeatureDefinitionsType::setReviseQuantityAllowed()
     * @uses FeatureDefinitionsType::setRevisePriceAllowed()
     * @uses FeatureDefinitionsType::setStoreOwnerExtendedListingDurationsEnabled()
     * @uses FeatureDefinitionsType::setStoreOwnerExtendedListingDurations()
     * @uses FeatureDefinitionsType::setPaymentMethod()
     * @uses FeatureDefinitionsType::setGroup1MaxFlatShippingCost()
     * @uses FeatureDefinitionsType::setGroup2MaxFlatShippingCost()
     * @uses FeatureDefinitionsType::setGroup3MaxFlatShippingCost()
     * @uses FeatureDefinitionsType::setMaxFlatShippingCostCBTExempt()
     * @uses FeatureDefinitionsType::setMaxFlatShippingCost()
     * @uses FeatureDefinitionsType::setVariationsEnabled()
     * @uses FeatureDefinitionsType::setAttributeConversionEnabled()
     * @uses FeatureDefinitionsType::setFreeGalleryPlusEnabled()
     * @uses FeatureDefinitionsType::setFreePicturePackEnabled()
     * @uses FeatureDefinitionsType::setItemCompatibilityEnabled()
     * @uses FeatureDefinitionsType::setMaxItemCompatibility()
     * @uses FeatureDefinitionsType::setMinItemCompatibility()
     * @uses FeatureDefinitionsType::setConditionEnabled()
     * @uses FeatureDefinitionsType::setConditionValues()
     * @uses FeatureDefinitionsType::setValueCategory()
     * @uses FeatureDefinitionsType::setProductCreationEnabled()
     * @uses FeatureDefinitionsType::setEANEnabled()
     * @uses FeatureDefinitionsType::setISBNEnabled()
     * @uses FeatureDefinitionsType::setUPCEnabled()
     * @uses FeatureDefinitionsType::setCompatibleVehicleType()
     * @uses FeatureDefinitionsType::setMaxGranularFitmentCount()
     * @uses FeatureDefinitionsType::setPaymentOptionsGroup()
     * @uses FeatureDefinitionsType::setShippingProfileCategoryGroup()
     * @uses FeatureDefinitionsType::setPaymentProfileCategoryGroup()
     * @uses FeatureDefinitionsType::setReturnPolicyProfileCategoryGroup()
     * @uses FeatureDefinitionsType::setVINSupported()
     * @uses FeatureDefinitionsType::setVRMSupported()
     * @uses FeatureDefinitionsType::setSellerProvidedTitleSupported()
     * @uses FeatureDefinitionsType::setDepositSupported()
     * @uses FeatureDefinitionsType::setGlobalShippingEnabled()
     * @uses FeatureDefinitionsType::setAdditionalCompatibilityEnabled()
     * @uses FeatureDefinitionsType::setAny()
     * @uses FeatureDefinitionsType::setPickupDropOffEnabled()
     * @uses FeatureDefinitionsType::setDigitalGoodDeliveryEnabled()
     * @uses FeatureDefinitionsType::setEpidSupported()
     * @uses FeatureDefinitionsType::setKTypeSupported()
     * @uses FeatureDefinitionsType::setProductRequiredEnabled()
     * @uses FeatureDefinitionsType::setDomesticReturnsAcceptedValues()
     * @uses FeatureDefinitionsType::setInternationalReturnsAcceptedValues()
     * @uses FeatureDefinitionsType::setDomesticReturnsDurationValues()
     * @uses FeatureDefinitionsType::setInternationalReturnsDurationValues()
     * @uses FeatureDefinitionsType::setDomesticReturnsShipmentPayeeValues()
     * @uses FeatureDefinitionsType::setInternationalReturnsShipmentPayeeValues()
     * @uses FeatureDefinitionsType::setDomesticRefundMethodValues()
     * @uses FeatureDefinitionsType::setInternationalRefundMethodValues()
     * @uses FeatureDefinitionsType::setReturnPolicyDescriptionEnabled()
     * @param \LewisLarsen\Ebay\StructType\ListingDurationDefinitionsType $listingDurations
     * @param \LewisLarsen\Ebay\StructType\ShippingTermRequiredDefinitionType $shippingTermsRequired
     * @param \LewisLarsen\Ebay\StructType\BestOfferEnabledDefinitionType $bestOfferEnabled
     * @param \LewisLarsen\Ebay\StructType\DutchBINEnabledDefinitionType $dutchBINEnabled
     * @param \LewisLarsen\Ebay\StructType\UserConsentRequiredDefinitionType $userConsentRequired
     * @param \LewisLarsen\Ebay\StructType\HomePageFeaturedEnabledDefinitionType $homePageFeaturedEnabled
     * @param \LewisLarsen\Ebay\StructType\ProPackEnabledDefinitionType $proPackEnabled
     * @param \LewisLarsen\Ebay\StructType\BasicUpgradePackEnabledDefinitionType $basicUpgradePackEnabled
     * @param \LewisLarsen\Ebay\StructType\ValuePackEnabledDefinitionType $valuePackEnabled
     * @param \LewisLarsen\Ebay\StructType\ProPackPlusEnabledDefinitionType $proPackPlusEnabled
     * @param \LewisLarsen\Ebay\StructType\AdFormatEnabledDefinitionType $adFormatEnabled
     * @param \LewisLarsen\Ebay\StructType\BestOfferCounterEnabledDefinitionType $bestOfferCounterEnabled
     * @param \LewisLarsen\Ebay\StructType\BestOfferAutoDeclineEnabledDefinitionType $bestOfferAutoDeclineEnabled
     * @param \LewisLarsen\Ebay\StructType\LocalMarketSpecialitySubscriptionDefinitionType $localMarketSpecialitySubscription
     * @param \LewisLarsen\Ebay\StructType\LocalMarketRegularSubscriptionDefinitionType $localMarketRegularSubscription
     * @param \LewisLarsen\Ebay\StructType\LocalMarketPremiumSubscriptionDefinitionType $localMarketPremiumSubscription
     * @param \LewisLarsen\Ebay\StructType\LocalMarketNonSubscriptionDefinitionType $localMarketNonSubscription
     * @param \LewisLarsen\Ebay\StructType\ExpressEnabledDefinitionType $expressEnabled
     * @param \LewisLarsen\Ebay\StructType\ExpressPicturesRequiredDefinitionType $expressPicturesRequired
     * @param \LewisLarsen\Ebay\StructType\ExpressConditionRequiredDefinitionType $expressConditionRequired
     * @param \LewisLarsen\Ebay\StructType\MinimumReservePriceDefinitionType $minimumReservePrice
     * @param \LewisLarsen\Ebay\StructType\TCREnabledDefinitionType $transactionConfirmationRequestEnabled
     * @param \LewisLarsen\Ebay\StructType\SellerContactDetailsEnabledDefinitionType $sellerContactDetailsEnabled
     * @param \LewisLarsen\Ebay\StructType\StoreInventoryEnabledDefinitionType $storeInventoryEnabled
     * @param \LewisLarsen\Ebay\StructType\SkypeMeTransactionalEnabledDefinitionType $skypeMeTransactionalEnabled
     * @param \LewisLarsen\Ebay\StructType\SkypeMeNonTransactionalEnabledDefinitionType $skypeMeNonTransactionalEnabled
     * @param \LewisLarsen\Ebay\StructType\LocalListingDistancesRegularDefinitionType $localListingDistancesRegular
     * @param \LewisLarsen\Ebay\StructType\LocalListingDistancesSpecialtyDefinitionType $localListingDistancesSpecialty
     * @param \LewisLarsen\Ebay\StructType\LocalListingDistancesNonSubscriptionDefinitionType $localListingDistancesNonSubscription
     * @param \LewisLarsen\Ebay\StructType\ClassifiedAdPaymentMethodEnabledDefinitionType $classifiedAdPaymentMethodEnabled
     * @param \LewisLarsen\Ebay\StructType\ClassifiedAdShippingMethodEnabledDefinitionType $classifiedAdShippingMethodEnabled
     * @param \LewisLarsen\Ebay\StructType\ClassifiedAdBestOfferEnabledDefinitionType $classifiedAdBestOfferEnabled
     * @param \LewisLarsen\Ebay\StructType\ClassifiedAdCounterOfferEnabledDefinitionType $classifiedAdCounterOfferEnabled
     * @param \LewisLarsen\Ebay\StructType\ClassifiedAdAutoDeclineEnabledDefinitionType $classifiedAdAutoDeclineEnabled
     * @param \LewisLarsen\Ebay\StructType\ClassifiedAdContactByPhoneEnabledDefinitionType $classifiedAdContactByPhoneEnabled
     * @param \LewisLarsen\Ebay\StructType\ClassifiedAdContactByEmailEnabledDefintionType $classifiedAdContactByEmailEnabled
     * @param \LewisLarsen\Ebay\StructType\SafePaymentRequiredDefinitionType $safePaymentRequired
     * @param \LewisLarsen\Ebay\StructType\ClassifiedAdPayPerLeadEnabledDefinitionType $classifiedAdPayPerLeadEnabled
     * @param \LewisLarsen\Ebay\StructType\ItemSpecificsEnabledDefinitionType $itemSpecificsEnabled
     * @param \LewisLarsen\Ebay\StructType\PaisaPayFullEscrowEnabledDefinitionType $paisaPayFullEscrowEnabled
     * @param \LewisLarsen\Ebay\StructType\ISBNIdentifierEnabledDefinitionType $iSBNIdentifierEnabled
     * @param \LewisLarsen\Ebay\StructType\UPCIdentifierEnabledDefinitionType $uPCIdentifierEnabled
     * @param \LewisLarsen\Ebay\StructType\EANIdentifierEnabledDefinitionType $eANIdentifierEnabled
     * @param \LewisLarsen\Ebay\StructType\BrandMPNIdentifierEnabledDefinitionType $brandMPNIdentifierEnabled
     * @param \LewisLarsen\Ebay\StructType\BestOfferAutoAcceptEnabledDefinitionType $bestOfferAutoAcceptEnabled
     * @param \LewisLarsen\Ebay\StructType\ClassifiedAdAutoAcceptEnabledDefinitionType $classifiedAdAutoAcceptEnabled
     * @param \LewisLarsen\Ebay\StructType\CrossBorderTradeNorthAmericaEnabledDefinitionType $crossBorderTradeNorthAmericaEnabled
     * @param \LewisLarsen\Ebay\StructType\CrossBorderTradeGBEnabledDefinitionType $crossBorderTradeGBEnabled
     * @param \LewisLarsen\Ebay\StructType\CrossBorderTradeAustraliaEnabledDefinitionType $crossBorderTradeAustraliaEnabled
     * @param \LewisLarsen\Ebay\StructType\PayPalBuyerProtectionEnabledDefinitionType $payPalBuyerProtectionEnabled
     * @param \LewisLarsen\Ebay\StructType\BuyerGuaranteeEnabledDefinitionType $buyerGuaranteeEnabled
     * @param \LewisLarsen\Ebay\StructType\CombinedFixedPriceTreatmentEnabledDefinitionType $combinedFixedPriceTreatmentEnabled
     * @param \LewisLarsen\Ebay\StructType\ListingEnhancementDurationDefinitionType $galleryFeaturedDurations
     * @param \LewisLarsen\Ebay\StructType\INEscrowWorkflowTimelineDefinitionType $iNEscrowWorkflowTimeline
     * @param \LewisLarsen\Ebay\StructType\PayPalRequiredDefinitionType $payPalRequired
     * @param \LewisLarsen\Ebay\StructType\EBayMotorsProAdFormatEnabledDefinitionType $eBayMotorsProAdFormatEnabled
     * @param \LewisLarsen\Ebay\StructType\EBayMotorsProContactByPhoneEnabledDefinitionType $eBayMotorsProContactByPhoneEnabled
     * @param \LewisLarsen\Ebay\StructType\EBayMotorsProPhoneCountDefinitionType $eBayMotorsProPhoneCount
     * @param \LewisLarsen\Ebay\StructType\EBayMotorsProContactByAddressEnabledDefinitionType $eBayMotorsProContactByAddressEnabled
     * @param \LewisLarsen\Ebay\StructType\EBayMotorsProStreetCountDefinitionType $eBayMotorsProStreetCount
     * @param \LewisLarsen\Ebay\StructType\EBayMotorsProCompanyNameEnabledDefinitionType $eBayMotorsProCompanyNameEnabled
     * @param \LewisLarsen\Ebay\StructType\EBayMotorsProContactByEmailEnabledDefinitionType $eBayMotorsProContactByEmailEnabled
     * @param \LewisLarsen\Ebay\StructType\EBayMotorsProBestOfferEnabledDefinitionType $eBayMotorsProBestOfferEnabled
     * @param \LewisLarsen\Ebay\StructType\EBayMotorsProAutoAcceptEnabledDefinitionType $eBayMotorsProAutoAcceptEnabled
     * @param \LewisLarsen\Ebay\StructType\EBayMotorsProAutoDeclineEnabledDefinitionType $eBayMotorsProAutoDeclineEnabled
     * @param \LewisLarsen\Ebay\StructType\EBayMotorsProPaymentMethodCheckOutEnabledDefinitionType $eBayMotorsProPaymentMethodCheckOutEnabled
     * @param \LewisLarsen\Ebay\StructType\EBayMotorsProShippingMethodEnabledDefinitionType $eBayMotorsProShippingMethodEnabled
     * @param \LewisLarsen\Ebay\StructType\EBayMotorsProCounterOfferEnabledDefinitionType $eBayMotorsProCounterOfferEnabled
     * @param \LewisLarsen\Ebay\StructType\EBayMotorsProSellerContactDetailsEnabledDefinitionType $eBayMotorsProSellerContactDetailsEnabled
     * @param \LewisLarsen\Ebay\StructType\LocalMarketAdFormatEnabledDefinitionType $localMarketAdFormatEnabled
     * @param \LewisLarsen\Ebay\StructType\LocalMarketContactByPhoneEnabledDefinitionType $localMarketContactByPhoneEnabled
     * @param \LewisLarsen\Ebay\StructType\LocalMarketPhoneCountDefinitionType $localMarketPhoneCount
     * @param \LewisLarsen\Ebay\StructType\LocalMarketContactByAddressEnabledDefinitionType $localMarketContactByAddressEnabled
     * @param \LewisLarsen\Ebay\StructType\LocalMarketStreetCountDefinitionType $localMarketStreetCount
     * @param \LewisLarsen\Ebay\StructType\LocalMarketCompanyNameEnabledDefinitionType $localMarketCompanyNameEnabled
     * @param \LewisLarsen\Ebay\StructType\LocalMarketContactByEmailEnabledDefinitionType $localMarketContactByEmailEnabled
     * @param \LewisLarsen\Ebay\StructType\LocalMarketBestOfferEnabledDefinitionType $localMarketBestOfferEnabled
     * @param \LewisLarsen\Ebay\StructType\LocalMarketAutoAcceptEnabledDefinitionType $localMarketAutoAcceptEnabled
     * @param \LewisLarsen\Ebay\StructType\LocalMarketAutoDeclineEnabledDefinitionType $localMarketAutoDeclineEnabled
     * @param \LewisLarsen\Ebay\StructType\LocalMarketPaymentMethodCheckOutEnabledDefinitionType $localMarketPaymentMethodCheckOutEnabled
     * @param \LewisLarsen\Ebay\StructType\LocalMarketShippingMethodEnabledDefinitionType $localMarketShippingMethodEnabled
     * @param \LewisLarsen\Ebay\StructType\LocalMarketCounterOfferEnabledDefinitionType $localMarketCounterOfferEnabled
     * @param \LewisLarsen\Ebay\StructType\LocalMarketSellerContactDetailsEnabledDefinitionType $localMarketSellerContactDetailsEnabled
     * @param \LewisLarsen\Ebay\StructType\ClassifiedAdPhoneCountDefinitionType $classifiedAdPhoneCount
     * @param \LewisLarsen\Ebay\StructType\ClassifiedAdContactByAddressEnabledDefinitionType $classifiedAdContactByAddressEnabled
     * @param \LewisLarsen\Ebay\StructType\ClassifiedAdStreetCountDefinitionType $classifiedAdStreetCount
     * @param \LewisLarsen\Ebay\StructType\ClassifiedAdCompanyNameEnabledDefinitionType $classifiedAdCompanyNameEnabled
     * @param \LewisLarsen\Ebay\StructType\SpecialitySubscriptionDefinitionType $specialitySubscription
     * @param \LewisLarsen\Ebay\StructType\RegularSubscriptionDefinitionType $regularSubscription
     * @param \LewisLarsen\Ebay\StructType\PremiumSubscriptionDefinitionType $premiumSubscription
     * @param \LewisLarsen\Ebay\StructType\NonSubscriptionDefinitionType $nonSubscription
     * @param \LewisLarsen\Ebay\StructType\ReturnPolicyEnabledDefinitionType $returnPolicyEnabled
     * @param \LewisLarsen\Ebay\StructType\HandlingTimeEnabledDefinitionType $handlingTimeEnabled
     * @param \LewisLarsen\Ebay\StructType\PayPalRequiredForStoreOwnerDefinitionType $payPalRequiredForStoreOwner
     * @param \LewisLarsen\Ebay\StructType\ReviseQuantityAllowedDefinitionType $reviseQuantityAllowed
     * @param \LewisLarsen\Ebay\StructType\RevisePriceAllowedDefinitionType $revisePriceAllowed
     * @param \LewisLarsen\Ebay\StructType\StoreOwnerExtendedListingDurationsEnabledDefinitionType $storeOwnerExtendedListingDurationsEnabled
     * @param \LewisLarsen\Ebay\StructType\StoreOwnerExtendedListingDurationsDefinitionType $storeOwnerExtendedListingDurations
     * @param \LewisLarsen\Ebay\StructType\PaymentMethodDefinitionType $paymentMethod
     * @param \LewisLarsen\Ebay\StructType\Group1MaxFlatShippingCostDefinitionType $group1MaxFlatShippingCost
     * @param \LewisLarsen\Ebay\StructType\Group2MaxFlatShippingCostDefinitionType $group2MaxFlatShippingCost
     * @param \LewisLarsen\Ebay\StructType\Group3MaxFlatShippingCostDefinitionType $group3MaxFlatShippingCost
     * @param \LewisLarsen\Ebay\StructType\MaxFlatShippingCostCBTExemptDefinitionType $maxFlatShippingCostCBTExempt
     * @param \LewisLarsen\Ebay\StructType\MaxFlatShippingCostDefinitionType $maxFlatShippingCost
     * @param \LewisLarsen\Ebay\StructType\VariationsEnabledDefinitionType $variationsEnabled
     * @param \LewisLarsen\Ebay\StructType\AttributeConversionEnabledFeatureDefinitionType $attributeConversionEnabled
     * @param \LewisLarsen\Ebay\StructType\FreeGalleryPlusEnabledDefinitionType $freeGalleryPlusEnabled
     * @param \LewisLarsen\Ebay\StructType\FreePicturePackEnabledDefinitionType $freePicturePackEnabled
     * @param \LewisLarsen\Ebay\StructType\ItemCompatibilityEnabledDefinitionType $itemCompatibilityEnabled
     * @param \LewisLarsen\Ebay\StructType\MaxItemCompatibilityDefinitionType $maxItemCompatibility
     * @param \LewisLarsen\Ebay\StructType\MinItemCompatibilityDefinitionType $minItemCompatibility
     * @param \LewisLarsen\Ebay\StructType\ConditionEnabledDefinitionType $conditionEnabled
     * @param \LewisLarsen\Ebay\StructType\ConditionValuesDefinitionType $conditionValues
     * @param \LewisLarsen\Ebay\StructType\ValueCategoryDefinitionType $valueCategory
     * @param \LewisLarsen\Ebay\StructType\ProductCreationEnabledDefinitionType $productCreationEnabled
     * @param \LewisLarsen\Ebay\StructType\EANEnabledDefinitionType $eANEnabled
     * @param \LewisLarsen\Ebay\StructType\ISBNEnabledDefinitionType $iSBNEnabled
     * @param \LewisLarsen\Ebay\StructType\UPCEnabledDefinitionType $uPCEnabled
     * @param \LewisLarsen\Ebay\StructType\CompatibleVehicleTypeDefinitionType $compatibleVehicleType
     * @param \LewisLarsen\Ebay\StructType\MaxGranularFitmentCountDefinitionType $maxGranularFitmentCount
     * @param \LewisLarsen\Ebay\StructType\PaymentOptionsGroupEnabledDefinitionType $paymentOptionsGroup
     * @param \LewisLarsen\Ebay\StructType\ProfileCategoryGroupDefinitionType $shippingProfileCategoryGroup
     * @param \LewisLarsen\Ebay\StructType\ProfileCategoryGroupDefinitionType $paymentProfileCategoryGroup
     * @param \LewisLarsen\Ebay\StructType\ProfileCategoryGroupDefinitionType $returnPolicyProfileCategoryGroup
     * @param \LewisLarsen\Ebay\StructType\VINSupportedDefinitionType $vINSupported
     * @param \LewisLarsen\Ebay\StructType\VRMSupportedDefinitionType $vRMSupported
     * @param \LewisLarsen\Ebay\StructType\SellerProvidedTitleSupportedDefinitionType $sellerProvidedTitleSupported
     * @param \LewisLarsen\Ebay\StructType\DepositSupportedDefinitionType $depositSupported
     * @param \LewisLarsen\Ebay\StructType\GlobalShippingEnabledDefinitionType $globalShippingEnabled
     * @param \LewisLarsen\Ebay\StructType\AdditionalCompatibilityEnabledDefinitionType $additionalCompatibilityEnabled
     * @param \DOMDocument $any
     * @param \LewisLarsen\Ebay\StructType\PickupDropOffEnabledDefinitionType $pickupDropOffEnabled
     * @param \LewisLarsen\Ebay\StructType\DigitalGoodDeliveryEnabledDefinitionType $digitalGoodDeliveryEnabled
     * @param \LewisLarsen\Ebay\StructType\EpidSupportedDefinitionType $epidSupported
     * @param \LewisLarsen\Ebay\StructType\KTypeSupportedDefinitionType $kTypeSupported
     * @param \LewisLarsen\Ebay\StructType\ProductRequiredEnabledDefinitionType $productRequiredEnabled
     * @param \LewisLarsen\Ebay\StructType\DomesticReturnsAcceptedDefinitionType $domesticReturnsAcceptedValues
     * @param \LewisLarsen\Ebay\StructType\InternationalReturnsAcceptedDefinitionType $internationalReturnsAcceptedValues
     * @param \LewisLarsen\Ebay\StructType\DomesticReturnsDurationDefinitionType $domesticReturnsDurationValues
     * @param \LewisLarsen\Ebay\StructType\InternationalReturnsDurationDefinitionType $internationalReturnsDurationValues
     * @param \LewisLarsen\Ebay\StructType\DomesticReturnsShipmentPayeeDefinitionType $domesticReturnsShipmentPayeeValues
     * @param \LewisLarsen\Ebay\StructType\InternationalReturnsShipmentPayeeDefinitionType $internationalReturnsShipmentPayeeValues
     * @param \LewisLarsen\Ebay\StructType\DomesticRefundMethodCodeType $domesticRefundMethodValues
     * @param \LewisLarsen\Ebay\StructType\InternationalRefundMethodCodeType $internationalRefundMethodValues
     * @param \LewisLarsen\Ebay\StructType\ReturnPolicyDescriptionEnabledDefinitionType $returnPolicyDescriptionEnabled
     */
    public function __construct(\LewisLarsen\Ebay\StructType\ListingDurationDefinitionsType $listingDurations = null, \LewisLarsen\Ebay\StructType\ShippingTermRequiredDefinitionType $shippingTermsRequired = null, \LewisLarsen\Ebay\StructType\BestOfferEnabledDefinitionType $bestOfferEnabled = null, \LewisLarsen\Ebay\StructType\DutchBINEnabledDefinitionType $dutchBINEnabled = null, \LewisLarsen\Ebay\StructType\UserConsentRequiredDefinitionType $userConsentRequired = null, \LewisLarsen\Ebay\StructType\HomePageFeaturedEnabledDefinitionType $homePageFeaturedEnabled = null, \LewisLarsen\Ebay\StructType\ProPackEnabledDefinitionType $proPackEnabled = null, \LewisLarsen\Ebay\StructType\BasicUpgradePackEnabledDefinitionType $basicUpgradePackEnabled = null, \LewisLarsen\Ebay\StructType\ValuePackEnabledDefinitionType $valuePackEnabled = null, \LewisLarsen\Ebay\StructType\ProPackPlusEnabledDefinitionType $proPackPlusEnabled = null, \LewisLarsen\Ebay\StructType\AdFormatEnabledDefinitionType $adFormatEnabled = null, \LewisLarsen\Ebay\StructType\BestOfferCounterEnabledDefinitionType $bestOfferCounterEnabled = null, \LewisLarsen\Ebay\StructType\BestOfferAutoDeclineEnabledDefinitionType $bestOfferAutoDeclineEnabled = null, \LewisLarsen\Ebay\StructType\LocalMarketSpecialitySubscriptionDefinitionType $localMarketSpecialitySubscription = null, \LewisLarsen\Ebay\StructType\LocalMarketRegularSubscriptionDefinitionType $localMarketRegularSubscription = null, \LewisLarsen\Ebay\StructType\LocalMarketPremiumSubscriptionDefinitionType $localMarketPremiumSubscription = null, \LewisLarsen\Ebay\StructType\LocalMarketNonSubscriptionDefinitionType $localMarketNonSubscription = null, \LewisLarsen\Ebay\StructType\ExpressEnabledDefinitionType $expressEnabled = null, \LewisLarsen\Ebay\StructType\ExpressPicturesRequiredDefinitionType $expressPicturesRequired = null, \LewisLarsen\Ebay\StructType\ExpressConditionRequiredDefinitionType $expressConditionRequired = null, \LewisLarsen\Ebay\StructType\MinimumReservePriceDefinitionType $minimumReservePrice = null, \LewisLarsen\Ebay\StructType\TCREnabledDefinitionType $transactionConfirmationRequestEnabled = null, \LewisLarsen\Ebay\StructType\SellerContactDetailsEnabledDefinitionType $sellerContactDetailsEnabled = null, \LewisLarsen\Ebay\StructType\StoreInventoryEnabledDefinitionType $storeInventoryEnabled = null, \LewisLarsen\Ebay\StructType\SkypeMeTransactionalEnabledDefinitionType $skypeMeTransactionalEnabled = null, \LewisLarsen\Ebay\StructType\SkypeMeNonTransactionalEnabledDefinitionType $skypeMeNonTransactionalEnabled = null, \LewisLarsen\Ebay\StructType\LocalListingDistancesRegularDefinitionType $localListingDistancesRegular = null, \LewisLarsen\Ebay\StructType\LocalListingDistancesSpecialtyDefinitionType $localListingDistancesSpecialty = null, \LewisLarsen\Ebay\StructType\LocalListingDistancesNonSubscriptionDefinitionType $localListingDistancesNonSubscription = null, \LewisLarsen\Ebay\StructType\ClassifiedAdPaymentMethodEnabledDefinitionType $classifiedAdPaymentMethodEnabled = null, \LewisLarsen\Ebay\StructType\ClassifiedAdShippingMethodEnabledDefinitionType $classifiedAdShippingMethodEnabled = null, \LewisLarsen\Ebay\StructType\ClassifiedAdBestOfferEnabledDefinitionType $classifiedAdBestOfferEnabled = null, \LewisLarsen\Ebay\StructType\ClassifiedAdCounterOfferEnabledDefinitionType $classifiedAdCounterOfferEnabled = null, \LewisLarsen\Ebay\StructType\ClassifiedAdAutoDeclineEnabledDefinitionType $classifiedAdAutoDeclineEnabled = null, \LewisLarsen\Ebay\StructType\ClassifiedAdContactByPhoneEnabledDefinitionType $classifiedAdContactByPhoneEnabled = null, \LewisLarsen\Ebay\StructType\ClassifiedAdContactByEmailEnabledDefintionType $classifiedAdContactByEmailEnabled = null, \LewisLarsen\Ebay\StructType\SafePaymentRequiredDefinitionType $safePaymentRequired = null, \LewisLarsen\Ebay\StructType\ClassifiedAdPayPerLeadEnabledDefinitionType $classifiedAdPayPerLeadEnabled = null, \LewisLarsen\Ebay\StructType\ItemSpecificsEnabledDefinitionType $itemSpecificsEnabled = null, \LewisLarsen\Ebay\StructType\PaisaPayFullEscrowEnabledDefinitionType $paisaPayFullEscrowEnabled = null, \LewisLarsen\Ebay\StructType\ISBNIdentifierEnabledDefinitionType $iSBNIdentifierEnabled = null, \LewisLarsen\Ebay\StructType\UPCIdentifierEnabledDefinitionType $uPCIdentifierEnabled = null, \LewisLarsen\Ebay\StructType\EANIdentifierEnabledDefinitionType $eANIdentifierEnabled = null, \LewisLarsen\Ebay\StructType\BrandMPNIdentifierEnabledDefinitionType $brandMPNIdentifierEnabled = null, \LewisLarsen\Ebay\StructType\BestOfferAutoAcceptEnabledDefinitionType $bestOfferAutoAcceptEnabled = null, \LewisLarsen\Ebay\StructType\ClassifiedAdAutoAcceptEnabledDefinitionType $classifiedAdAutoAcceptEnabled = null, \LewisLarsen\Ebay\StructType\CrossBorderTradeNorthAmericaEnabledDefinitionType $crossBorderTradeNorthAmericaEnabled = null, \LewisLarsen\Ebay\StructType\CrossBorderTradeGBEnabledDefinitionType $crossBorderTradeGBEnabled = null, \LewisLarsen\Ebay\StructType\CrossBorderTradeAustraliaEnabledDefinitionType $crossBorderTradeAustraliaEnabled = null, \LewisLarsen\Ebay\StructType\PayPalBuyerProtectionEnabledDefinitionType $payPalBuyerProtectionEnabled = null, \LewisLarsen\Ebay\StructType\BuyerGuaranteeEnabledDefinitionType $buyerGuaranteeEnabled = null, \LewisLarsen\Ebay\StructType\CombinedFixedPriceTreatmentEnabledDefinitionType $combinedFixedPriceTreatmentEnabled = null, \LewisLarsen\Ebay\StructType\ListingEnhancementDurationDefinitionType $galleryFeaturedDurations = null, \LewisLarsen\Ebay\StructType\INEscrowWorkflowTimelineDefinitionType $iNEscrowWorkflowTimeline = null, \LewisLarsen\Ebay\StructType\PayPalRequiredDefinitionType $payPalRequired = null, \LewisLarsen\Ebay\StructType\EBayMotorsProAdFormatEnabledDefinitionType $eBayMotorsProAdFormatEnabled = null, \LewisLarsen\Ebay\StructType\EBayMotorsProContactByPhoneEnabledDefinitionType $eBayMotorsProContactByPhoneEnabled = null, \LewisLarsen\Ebay\StructType\EBayMotorsProPhoneCountDefinitionType $eBayMotorsProPhoneCount = null, \LewisLarsen\Ebay\StructType\EBayMotorsProContactByAddressEnabledDefinitionType $eBayMotorsProContactByAddressEnabled = null, \LewisLarsen\Ebay\StructType\EBayMotorsProStreetCountDefinitionType $eBayMotorsProStreetCount = null, \LewisLarsen\Ebay\StructType\EBayMotorsProCompanyNameEnabledDefinitionType $eBayMotorsProCompanyNameEnabled = null, \LewisLarsen\Ebay\StructType\EBayMotorsProContactByEmailEnabledDefinitionType $eBayMotorsProContactByEmailEnabled = null, \LewisLarsen\Ebay\StructType\EBayMotorsProBestOfferEnabledDefinitionType $eBayMotorsProBestOfferEnabled = null, \LewisLarsen\Ebay\StructType\EBayMotorsProAutoAcceptEnabledDefinitionType $eBayMotorsProAutoAcceptEnabled = null, \LewisLarsen\Ebay\StructType\EBayMotorsProAutoDeclineEnabledDefinitionType $eBayMotorsProAutoDeclineEnabled = null, \LewisLarsen\Ebay\StructType\EBayMotorsProPaymentMethodCheckOutEnabledDefinitionType $eBayMotorsProPaymentMethodCheckOutEnabled = null, \LewisLarsen\Ebay\StructType\EBayMotorsProShippingMethodEnabledDefinitionType $eBayMotorsProShippingMethodEnabled = null, \LewisLarsen\Ebay\StructType\EBayMotorsProCounterOfferEnabledDefinitionType $eBayMotorsProCounterOfferEnabled = null, \LewisLarsen\Ebay\StructType\EBayMotorsProSellerContactDetailsEnabledDefinitionType $eBayMotorsProSellerContactDetailsEnabled = null, \LewisLarsen\Ebay\StructType\LocalMarketAdFormatEnabledDefinitionType $localMarketAdFormatEnabled = null, \LewisLarsen\Ebay\StructType\LocalMarketContactByPhoneEnabledDefinitionType $localMarketContactByPhoneEnabled = null, \LewisLarsen\Ebay\StructType\LocalMarketPhoneCountDefinitionType $localMarketPhoneCount = null, \LewisLarsen\Ebay\StructType\LocalMarketContactByAddressEnabledDefinitionType $localMarketContactByAddressEnabled = null, \LewisLarsen\Ebay\StructType\LocalMarketStreetCountDefinitionType $localMarketStreetCount = null, \LewisLarsen\Ebay\StructType\LocalMarketCompanyNameEnabledDefinitionType $localMarketCompanyNameEnabled = null, \LewisLarsen\Ebay\StructType\LocalMarketContactByEmailEnabledDefinitionType $localMarketContactByEmailEnabled = null, \LewisLarsen\Ebay\StructType\LocalMarketBestOfferEnabledDefinitionType $localMarketBestOfferEnabled = null, \LewisLarsen\Ebay\StructType\LocalMarketAutoAcceptEnabledDefinitionType $localMarketAutoAcceptEnabled = null, \LewisLarsen\Ebay\StructType\LocalMarketAutoDeclineEnabledDefinitionType $localMarketAutoDeclineEnabled = null, \LewisLarsen\Ebay\StructType\LocalMarketPaymentMethodCheckOutEnabledDefinitionType $localMarketPaymentMethodCheckOutEnabled = null, \LewisLarsen\Ebay\StructType\LocalMarketShippingMethodEnabledDefinitionType $localMarketShippingMethodEnabled = null, \LewisLarsen\Ebay\StructType\LocalMarketCounterOfferEnabledDefinitionType $localMarketCounterOfferEnabled = null, \LewisLarsen\Ebay\StructType\LocalMarketSellerContactDetailsEnabledDefinitionType $localMarketSellerContactDetailsEnabled = null, \LewisLarsen\Ebay\StructType\ClassifiedAdPhoneCountDefinitionType $classifiedAdPhoneCount = null, \LewisLarsen\Ebay\StructType\ClassifiedAdContactByAddressEnabledDefinitionType $classifiedAdContactByAddressEnabled = null, \LewisLarsen\Ebay\StructType\ClassifiedAdStreetCountDefinitionType $classifiedAdStreetCount = null, \LewisLarsen\Ebay\StructType\ClassifiedAdCompanyNameEnabledDefinitionType $classifiedAdCompanyNameEnabled = null, \LewisLarsen\Ebay\StructType\SpecialitySubscriptionDefinitionType $specialitySubscription = null, \LewisLarsen\Ebay\StructType\RegularSubscriptionDefinitionType $regularSubscription = null, \LewisLarsen\Ebay\StructType\PremiumSubscriptionDefinitionType $premiumSubscription = null, \LewisLarsen\Ebay\StructType\NonSubscriptionDefinitionType $nonSubscription = null, \LewisLarsen\Ebay\StructType\ReturnPolicyEnabledDefinitionType $returnPolicyEnabled = null, \LewisLarsen\Ebay\StructType\HandlingTimeEnabledDefinitionType $handlingTimeEnabled = null, \LewisLarsen\Ebay\StructType\PayPalRequiredForStoreOwnerDefinitionType $payPalRequiredForStoreOwner = null, \LewisLarsen\Ebay\StructType\ReviseQuantityAllowedDefinitionType $reviseQuantityAllowed = null, \LewisLarsen\Ebay\StructType\RevisePriceAllowedDefinitionType $revisePriceAllowed = null, \LewisLarsen\Ebay\StructType\StoreOwnerExtendedListingDurationsEnabledDefinitionType $storeOwnerExtendedListingDurationsEnabled = null, \LewisLarsen\Ebay\StructType\StoreOwnerExtendedListingDurationsDefinitionType $storeOwnerExtendedListingDurations = null, \LewisLarsen\Ebay\StructType\PaymentMethodDefinitionType $paymentMethod = null, \LewisLarsen\Ebay\StructType\Group1MaxFlatShippingCostDefinitionType $group1MaxFlatShippingCost = null, \LewisLarsen\Ebay\StructType\Group2MaxFlatShippingCostDefinitionType $group2MaxFlatShippingCost = null, \LewisLarsen\Ebay\StructType\Group3MaxFlatShippingCostDefinitionType $group3MaxFlatShippingCost = null, \LewisLarsen\Ebay\StructType\MaxFlatShippingCostCBTExemptDefinitionType $maxFlatShippingCostCBTExempt = null, \LewisLarsen\Ebay\StructType\MaxFlatShippingCostDefinitionType $maxFlatShippingCost = null, \LewisLarsen\Ebay\StructType\VariationsEnabledDefinitionType $variationsEnabled = null, \LewisLarsen\Ebay\StructType\AttributeConversionEnabledFeatureDefinitionType $attributeConversionEnabled = null, \LewisLarsen\Ebay\StructType\FreeGalleryPlusEnabledDefinitionType $freeGalleryPlusEnabled = null, \LewisLarsen\Ebay\StructType\FreePicturePackEnabledDefinitionType $freePicturePackEnabled = null, \LewisLarsen\Ebay\StructType\ItemCompatibilityEnabledDefinitionType $itemCompatibilityEnabled = null, \LewisLarsen\Ebay\StructType\MaxItemCompatibilityDefinitionType $maxItemCompatibility = null, \LewisLarsen\Ebay\StructType\MinItemCompatibilityDefinitionType $minItemCompatibility = null, \LewisLarsen\Ebay\StructType\ConditionEnabledDefinitionType $conditionEnabled = null, \LewisLarsen\Ebay\StructType\ConditionValuesDefinitionType $conditionValues = null, \LewisLarsen\Ebay\StructType\ValueCategoryDefinitionType $valueCategory = null, \LewisLarsen\Ebay\StructType\ProductCreationEnabledDefinitionType $productCreationEnabled = null, \LewisLarsen\Ebay\StructType\EANEnabledDefinitionType $eANEnabled = null, \LewisLarsen\Ebay\StructType\ISBNEnabledDefinitionType $iSBNEnabled = null, \LewisLarsen\Ebay\StructType\UPCEnabledDefinitionType $uPCEnabled = null, \LewisLarsen\Ebay\StructType\CompatibleVehicleTypeDefinitionType $compatibleVehicleType = null, \LewisLarsen\Ebay\StructType\MaxGranularFitmentCountDefinitionType $maxGranularFitmentCount = null, \LewisLarsen\Ebay\StructType\PaymentOptionsGroupEnabledDefinitionType $paymentOptionsGroup = null, \LewisLarsen\Ebay\StructType\ProfileCategoryGroupDefinitionType $shippingProfileCategoryGroup = null, \LewisLarsen\Ebay\StructType\ProfileCategoryGroupDefinitionType $paymentProfileCategoryGroup = null, \LewisLarsen\Ebay\StructType\ProfileCategoryGroupDefinitionType $returnPolicyProfileCategoryGroup = null, \LewisLarsen\Ebay\StructType\VINSupportedDefinitionType $vINSupported = null, \LewisLarsen\Ebay\StructType\VRMSupportedDefinitionType $vRMSupported = null, \LewisLarsen\Ebay\StructType\SellerProvidedTitleSupportedDefinitionType $sellerProvidedTitleSupported = null, \LewisLarsen\Ebay\StructType\DepositSupportedDefinitionType $depositSupported = null, \LewisLarsen\Ebay\StructType\GlobalShippingEnabledDefinitionType $globalShippingEnabled = null, \LewisLarsen\Ebay\StructType\AdditionalCompatibilityEnabledDefinitionType $additionalCompatibilityEnabled = null, \DOMDocument $any = null, \LewisLarsen\Ebay\StructType\PickupDropOffEnabledDefinitionType $pickupDropOffEnabled = null, \LewisLarsen\Ebay\StructType\DigitalGoodDeliveryEnabledDefinitionType $digitalGoodDeliveryEnabled = null, \LewisLarsen\Ebay\StructType\EpidSupportedDefinitionType $epidSupported = null, \LewisLarsen\Ebay\StructType\KTypeSupportedDefinitionType $kTypeSupported = null, \LewisLarsen\Ebay\StructType\ProductRequiredEnabledDefinitionType $productRequiredEnabled = null, \LewisLarsen\Ebay\StructType\DomesticReturnsAcceptedDefinitionType $domesticReturnsAcceptedValues = null, \LewisLarsen\Ebay\StructType\InternationalReturnsAcceptedDefinitionType $internationalReturnsAcceptedValues = null, \LewisLarsen\Ebay\StructType\DomesticReturnsDurationDefinitionType $domesticReturnsDurationValues = null, \LewisLarsen\Ebay\StructType\InternationalReturnsDurationDefinitionType $internationalReturnsDurationValues = null, \LewisLarsen\Ebay\StructType\DomesticReturnsShipmentPayeeDefinitionType $domesticReturnsShipmentPayeeValues = null, \LewisLarsen\Ebay\StructType\InternationalReturnsShipmentPayeeDefinitionType $internationalReturnsShipmentPayeeValues = null, \LewisLarsen\Ebay\StructType\DomesticRefundMethodCodeType $domesticRefundMethodValues = null, \LewisLarsen\Ebay\StructType\InternationalRefundMethodCodeType $internationalRefundMethodValues = null, \LewisLarsen\Ebay\StructType\ReturnPolicyDescriptionEnabledDefinitionType $returnPolicyDescriptionEnabled = null)
    {
        $this
            ->setListingDurations($listingDurations)
            ->setShippingTermsRequired($shippingTermsRequired)
            ->setBestOfferEnabled($bestOfferEnabled)
            ->setDutchBINEnabled($dutchBINEnabled)
            ->setUserConsentRequired($userConsentRequired)
            ->setHomePageFeaturedEnabled($homePageFeaturedEnabled)
            ->setProPackEnabled($proPackEnabled)
            ->setBasicUpgradePackEnabled($basicUpgradePackEnabled)
            ->setValuePackEnabled($valuePackEnabled)
            ->setProPackPlusEnabled($proPackPlusEnabled)
            ->setAdFormatEnabled($adFormatEnabled)
            ->setBestOfferCounterEnabled($bestOfferCounterEnabled)
            ->setBestOfferAutoDeclineEnabled($bestOfferAutoDeclineEnabled)
            ->setLocalMarketSpecialitySubscription($localMarketSpecialitySubscription)
            ->setLocalMarketRegularSubscription($localMarketRegularSubscription)
            ->setLocalMarketPremiumSubscription($localMarketPremiumSubscription)
            ->setLocalMarketNonSubscription($localMarketNonSubscription)
            ->setExpressEnabled($expressEnabled)
            ->setExpressPicturesRequired($expressPicturesRequired)
            ->setExpressConditionRequired($expressConditionRequired)
            ->setMinimumReservePrice($minimumReservePrice)
            ->setTransactionConfirmationRequestEnabled($transactionConfirmationRequestEnabled)
            ->setSellerContactDetailsEnabled($sellerContactDetailsEnabled)
            ->setStoreInventoryEnabled($storeInventoryEnabled)
            ->setSkypeMeTransactionalEnabled($skypeMeTransactionalEnabled)
            ->setSkypeMeNonTransactionalEnabled($skypeMeNonTransactionalEnabled)
            ->setLocalListingDistancesRegular($localListingDistancesRegular)
            ->setLocalListingDistancesSpecialty($localListingDistancesSpecialty)
            ->setLocalListingDistancesNonSubscription($localListingDistancesNonSubscription)
            ->setClassifiedAdPaymentMethodEnabled($classifiedAdPaymentMethodEnabled)
            ->setClassifiedAdShippingMethodEnabled($classifiedAdShippingMethodEnabled)
            ->setClassifiedAdBestOfferEnabled($classifiedAdBestOfferEnabled)
            ->setClassifiedAdCounterOfferEnabled($classifiedAdCounterOfferEnabled)
            ->setClassifiedAdAutoDeclineEnabled($classifiedAdAutoDeclineEnabled)
            ->setClassifiedAdContactByPhoneEnabled($classifiedAdContactByPhoneEnabled)
            ->setClassifiedAdContactByEmailEnabled($classifiedAdContactByEmailEnabled)
            ->setSafePaymentRequired($safePaymentRequired)
            ->setClassifiedAdPayPerLeadEnabled($classifiedAdPayPerLeadEnabled)
            ->setItemSpecificsEnabled($itemSpecificsEnabled)
            ->setPaisaPayFullEscrowEnabled($paisaPayFullEscrowEnabled)
            ->setISBNIdentifierEnabled($iSBNIdentifierEnabled)
            ->setUPCIdentifierEnabled($uPCIdentifierEnabled)
            ->setEANIdentifierEnabled($eANIdentifierEnabled)
            ->setBrandMPNIdentifierEnabled($brandMPNIdentifierEnabled)
            ->setBestOfferAutoAcceptEnabled($bestOfferAutoAcceptEnabled)
            ->setClassifiedAdAutoAcceptEnabled($classifiedAdAutoAcceptEnabled)
            ->setCrossBorderTradeNorthAmericaEnabled($crossBorderTradeNorthAmericaEnabled)
            ->setCrossBorderTradeGBEnabled($crossBorderTradeGBEnabled)
            ->setCrossBorderTradeAustraliaEnabled($crossBorderTradeAustraliaEnabled)
            ->setPayPalBuyerProtectionEnabled($payPalBuyerProtectionEnabled)
            ->setBuyerGuaranteeEnabled($buyerGuaranteeEnabled)
            ->setCombinedFixedPriceTreatmentEnabled($combinedFixedPriceTreatmentEnabled)
            ->setGalleryFeaturedDurations($galleryFeaturedDurations)
            ->setINEscrowWorkflowTimeline($iNEscrowWorkflowTimeline)
            ->setPayPalRequired($payPalRequired)
            ->setEBayMotorsProAdFormatEnabled($eBayMotorsProAdFormatEnabled)
            ->setEBayMotorsProContactByPhoneEnabled($eBayMotorsProContactByPhoneEnabled)
            ->setEBayMotorsProPhoneCount($eBayMotorsProPhoneCount)
            ->setEBayMotorsProContactByAddressEnabled($eBayMotorsProContactByAddressEnabled)
            ->setEBayMotorsProStreetCount($eBayMotorsProStreetCount)
            ->setEBayMotorsProCompanyNameEnabled($eBayMotorsProCompanyNameEnabled)
            ->setEBayMotorsProContactByEmailEnabled($eBayMotorsProContactByEmailEnabled)
            ->setEBayMotorsProBestOfferEnabled($eBayMotorsProBestOfferEnabled)
            ->setEBayMotorsProAutoAcceptEnabled($eBayMotorsProAutoAcceptEnabled)
            ->setEBayMotorsProAutoDeclineEnabled($eBayMotorsProAutoDeclineEnabled)
            ->setEBayMotorsProPaymentMethodCheckOutEnabled($eBayMotorsProPaymentMethodCheckOutEnabled)
            ->setEBayMotorsProShippingMethodEnabled($eBayMotorsProShippingMethodEnabled)
            ->setEBayMotorsProCounterOfferEnabled($eBayMotorsProCounterOfferEnabled)
            ->setEBayMotorsProSellerContactDetailsEnabled($eBayMotorsProSellerContactDetailsEnabled)
            ->setLocalMarketAdFormatEnabled($localMarketAdFormatEnabled)
            ->setLocalMarketContactByPhoneEnabled($localMarketContactByPhoneEnabled)
            ->setLocalMarketPhoneCount($localMarketPhoneCount)
            ->setLocalMarketContactByAddressEnabled($localMarketContactByAddressEnabled)
            ->setLocalMarketStreetCount($localMarketStreetCount)
            ->setLocalMarketCompanyNameEnabled($localMarketCompanyNameEnabled)
            ->setLocalMarketContactByEmailEnabled($localMarketContactByEmailEnabled)
            ->setLocalMarketBestOfferEnabled($localMarketBestOfferEnabled)
            ->setLocalMarketAutoAcceptEnabled($localMarketAutoAcceptEnabled)
            ->setLocalMarketAutoDeclineEnabled($localMarketAutoDeclineEnabled)
            ->setLocalMarketPaymentMethodCheckOutEnabled($localMarketPaymentMethodCheckOutEnabled)
            ->setLocalMarketShippingMethodEnabled($localMarketShippingMethodEnabled)
            ->setLocalMarketCounterOfferEnabled($localMarketCounterOfferEnabled)
            ->setLocalMarketSellerContactDetailsEnabled($localMarketSellerContactDetailsEnabled)
            ->setClassifiedAdPhoneCount($classifiedAdPhoneCount)
            ->setClassifiedAdContactByAddressEnabled($classifiedAdContactByAddressEnabled)
            ->setClassifiedAdStreetCount($classifiedAdStreetCount)
            ->setClassifiedAdCompanyNameEnabled($classifiedAdCompanyNameEnabled)
            ->setSpecialitySubscription($specialitySubscription)
            ->setRegularSubscription($regularSubscription)
            ->setPremiumSubscription($premiumSubscription)
            ->setNonSubscription($nonSubscription)
            ->setReturnPolicyEnabled($returnPolicyEnabled)
            ->setHandlingTimeEnabled($handlingTimeEnabled)
            ->setPayPalRequiredForStoreOwner($payPalRequiredForStoreOwner)
            ->setReviseQuantityAllowed($reviseQuantityAllowed)
            ->setRevisePriceAllowed($revisePriceAllowed)
            ->setStoreOwnerExtendedListingDurationsEnabled($storeOwnerExtendedListingDurationsEnabled)
            ->setStoreOwnerExtendedListingDurations($storeOwnerExtendedListingDurations)
            ->setPaymentMethod($paymentMethod)
            ->setGroup1MaxFlatShippingCost($group1MaxFlatShippingCost)
            ->setGroup2MaxFlatShippingCost($group2MaxFlatShippingCost)
            ->setGroup3MaxFlatShippingCost($group3MaxFlatShippingCost)
            ->setMaxFlatShippingCostCBTExempt($maxFlatShippingCostCBTExempt)
            ->setMaxFlatShippingCost($maxFlatShippingCost)
            ->setVariationsEnabled($variationsEnabled)
            ->setAttributeConversionEnabled($attributeConversionEnabled)
            ->setFreeGalleryPlusEnabled($freeGalleryPlusEnabled)
            ->setFreePicturePackEnabled($freePicturePackEnabled)
            ->setItemCompatibilityEnabled($itemCompatibilityEnabled)
            ->setMaxItemCompatibility($maxItemCompatibility)
            ->setMinItemCompatibility($minItemCompatibility)
            ->setConditionEnabled($conditionEnabled)
            ->setConditionValues($conditionValues)
            ->setValueCategory($valueCategory)
            ->setProductCreationEnabled($productCreationEnabled)
            ->setEANEnabled($eANEnabled)
            ->setISBNEnabled($iSBNEnabled)
            ->setUPCEnabled($uPCEnabled)
            ->setCompatibleVehicleType($compatibleVehicleType)
            ->setMaxGranularFitmentCount($maxGranularFitmentCount)
            ->setPaymentOptionsGroup($paymentOptionsGroup)
            ->setShippingProfileCategoryGroup($shippingProfileCategoryGroup)
            ->setPaymentProfileCategoryGroup($paymentProfileCategoryGroup)
            ->setReturnPolicyProfileCategoryGroup($returnPolicyProfileCategoryGroup)
            ->setVINSupported($vINSupported)
            ->setVRMSupported($vRMSupported)
            ->setSellerProvidedTitleSupported($sellerProvidedTitleSupported)
            ->setDepositSupported($depositSupported)
            ->setGlobalShippingEnabled($globalShippingEnabled)
            ->setAdditionalCompatibilityEnabled($additionalCompatibilityEnabled)
            ->setAny($any)
            ->setPickupDropOffEnabled($pickupDropOffEnabled)
            ->setDigitalGoodDeliveryEnabled($digitalGoodDeliveryEnabled)
            ->setEpidSupported($epidSupported)
            ->setKTypeSupported($kTypeSupported)
            ->setProductRequiredEnabled($productRequiredEnabled)
            ->setDomesticReturnsAcceptedValues($domesticReturnsAcceptedValues)
            ->setInternationalReturnsAcceptedValues($internationalReturnsAcceptedValues)
            ->setDomesticReturnsDurationValues($domesticReturnsDurationValues)
            ->setInternationalReturnsDurationValues($internationalReturnsDurationValues)
            ->setDomesticReturnsShipmentPayeeValues($domesticReturnsShipmentPayeeValues)
            ->setInternationalReturnsShipmentPayeeValues($internationalReturnsShipmentPayeeValues)
            ->setDomesticRefundMethodValues($domesticRefundMethodValues)
            ->setInternationalRefundMethodValues($internationalRefundMethodValues)
            ->setReturnPolicyDescriptionEnabled($returnPolicyDescriptionEnabled);
    }
    /**
     * Get ListingDurations value
     * @return \LewisLarsen\Ebay\StructType\ListingDurationDefinitionsType|null
     */
    public function getListingDurations()
    {
        return $this->ListingDurations;
    }
    /**
     * Set ListingDurations value
     * @param \LewisLarsen\Ebay\StructType\ListingDurationDefinitionsType $listingDurations
     * @return \LewisLarsen\Ebay\StructType\FeatureDefinitionsType
     */
    public function setListingDurations(\LewisLarsen\Ebay\StructType\ListingDurationDefinitionsType $listingDurations = null)
    {
        $this->ListingDurations = $listingDurations;
        return $this;
    }
    /**
     * Get ShippingTermsRequired value
     * @return \LewisLarsen\Ebay\StructType\ShippingTermRequiredDefinitionType|null
     */
    public function getShippingTermsRequired()
    {
        return $this->ShippingTermsRequired;
    }
    /**
     * Set ShippingTermsRequired value
     * @param \LewisLarsen\Ebay\StructType\ShippingTermRequiredDefinitionType $shippingTermsRequired
     * @return \LewisLarsen\Ebay\StructType\FeatureDefinitionsType
     */
    public function setShippingTermsRequired(\LewisLarsen\Ebay\StructType\ShippingTermRequiredDefinitionType $shippingTermsRequired = null)
    {
        $this->ShippingTermsRequired = $shippingTermsRequired;
        return $this;
    }
    /**
     * Get BestOfferEnabled value
     * @return \LewisLarsen\Ebay\StructType\BestOfferEnabledDefinitionType|null
     */
    public function getBestOfferEnabled()
    {
        return $this->BestOfferEnabled;
    }
    /**
     * Set BestOfferEnabled value
     * @param \LewisLarsen\Ebay\StructType\BestOfferEnabledDefinitionType $bestOfferEnabled
     * @return \LewisLarsen\Ebay\StructType\FeatureDefinitionsType
     */
    public function setBestOfferEnabled(\LewisLarsen\Ebay\StructType\BestOfferEnabledDefinitionType $bestOfferEnabled = null)
    {
        $this->BestOfferEnabled = $bestOfferEnabled;
        return $this;
    }
    /**
     * Get DutchBINEnabled value
     * @return \LewisLarsen\Ebay\StructType\DutchBINEnabledDefinitionType|null
     */
    public function getDutchBINEnabled()
    {
        return $this->DutchBINEnabled;
    }
    /**
     * Set DutchBINEnabled value
     * @param \LewisLarsen\Ebay\StructType\DutchBINEnabledDefinitionType $dutchBINEnabled
     * @return \LewisLarsen\Ebay\StructType\FeatureDefinitionsType
     */
    public function setDutchBINEnabled(\LewisLarsen\Ebay\StructType\DutchBINEnabledDefinitionType $dutchBINEnabled = null)
    {
        $this->DutchBINEnabled = $dutchBINEnabled;
        return $this;
    }
    /**
     * Get UserConsentRequired value
     * @return \LewisLarsen\Ebay\StructType\UserConsentRequiredDefinitionType|null
     */
    public function getUserConsentRequired()
    {
        return $this->UserConsentRequired;
    }
    /**
     * Set UserConsentRequired value
     * @param \LewisLarsen\Ebay\StructType\UserConsentRequiredDefinitionType $userConsentRequired
     * @return \LewisLarsen\Ebay\StructType\FeatureDefinitionsType
     */
    public function setUserConsentRequired(\LewisLarsen\Ebay\StructType\UserConsentRequiredDefinitionType $userConsentRequired = null)
    {
        $this->UserConsentRequired = $userConsentRequired;
        return $this;
    }
    /**
     * Get HomePageFeaturedEnabled value
     * @return \LewisLarsen\Ebay\StructType\HomePageFeaturedEnabledDefinitionType|null
     */
    public function getHomePageFeaturedEnabled()
    {
        return $this->HomePageFeaturedEnabled;
    }
    /**
     * Set HomePageFeaturedEnabled value
     * @param \LewisLarsen\Ebay\StructType\HomePageFeaturedEnabledDefinitionType $homePageFeaturedEnabled
     * @return \LewisLarsen\Ebay\StructType\FeatureDefinitionsType
     */
    public function setHomePageFeaturedEnabled(\LewisLarsen\Ebay\StructType\HomePageFeaturedEnabledDefinitionType $homePageFeaturedEnabled = null)
    {
        $this->HomePageFeaturedEnabled = $homePageFeaturedEnabled;
        return $this;
    }
    /**
     * Get ProPackEnabled value
     * @return \LewisLarsen\Ebay\StructType\ProPackEnabledDefinitionType|null
     */
    public function getProPackEnabled()
    {
        return $this->ProPackEnabled;
    }
    /**
     * Set ProPackEnabled value
     * @param \LewisLarsen\Ebay\StructType\ProPackEnabledDefinitionType $proPackEnabled
     * @return \LewisLarsen\Ebay\StructType\FeatureDefinitionsType
     */
    public function setProPackEnabled(\LewisLarsen\Ebay\StructType\ProPackEnabledDefinitionType $proPackEnabled = null)
    {
        $this->ProPackEnabled = $proPackEnabled;
        return $this;
    }
    /**
     * Get BasicUpgradePackEnabled value
     * @return \LewisLarsen\Ebay\StructType\BasicUpgradePackEnabledDefinitionType|null
     */
    public function getBasicUpgradePackEnabled()
    {
        return $this->BasicUpgradePackEnabled;
    }
    /**
     * Set BasicUpgradePackEnabled value
     * @param \LewisLarsen\Ebay\StructType\BasicUpgradePackEnabledDefinitionType $basicUpgradePackEnabled
     * @return \LewisLarsen\Ebay\StructType\FeatureDefinitionsType
     */
    public function setBasicUpgradePackEnabled(\LewisLarsen\Ebay\StructType\BasicUpgradePackEnabledDefinitionType $basicUpgradePackEnabled = null)
    {
        $this->BasicUpgradePackEnabled = $basicUpgradePackEnabled;
        return $this;
    }
    /**
     * Get ValuePackEnabled value
     * @return \LewisLarsen\Ebay\StructType\ValuePackEnabledDefinitionType|null
     */
    public function getValuePackEnabled()
    {
        return $this->ValuePackEnabled;
    }
    /**
     * Set ValuePackEnabled value
     * @param \LewisLarsen\Ebay\StructType\ValuePackEnabledDefinitionType $valuePackEnabled
     * @return \LewisLarsen\Ebay\StructType\FeatureDefinitionsType
     */
    public function setValuePackEnabled(\LewisLarsen\Ebay\StructType\ValuePackEnabledDefinitionType $valuePackEnabled = null)
    {
        $this->ValuePackEnabled = $valuePackEnabled;
        return $this;
    }
    /**
     * Get ProPackPlusEnabled value
     * @return \LewisLarsen\Ebay\StructType\ProPackPlusEnabledDefinitionType|null
     */
    public function getProPackPlusEnabled()
    {
        return $this->ProPackPlusEnabled;
    }
    /**
     * Set ProPackPlusEnabled value
     * @param \LewisLarsen\Ebay\StructType\ProPackPlusEnabledDefinitionType $proPackPlusEnabled
     * @return \LewisLarsen\Ebay\StructType\FeatureDefinitionsType
     */
    public function setProPackPlusEnabled(\LewisLarsen\Ebay\StructType\ProPackPlusEnabledDefinitionType $proPackPlusEnabled = null)
    {
        $this->ProPackPlusEnabled = $proPackPlusEnabled;
        return $this;
    }
    /**
     * Get AdFormatEnabled value
     * @return \LewisLarsen\Ebay\StructType\AdFormatEnabledDefinitionType|null
     */
    public function getAdFormatEnabled()
    {
        return $this->AdFormatEnabled;
    }
    /**
     * Set AdFormatEnabled value
     * @param \LewisLarsen\Ebay\StructType\AdFormatEnabledDefinitionType $adFormatEnabled
     * @return \LewisLarsen\Ebay\StructType\FeatureDefinitionsType
     */
    public function setAdFormatEnabled(\LewisLarsen\Ebay\StructType\AdFormatEnabledDefinitionType $adFormatEnabled = null)
    {
        $this->AdFormatEnabled = $adFormatEnabled;
        return $this;
    }
    /**
     * Get BestOfferCounterEnabled value
     * @return \LewisLarsen\Ebay\StructType\BestOfferCounterEnabledDefinitionType|null
     */
    public function getBestOfferCounterEnabled()
    {
        return $this->BestOfferCounterEnabled;
    }
    /**
     * Set BestOfferCounterEnabled value
     * @param \LewisLarsen\Ebay\StructType\BestOfferCounterEnabledDefinitionType $bestOfferCounterEnabled
     * @return \LewisLarsen\Ebay\StructType\FeatureDefinitionsType
     */
    public function setBestOfferCounterEnabled(\LewisLarsen\Ebay\StructType\BestOfferCounterEnabledDefinitionType $bestOfferCounterEnabled = null)
    {
        $this->BestOfferCounterEnabled = $bestOfferCounterEnabled;
        return $this;
    }
    /**
     * Get BestOfferAutoDeclineEnabled value
     * @return \LewisLarsen\Ebay\StructType\BestOfferAutoDeclineEnabledDefinitionType|null
     */
    public function getBestOfferAutoDeclineEnabled()
    {
        return $this->BestOfferAutoDeclineEnabled;
    }
    /**
     * Set BestOfferAutoDeclineEnabled value
     * @param \LewisLarsen\Ebay\StructType\BestOfferAutoDeclineEnabledDefinitionType $bestOfferAutoDeclineEnabled
     * @return \LewisLarsen\Ebay\StructType\FeatureDefinitionsType
     */
    public function setBestOfferAutoDeclineEnabled(\LewisLarsen\Ebay\StructType\BestOfferAutoDeclineEnabledDefinitionType $bestOfferAutoDeclineEnabled = null)
    {
        $this->BestOfferAutoDeclineEnabled = $bestOfferAutoDeclineEnabled;
        return $this;
    }
    /**
     * Get LocalMarketSpecialitySubscription value
     * @return \LewisLarsen\Ebay\StructType\LocalMarketSpecialitySubscriptionDefinitionType|null
     */
    public function getLocalMarketSpecialitySubscription()
    {
        return $this->LocalMarketSpecialitySubscription;
    }
    /**
     * Set LocalMarketSpecialitySubscription value
     * @param \LewisLarsen\Ebay\StructType\LocalMarketSpecialitySubscriptionDefinitionType $localMarketSpecialitySubscription
     * @return \LewisLarsen\Ebay\StructType\FeatureDefinitionsType
     */
    public function setLocalMarketSpecialitySubscription(\LewisLarsen\Ebay\StructType\LocalMarketSpecialitySubscriptionDefinitionType $localMarketSpecialitySubscription = null)
    {
        $this->LocalMarketSpecialitySubscription = $localMarketSpecialitySubscription;
        return $this;
    }
    /**
     * Get LocalMarketRegularSubscription value
     * @return \LewisLarsen\Ebay\StructType\LocalMarketRegularSubscriptionDefinitionType|null
     */
    public function getLocalMarketRegularSubscription()
    {
        return $this->LocalMarketRegularSubscription;
    }
    /**
     * Set LocalMarketRegularSubscription value
     * @param \LewisLarsen\Ebay\StructType\LocalMarketRegularSubscriptionDefinitionType $localMarketRegularSubscription
     * @return \LewisLarsen\Ebay\StructType\FeatureDefinitionsType
     */
    public function setLocalMarketRegularSubscription(\LewisLarsen\Ebay\StructType\LocalMarketRegularSubscriptionDefinitionType $localMarketRegularSubscription = null)
    {
        $this->LocalMarketRegularSubscription = $localMarketRegularSubscription;
        return $this;
    }
    /**
     * Get LocalMarketPremiumSubscription value
     * @return \LewisLarsen\Ebay\StructType\LocalMarketPremiumSubscriptionDefinitionType|null
     */
    public function getLocalMarketPremiumSubscription()
    {
        return $this->LocalMarketPremiumSubscription;
    }
    /**
     * Set LocalMarketPremiumSubscription value
     * @param \LewisLarsen\Ebay\StructType\LocalMarketPremiumSubscriptionDefinitionType $localMarketPremiumSubscription
     * @return \LewisLarsen\Ebay\StructType\FeatureDefinitionsType
     */
    public function setLocalMarketPremiumSubscription(\LewisLarsen\Ebay\StructType\LocalMarketPremiumSubscriptionDefinitionType $localMarketPremiumSubscription = null)
    {
        $this->LocalMarketPremiumSubscription = $localMarketPremiumSubscription;
        return $this;
    }
    /**
     * Get LocalMarketNonSubscription value
     * @return \LewisLarsen\Ebay\StructType\LocalMarketNonSubscriptionDefinitionType|null
     */
    public function getLocalMarketNonSubscription()
    {
        return $this->LocalMarketNonSubscription;
    }
    /**
     * Set LocalMarketNonSubscription value
     * @param \LewisLarsen\Ebay\StructType\LocalMarketNonSubscriptionDefinitionType $localMarketNonSubscription
     * @return \LewisLarsen\Ebay\StructType\FeatureDefinitionsType
     */
    public function setLocalMarketNonSubscription(\LewisLarsen\Ebay\StructType\LocalMarketNonSubscriptionDefinitionType $localMarketNonSubscription = null)
    {
        $this->LocalMarketNonSubscription = $localMarketNonSubscription;
        return $this;
    }
    /**
     * Get ExpressEnabled value
     * @return \LewisLarsen\Ebay\StructType\ExpressEnabledDefinitionType|null
     */
    public function getExpressEnabled()
    {
        return $this->ExpressEnabled;
    }
    /**
     * Set ExpressEnabled value
     * @param \LewisLarsen\Ebay\StructType\ExpressEnabledDefinitionType $expressEnabled
     * @return \LewisLarsen\Ebay\StructType\FeatureDefinitionsType
     */
    public function setExpressEnabled(\LewisLarsen\Ebay\StructType\ExpressEnabledDefinitionType $expressEnabled = null)
    {
        $this->ExpressEnabled = $expressEnabled;
        return $this;
    }
    /**
     * Get ExpressPicturesRequired value
     * @return \LewisLarsen\Ebay\StructType\ExpressPicturesRequiredDefinitionType|null
     */
    public function getExpressPicturesRequired()
    {
        return $this->ExpressPicturesRequired;
    }
    /**
     * Set ExpressPicturesRequired value
     * @param \LewisLarsen\Ebay\StructType\ExpressPicturesRequiredDefinitionType $expressPicturesRequired
     * @return \LewisLarsen\Ebay\StructType\FeatureDefinitionsType
     */
    public function setExpressPicturesRequired(\LewisLarsen\Ebay\StructType\ExpressPicturesRequiredDefinitionType $expressPicturesRequired = null)
    {
        $this->ExpressPicturesRequired = $expressPicturesRequired;
        return $this;
    }
    /**
     * Get ExpressConditionRequired value
     * @return \LewisLarsen\Ebay\StructType\ExpressConditionRequiredDefinitionType|null
     */
    public function getExpressConditionRequired()
    {
        return $this->ExpressConditionRequired;
    }
    /**
     * Set ExpressConditionRequired value
     * @param \LewisLarsen\Ebay\StructType\ExpressConditionRequiredDefinitionType $expressConditionRequired
     * @return \LewisLarsen\Ebay\StructType\FeatureDefinitionsType
     */
    public function setExpressConditionRequired(\LewisLarsen\Ebay\StructType\ExpressConditionRequiredDefinitionType $expressConditionRequired = null)
    {
        $this->ExpressConditionRequired = $expressConditionRequired;
        return $this;
    }
    /**
     * Get MinimumReservePrice value
     * @return \LewisLarsen\Ebay\StructType\MinimumReservePriceDefinitionType|null
     */
    public function getMinimumReservePrice()
    {
        return $this->MinimumReservePrice;
    }
    /**
     * Set MinimumReservePrice value
     * @param \LewisLarsen\Ebay\StructType\MinimumReservePriceDefinitionType $minimumReservePrice
     * @return \LewisLarsen\Ebay\StructType\FeatureDefinitionsType
     */
    public function setMinimumReservePrice(\LewisLarsen\Ebay\StructType\MinimumReservePriceDefinitionType $minimumReservePrice = null)
    {
        $this->MinimumReservePrice = $minimumReservePrice;
        return $this;
    }
    /**
     * Get TransactionConfirmationRequestEnabled value
     * @return \LewisLarsen\Ebay\StructType\TCREnabledDefinitionType|null
     */
    public function getTransactionConfirmationRequestEnabled()
    {
        return $this->TransactionConfirmationRequestEnabled;
    }
    /**
     * Set TransactionConfirmationRequestEnabled value
     * @param \LewisLarsen\Ebay\StructType\TCREnabledDefinitionType $transactionConfirmationRequestEnabled
     * @return \LewisLarsen\Ebay\StructType\FeatureDefinitionsType
     */
    public function setTransactionConfirmationRequestEnabled(\LewisLarsen\Ebay\StructType\TCREnabledDefinitionType $transactionConfirmationRequestEnabled = null)
    {
        $this->TransactionConfirmationRequestEnabled = $transactionConfirmationRequestEnabled;
        return $this;
    }
    /**
     * Get SellerContactDetailsEnabled value
     * @return \LewisLarsen\Ebay\StructType\SellerContactDetailsEnabledDefinitionType|null
     */
    public function getSellerContactDetailsEnabled()
    {
        return $this->SellerContactDetailsEnabled;
    }
    /**
     * Set SellerContactDetailsEnabled value
     * @param \LewisLarsen\Ebay\StructType\SellerContactDetailsEnabledDefinitionType $sellerContactDetailsEnabled
     * @return \LewisLarsen\Ebay\StructType\FeatureDefinitionsType
     */
    public function setSellerContactDetailsEnabled(\LewisLarsen\Ebay\StructType\SellerContactDetailsEnabledDefinitionType $sellerContactDetailsEnabled = null)
    {
        $this->SellerContactDetailsEnabled = $sellerContactDetailsEnabled;
        return $this;
    }
    /**
     * Get StoreInventoryEnabled value
     * @return \LewisLarsen\Ebay\StructType\StoreInventoryEnabledDefinitionType|null
     */
    public function getStoreInventoryEnabled()
    {
        return $this->StoreInventoryEnabled;
    }
    /**
     * Set StoreInventoryEnabled value
     * @param \LewisLarsen\Ebay\StructType\StoreInventoryEnabledDefinitionType $storeInventoryEnabled
     * @return \LewisLarsen\Ebay\StructType\FeatureDefinitionsType
     */
    public function setStoreInventoryEnabled(\LewisLarsen\Ebay\StructType\StoreInventoryEnabledDefinitionType $storeInventoryEnabled = null)
    {
        $this->StoreInventoryEnabled = $storeInventoryEnabled;
        return $this;
    }
    /**
     * Get SkypeMeTransactionalEnabled value
     * @return \LewisLarsen\Ebay\StructType\SkypeMeTransactionalEnabledDefinitionType|null
     */
    public function getSkypeMeTransactionalEnabled()
    {
        return $this->SkypeMeTransactionalEnabled;
    }
    /**
     * Set SkypeMeTransactionalEnabled value
     * @param \LewisLarsen\Ebay\StructType\SkypeMeTransactionalEnabledDefinitionType $skypeMeTransactionalEnabled
     * @return \LewisLarsen\Ebay\StructType\FeatureDefinitionsType
     */
    public function setSkypeMeTransactionalEnabled(\LewisLarsen\Ebay\StructType\SkypeMeTransactionalEnabledDefinitionType $skypeMeTransactionalEnabled = null)
    {
        $this->SkypeMeTransactionalEnabled = $skypeMeTransactionalEnabled;
        return $this;
    }
    /**
     * Get SkypeMeNonTransactionalEnabled value
     * @return \LewisLarsen\Ebay\StructType\SkypeMeNonTransactionalEnabledDefinitionType|null
     */
    public function getSkypeMeNonTransactionalEnabled()
    {
        return $this->SkypeMeNonTransactionalEnabled;
    }
    /**
     * Set SkypeMeNonTransactionalEnabled value
     * @param \LewisLarsen\Ebay\StructType\SkypeMeNonTransactionalEnabledDefinitionType $skypeMeNonTransactionalEnabled
     * @return \LewisLarsen\Ebay\StructType\FeatureDefinitionsType
     */
    public function setSkypeMeNonTransactionalEnabled(\LewisLarsen\Ebay\StructType\SkypeMeNonTransactionalEnabledDefinitionType $skypeMeNonTransactionalEnabled = null)
    {
        $this->SkypeMeNonTransactionalEnabled = $skypeMeNonTransactionalEnabled;
        return $this;
    }
    /**
     * Get LocalListingDistancesRegular value
     * @return \LewisLarsen\Ebay\StructType\LocalListingDistancesRegularDefinitionType|null
     */
    public function getLocalListingDistancesRegular()
    {
        return $this->LocalListingDistancesRegular;
    }
    /**
     * Set LocalListingDistancesRegular value
     * @param \LewisLarsen\Ebay\StructType\LocalListingDistancesRegularDefinitionType $localListingDistancesRegular
     * @return \LewisLarsen\Ebay\StructType\FeatureDefinitionsType
     */
    public function setLocalListingDistancesRegular(\LewisLarsen\Ebay\StructType\LocalListingDistancesRegularDefinitionType $localListingDistancesRegular = null)
    {
        $this->LocalListingDistancesRegular = $localListingDistancesRegular;
        return $this;
    }
    /**
     * Get LocalListingDistancesSpecialty value
     * @return \LewisLarsen\Ebay\StructType\LocalListingDistancesSpecialtyDefinitionType|null
     */
    public function getLocalListingDistancesSpecialty()
    {
        return $this->LocalListingDistancesSpecialty;
    }
    /**
     * Set LocalListingDistancesSpecialty value
     * @param \LewisLarsen\Ebay\StructType\LocalListingDistancesSpecialtyDefinitionType $localListingDistancesSpecialty
     * @return \LewisLarsen\Ebay\StructType\FeatureDefinitionsType
     */
    public function setLocalListingDistancesSpecialty(\LewisLarsen\Ebay\StructType\LocalListingDistancesSpecialtyDefinitionType $localListingDistancesSpecialty = null)
    {
        $this->LocalListingDistancesSpecialty = $localListingDistancesSpecialty;
        return $this;
    }
    /**
     * Get LocalListingDistancesNonSubscription value
     * @return \LewisLarsen\Ebay\StructType\LocalListingDistancesNonSubscriptionDefinitionType|null
     */
    public function getLocalListingDistancesNonSubscription()
    {
        return $this->LocalListingDistancesNonSubscription;
    }
    /**
     * Set LocalListingDistancesNonSubscription value
     * @param \LewisLarsen\Ebay\StructType\LocalListingDistancesNonSubscriptionDefinitionType $localListingDistancesNonSubscription
     * @return \LewisLarsen\Ebay\StructType\FeatureDefinitionsType
     */
    public function setLocalListingDistancesNonSubscription(\LewisLarsen\Ebay\StructType\LocalListingDistancesNonSubscriptionDefinitionType $localListingDistancesNonSubscription = null)
    {
        $this->LocalListingDistancesNonSubscription = $localListingDistancesNonSubscription;
        return $this;
    }
    /**
     * Get ClassifiedAdPaymentMethodEnabled value
     * @return \LewisLarsen\Ebay\StructType\ClassifiedAdPaymentMethodEnabledDefinitionType|null
     */
    public function getClassifiedAdPaymentMethodEnabled()
    {
        return $this->ClassifiedAdPaymentMethodEnabled;
    }
    /**
     * Set ClassifiedAdPaymentMethodEnabled value
     * @param \LewisLarsen\Ebay\StructType\ClassifiedAdPaymentMethodEnabledDefinitionType $classifiedAdPaymentMethodEnabled
     * @return \LewisLarsen\Ebay\StructType\FeatureDefinitionsType
     */
    public function setClassifiedAdPaymentMethodEnabled(\LewisLarsen\Ebay\StructType\ClassifiedAdPaymentMethodEnabledDefinitionType $classifiedAdPaymentMethodEnabled = null)
    {
        $this->ClassifiedAdPaymentMethodEnabled = $classifiedAdPaymentMethodEnabled;
        return $this;
    }
    /**
     * Get ClassifiedAdShippingMethodEnabled value
     * @return \LewisLarsen\Ebay\StructType\ClassifiedAdShippingMethodEnabledDefinitionType|null
     */
    public function getClassifiedAdShippingMethodEnabled()
    {
        return $this->ClassifiedAdShippingMethodEnabled;
    }
    /**
     * Set ClassifiedAdShippingMethodEnabled value
     * @param \LewisLarsen\Ebay\StructType\ClassifiedAdShippingMethodEnabledDefinitionType $classifiedAdShippingMethodEnabled
     * @return \LewisLarsen\Ebay\StructType\FeatureDefinitionsType
     */
    public function setClassifiedAdShippingMethodEnabled(\LewisLarsen\Ebay\StructType\ClassifiedAdShippingMethodEnabledDefinitionType $classifiedAdShippingMethodEnabled = null)
    {
        $this->ClassifiedAdShippingMethodEnabled = $classifiedAdShippingMethodEnabled;
        return $this;
    }
    /**
     * Get ClassifiedAdBestOfferEnabled value
     * @return \LewisLarsen\Ebay\StructType\ClassifiedAdBestOfferEnabledDefinitionType|null
     */
    public function getClassifiedAdBestOfferEnabled()
    {
        return $this->ClassifiedAdBestOfferEnabled;
    }
    /**
     * Set ClassifiedAdBestOfferEnabled value
     * @param \LewisLarsen\Ebay\StructType\ClassifiedAdBestOfferEnabledDefinitionType $classifiedAdBestOfferEnabled
     * @return \LewisLarsen\Ebay\StructType\FeatureDefinitionsType
     */
    public function setClassifiedAdBestOfferEnabled(\LewisLarsen\Ebay\StructType\ClassifiedAdBestOfferEnabledDefinitionType $classifiedAdBestOfferEnabled = null)
    {
        $this->ClassifiedAdBestOfferEnabled = $classifiedAdBestOfferEnabled;
        return $this;
    }
    /**
     * Get ClassifiedAdCounterOfferEnabled value
     * @return \LewisLarsen\Ebay\StructType\ClassifiedAdCounterOfferEnabledDefinitionType|null
     */
    public function getClassifiedAdCounterOfferEnabled()
    {
        return $this->ClassifiedAdCounterOfferEnabled;
    }
    /**
     * Set ClassifiedAdCounterOfferEnabled value
     * @param \LewisLarsen\Ebay\StructType\ClassifiedAdCounterOfferEnabledDefinitionType $classifiedAdCounterOfferEnabled
     * @return \LewisLarsen\Ebay\StructType\FeatureDefinitionsType
     */
    public function setClassifiedAdCounterOfferEnabled(\LewisLarsen\Ebay\StructType\ClassifiedAdCounterOfferEnabledDefinitionType $classifiedAdCounterOfferEnabled = null)
    {
        $this->ClassifiedAdCounterOfferEnabled = $classifiedAdCounterOfferEnabled;
        return $this;
    }
    /**
     * Get ClassifiedAdAutoDeclineEnabled value
     * @return \LewisLarsen\Ebay\StructType\ClassifiedAdAutoDeclineEnabledDefinitionType|null
     */
    public function getClassifiedAdAutoDeclineEnabled()
    {
        return $this->ClassifiedAdAutoDeclineEnabled;
    }
    /**
     * Set ClassifiedAdAutoDeclineEnabled value
     * @param \LewisLarsen\Ebay\StructType\ClassifiedAdAutoDeclineEnabledDefinitionType $classifiedAdAutoDeclineEnabled
     * @return \LewisLarsen\Ebay\StructType\FeatureDefinitionsType
     */
    public function setClassifiedAdAutoDeclineEnabled(\LewisLarsen\Ebay\StructType\ClassifiedAdAutoDeclineEnabledDefinitionType $classifiedAdAutoDeclineEnabled = null)
    {
        $this->ClassifiedAdAutoDeclineEnabled = $classifiedAdAutoDeclineEnabled;
        return $this;
    }
    /**
     * Get ClassifiedAdContactByPhoneEnabled value
     * @return \LewisLarsen\Ebay\StructType\ClassifiedAdContactByPhoneEnabledDefinitionType|null
     */
    public function getClassifiedAdContactByPhoneEnabled()
    {
        return $this->ClassifiedAdContactByPhoneEnabled;
    }
    /**
     * Set ClassifiedAdContactByPhoneEnabled value
     * @param \LewisLarsen\Ebay\StructType\ClassifiedAdContactByPhoneEnabledDefinitionType $classifiedAdContactByPhoneEnabled
     * @return \LewisLarsen\Ebay\StructType\FeatureDefinitionsType
     */
    public function setClassifiedAdContactByPhoneEnabled(\LewisLarsen\Ebay\StructType\ClassifiedAdContactByPhoneEnabledDefinitionType $classifiedAdContactByPhoneEnabled = null)
    {
        $this->ClassifiedAdContactByPhoneEnabled = $classifiedAdContactByPhoneEnabled;
        return $this;
    }
    /**
     * Get ClassifiedAdContactByEmailEnabled value
     * @return \LewisLarsen\Ebay\StructType\ClassifiedAdContactByEmailEnabledDefintionType|null
     */
    public function getClassifiedAdContactByEmailEnabled()
    {
        return $this->ClassifiedAdContactByEmailEnabled;
    }
    /**
     * Set ClassifiedAdContactByEmailEnabled value
     * @param \LewisLarsen\Ebay\StructType\ClassifiedAdContactByEmailEnabledDefintionType $classifiedAdContactByEmailEnabled
     * @return \LewisLarsen\Ebay\StructType\FeatureDefinitionsType
     */
    public function setClassifiedAdContactByEmailEnabled(\LewisLarsen\Ebay\StructType\ClassifiedAdContactByEmailEnabledDefintionType $classifiedAdContactByEmailEnabled = null)
    {
        $this->ClassifiedAdContactByEmailEnabled = $classifiedAdContactByEmailEnabled;
        return $this;
    }
    /**
     * Get SafePaymentRequired value
     * @return \LewisLarsen\Ebay\StructType\SafePaymentRequiredDefinitionType|null
     */
    public function getSafePaymentRequired()
    {
        return $this->SafePaymentRequired;
    }
    /**
     * Set SafePaymentRequired value
     * @param \LewisLarsen\Ebay\StructType\SafePaymentRequiredDefinitionType $safePaymentRequired
     * @return \LewisLarsen\Ebay\StructType\FeatureDefinitionsType
     */
    public function setSafePaymentRequired(\LewisLarsen\Ebay\StructType\SafePaymentRequiredDefinitionType $safePaymentRequired = null)
    {
        $this->SafePaymentRequired = $safePaymentRequired;
        return $this;
    }
    /**
     * Get ClassifiedAdPayPerLeadEnabled value
     * @return \LewisLarsen\Ebay\StructType\ClassifiedAdPayPerLeadEnabledDefinitionType|null
     */
    public function getClassifiedAdPayPerLeadEnabled()
    {
        return $this->ClassifiedAdPayPerLeadEnabled;
    }
    /**
     * Set ClassifiedAdPayPerLeadEnabled value
     * @param \LewisLarsen\Ebay\StructType\ClassifiedAdPayPerLeadEnabledDefinitionType $classifiedAdPayPerLeadEnabled
     * @return \LewisLarsen\Ebay\StructType\FeatureDefinitionsType
     */
    public function setClassifiedAdPayPerLeadEnabled(\LewisLarsen\Ebay\StructType\ClassifiedAdPayPerLeadEnabledDefinitionType $classifiedAdPayPerLeadEnabled = null)
    {
        $this->ClassifiedAdPayPerLeadEnabled = $classifiedAdPayPerLeadEnabled;
        return $this;
    }
    /**
     * Get ItemSpecificsEnabled value
     * @return \LewisLarsen\Ebay\StructType\ItemSpecificsEnabledDefinitionType|null
     */
    public function getItemSpecificsEnabled()
    {
        return $this->ItemSpecificsEnabled;
    }
    /**
     * Set ItemSpecificsEnabled value
     * @param \LewisLarsen\Ebay\StructType\ItemSpecificsEnabledDefinitionType $itemSpecificsEnabled
     * @return \LewisLarsen\Ebay\StructType\FeatureDefinitionsType
     */
    public function setItemSpecificsEnabled(\LewisLarsen\Ebay\StructType\ItemSpecificsEnabledDefinitionType $itemSpecificsEnabled = null)
    {
        $this->ItemSpecificsEnabled = $itemSpecificsEnabled;
        return $this;
    }
    /**
     * Get PaisaPayFullEscrowEnabled value
     * @return \LewisLarsen\Ebay\StructType\PaisaPayFullEscrowEnabledDefinitionType|null
     */
    public function getPaisaPayFullEscrowEnabled()
    {
        return $this->PaisaPayFullEscrowEnabled;
    }
    /**
     * Set PaisaPayFullEscrowEnabled value
     * @param \LewisLarsen\Ebay\StructType\PaisaPayFullEscrowEnabledDefinitionType $paisaPayFullEscrowEnabled
     * @return \LewisLarsen\Ebay\StructType\FeatureDefinitionsType
     */
    public function setPaisaPayFullEscrowEnabled(\LewisLarsen\Ebay\StructType\PaisaPayFullEscrowEnabledDefinitionType $paisaPayFullEscrowEnabled = null)
    {
        $this->PaisaPayFullEscrowEnabled = $paisaPayFullEscrowEnabled;
        return $this;
    }
    /**
     * Get ISBNIdentifierEnabled value
     * @return \LewisLarsen\Ebay\StructType\ISBNIdentifierEnabledDefinitionType|null
     */
    public function getISBNIdentifierEnabled()
    {
        return $this->ISBNIdentifierEnabled;
    }
    /**
     * Set ISBNIdentifierEnabled value
     * @param \LewisLarsen\Ebay\StructType\ISBNIdentifierEnabledDefinitionType $iSBNIdentifierEnabled
     * @return \LewisLarsen\Ebay\StructType\FeatureDefinitionsType
     */
    public function setISBNIdentifierEnabled(\LewisLarsen\Ebay\StructType\ISBNIdentifierEnabledDefinitionType $iSBNIdentifierEnabled = null)
    {
        $this->ISBNIdentifierEnabled = $iSBNIdentifierEnabled;
        return $this;
    }
    /**
     * Get UPCIdentifierEnabled value
     * @return \LewisLarsen\Ebay\StructType\UPCIdentifierEnabledDefinitionType|null
     */
    public function getUPCIdentifierEnabled()
    {
        return $this->UPCIdentifierEnabled;
    }
    /**
     * Set UPCIdentifierEnabled value
     * @param \LewisLarsen\Ebay\StructType\UPCIdentifierEnabledDefinitionType $uPCIdentifierEnabled
     * @return \LewisLarsen\Ebay\StructType\FeatureDefinitionsType
     */
    public function setUPCIdentifierEnabled(\LewisLarsen\Ebay\StructType\UPCIdentifierEnabledDefinitionType $uPCIdentifierEnabled = null)
    {
        $this->UPCIdentifierEnabled = $uPCIdentifierEnabled;
        return $this;
    }
    /**
     * Get EANIdentifierEnabled value
     * @return \LewisLarsen\Ebay\StructType\EANIdentifierEnabledDefinitionType|null
     */
    public function getEANIdentifierEnabled()
    {
        return $this->EANIdentifierEnabled;
    }
    /**
     * Set EANIdentifierEnabled value
     * @param \LewisLarsen\Ebay\StructType\EANIdentifierEnabledDefinitionType $eANIdentifierEnabled
     * @return \LewisLarsen\Ebay\StructType\FeatureDefinitionsType
     */
    public function setEANIdentifierEnabled(\LewisLarsen\Ebay\StructType\EANIdentifierEnabledDefinitionType $eANIdentifierEnabled = null)
    {
        $this->EANIdentifierEnabled = $eANIdentifierEnabled;
        return $this;
    }
    /**
     * Get BrandMPNIdentifierEnabled value
     * @return \LewisLarsen\Ebay\StructType\BrandMPNIdentifierEnabledDefinitionType|null
     */
    public function getBrandMPNIdentifierEnabled()
    {
        return $this->BrandMPNIdentifierEnabled;
    }
    /**
     * Set BrandMPNIdentifierEnabled value
     * @param \LewisLarsen\Ebay\StructType\BrandMPNIdentifierEnabledDefinitionType $brandMPNIdentifierEnabled
     * @return \LewisLarsen\Ebay\StructType\FeatureDefinitionsType
     */
    public function setBrandMPNIdentifierEnabled(\LewisLarsen\Ebay\StructType\BrandMPNIdentifierEnabledDefinitionType $brandMPNIdentifierEnabled = null)
    {
        $this->BrandMPNIdentifierEnabled = $brandMPNIdentifierEnabled;
        return $this;
    }
    /**
     * Get BestOfferAutoAcceptEnabled value
     * @return \LewisLarsen\Ebay\StructType\BestOfferAutoAcceptEnabledDefinitionType|null
     */
    public function getBestOfferAutoAcceptEnabled()
    {
        return $this->BestOfferAutoAcceptEnabled;
    }
    /**
     * Set BestOfferAutoAcceptEnabled value
     * @param \LewisLarsen\Ebay\StructType\BestOfferAutoAcceptEnabledDefinitionType $bestOfferAutoAcceptEnabled
     * @return \LewisLarsen\Ebay\StructType\FeatureDefinitionsType
     */
    public function setBestOfferAutoAcceptEnabled(\LewisLarsen\Ebay\StructType\BestOfferAutoAcceptEnabledDefinitionType $bestOfferAutoAcceptEnabled = null)
    {
        $this->BestOfferAutoAcceptEnabled = $bestOfferAutoAcceptEnabled;
        return $this;
    }
    /**
     * Get ClassifiedAdAutoAcceptEnabled value
     * @return \LewisLarsen\Ebay\StructType\ClassifiedAdAutoAcceptEnabledDefinitionType|null
     */
    public function getClassifiedAdAutoAcceptEnabled()
    {
        return $this->ClassifiedAdAutoAcceptEnabled;
    }
    /**
     * Set ClassifiedAdAutoAcceptEnabled value
     * @param \LewisLarsen\Ebay\StructType\ClassifiedAdAutoAcceptEnabledDefinitionType $classifiedAdAutoAcceptEnabled
     * @return \LewisLarsen\Ebay\StructType\FeatureDefinitionsType
     */
    public function setClassifiedAdAutoAcceptEnabled(\LewisLarsen\Ebay\StructType\ClassifiedAdAutoAcceptEnabledDefinitionType $classifiedAdAutoAcceptEnabled = null)
    {
        $this->ClassifiedAdAutoAcceptEnabled = $classifiedAdAutoAcceptEnabled;
        return $this;
    }
    /**
     * Get CrossBorderTradeNorthAmericaEnabled value
     * @return \LewisLarsen\Ebay\StructType\CrossBorderTradeNorthAmericaEnabledDefinitionType|null
     */
    public function getCrossBorderTradeNorthAmericaEnabled()
    {
        return $this->CrossBorderTradeNorthAmericaEnabled;
    }
    /**
     * Set CrossBorderTradeNorthAmericaEnabled value
     * @param \LewisLarsen\Ebay\StructType\CrossBorderTradeNorthAmericaEnabledDefinitionType $crossBorderTradeNorthAmericaEnabled
     * @return \LewisLarsen\Ebay\StructType\FeatureDefinitionsType
     */
    public function setCrossBorderTradeNorthAmericaEnabled(\LewisLarsen\Ebay\StructType\CrossBorderTradeNorthAmericaEnabledDefinitionType $crossBorderTradeNorthAmericaEnabled = null)
    {
        $this->CrossBorderTradeNorthAmericaEnabled = $crossBorderTradeNorthAmericaEnabled;
        return $this;
    }
    /**
     * Get CrossBorderTradeGBEnabled value
     * @return \LewisLarsen\Ebay\StructType\CrossBorderTradeGBEnabledDefinitionType|null
     */
    public function getCrossBorderTradeGBEnabled()
    {
        return $this->CrossBorderTradeGBEnabled;
    }
    /**
     * Set CrossBorderTradeGBEnabled value
     * @param \LewisLarsen\Ebay\StructType\CrossBorderTradeGBEnabledDefinitionType $crossBorderTradeGBEnabled
     * @return \LewisLarsen\Ebay\StructType\FeatureDefinitionsType
     */
    public function setCrossBorderTradeGBEnabled(\LewisLarsen\Ebay\StructType\CrossBorderTradeGBEnabledDefinitionType $crossBorderTradeGBEnabled = null)
    {
        $this->CrossBorderTradeGBEnabled = $crossBorderTradeGBEnabled;
        return $this;
    }
    /**
     * Get CrossBorderTradeAustraliaEnabled value
     * @return \LewisLarsen\Ebay\StructType\CrossBorderTradeAustraliaEnabledDefinitionType|null
     */
    public function getCrossBorderTradeAustraliaEnabled()
    {
        return $this->CrossBorderTradeAustraliaEnabled;
    }
    /**
     * Set CrossBorderTradeAustraliaEnabled value
     * @param \LewisLarsen\Ebay\StructType\CrossBorderTradeAustraliaEnabledDefinitionType $crossBorderTradeAustraliaEnabled
     * @return \LewisLarsen\Ebay\StructType\FeatureDefinitionsType
     */
    public function setCrossBorderTradeAustraliaEnabled(\LewisLarsen\Ebay\StructType\CrossBorderTradeAustraliaEnabledDefinitionType $crossBorderTradeAustraliaEnabled = null)
    {
        $this->CrossBorderTradeAustraliaEnabled = $crossBorderTradeAustraliaEnabled;
        return $this;
    }
    /**
     * Get PayPalBuyerProtectionEnabled value
     * @return \LewisLarsen\Ebay\StructType\PayPalBuyerProtectionEnabledDefinitionType|null
     */
    public function getPayPalBuyerProtectionEnabled()
    {
        return $this->PayPalBuyerProtectionEnabled;
    }
    /**
     * Set PayPalBuyerProtectionEnabled value
     * @param \LewisLarsen\Ebay\StructType\PayPalBuyerProtectionEnabledDefinitionType $payPalBuyerProtectionEnabled
     * @return \LewisLarsen\Ebay\StructType\FeatureDefinitionsType
     */
    public function setPayPalBuyerProtectionEnabled(\LewisLarsen\Ebay\StructType\PayPalBuyerProtectionEnabledDefinitionType $payPalBuyerProtectionEnabled = null)
    {
        $this->PayPalBuyerProtectionEnabled = $payPalBuyerProtectionEnabled;
        return $this;
    }
    /**
     * Get BuyerGuaranteeEnabled value
     * @return \LewisLarsen\Ebay\StructType\BuyerGuaranteeEnabledDefinitionType|null
     */
    public function getBuyerGuaranteeEnabled()
    {
        return $this->BuyerGuaranteeEnabled;
    }
    /**
     * Set BuyerGuaranteeEnabled value
     * @param \LewisLarsen\Ebay\StructType\BuyerGuaranteeEnabledDefinitionType $buyerGuaranteeEnabled
     * @return \LewisLarsen\Ebay\StructType\FeatureDefinitionsType
     */
    public function setBuyerGuaranteeEnabled(\LewisLarsen\Ebay\StructType\BuyerGuaranteeEnabledDefinitionType $buyerGuaranteeEnabled = null)
    {
        $this->BuyerGuaranteeEnabled = $buyerGuaranteeEnabled;
        return $this;
    }
    /**
     * Get CombinedFixedPriceTreatmentEnabled value
     * @return \LewisLarsen\Ebay\StructType\CombinedFixedPriceTreatmentEnabledDefinitionType|null
     */
    public function getCombinedFixedPriceTreatmentEnabled()
    {
        return $this->CombinedFixedPriceTreatmentEnabled;
    }
    /**
     * Set CombinedFixedPriceTreatmentEnabled value
     * @param \LewisLarsen\Ebay\StructType\CombinedFixedPriceTreatmentEnabledDefinitionType $combinedFixedPriceTreatmentEnabled
     * @return \LewisLarsen\Ebay\StructType\FeatureDefinitionsType
     */
    public function setCombinedFixedPriceTreatmentEnabled(\LewisLarsen\Ebay\StructType\CombinedFixedPriceTreatmentEnabledDefinitionType $combinedFixedPriceTreatmentEnabled = null)
    {
        $this->CombinedFixedPriceTreatmentEnabled = $combinedFixedPriceTreatmentEnabled;
        return $this;
    }
    /**
     * Get GalleryFeaturedDurations value
     * @return \LewisLarsen\Ebay\StructType\ListingEnhancementDurationDefinitionType|null
     */
    public function getGalleryFeaturedDurations()
    {
        return $this->GalleryFeaturedDurations;
    }
    /**
     * Set GalleryFeaturedDurations value
     * @param \LewisLarsen\Ebay\StructType\ListingEnhancementDurationDefinitionType $galleryFeaturedDurations
     * @return \LewisLarsen\Ebay\StructType\FeatureDefinitionsType
     */
    public function setGalleryFeaturedDurations(\LewisLarsen\Ebay\StructType\ListingEnhancementDurationDefinitionType $galleryFeaturedDurations = null)
    {
        $this->GalleryFeaturedDurations = $galleryFeaturedDurations;
        return $this;
    }
    /**
     * Get INEscrowWorkflowTimeline value
     * @return \LewisLarsen\Ebay\StructType\INEscrowWorkflowTimelineDefinitionType|null
     */
    public function getINEscrowWorkflowTimeline()
    {
        return $this->INEscrowWorkflowTimeline;
    }
    /**
     * Set INEscrowWorkflowTimeline value
     * @param \LewisLarsen\Ebay\StructType\INEscrowWorkflowTimelineDefinitionType $iNEscrowWorkflowTimeline
     * @return \LewisLarsen\Ebay\StructType\FeatureDefinitionsType
     */
    public function setINEscrowWorkflowTimeline(\LewisLarsen\Ebay\StructType\INEscrowWorkflowTimelineDefinitionType $iNEscrowWorkflowTimeline = null)
    {
        $this->INEscrowWorkflowTimeline = $iNEscrowWorkflowTimeline;
        return $this;
    }
    /**
     * Get PayPalRequired value
     * @return \LewisLarsen\Ebay\StructType\PayPalRequiredDefinitionType|null
     */
    public function getPayPalRequired()
    {
        return $this->PayPalRequired;
    }
    /**
     * Set PayPalRequired value
     * @param \LewisLarsen\Ebay\StructType\PayPalRequiredDefinitionType $payPalRequired
     * @return \LewisLarsen\Ebay\StructType\FeatureDefinitionsType
     */
    public function setPayPalRequired(\LewisLarsen\Ebay\StructType\PayPalRequiredDefinitionType $payPalRequired = null)
    {
        $this->PayPalRequired = $payPalRequired;
        return $this;
    }
    /**
     * Get eBayMotorsProAdFormatEnabled value
     * @return \LewisLarsen\Ebay\StructType\EBayMotorsProAdFormatEnabledDefinitionType|null
     */
    public function getEBayMotorsProAdFormatEnabled()
    {
        return $this->eBayMotorsProAdFormatEnabled;
    }
    /**
     * Set eBayMotorsProAdFormatEnabled value
     * @param \LewisLarsen\Ebay\StructType\EBayMotorsProAdFormatEnabledDefinitionType $eBayMotorsProAdFormatEnabled
     * @return \LewisLarsen\Ebay\StructType\FeatureDefinitionsType
     */
    public function setEBayMotorsProAdFormatEnabled(\LewisLarsen\Ebay\StructType\EBayMotorsProAdFormatEnabledDefinitionType $eBayMotorsProAdFormatEnabled = null)
    {
        $this->eBayMotorsProAdFormatEnabled = $eBayMotorsProAdFormatEnabled;
        return $this;
    }
    /**
     * Get eBayMotorsProContactByPhoneEnabled value
     * @return \LewisLarsen\Ebay\StructType\EBayMotorsProContactByPhoneEnabledDefinitionType|null
     */
    public function getEBayMotorsProContactByPhoneEnabled()
    {
        return $this->eBayMotorsProContactByPhoneEnabled;
    }
    /**
     * Set eBayMotorsProContactByPhoneEnabled value
     * @param \LewisLarsen\Ebay\StructType\EBayMotorsProContactByPhoneEnabledDefinitionType $eBayMotorsProContactByPhoneEnabled
     * @return \LewisLarsen\Ebay\StructType\FeatureDefinitionsType
     */
    public function setEBayMotorsProContactByPhoneEnabled(\LewisLarsen\Ebay\StructType\EBayMotorsProContactByPhoneEnabledDefinitionType $eBayMotorsProContactByPhoneEnabled = null)
    {
        $this->eBayMotorsProContactByPhoneEnabled = $eBayMotorsProContactByPhoneEnabled;
        return $this;
    }
    /**
     * Get eBayMotorsProPhoneCount value
     * @return \LewisLarsen\Ebay\StructType\EBayMotorsProPhoneCountDefinitionType|null
     */
    public function getEBayMotorsProPhoneCount()
    {
        return $this->eBayMotorsProPhoneCount;
    }
    /**
     * Set eBayMotorsProPhoneCount value
     * @param \LewisLarsen\Ebay\StructType\EBayMotorsProPhoneCountDefinitionType $eBayMotorsProPhoneCount
     * @return \LewisLarsen\Ebay\StructType\FeatureDefinitionsType
     */
    public function setEBayMotorsProPhoneCount(\LewisLarsen\Ebay\StructType\EBayMotorsProPhoneCountDefinitionType $eBayMotorsProPhoneCount = null)
    {
        $this->eBayMotorsProPhoneCount = $eBayMotorsProPhoneCount;
        return $this;
    }
    /**
     * Get eBayMotorsProContactByAddressEnabled value
     * @return \LewisLarsen\Ebay\StructType\EBayMotorsProContactByAddressEnabledDefinitionType|null
     */
    public function getEBayMotorsProContactByAddressEnabled()
    {
        return $this->eBayMotorsProContactByAddressEnabled;
    }
    /**
     * Set eBayMotorsProContactByAddressEnabled value
     * @param \LewisLarsen\Ebay\StructType\EBayMotorsProContactByAddressEnabledDefinitionType $eBayMotorsProContactByAddressEnabled
     * @return \LewisLarsen\Ebay\StructType\FeatureDefinitionsType
     */
    public function setEBayMotorsProContactByAddressEnabled(\LewisLarsen\Ebay\StructType\EBayMotorsProContactByAddressEnabledDefinitionType $eBayMotorsProContactByAddressEnabled = null)
    {
        $this->eBayMotorsProContactByAddressEnabled = $eBayMotorsProContactByAddressEnabled;
        return $this;
    }
    /**
     * Get eBayMotorsProStreetCount value
     * @return \LewisLarsen\Ebay\StructType\EBayMotorsProStreetCountDefinitionType|null
     */
    public function getEBayMotorsProStreetCount()
    {
        return $this->eBayMotorsProStreetCount;
    }
    /**
     * Set eBayMotorsProStreetCount value
     * @param \LewisLarsen\Ebay\StructType\EBayMotorsProStreetCountDefinitionType $eBayMotorsProStreetCount
     * @return \LewisLarsen\Ebay\StructType\FeatureDefinitionsType
     */
    public function setEBayMotorsProStreetCount(\LewisLarsen\Ebay\StructType\EBayMotorsProStreetCountDefinitionType $eBayMotorsProStreetCount = null)
    {
        $this->eBayMotorsProStreetCount = $eBayMotorsProStreetCount;
        return $this;
    }
    /**
     * Get eBayMotorsProCompanyNameEnabled value
     * @return \LewisLarsen\Ebay\StructType\EBayMotorsProCompanyNameEnabledDefinitionType|null
     */
    public function getEBayMotorsProCompanyNameEnabled()
    {
        return $this->eBayMotorsProCompanyNameEnabled;
    }
    /**
     * Set eBayMotorsProCompanyNameEnabled value
     * @param \LewisLarsen\Ebay\StructType\EBayMotorsProCompanyNameEnabledDefinitionType $eBayMotorsProCompanyNameEnabled
     * @return \LewisLarsen\Ebay\StructType\FeatureDefinitionsType
     */
    public function setEBayMotorsProCompanyNameEnabled(\LewisLarsen\Ebay\StructType\EBayMotorsProCompanyNameEnabledDefinitionType $eBayMotorsProCompanyNameEnabled = null)
    {
        $this->eBayMotorsProCompanyNameEnabled = $eBayMotorsProCompanyNameEnabled;
        return $this;
    }
    /**
     * Get eBayMotorsProContactByEmailEnabled value
     * @return \LewisLarsen\Ebay\StructType\EBayMotorsProContactByEmailEnabledDefinitionType|null
     */
    public function getEBayMotorsProContactByEmailEnabled()
    {
        return $this->eBayMotorsProContactByEmailEnabled;
    }
    /**
     * Set eBayMotorsProContactByEmailEnabled value
     * @param \LewisLarsen\Ebay\StructType\EBayMotorsProContactByEmailEnabledDefinitionType $eBayMotorsProContactByEmailEnabled
     * @return \LewisLarsen\Ebay\StructType\FeatureDefinitionsType
     */
    public function setEBayMotorsProContactByEmailEnabled(\LewisLarsen\Ebay\StructType\EBayMotorsProContactByEmailEnabledDefinitionType $eBayMotorsProContactByEmailEnabled = null)
    {
        $this->eBayMotorsProContactByEmailEnabled = $eBayMotorsProContactByEmailEnabled;
        return $this;
    }
    /**
     * Get eBayMotorsProBestOfferEnabled value
     * @return \LewisLarsen\Ebay\StructType\EBayMotorsProBestOfferEnabledDefinitionType|null
     */
    public function getEBayMotorsProBestOfferEnabled()
    {
        return $this->eBayMotorsProBestOfferEnabled;
    }
    /**
     * Set eBayMotorsProBestOfferEnabled value
     * @param \LewisLarsen\Ebay\StructType\EBayMotorsProBestOfferEnabledDefinitionType $eBayMotorsProBestOfferEnabled
     * @return \LewisLarsen\Ebay\StructType\FeatureDefinitionsType
     */
    public function setEBayMotorsProBestOfferEnabled(\LewisLarsen\Ebay\StructType\EBayMotorsProBestOfferEnabledDefinitionType $eBayMotorsProBestOfferEnabled = null)
    {
        $this->eBayMotorsProBestOfferEnabled = $eBayMotorsProBestOfferEnabled;
        return $this;
    }
    /**
     * Get eBayMotorsProAutoAcceptEnabled value
     * @return \LewisLarsen\Ebay\StructType\EBayMotorsProAutoAcceptEnabledDefinitionType|null
     */
    public function getEBayMotorsProAutoAcceptEnabled()
    {
        return $this->eBayMotorsProAutoAcceptEnabled;
    }
    /**
     * Set eBayMotorsProAutoAcceptEnabled value
     * @param \LewisLarsen\Ebay\StructType\EBayMotorsProAutoAcceptEnabledDefinitionType $eBayMotorsProAutoAcceptEnabled
     * @return \LewisLarsen\Ebay\StructType\FeatureDefinitionsType
     */
    public function setEBayMotorsProAutoAcceptEnabled(\LewisLarsen\Ebay\StructType\EBayMotorsProAutoAcceptEnabledDefinitionType $eBayMotorsProAutoAcceptEnabled = null)
    {
        $this->eBayMotorsProAutoAcceptEnabled = $eBayMotorsProAutoAcceptEnabled;
        return $this;
    }
    /**
     * Get eBayMotorsProAutoDeclineEnabled value
     * @return \LewisLarsen\Ebay\StructType\EBayMotorsProAutoDeclineEnabledDefinitionType|null
     */
    public function getEBayMotorsProAutoDeclineEnabled()
    {
        return $this->eBayMotorsProAutoDeclineEnabled;
    }
    /**
     * Set eBayMotorsProAutoDeclineEnabled value
     * @param \LewisLarsen\Ebay\StructType\EBayMotorsProAutoDeclineEnabledDefinitionType $eBayMotorsProAutoDeclineEnabled
     * @return \LewisLarsen\Ebay\StructType\FeatureDefinitionsType
     */
    public function setEBayMotorsProAutoDeclineEnabled(\LewisLarsen\Ebay\StructType\EBayMotorsProAutoDeclineEnabledDefinitionType $eBayMotorsProAutoDeclineEnabled = null)
    {
        $this->eBayMotorsProAutoDeclineEnabled = $eBayMotorsProAutoDeclineEnabled;
        return $this;
    }
    /**
     * Get eBayMotorsProPaymentMethodCheckOutEnabled value
     * @return \LewisLarsen\Ebay\StructType\EBayMotorsProPaymentMethodCheckOutEnabledDefinitionType|null
     */
    public function getEBayMotorsProPaymentMethodCheckOutEnabled()
    {
        return $this->eBayMotorsProPaymentMethodCheckOutEnabled;
    }
    /**
     * Set eBayMotorsProPaymentMethodCheckOutEnabled value
     * @param \LewisLarsen\Ebay\StructType\EBayMotorsProPaymentMethodCheckOutEnabledDefinitionType $eBayMotorsProPaymentMethodCheckOutEnabled
     * @return \LewisLarsen\Ebay\StructType\FeatureDefinitionsType
     */
    public function setEBayMotorsProPaymentMethodCheckOutEnabled(\LewisLarsen\Ebay\StructType\EBayMotorsProPaymentMethodCheckOutEnabledDefinitionType $eBayMotorsProPaymentMethodCheckOutEnabled = null)
    {
        $this->eBayMotorsProPaymentMethodCheckOutEnabled = $eBayMotorsProPaymentMethodCheckOutEnabled;
        return $this;
    }
    /**
     * Get eBayMotorsProShippingMethodEnabled value
     * @return \LewisLarsen\Ebay\StructType\EBayMotorsProShippingMethodEnabledDefinitionType|null
     */
    public function getEBayMotorsProShippingMethodEnabled()
    {
        return $this->eBayMotorsProShippingMethodEnabled;
    }
    /**
     * Set eBayMotorsProShippingMethodEnabled value
     * @param \LewisLarsen\Ebay\StructType\EBayMotorsProShippingMethodEnabledDefinitionType $eBayMotorsProShippingMethodEnabled
     * @return \LewisLarsen\Ebay\StructType\FeatureDefinitionsType
     */
    public function setEBayMotorsProShippingMethodEnabled(\LewisLarsen\Ebay\StructType\EBayMotorsProShippingMethodEnabledDefinitionType $eBayMotorsProShippingMethodEnabled = null)
    {
        $this->eBayMotorsProShippingMethodEnabled = $eBayMotorsProShippingMethodEnabled;
        return $this;
    }
    /**
     * Get eBayMotorsProCounterOfferEnabled value
     * @return \LewisLarsen\Ebay\StructType\EBayMotorsProCounterOfferEnabledDefinitionType|null
     */
    public function getEBayMotorsProCounterOfferEnabled()
    {
        return $this->eBayMotorsProCounterOfferEnabled;
    }
    /**
     * Set eBayMotorsProCounterOfferEnabled value
     * @param \LewisLarsen\Ebay\StructType\EBayMotorsProCounterOfferEnabledDefinitionType $eBayMotorsProCounterOfferEnabled
     * @return \LewisLarsen\Ebay\StructType\FeatureDefinitionsType
     */
    public function setEBayMotorsProCounterOfferEnabled(\LewisLarsen\Ebay\StructType\EBayMotorsProCounterOfferEnabledDefinitionType $eBayMotorsProCounterOfferEnabled = null)
    {
        $this->eBayMotorsProCounterOfferEnabled = $eBayMotorsProCounterOfferEnabled;
        return $this;
    }
    /**
     * Get eBayMotorsProSellerContactDetailsEnabled value
     * @return \LewisLarsen\Ebay\StructType\EBayMotorsProSellerContactDetailsEnabledDefinitionType|null
     */
    public function getEBayMotorsProSellerContactDetailsEnabled()
    {
        return $this->eBayMotorsProSellerContactDetailsEnabled;
    }
    /**
     * Set eBayMotorsProSellerContactDetailsEnabled value
     * @param \LewisLarsen\Ebay\StructType\EBayMotorsProSellerContactDetailsEnabledDefinitionType $eBayMotorsProSellerContactDetailsEnabled
     * @return \LewisLarsen\Ebay\StructType\FeatureDefinitionsType
     */
    public function setEBayMotorsProSellerContactDetailsEnabled(\LewisLarsen\Ebay\StructType\EBayMotorsProSellerContactDetailsEnabledDefinitionType $eBayMotorsProSellerContactDetailsEnabled = null)
    {
        $this->eBayMotorsProSellerContactDetailsEnabled = $eBayMotorsProSellerContactDetailsEnabled;
        return $this;
    }
    /**
     * Get LocalMarketAdFormatEnabled value
     * @return \LewisLarsen\Ebay\StructType\LocalMarketAdFormatEnabledDefinitionType|null
     */
    public function getLocalMarketAdFormatEnabled()
    {
        return $this->LocalMarketAdFormatEnabled;
    }
    /**
     * Set LocalMarketAdFormatEnabled value
     * @param \LewisLarsen\Ebay\StructType\LocalMarketAdFormatEnabledDefinitionType $localMarketAdFormatEnabled
     * @return \LewisLarsen\Ebay\StructType\FeatureDefinitionsType
     */
    public function setLocalMarketAdFormatEnabled(\LewisLarsen\Ebay\StructType\LocalMarketAdFormatEnabledDefinitionType $localMarketAdFormatEnabled = null)
    {
        $this->LocalMarketAdFormatEnabled = $localMarketAdFormatEnabled;
        return $this;
    }
    /**
     * Get LocalMarketContactByPhoneEnabled value
     * @return \LewisLarsen\Ebay\StructType\LocalMarketContactByPhoneEnabledDefinitionType|null
     */
    public function getLocalMarketContactByPhoneEnabled()
    {
        return $this->LocalMarketContactByPhoneEnabled;
    }
    /**
     * Set LocalMarketContactByPhoneEnabled value
     * @param \LewisLarsen\Ebay\StructType\LocalMarketContactByPhoneEnabledDefinitionType $localMarketContactByPhoneEnabled
     * @return \LewisLarsen\Ebay\StructType\FeatureDefinitionsType
     */
    public function setLocalMarketContactByPhoneEnabled(\LewisLarsen\Ebay\StructType\LocalMarketContactByPhoneEnabledDefinitionType $localMarketContactByPhoneEnabled = null)
    {
        $this->LocalMarketContactByPhoneEnabled = $localMarketContactByPhoneEnabled;
        return $this;
    }
    /**
     * Get LocalMarketPhoneCount value
     * @return \LewisLarsen\Ebay\StructType\LocalMarketPhoneCountDefinitionType|null
     */
    public function getLocalMarketPhoneCount()
    {
        return $this->LocalMarketPhoneCount;
    }
    /**
     * Set LocalMarketPhoneCount value
     * @param \LewisLarsen\Ebay\StructType\LocalMarketPhoneCountDefinitionType $localMarketPhoneCount
     * @return \LewisLarsen\Ebay\StructType\FeatureDefinitionsType
     */
    public function setLocalMarketPhoneCount(\LewisLarsen\Ebay\StructType\LocalMarketPhoneCountDefinitionType $localMarketPhoneCount = null)
    {
        $this->LocalMarketPhoneCount = $localMarketPhoneCount;
        return $this;
    }
    /**
     * Get LocalMarketContactByAddressEnabled value
     * @return \LewisLarsen\Ebay\StructType\LocalMarketContactByAddressEnabledDefinitionType|null
     */
    public function getLocalMarketContactByAddressEnabled()
    {
        return $this->LocalMarketContactByAddressEnabled;
    }
    /**
     * Set LocalMarketContactByAddressEnabled value
     * @param \LewisLarsen\Ebay\StructType\LocalMarketContactByAddressEnabledDefinitionType $localMarketContactByAddressEnabled
     * @return \LewisLarsen\Ebay\StructType\FeatureDefinitionsType
     */
    public function setLocalMarketContactByAddressEnabled(\LewisLarsen\Ebay\StructType\LocalMarketContactByAddressEnabledDefinitionType $localMarketContactByAddressEnabled = null)
    {
        $this->LocalMarketContactByAddressEnabled = $localMarketContactByAddressEnabled;
        return $this;
    }
    /**
     * Get LocalMarketStreetCount value
     * @return \LewisLarsen\Ebay\StructType\LocalMarketStreetCountDefinitionType|null
     */
    public function getLocalMarketStreetCount()
    {
        return $this->LocalMarketStreetCount;
    }
    /**
     * Set LocalMarketStreetCount value
     * @param \LewisLarsen\Ebay\StructType\LocalMarketStreetCountDefinitionType $localMarketStreetCount
     * @return \LewisLarsen\Ebay\StructType\FeatureDefinitionsType
     */
    public function setLocalMarketStreetCount(\LewisLarsen\Ebay\StructType\LocalMarketStreetCountDefinitionType $localMarketStreetCount = null)
    {
        $this->LocalMarketStreetCount = $localMarketStreetCount;
        return $this;
    }
    /**
     * Get LocalMarketCompanyNameEnabled value
     * @return \LewisLarsen\Ebay\StructType\LocalMarketCompanyNameEnabledDefinitionType|null
     */
    public function getLocalMarketCompanyNameEnabled()
    {
        return $this->LocalMarketCompanyNameEnabled;
    }
    /**
     * Set LocalMarketCompanyNameEnabled value
     * @param \LewisLarsen\Ebay\StructType\LocalMarketCompanyNameEnabledDefinitionType $localMarketCompanyNameEnabled
     * @return \LewisLarsen\Ebay\StructType\FeatureDefinitionsType
     */
    public function setLocalMarketCompanyNameEnabled(\LewisLarsen\Ebay\StructType\LocalMarketCompanyNameEnabledDefinitionType $localMarketCompanyNameEnabled = null)
    {
        $this->LocalMarketCompanyNameEnabled = $localMarketCompanyNameEnabled;
        return $this;
    }
    /**
     * Get LocalMarketContactByEmailEnabled value
     * @return \LewisLarsen\Ebay\StructType\LocalMarketContactByEmailEnabledDefinitionType|null
     */
    public function getLocalMarketContactByEmailEnabled()
    {
        return $this->LocalMarketContactByEmailEnabled;
    }
    /**
     * Set LocalMarketContactByEmailEnabled value
     * @param \LewisLarsen\Ebay\StructType\LocalMarketContactByEmailEnabledDefinitionType $localMarketContactByEmailEnabled
     * @return \LewisLarsen\Ebay\StructType\FeatureDefinitionsType
     */
    public function setLocalMarketContactByEmailEnabled(\LewisLarsen\Ebay\StructType\LocalMarketContactByEmailEnabledDefinitionType $localMarketContactByEmailEnabled = null)
    {
        $this->LocalMarketContactByEmailEnabled = $localMarketContactByEmailEnabled;
        return $this;
    }
    /**
     * Get LocalMarketBestOfferEnabled value
     * @return \LewisLarsen\Ebay\StructType\LocalMarketBestOfferEnabledDefinitionType|null
     */
    public function getLocalMarketBestOfferEnabled()
    {
        return $this->LocalMarketBestOfferEnabled;
    }
    /**
     * Set LocalMarketBestOfferEnabled value
     * @param \LewisLarsen\Ebay\StructType\LocalMarketBestOfferEnabledDefinitionType $localMarketBestOfferEnabled
     * @return \LewisLarsen\Ebay\StructType\FeatureDefinitionsType
     */
    public function setLocalMarketBestOfferEnabled(\LewisLarsen\Ebay\StructType\LocalMarketBestOfferEnabledDefinitionType $localMarketBestOfferEnabled = null)
    {
        $this->LocalMarketBestOfferEnabled = $localMarketBestOfferEnabled;
        return $this;
    }
    /**
     * Get LocalMarketAutoAcceptEnabled value
     * @return \LewisLarsen\Ebay\StructType\LocalMarketAutoAcceptEnabledDefinitionType|null
     */
    public function getLocalMarketAutoAcceptEnabled()
    {
        return $this->LocalMarketAutoAcceptEnabled;
    }
    /**
     * Set LocalMarketAutoAcceptEnabled value
     * @param \LewisLarsen\Ebay\StructType\LocalMarketAutoAcceptEnabledDefinitionType $localMarketAutoAcceptEnabled
     * @return \LewisLarsen\Ebay\StructType\FeatureDefinitionsType
     */
    public function setLocalMarketAutoAcceptEnabled(\LewisLarsen\Ebay\StructType\LocalMarketAutoAcceptEnabledDefinitionType $localMarketAutoAcceptEnabled = null)
    {
        $this->LocalMarketAutoAcceptEnabled = $localMarketAutoAcceptEnabled;
        return $this;
    }
    /**
     * Get LocalMarketAutoDeclineEnabled value
     * @return \LewisLarsen\Ebay\StructType\LocalMarketAutoDeclineEnabledDefinitionType|null
     */
    public function getLocalMarketAutoDeclineEnabled()
    {
        return $this->LocalMarketAutoDeclineEnabled;
    }
    /**
     * Set LocalMarketAutoDeclineEnabled value
     * @param \LewisLarsen\Ebay\StructType\LocalMarketAutoDeclineEnabledDefinitionType $localMarketAutoDeclineEnabled
     * @return \LewisLarsen\Ebay\StructType\FeatureDefinitionsType
     */
    public function setLocalMarketAutoDeclineEnabled(\LewisLarsen\Ebay\StructType\LocalMarketAutoDeclineEnabledDefinitionType $localMarketAutoDeclineEnabled = null)
    {
        $this->LocalMarketAutoDeclineEnabled = $localMarketAutoDeclineEnabled;
        return $this;
    }
    /**
     * Get LocalMarketPaymentMethodCheckOutEnabled value
     * @return \LewisLarsen\Ebay\StructType\LocalMarketPaymentMethodCheckOutEnabledDefinitionType|null
     */
    public function getLocalMarketPaymentMethodCheckOutEnabled()
    {
        return $this->LocalMarketPaymentMethodCheckOutEnabled;
    }
    /**
     * Set LocalMarketPaymentMethodCheckOutEnabled value
     * @param \LewisLarsen\Ebay\StructType\LocalMarketPaymentMethodCheckOutEnabledDefinitionType $localMarketPaymentMethodCheckOutEnabled
     * @return \LewisLarsen\Ebay\StructType\FeatureDefinitionsType
     */
    public function setLocalMarketPaymentMethodCheckOutEnabled(\LewisLarsen\Ebay\StructType\LocalMarketPaymentMethodCheckOutEnabledDefinitionType $localMarketPaymentMethodCheckOutEnabled = null)
    {
        $this->LocalMarketPaymentMethodCheckOutEnabled = $localMarketPaymentMethodCheckOutEnabled;
        return $this;
    }
    /**
     * Get LocalMarketShippingMethodEnabled value
     * @return \LewisLarsen\Ebay\StructType\LocalMarketShippingMethodEnabledDefinitionType|null
     */
    public function getLocalMarketShippingMethodEnabled()
    {
        return $this->LocalMarketShippingMethodEnabled;
    }
    /**
     * Set LocalMarketShippingMethodEnabled value
     * @param \LewisLarsen\Ebay\StructType\LocalMarketShippingMethodEnabledDefinitionType $localMarketShippingMethodEnabled
     * @return \LewisLarsen\Ebay\StructType\FeatureDefinitionsType
     */
    public function setLocalMarketShippingMethodEnabled(\LewisLarsen\Ebay\StructType\LocalMarketShippingMethodEnabledDefinitionType $localMarketShippingMethodEnabled = null)
    {
        $this->LocalMarketShippingMethodEnabled = $localMarketShippingMethodEnabled;
        return $this;
    }
    /**
     * Get LocalMarketCounterOfferEnabled value
     * @return \LewisLarsen\Ebay\StructType\LocalMarketCounterOfferEnabledDefinitionType|null
     */
    public function getLocalMarketCounterOfferEnabled()
    {
        return $this->LocalMarketCounterOfferEnabled;
    }
    /**
     * Set LocalMarketCounterOfferEnabled value
     * @param \LewisLarsen\Ebay\StructType\LocalMarketCounterOfferEnabledDefinitionType $localMarketCounterOfferEnabled
     * @return \LewisLarsen\Ebay\StructType\FeatureDefinitionsType
     */
    public function setLocalMarketCounterOfferEnabled(\LewisLarsen\Ebay\StructType\LocalMarketCounterOfferEnabledDefinitionType $localMarketCounterOfferEnabled = null)
    {
        $this->LocalMarketCounterOfferEnabled = $localMarketCounterOfferEnabled;
        return $this;
    }
    /**
     * Get LocalMarketSellerContactDetailsEnabled value
     * @return \LewisLarsen\Ebay\StructType\LocalMarketSellerContactDetailsEnabledDefinitionType|null
     */
    public function getLocalMarketSellerContactDetailsEnabled()
    {
        return $this->LocalMarketSellerContactDetailsEnabled;
    }
    /**
     * Set LocalMarketSellerContactDetailsEnabled value
     * @param \LewisLarsen\Ebay\StructType\LocalMarketSellerContactDetailsEnabledDefinitionType $localMarketSellerContactDetailsEnabled
     * @return \LewisLarsen\Ebay\StructType\FeatureDefinitionsType
     */
    public function setLocalMarketSellerContactDetailsEnabled(\LewisLarsen\Ebay\StructType\LocalMarketSellerContactDetailsEnabledDefinitionType $localMarketSellerContactDetailsEnabled = null)
    {
        $this->LocalMarketSellerContactDetailsEnabled = $localMarketSellerContactDetailsEnabled;
        return $this;
    }
    /**
     * Get ClassifiedAdPhoneCount value
     * @return \LewisLarsen\Ebay\StructType\ClassifiedAdPhoneCountDefinitionType|null
     */
    public function getClassifiedAdPhoneCount()
    {
        return $this->ClassifiedAdPhoneCount;
    }
    /**
     * Set ClassifiedAdPhoneCount value
     * @param \LewisLarsen\Ebay\StructType\ClassifiedAdPhoneCountDefinitionType $classifiedAdPhoneCount
     * @return \LewisLarsen\Ebay\StructType\FeatureDefinitionsType
     */
    public function setClassifiedAdPhoneCount(\LewisLarsen\Ebay\StructType\ClassifiedAdPhoneCountDefinitionType $classifiedAdPhoneCount = null)
    {
        $this->ClassifiedAdPhoneCount = $classifiedAdPhoneCount;
        return $this;
    }
    /**
     * Get ClassifiedAdContactByAddressEnabled value
     * @return \LewisLarsen\Ebay\StructType\ClassifiedAdContactByAddressEnabledDefinitionType|null
     */
    public function getClassifiedAdContactByAddressEnabled()
    {
        return $this->ClassifiedAdContactByAddressEnabled;
    }
    /**
     * Set ClassifiedAdContactByAddressEnabled value
     * @param \LewisLarsen\Ebay\StructType\ClassifiedAdContactByAddressEnabledDefinitionType $classifiedAdContactByAddressEnabled
     * @return \LewisLarsen\Ebay\StructType\FeatureDefinitionsType
     */
    public function setClassifiedAdContactByAddressEnabled(\LewisLarsen\Ebay\StructType\ClassifiedAdContactByAddressEnabledDefinitionType $classifiedAdContactByAddressEnabled = null)
    {
        $this->ClassifiedAdContactByAddressEnabled = $classifiedAdContactByAddressEnabled;
        return $this;
    }
    /**
     * Get ClassifiedAdStreetCount value
     * @return \LewisLarsen\Ebay\StructType\ClassifiedAdStreetCountDefinitionType|null
     */
    public function getClassifiedAdStreetCount()
    {
        return $this->ClassifiedAdStreetCount;
    }
    /**
     * Set ClassifiedAdStreetCount value
     * @param \LewisLarsen\Ebay\StructType\ClassifiedAdStreetCountDefinitionType $classifiedAdStreetCount
     * @return \LewisLarsen\Ebay\StructType\FeatureDefinitionsType
     */
    public function setClassifiedAdStreetCount(\LewisLarsen\Ebay\StructType\ClassifiedAdStreetCountDefinitionType $classifiedAdStreetCount = null)
    {
        $this->ClassifiedAdStreetCount = $classifiedAdStreetCount;
        return $this;
    }
    /**
     * Get ClassifiedAdCompanyNameEnabled value
     * @return \LewisLarsen\Ebay\StructType\ClassifiedAdCompanyNameEnabledDefinitionType|null
     */
    public function getClassifiedAdCompanyNameEnabled()
    {
        return $this->ClassifiedAdCompanyNameEnabled;
    }
    /**
     * Set ClassifiedAdCompanyNameEnabled value
     * @param \LewisLarsen\Ebay\StructType\ClassifiedAdCompanyNameEnabledDefinitionType $classifiedAdCompanyNameEnabled
     * @return \LewisLarsen\Ebay\StructType\FeatureDefinitionsType
     */
    public function setClassifiedAdCompanyNameEnabled(\LewisLarsen\Ebay\StructType\ClassifiedAdCompanyNameEnabledDefinitionType $classifiedAdCompanyNameEnabled = null)
    {
        $this->ClassifiedAdCompanyNameEnabled = $classifiedAdCompanyNameEnabled;
        return $this;
    }
    /**
     * Get SpecialitySubscription value
     * @return \LewisLarsen\Ebay\StructType\SpecialitySubscriptionDefinitionType|null
     */
    public function getSpecialitySubscription()
    {
        return $this->SpecialitySubscription;
    }
    /**
     * Set SpecialitySubscription value
     * @param \LewisLarsen\Ebay\StructType\SpecialitySubscriptionDefinitionType $specialitySubscription
     * @return \LewisLarsen\Ebay\StructType\FeatureDefinitionsType
     */
    public function setSpecialitySubscription(\LewisLarsen\Ebay\StructType\SpecialitySubscriptionDefinitionType $specialitySubscription = null)
    {
        $this->SpecialitySubscription = $specialitySubscription;
        return $this;
    }
    /**
     * Get RegularSubscription value
     * @return \LewisLarsen\Ebay\StructType\RegularSubscriptionDefinitionType|null
     */
    public function getRegularSubscription()
    {
        return $this->RegularSubscription;
    }
    /**
     * Set RegularSubscription value
     * @param \LewisLarsen\Ebay\StructType\RegularSubscriptionDefinitionType $regularSubscription
     * @return \LewisLarsen\Ebay\StructType\FeatureDefinitionsType
     */
    public function setRegularSubscription(\LewisLarsen\Ebay\StructType\RegularSubscriptionDefinitionType $regularSubscription = null)
    {
        $this->RegularSubscription = $regularSubscription;
        return $this;
    }
    /**
     * Get PremiumSubscription value
     * @return \LewisLarsen\Ebay\StructType\PremiumSubscriptionDefinitionType|null
     */
    public function getPremiumSubscription()
    {
        return $this->PremiumSubscription;
    }
    /**
     * Set PremiumSubscription value
     * @param \LewisLarsen\Ebay\StructType\PremiumSubscriptionDefinitionType $premiumSubscription
     * @return \LewisLarsen\Ebay\StructType\FeatureDefinitionsType
     */
    public function setPremiumSubscription(\LewisLarsen\Ebay\StructType\PremiumSubscriptionDefinitionType $premiumSubscription = null)
    {
        $this->PremiumSubscription = $premiumSubscription;
        return $this;
    }
    /**
     * Get NonSubscription value
     * @return \LewisLarsen\Ebay\StructType\NonSubscriptionDefinitionType|null
     */
    public function getNonSubscription()
    {
        return $this->NonSubscription;
    }
    /**
     * Set NonSubscription value
     * @param \LewisLarsen\Ebay\StructType\NonSubscriptionDefinitionType $nonSubscription
     * @return \LewisLarsen\Ebay\StructType\FeatureDefinitionsType
     */
    public function setNonSubscription(\LewisLarsen\Ebay\StructType\NonSubscriptionDefinitionType $nonSubscription = null)
    {
        $this->NonSubscription = $nonSubscription;
        return $this;
    }
    /**
     * Get ReturnPolicyEnabled value
     * @return \LewisLarsen\Ebay\StructType\ReturnPolicyEnabledDefinitionType|null
     */
    public function getReturnPolicyEnabled()
    {
        return $this->ReturnPolicyEnabled;
    }
    /**
     * Set ReturnPolicyEnabled value
     * @param \LewisLarsen\Ebay\StructType\ReturnPolicyEnabledDefinitionType $returnPolicyEnabled
     * @return \LewisLarsen\Ebay\StructType\FeatureDefinitionsType
     */
    public function setReturnPolicyEnabled(\LewisLarsen\Ebay\StructType\ReturnPolicyEnabledDefinitionType $returnPolicyEnabled = null)
    {
        $this->ReturnPolicyEnabled = $returnPolicyEnabled;
        return $this;
    }
    /**
     * Get HandlingTimeEnabled value
     * @return \LewisLarsen\Ebay\StructType\HandlingTimeEnabledDefinitionType|null
     */
    public function getHandlingTimeEnabled()
    {
        return $this->HandlingTimeEnabled;
    }
    /**
     * Set HandlingTimeEnabled value
     * @param \LewisLarsen\Ebay\StructType\HandlingTimeEnabledDefinitionType $handlingTimeEnabled
     * @return \LewisLarsen\Ebay\StructType\FeatureDefinitionsType
     */
    public function setHandlingTimeEnabled(\LewisLarsen\Ebay\StructType\HandlingTimeEnabledDefinitionType $handlingTimeEnabled = null)
    {
        $this->HandlingTimeEnabled = $handlingTimeEnabled;
        return $this;
    }
    /**
     * Get PayPalRequiredForStoreOwner value
     * @return \LewisLarsen\Ebay\StructType\PayPalRequiredForStoreOwnerDefinitionType|null
     */
    public function getPayPalRequiredForStoreOwner()
    {
        return $this->PayPalRequiredForStoreOwner;
    }
    /**
     * Set PayPalRequiredForStoreOwner value
     * @param \LewisLarsen\Ebay\StructType\PayPalRequiredForStoreOwnerDefinitionType $payPalRequiredForStoreOwner
     * @return \LewisLarsen\Ebay\StructType\FeatureDefinitionsType
     */
    public function setPayPalRequiredForStoreOwner(\LewisLarsen\Ebay\StructType\PayPalRequiredForStoreOwnerDefinitionType $payPalRequiredForStoreOwner = null)
    {
        $this->PayPalRequiredForStoreOwner = $payPalRequiredForStoreOwner;
        return $this;
    }
    /**
     * Get ReviseQuantityAllowed value
     * @return \LewisLarsen\Ebay\StructType\ReviseQuantityAllowedDefinitionType|null
     */
    public function getReviseQuantityAllowed()
    {
        return $this->ReviseQuantityAllowed;
    }
    /**
     * Set ReviseQuantityAllowed value
     * @param \LewisLarsen\Ebay\StructType\ReviseQuantityAllowedDefinitionType $reviseQuantityAllowed
     * @return \LewisLarsen\Ebay\StructType\FeatureDefinitionsType
     */
    public function setReviseQuantityAllowed(\LewisLarsen\Ebay\StructType\ReviseQuantityAllowedDefinitionType $reviseQuantityAllowed = null)
    {
        $this->ReviseQuantityAllowed = $reviseQuantityAllowed;
        return $this;
    }
    /**
     * Get RevisePriceAllowed value
     * @return \LewisLarsen\Ebay\StructType\RevisePriceAllowedDefinitionType|null
     */
    public function getRevisePriceAllowed()
    {
        return $this->RevisePriceAllowed;
    }
    /**
     * Set RevisePriceAllowed value
     * @param \LewisLarsen\Ebay\StructType\RevisePriceAllowedDefinitionType $revisePriceAllowed
     * @return \LewisLarsen\Ebay\StructType\FeatureDefinitionsType
     */
    public function setRevisePriceAllowed(\LewisLarsen\Ebay\StructType\RevisePriceAllowedDefinitionType $revisePriceAllowed = null)
    {
        $this->RevisePriceAllowed = $revisePriceAllowed;
        return $this;
    }
    /**
     * Get StoreOwnerExtendedListingDurationsEnabled value
     * @return \LewisLarsen\Ebay\StructType\StoreOwnerExtendedListingDurationsEnabledDefinitionType|null
     */
    public function getStoreOwnerExtendedListingDurationsEnabled()
    {
        return $this->StoreOwnerExtendedListingDurationsEnabled;
    }
    /**
     * Set StoreOwnerExtendedListingDurationsEnabled value
     * @param \LewisLarsen\Ebay\StructType\StoreOwnerExtendedListingDurationsEnabledDefinitionType $storeOwnerExtendedListingDurationsEnabled
     * @return \LewisLarsen\Ebay\StructType\FeatureDefinitionsType
     */
    public function setStoreOwnerExtendedListingDurationsEnabled(\LewisLarsen\Ebay\StructType\StoreOwnerExtendedListingDurationsEnabledDefinitionType $storeOwnerExtendedListingDurationsEnabled = null)
    {
        $this->StoreOwnerExtendedListingDurationsEnabled = $storeOwnerExtendedListingDurationsEnabled;
        return $this;
    }
    /**
     * Get StoreOwnerExtendedListingDurations value
     * @return \LewisLarsen\Ebay\StructType\StoreOwnerExtendedListingDurationsDefinitionType|null
     */
    public function getStoreOwnerExtendedListingDurations()
    {
        return $this->StoreOwnerExtendedListingDurations;
    }
    /**
     * Set StoreOwnerExtendedListingDurations value
     * @param \LewisLarsen\Ebay\StructType\StoreOwnerExtendedListingDurationsDefinitionType $storeOwnerExtendedListingDurations
     * @return \LewisLarsen\Ebay\StructType\FeatureDefinitionsType
     */
    public function setStoreOwnerExtendedListingDurations(\LewisLarsen\Ebay\StructType\StoreOwnerExtendedListingDurationsDefinitionType $storeOwnerExtendedListingDurations = null)
    {
        $this->StoreOwnerExtendedListingDurations = $storeOwnerExtendedListingDurations;
        return $this;
    }
    /**
     * Get PaymentMethod value
     * @return \LewisLarsen\Ebay\StructType\PaymentMethodDefinitionType|null
     */
    public function getPaymentMethod()
    {
        return $this->PaymentMethod;
    }
    /**
     * Set PaymentMethod value
     * @param \LewisLarsen\Ebay\StructType\PaymentMethodDefinitionType $paymentMethod
     * @return \LewisLarsen\Ebay\StructType\FeatureDefinitionsType
     */
    public function setPaymentMethod(\LewisLarsen\Ebay\StructType\PaymentMethodDefinitionType $paymentMethod = null)
    {
        $this->PaymentMethod = $paymentMethod;
        return $this;
    }
    /**
     * Get Group1MaxFlatShippingCost value
     * @return \LewisLarsen\Ebay\StructType\Group1MaxFlatShippingCostDefinitionType|null
     */
    public function getGroup1MaxFlatShippingCost()
    {
        return $this->Group1MaxFlatShippingCost;
    }
    /**
     * Set Group1MaxFlatShippingCost value
     * @param \LewisLarsen\Ebay\StructType\Group1MaxFlatShippingCostDefinitionType $group1MaxFlatShippingCost
     * @return \LewisLarsen\Ebay\StructType\FeatureDefinitionsType
     */
    public function setGroup1MaxFlatShippingCost(\LewisLarsen\Ebay\StructType\Group1MaxFlatShippingCostDefinitionType $group1MaxFlatShippingCost = null)
    {
        $this->Group1MaxFlatShippingCost = $group1MaxFlatShippingCost;
        return $this;
    }
    /**
     * Get Group2MaxFlatShippingCost value
     * @return \LewisLarsen\Ebay\StructType\Group2MaxFlatShippingCostDefinitionType|null
     */
    public function getGroup2MaxFlatShippingCost()
    {
        return $this->Group2MaxFlatShippingCost;
    }
    /**
     * Set Group2MaxFlatShippingCost value
     * @param \LewisLarsen\Ebay\StructType\Group2MaxFlatShippingCostDefinitionType $group2MaxFlatShippingCost
     * @return \LewisLarsen\Ebay\StructType\FeatureDefinitionsType
     */
    public function setGroup2MaxFlatShippingCost(\LewisLarsen\Ebay\StructType\Group2MaxFlatShippingCostDefinitionType $group2MaxFlatShippingCost = null)
    {
        $this->Group2MaxFlatShippingCost = $group2MaxFlatShippingCost;
        return $this;
    }
    /**
     * Get Group3MaxFlatShippingCost value
     * @return \LewisLarsen\Ebay\StructType\Group3MaxFlatShippingCostDefinitionType|null
     */
    public function getGroup3MaxFlatShippingCost()
    {
        return $this->Group3MaxFlatShippingCost;
    }
    /**
     * Set Group3MaxFlatShippingCost value
     * @param \LewisLarsen\Ebay\StructType\Group3MaxFlatShippingCostDefinitionType $group3MaxFlatShippingCost
     * @return \LewisLarsen\Ebay\StructType\FeatureDefinitionsType
     */
    public function setGroup3MaxFlatShippingCost(\LewisLarsen\Ebay\StructType\Group3MaxFlatShippingCostDefinitionType $group3MaxFlatShippingCost = null)
    {
        $this->Group3MaxFlatShippingCost = $group3MaxFlatShippingCost;
        return $this;
    }
    /**
     * Get MaxFlatShippingCostCBTExempt value
     * @return \LewisLarsen\Ebay\StructType\MaxFlatShippingCostCBTExemptDefinitionType|null
     */
    public function getMaxFlatShippingCostCBTExempt()
    {
        return $this->MaxFlatShippingCostCBTExempt;
    }
    /**
     * Set MaxFlatShippingCostCBTExempt value
     * @param \LewisLarsen\Ebay\StructType\MaxFlatShippingCostCBTExemptDefinitionType $maxFlatShippingCostCBTExempt
     * @return \LewisLarsen\Ebay\StructType\FeatureDefinitionsType
     */
    public function setMaxFlatShippingCostCBTExempt(\LewisLarsen\Ebay\StructType\MaxFlatShippingCostCBTExemptDefinitionType $maxFlatShippingCostCBTExempt = null)
    {
        $this->MaxFlatShippingCostCBTExempt = $maxFlatShippingCostCBTExempt;
        return $this;
    }
    /**
     * Get MaxFlatShippingCost value
     * @return \LewisLarsen\Ebay\StructType\MaxFlatShippingCostDefinitionType|null
     */
    public function getMaxFlatShippingCost()
    {
        return $this->MaxFlatShippingCost;
    }
    /**
     * Set MaxFlatShippingCost value
     * @param \LewisLarsen\Ebay\StructType\MaxFlatShippingCostDefinitionType $maxFlatShippingCost
     * @return \LewisLarsen\Ebay\StructType\FeatureDefinitionsType
     */
    public function setMaxFlatShippingCost(\LewisLarsen\Ebay\StructType\MaxFlatShippingCostDefinitionType $maxFlatShippingCost = null)
    {
        $this->MaxFlatShippingCost = $maxFlatShippingCost;
        return $this;
    }
    /**
     * Get VariationsEnabled value
     * @return \LewisLarsen\Ebay\StructType\VariationsEnabledDefinitionType|null
     */
    public function getVariationsEnabled()
    {
        return $this->VariationsEnabled;
    }
    /**
     * Set VariationsEnabled value
     * @param \LewisLarsen\Ebay\StructType\VariationsEnabledDefinitionType $variationsEnabled
     * @return \LewisLarsen\Ebay\StructType\FeatureDefinitionsType
     */
    public function setVariationsEnabled(\LewisLarsen\Ebay\StructType\VariationsEnabledDefinitionType $variationsEnabled = null)
    {
        $this->VariationsEnabled = $variationsEnabled;
        return $this;
    }
    /**
     * Get AttributeConversionEnabled value
     * @return \LewisLarsen\Ebay\StructType\AttributeConversionEnabledFeatureDefinitionType|null
     */
    public function getAttributeConversionEnabled()
    {
        return $this->AttributeConversionEnabled;
    }
    /**
     * Set AttributeConversionEnabled value
     * @param \LewisLarsen\Ebay\StructType\AttributeConversionEnabledFeatureDefinitionType $attributeConversionEnabled
     * @return \LewisLarsen\Ebay\StructType\FeatureDefinitionsType
     */
    public function setAttributeConversionEnabled(\LewisLarsen\Ebay\StructType\AttributeConversionEnabledFeatureDefinitionType $attributeConversionEnabled = null)
    {
        $this->AttributeConversionEnabled = $attributeConversionEnabled;
        return $this;
    }
    /**
     * Get FreeGalleryPlusEnabled value
     * @return \LewisLarsen\Ebay\StructType\FreeGalleryPlusEnabledDefinitionType|null
     */
    public function getFreeGalleryPlusEnabled()
    {
        return $this->FreeGalleryPlusEnabled;
    }
    /**
     * Set FreeGalleryPlusEnabled value
     * @param \LewisLarsen\Ebay\StructType\FreeGalleryPlusEnabledDefinitionType $freeGalleryPlusEnabled
     * @return \LewisLarsen\Ebay\StructType\FeatureDefinitionsType
     */
    public function setFreeGalleryPlusEnabled(\LewisLarsen\Ebay\StructType\FreeGalleryPlusEnabledDefinitionType $freeGalleryPlusEnabled = null)
    {
        $this->FreeGalleryPlusEnabled = $freeGalleryPlusEnabled;
        return $this;
    }
    /**
     * Get FreePicturePackEnabled value
     * @return \LewisLarsen\Ebay\StructType\FreePicturePackEnabledDefinitionType|null
     */
    public function getFreePicturePackEnabled()
    {
        return $this->FreePicturePackEnabled;
    }
    /**
     * Set FreePicturePackEnabled value
     * @param \LewisLarsen\Ebay\StructType\FreePicturePackEnabledDefinitionType $freePicturePackEnabled
     * @return \LewisLarsen\Ebay\StructType\FeatureDefinitionsType
     */
    public function setFreePicturePackEnabled(\LewisLarsen\Ebay\StructType\FreePicturePackEnabledDefinitionType $freePicturePackEnabled = null)
    {
        $this->FreePicturePackEnabled = $freePicturePackEnabled;
        return $this;
    }
    /**
     * Get ItemCompatibilityEnabled value
     * @return \LewisLarsen\Ebay\StructType\ItemCompatibilityEnabledDefinitionType|null
     */
    public function getItemCompatibilityEnabled()
    {
        return $this->ItemCompatibilityEnabled;
    }
    /**
     * Set ItemCompatibilityEnabled value
     * @param \LewisLarsen\Ebay\StructType\ItemCompatibilityEnabledDefinitionType $itemCompatibilityEnabled
     * @return \LewisLarsen\Ebay\StructType\FeatureDefinitionsType
     */
    public function setItemCompatibilityEnabled(\LewisLarsen\Ebay\StructType\ItemCompatibilityEnabledDefinitionType $itemCompatibilityEnabled = null)
    {
        $this->ItemCompatibilityEnabled = $itemCompatibilityEnabled;
        return $this;
    }
    /**
     * Get MaxItemCompatibility value
     * @return \LewisLarsen\Ebay\StructType\MaxItemCompatibilityDefinitionType|null
     */
    public function getMaxItemCompatibility()
    {
        return $this->MaxItemCompatibility;
    }
    /**
     * Set MaxItemCompatibility value
     * @param \LewisLarsen\Ebay\StructType\MaxItemCompatibilityDefinitionType $maxItemCompatibility
     * @return \LewisLarsen\Ebay\StructType\FeatureDefinitionsType
     */
    public function setMaxItemCompatibility(\LewisLarsen\Ebay\StructType\MaxItemCompatibilityDefinitionType $maxItemCompatibility = null)
    {
        $this->MaxItemCompatibility = $maxItemCompatibility;
        return $this;
    }
    /**
     * Get MinItemCompatibility value
     * @return \LewisLarsen\Ebay\StructType\MinItemCompatibilityDefinitionType|null
     */
    public function getMinItemCompatibility()
    {
        return $this->MinItemCompatibility;
    }
    /**
     * Set MinItemCompatibility value
     * @param \LewisLarsen\Ebay\StructType\MinItemCompatibilityDefinitionType $minItemCompatibility
     * @return \LewisLarsen\Ebay\StructType\FeatureDefinitionsType
     */
    public function setMinItemCompatibility(\LewisLarsen\Ebay\StructType\MinItemCompatibilityDefinitionType $minItemCompatibility = null)
    {
        $this->MinItemCompatibility = $minItemCompatibility;
        return $this;
    }
    /**
     * Get ConditionEnabled value
     * @return \LewisLarsen\Ebay\StructType\ConditionEnabledDefinitionType|null
     */
    public function getConditionEnabled()
    {
        return $this->ConditionEnabled;
    }
    /**
     * Set ConditionEnabled value
     * @param \LewisLarsen\Ebay\StructType\ConditionEnabledDefinitionType $conditionEnabled
     * @return \LewisLarsen\Ebay\StructType\FeatureDefinitionsType
     */
    public function setConditionEnabled(\LewisLarsen\Ebay\StructType\ConditionEnabledDefinitionType $conditionEnabled = null)
    {
        $this->ConditionEnabled = $conditionEnabled;
        return $this;
    }
    /**
     * Get ConditionValues value
     * @return \LewisLarsen\Ebay\StructType\ConditionValuesDefinitionType|null
     */
    public function getConditionValues()
    {
        return $this->ConditionValues;
    }
    /**
     * Set ConditionValues value
     * @param \LewisLarsen\Ebay\StructType\ConditionValuesDefinitionType $conditionValues
     * @return \LewisLarsen\Ebay\StructType\FeatureDefinitionsType
     */
    public function setConditionValues(\LewisLarsen\Ebay\StructType\ConditionValuesDefinitionType $conditionValues = null)
    {
        $this->ConditionValues = $conditionValues;
        return $this;
    }
    /**
     * Get ValueCategory value
     * @return \LewisLarsen\Ebay\StructType\ValueCategoryDefinitionType|null
     */
    public function getValueCategory()
    {
        return $this->ValueCategory;
    }
    /**
     * Set ValueCategory value
     * @param \LewisLarsen\Ebay\StructType\ValueCategoryDefinitionType $valueCategory
     * @return \LewisLarsen\Ebay\StructType\FeatureDefinitionsType
     */
    public function setValueCategory(\LewisLarsen\Ebay\StructType\ValueCategoryDefinitionType $valueCategory = null)
    {
        $this->ValueCategory = $valueCategory;
        return $this;
    }
    /**
     * Get ProductCreationEnabled value
     * @return \LewisLarsen\Ebay\StructType\ProductCreationEnabledDefinitionType|null
     */
    public function getProductCreationEnabled()
    {
        return $this->ProductCreationEnabled;
    }
    /**
     * Set ProductCreationEnabled value
     * @param \LewisLarsen\Ebay\StructType\ProductCreationEnabledDefinitionType $productCreationEnabled
     * @return \LewisLarsen\Ebay\StructType\FeatureDefinitionsType
     */
    public function setProductCreationEnabled(\LewisLarsen\Ebay\StructType\ProductCreationEnabledDefinitionType $productCreationEnabled = null)
    {
        $this->ProductCreationEnabled = $productCreationEnabled;
        return $this;
    }
    /**
     * Get EANEnabled value
     * @return \LewisLarsen\Ebay\StructType\EANEnabledDefinitionType|null
     */
    public function getEANEnabled()
    {
        return $this->EANEnabled;
    }
    /**
     * Set EANEnabled value
     * @param \LewisLarsen\Ebay\StructType\EANEnabledDefinitionType $eANEnabled
     * @return \LewisLarsen\Ebay\StructType\FeatureDefinitionsType
     */
    public function setEANEnabled(\LewisLarsen\Ebay\StructType\EANEnabledDefinitionType $eANEnabled = null)
    {
        $this->EANEnabled = $eANEnabled;
        return $this;
    }
    /**
     * Get ISBNEnabled value
     * @return \LewisLarsen\Ebay\StructType\ISBNEnabledDefinitionType|null
     */
    public function getISBNEnabled()
    {
        return $this->ISBNEnabled;
    }
    /**
     * Set ISBNEnabled value
     * @param \LewisLarsen\Ebay\StructType\ISBNEnabledDefinitionType $iSBNEnabled
     * @return \LewisLarsen\Ebay\StructType\FeatureDefinitionsType
     */
    public function setISBNEnabled(\LewisLarsen\Ebay\StructType\ISBNEnabledDefinitionType $iSBNEnabled = null)
    {
        $this->ISBNEnabled = $iSBNEnabled;
        return $this;
    }
    /**
     * Get UPCEnabled value
     * @return \LewisLarsen\Ebay\StructType\UPCEnabledDefinitionType|null
     */
    public function getUPCEnabled()
    {
        return $this->UPCEnabled;
    }
    /**
     * Set UPCEnabled value
     * @param \LewisLarsen\Ebay\StructType\UPCEnabledDefinitionType $uPCEnabled
     * @return \LewisLarsen\Ebay\StructType\FeatureDefinitionsType
     */
    public function setUPCEnabled(\LewisLarsen\Ebay\StructType\UPCEnabledDefinitionType $uPCEnabled = null)
    {
        $this->UPCEnabled = $uPCEnabled;
        return $this;
    }
    /**
     * Get CompatibleVehicleType value
     * @return \LewisLarsen\Ebay\StructType\CompatibleVehicleTypeDefinitionType|null
     */
    public function getCompatibleVehicleType()
    {
        return $this->CompatibleVehicleType;
    }
    /**
     * Set CompatibleVehicleType value
     * @param \LewisLarsen\Ebay\StructType\CompatibleVehicleTypeDefinitionType $compatibleVehicleType
     * @return \LewisLarsen\Ebay\StructType\FeatureDefinitionsType
     */
    public function setCompatibleVehicleType(\LewisLarsen\Ebay\StructType\CompatibleVehicleTypeDefinitionType $compatibleVehicleType = null)
    {
        $this->CompatibleVehicleType = $compatibleVehicleType;
        return $this;
    }
    /**
     * Get MaxGranularFitmentCount value
     * @return \LewisLarsen\Ebay\StructType\MaxGranularFitmentCountDefinitionType|null
     */
    public function getMaxGranularFitmentCount()
    {
        return $this->MaxGranularFitmentCount;
    }
    /**
     * Set MaxGranularFitmentCount value
     * @param \LewisLarsen\Ebay\StructType\MaxGranularFitmentCountDefinitionType $maxGranularFitmentCount
     * @return \LewisLarsen\Ebay\StructType\FeatureDefinitionsType
     */
    public function setMaxGranularFitmentCount(\LewisLarsen\Ebay\StructType\MaxGranularFitmentCountDefinitionType $maxGranularFitmentCount = null)
    {
        $this->MaxGranularFitmentCount = $maxGranularFitmentCount;
        return $this;
    }
    /**
     * Get PaymentOptionsGroup value
     * @return \LewisLarsen\Ebay\StructType\PaymentOptionsGroupEnabledDefinitionType|null
     */
    public function getPaymentOptionsGroup()
    {
        return $this->PaymentOptionsGroup;
    }
    /**
     * Set PaymentOptionsGroup value
     * @param \LewisLarsen\Ebay\StructType\PaymentOptionsGroupEnabledDefinitionType $paymentOptionsGroup
     * @return \LewisLarsen\Ebay\StructType\FeatureDefinitionsType
     */
    public function setPaymentOptionsGroup(\LewisLarsen\Ebay\StructType\PaymentOptionsGroupEnabledDefinitionType $paymentOptionsGroup = null)
    {
        $this->PaymentOptionsGroup = $paymentOptionsGroup;
        return $this;
    }
    /**
     * Get ShippingProfileCategoryGroup value
     * @return \LewisLarsen\Ebay\StructType\ProfileCategoryGroupDefinitionType|null
     */
    public function getShippingProfileCategoryGroup()
    {
        return $this->ShippingProfileCategoryGroup;
    }
    /**
     * Set ShippingProfileCategoryGroup value
     * @param \LewisLarsen\Ebay\StructType\ProfileCategoryGroupDefinitionType $shippingProfileCategoryGroup
     * @return \LewisLarsen\Ebay\StructType\FeatureDefinitionsType
     */
    public function setShippingProfileCategoryGroup(\LewisLarsen\Ebay\StructType\ProfileCategoryGroupDefinitionType $shippingProfileCategoryGroup = null)
    {
        $this->ShippingProfileCategoryGroup = $shippingProfileCategoryGroup;
        return $this;
    }
    /**
     * Get PaymentProfileCategoryGroup value
     * @return \LewisLarsen\Ebay\StructType\ProfileCategoryGroupDefinitionType|null
     */
    public function getPaymentProfileCategoryGroup()
    {
        return $this->PaymentProfileCategoryGroup;
    }
    /**
     * Set PaymentProfileCategoryGroup value
     * @param \LewisLarsen\Ebay\StructType\ProfileCategoryGroupDefinitionType $paymentProfileCategoryGroup
     * @return \LewisLarsen\Ebay\StructType\FeatureDefinitionsType
     */
    public function setPaymentProfileCategoryGroup(\LewisLarsen\Ebay\StructType\ProfileCategoryGroupDefinitionType $paymentProfileCategoryGroup = null)
    {
        $this->PaymentProfileCategoryGroup = $paymentProfileCategoryGroup;
        return $this;
    }
    /**
     * Get ReturnPolicyProfileCategoryGroup value
     * @return \LewisLarsen\Ebay\StructType\ProfileCategoryGroupDefinitionType|null
     */
    public function getReturnPolicyProfileCategoryGroup()
    {
        return $this->ReturnPolicyProfileCategoryGroup;
    }
    /**
     * Set ReturnPolicyProfileCategoryGroup value
     * @param \LewisLarsen\Ebay\StructType\ProfileCategoryGroupDefinitionType $returnPolicyProfileCategoryGroup
     * @return \LewisLarsen\Ebay\StructType\FeatureDefinitionsType
     */
    public function setReturnPolicyProfileCategoryGroup(\LewisLarsen\Ebay\StructType\ProfileCategoryGroupDefinitionType $returnPolicyProfileCategoryGroup = null)
    {
        $this->ReturnPolicyProfileCategoryGroup = $returnPolicyProfileCategoryGroup;
        return $this;
    }
    /**
     * Get VINSupported value
     * @return \LewisLarsen\Ebay\StructType\VINSupportedDefinitionType|null
     */
    public function getVINSupported()
    {
        return $this->VINSupported;
    }
    /**
     * Set VINSupported value
     * @param \LewisLarsen\Ebay\StructType\VINSupportedDefinitionType $vINSupported
     * @return \LewisLarsen\Ebay\StructType\FeatureDefinitionsType
     */
    public function setVINSupported(\LewisLarsen\Ebay\StructType\VINSupportedDefinitionType $vINSupported = null)
    {
        $this->VINSupported = $vINSupported;
        return $this;
    }
    /**
     * Get VRMSupported value
     * @return \LewisLarsen\Ebay\StructType\VRMSupportedDefinitionType|null
     */
    public function getVRMSupported()
    {
        return $this->VRMSupported;
    }
    /**
     * Set VRMSupported value
     * @param \LewisLarsen\Ebay\StructType\VRMSupportedDefinitionType $vRMSupported
     * @return \LewisLarsen\Ebay\StructType\FeatureDefinitionsType
     */
    public function setVRMSupported(\LewisLarsen\Ebay\StructType\VRMSupportedDefinitionType $vRMSupported = null)
    {
        $this->VRMSupported = $vRMSupported;
        return $this;
    }
    /**
     * Get SellerProvidedTitleSupported value
     * @return \LewisLarsen\Ebay\StructType\SellerProvidedTitleSupportedDefinitionType|null
     */
    public function getSellerProvidedTitleSupported()
    {
        return $this->SellerProvidedTitleSupported;
    }
    /**
     * Set SellerProvidedTitleSupported value
     * @param \LewisLarsen\Ebay\StructType\SellerProvidedTitleSupportedDefinitionType $sellerProvidedTitleSupported
     * @return \LewisLarsen\Ebay\StructType\FeatureDefinitionsType
     */
    public function setSellerProvidedTitleSupported(\LewisLarsen\Ebay\StructType\SellerProvidedTitleSupportedDefinitionType $sellerProvidedTitleSupported = null)
    {
        $this->SellerProvidedTitleSupported = $sellerProvidedTitleSupported;
        return $this;
    }
    /**
     * Get DepositSupported value
     * @return \LewisLarsen\Ebay\StructType\DepositSupportedDefinitionType|null
     */
    public function getDepositSupported()
    {
        return $this->DepositSupported;
    }
    /**
     * Set DepositSupported value
     * @param \LewisLarsen\Ebay\StructType\DepositSupportedDefinitionType $depositSupported
     * @return \LewisLarsen\Ebay\StructType\FeatureDefinitionsType
     */
    public function setDepositSupported(\LewisLarsen\Ebay\StructType\DepositSupportedDefinitionType $depositSupported = null)
    {
        $this->DepositSupported = $depositSupported;
        return $this;
    }
    /**
     * Get GlobalShippingEnabled value
     * @return \LewisLarsen\Ebay\StructType\GlobalShippingEnabledDefinitionType|null
     */
    public function getGlobalShippingEnabled()
    {
        return $this->GlobalShippingEnabled;
    }
    /**
     * Set GlobalShippingEnabled value
     * @param \LewisLarsen\Ebay\StructType\GlobalShippingEnabledDefinitionType $globalShippingEnabled
     * @return \LewisLarsen\Ebay\StructType\FeatureDefinitionsType
     */
    public function setGlobalShippingEnabled(\LewisLarsen\Ebay\StructType\GlobalShippingEnabledDefinitionType $globalShippingEnabled = null)
    {
        $this->GlobalShippingEnabled = $globalShippingEnabled;
        return $this;
    }
    /**
     * Get AdditionalCompatibilityEnabled value
     * @return \LewisLarsen\Ebay\StructType\AdditionalCompatibilityEnabledDefinitionType|null
     */
    public function getAdditionalCompatibilityEnabled()
    {
        return $this->AdditionalCompatibilityEnabled;
    }
    /**
     * Set AdditionalCompatibilityEnabled value
     * @param \LewisLarsen\Ebay\StructType\AdditionalCompatibilityEnabledDefinitionType $additionalCompatibilityEnabled
     * @return \LewisLarsen\Ebay\StructType\FeatureDefinitionsType
     */
    public function setAdditionalCompatibilityEnabled(\LewisLarsen\Ebay\StructType\AdditionalCompatibilityEnabledDefinitionType $additionalCompatibilityEnabled = null)
    {
        $this->AdditionalCompatibilityEnabled = $additionalCompatibilityEnabled;
        return $this;
    }
    /**
     * Get any value
     * @uses \DOMDocument::loadXML()
     * @param bool $asString true: returns XML string, false: returns \DOMDocument
     * @return \DOMDocument|null
     */
    public function getAny($asString = true)
    {
        $domDocument = null;
        if (!empty($this->any) && !$asString) {
            $domDocument = new \DOMDocument('1.0', 'UTF-8');
            $domDocument->loadXML($this->any);
        }
        return $asString ? $this->any : $domDocument;
    }
    /**
     * Set any value
     * @uses \DOMDocument::hasChildNodes()
     * @uses \DOMDocument::saveXML()
     * @uses \DOMNode::item()
     * @param \DOMDocument $any
     * @return \LewisLarsen\Ebay\StructType\FeatureDefinitionsType
     */
    public function setAny(\DOMDocument $any = null)
    {
        $this->any = ($any instanceof \DOMDocument) && $any->hasChildNodes() ? $any->saveXML($any->childNodes->item(0)) : $any;
        return $this;
    }
    /**
     * Get PickupDropOffEnabled value
     * @return \LewisLarsen\Ebay\StructType\PickupDropOffEnabledDefinitionType|null
     */
    public function getPickupDropOffEnabled()
    {
        return $this->PickupDropOffEnabled;
    }
    /**
     * Set PickupDropOffEnabled value
     * @param \LewisLarsen\Ebay\StructType\PickupDropOffEnabledDefinitionType $pickupDropOffEnabled
     * @return \LewisLarsen\Ebay\StructType\FeatureDefinitionsType
     */
    public function setPickupDropOffEnabled(\LewisLarsen\Ebay\StructType\PickupDropOffEnabledDefinitionType $pickupDropOffEnabled = null)
    {
        $this->PickupDropOffEnabled = $pickupDropOffEnabled;
        return $this;
    }
    /**
     * Get DigitalGoodDeliveryEnabled value
     * @return \LewisLarsen\Ebay\StructType\DigitalGoodDeliveryEnabledDefinitionType|null
     */
    public function getDigitalGoodDeliveryEnabled()
    {
        return $this->DigitalGoodDeliveryEnabled;
    }
    /**
     * Set DigitalGoodDeliveryEnabled value
     * @param \LewisLarsen\Ebay\StructType\DigitalGoodDeliveryEnabledDefinitionType $digitalGoodDeliveryEnabled
     * @return \LewisLarsen\Ebay\StructType\FeatureDefinitionsType
     */
    public function setDigitalGoodDeliveryEnabled(\LewisLarsen\Ebay\StructType\DigitalGoodDeliveryEnabledDefinitionType $digitalGoodDeliveryEnabled = null)
    {
        $this->DigitalGoodDeliveryEnabled = $digitalGoodDeliveryEnabled;
        return $this;
    }
    /**
     * Get EpidSupported value
     * @return \LewisLarsen\Ebay\StructType\EpidSupportedDefinitionType|null
     */
    public function getEpidSupported()
    {
        return $this->EpidSupported;
    }
    /**
     * Set EpidSupported value
     * @param \LewisLarsen\Ebay\StructType\EpidSupportedDefinitionType $epidSupported
     * @return \LewisLarsen\Ebay\StructType\FeatureDefinitionsType
     */
    public function setEpidSupported(\LewisLarsen\Ebay\StructType\EpidSupportedDefinitionType $epidSupported = null)
    {
        $this->EpidSupported = $epidSupported;
        return $this;
    }
    /**
     * Get KTypeSupported value
     * @return \LewisLarsen\Ebay\StructType\KTypeSupportedDefinitionType|null
     */
    public function getKTypeSupported()
    {
        return $this->KTypeSupported;
    }
    /**
     * Set KTypeSupported value
     * @param \LewisLarsen\Ebay\StructType\KTypeSupportedDefinitionType $kTypeSupported
     * @return \LewisLarsen\Ebay\StructType\FeatureDefinitionsType
     */
    public function setKTypeSupported(\LewisLarsen\Ebay\StructType\KTypeSupportedDefinitionType $kTypeSupported = null)
    {
        $this->KTypeSupported = $kTypeSupported;
        return $this;
    }
    /**
     * Get ProductRequiredEnabled value
     * @return \LewisLarsen\Ebay\StructType\ProductRequiredEnabledDefinitionType|null
     */
    public function getProductRequiredEnabled()
    {
        return $this->ProductRequiredEnabled;
    }
    /**
     * Set ProductRequiredEnabled value
     * @param \LewisLarsen\Ebay\StructType\ProductRequiredEnabledDefinitionType $productRequiredEnabled
     * @return \LewisLarsen\Ebay\StructType\FeatureDefinitionsType
     */
    public function setProductRequiredEnabled(\LewisLarsen\Ebay\StructType\ProductRequiredEnabledDefinitionType $productRequiredEnabled = null)
    {
        $this->ProductRequiredEnabled = $productRequiredEnabled;
        return $this;
    }
    /**
     * Get DomesticReturnsAcceptedValues value
     * @return \LewisLarsen\Ebay\StructType\DomesticReturnsAcceptedDefinitionType|null
     */
    public function getDomesticReturnsAcceptedValues()
    {
        return $this->DomesticReturnsAcceptedValues;
    }
    /**
     * Set DomesticReturnsAcceptedValues value
     * @param \LewisLarsen\Ebay\StructType\DomesticReturnsAcceptedDefinitionType $domesticReturnsAcceptedValues
     * @return \LewisLarsen\Ebay\StructType\FeatureDefinitionsType
     */
    public function setDomesticReturnsAcceptedValues(\LewisLarsen\Ebay\StructType\DomesticReturnsAcceptedDefinitionType $domesticReturnsAcceptedValues = null)
    {
        $this->DomesticReturnsAcceptedValues = $domesticReturnsAcceptedValues;
        return $this;
    }
    /**
     * Get InternationalReturnsAcceptedValues value
     * @return \LewisLarsen\Ebay\StructType\InternationalReturnsAcceptedDefinitionType|null
     */
    public function getInternationalReturnsAcceptedValues()
    {
        return $this->InternationalReturnsAcceptedValues;
    }
    /**
     * Set InternationalReturnsAcceptedValues value
     * @param \LewisLarsen\Ebay\StructType\InternationalReturnsAcceptedDefinitionType $internationalReturnsAcceptedValues
     * @return \LewisLarsen\Ebay\StructType\FeatureDefinitionsType
     */
    public function setInternationalReturnsAcceptedValues(\LewisLarsen\Ebay\StructType\InternationalReturnsAcceptedDefinitionType $internationalReturnsAcceptedValues = null)
    {
        $this->InternationalReturnsAcceptedValues = $internationalReturnsAcceptedValues;
        return $this;
    }
    /**
     * Get DomesticReturnsDurationValues value
     * @return \LewisLarsen\Ebay\StructType\DomesticReturnsDurationDefinitionType|null
     */
    public function getDomesticReturnsDurationValues()
    {
        return $this->DomesticReturnsDurationValues;
    }
    /**
     * Set DomesticReturnsDurationValues value
     * @param \LewisLarsen\Ebay\StructType\DomesticReturnsDurationDefinitionType $domesticReturnsDurationValues
     * @return \LewisLarsen\Ebay\StructType\FeatureDefinitionsType
     */
    public function setDomesticReturnsDurationValues(\LewisLarsen\Ebay\StructType\DomesticReturnsDurationDefinitionType $domesticReturnsDurationValues = null)
    {
        $this->DomesticReturnsDurationValues = $domesticReturnsDurationValues;
        return $this;
    }
    /**
     * Get InternationalReturnsDurationValues value
     * @return \LewisLarsen\Ebay\StructType\InternationalReturnsDurationDefinitionType|null
     */
    public function getInternationalReturnsDurationValues()
    {
        return $this->InternationalReturnsDurationValues;
    }
    /**
     * Set InternationalReturnsDurationValues value
     * @param \LewisLarsen\Ebay\StructType\InternationalReturnsDurationDefinitionType $internationalReturnsDurationValues
     * @return \LewisLarsen\Ebay\StructType\FeatureDefinitionsType
     */
    public function setInternationalReturnsDurationValues(\LewisLarsen\Ebay\StructType\InternationalReturnsDurationDefinitionType $internationalReturnsDurationValues = null)
    {
        $this->InternationalReturnsDurationValues = $internationalReturnsDurationValues;
        return $this;
    }
    /**
     * Get DomesticReturnsShipmentPayeeValues value
     * @return \LewisLarsen\Ebay\StructType\DomesticReturnsShipmentPayeeDefinitionType|null
     */
    public function getDomesticReturnsShipmentPayeeValues()
    {
        return $this->DomesticReturnsShipmentPayeeValues;
    }
    /**
     * Set DomesticReturnsShipmentPayeeValues value
     * @param \LewisLarsen\Ebay\StructType\DomesticReturnsShipmentPayeeDefinitionType $domesticReturnsShipmentPayeeValues
     * @return \LewisLarsen\Ebay\StructType\FeatureDefinitionsType
     */
    public function setDomesticReturnsShipmentPayeeValues(\LewisLarsen\Ebay\StructType\DomesticReturnsShipmentPayeeDefinitionType $domesticReturnsShipmentPayeeValues = null)
    {
        $this->DomesticReturnsShipmentPayeeValues = $domesticReturnsShipmentPayeeValues;
        return $this;
    }
    /**
     * Get InternationalReturnsShipmentPayeeValues value
     * @return \LewisLarsen\Ebay\StructType\InternationalReturnsShipmentPayeeDefinitionType|null
     */
    public function getInternationalReturnsShipmentPayeeValues()
    {
        return $this->InternationalReturnsShipmentPayeeValues;
    }
    /**
     * Set InternationalReturnsShipmentPayeeValues value
     * @param \LewisLarsen\Ebay\StructType\InternationalReturnsShipmentPayeeDefinitionType $internationalReturnsShipmentPayeeValues
     * @return \LewisLarsen\Ebay\StructType\FeatureDefinitionsType
     */
    public function setInternationalReturnsShipmentPayeeValues(\LewisLarsen\Ebay\StructType\InternationalReturnsShipmentPayeeDefinitionType $internationalReturnsShipmentPayeeValues = null)
    {
        $this->InternationalReturnsShipmentPayeeValues = $internationalReturnsShipmentPayeeValues;
        return $this;
    }
    /**
     * Get DomesticRefundMethodValues value
     * @return \LewisLarsen\Ebay\StructType\DomesticRefundMethodCodeType|null
     */
    public function getDomesticRefundMethodValues()
    {
        return $this->DomesticRefundMethodValues;
    }
    /**
     * Set DomesticRefundMethodValues value
     * @param \LewisLarsen\Ebay\StructType\DomesticRefundMethodCodeType $domesticRefundMethodValues
     * @return \LewisLarsen\Ebay\StructType\FeatureDefinitionsType
     */
    public function setDomesticRefundMethodValues(\LewisLarsen\Ebay\StructType\DomesticRefundMethodCodeType $domesticRefundMethodValues = null)
    {
        $this->DomesticRefundMethodValues = $domesticRefundMethodValues;
        return $this;
    }
    /**
     * Get InternationalRefundMethodValues value
     * @return \LewisLarsen\Ebay\StructType\InternationalRefundMethodCodeType|null
     */
    public function getInternationalRefundMethodValues()
    {
        return $this->InternationalRefundMethodValues;
    }
    /**
     * Set InternationalRefundMethodValues value
     * @param \LewisLarsen\Ebay\StructType\InternationalRefundMethodCodeType $internationalRefundMethodValues
     * @return \LewisLarsen\Ebay\StructType\FeatureDefinitionsType
     */
    public function setInternationalRefundMethodValues(\LewisLarsen\Ebay\StructType\InternationalRefundMethodCodeType $internationalRefundMethodValues = null)
    {
        $this->InternationalRefundMethodValues = $internationalRefundMethodValues;
        return $this;
    }
    /**
     * Get ReturnPolicyDescriptionEnabled value
     * @return \LewisLarsen\Ebay\StructType\ReturnPolicyDescriptionEnabledDefinitionType|null
     */
    public function getReturnPolicyDescriptionEnabled()
    {
        return $this->ReturnPolicyDescriptionEnabled;
    }
    /**
     * Set ReturnPolicyDescriptionEnabled value
     * @param \LewisLarsen\Ebay\StructType\ReturnPolicyDescriptionEnabledDefinitionType $returnPolicyDescriptionEnabled
     * @return \LewisLarsen\Ebay\StructType\FeatureDefinitionsType
     */
    public function setReturnPolicyDescriptionEnabled(\LewisLarsen\Ebay\StructType\ReturnPolicyDescriptionEnabledDefinitionType $returnPolicyDescriptionEnabled = null)
    {
        $this->ReturnPolicyDescriptionEnabled = $returnPolicyDescriptionEnabled;
        return $this;
    }
}
