<?php

namespace LewisLarsen\Ebay\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetSellingManagerTemplateAutomationRuleResponseType
 * StructType
 * Meta information extracted from the WSDL
 * - documentation: Contains the set of automation rules associated with the specified template.
 * @subpackage Structs
 */
class GetSellingManagerTemplateAutomationRuleResponseType extends AbstractResponseType
{
    /**
     * The AutomatedListingRule
     * Meta information extracted from the WSDL
     * - documentation: The information for the automated listing rule associated with the template.
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\SellingManagerAutoListType
     */
    public $AutomatedListingRule;
    /**
     * The AutomatedRelistingRule
     * Meta information extracted from the WSDL
     * - documentation: The information for the automated relisting rule associated with the template.
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\SellingManagerAutoRelistType
     */
    public $AutomatedRelistingRule;
    /**
     * The AutomatedSecondChanceOfferRule
     * Meta information extracted from the WSDL
     * - documentation: The information for the automated Second Chance Offer rule associated with the template.
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\SellingManagerAutoSecondChanceOfferType
     */
    public $AutomatedSecondChanceOfferRule;
    /**
     * The Fees
     * Meta information extracted from the WSDL
     * - documentation: Contains fees that may be incurred when items are listed using the automation rule (e.g., a scheduled listing fee). Use of an automation rule does not in itself have a fee, but use can result in a fee.
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\FeesType
     */
    public $Fees;
    /**
     * Constructor method for GetSellingManagerTemplateAutomationRuleResponseType
     * @uses GetSellingManagerTemplateAutomationRuleResponseType::setAutomatedListingRule()
     * @uses GetSellingManagerTemplateAutomationRuleResponseType::setAutomatedRelistingRule()
     * @uses GetSellingManagerTemplateAutomationRuleResponseType::setAutomatedSecondChanceOfferRule()
     * @uses GetSellingManagerTemplateAutomationRuleResponseType::setFees()
     * @param \LewisLarsen\Ebay\StructType\SellingManagerAutoListType $automatedListingRule
     * @param \LewisLarsen\Ebay\StructType\SellingManagerAutoRelistType $automatedRelistingRule
     * @param \LewisLarsen\Ebay\StructType\SellingManagerAutoSecondChanceOfferType $automatedSecondChanceOfferRule
     * @param \LewisLarsen\Ebay\StructType\FeesType $fees
     */
    public function __construct(\LewisLarsen\Ebay\StructType\SellingManagerAutoListType $automatedListingRule = null, \LewisLarsen\Ebay\StructType\SellingManagerAutoRelistType $automatedRelistingRule = null, \LewisLarsen\Ebay\StructType\SellingManagerAutoSecondChanceOfferType $automatedSecondChanceOfferRule = null, \LewisLarsen\Ebay\StructType\FeesType $fees = null)
    {
        $this
            ->setAutomatedListingRule($automatedListingRule)
            ->setAutomatedRelistingRule($automatedRelistingRule)
            ->setAutomatedSecondChanceOfferRule($automatedSecondChanceOfferRule)
            ->setFees($fees);
    }
    /**
     * Get AutomatedListingRule value
     * @return \LewisLarsen\Ebay\StructType\SellingManagerAutoListType|null
     */
    public function getAutomatedListingRule()
    {
        return $this->AutomatedListingRule;
    }
    /**
     * Set AutomatedListingRule value
     * @param \LewisLarsen\Ebay\StructType\SellingManagerAutoListType $automatedListingRule
     * @return \LewisLarsen\Ebay\StructType\GetSellingManagerTemplateAutomationRuleResponseType
     */
    public function setAutomatedListingRule(\LewisLarsen\Ebay\StructType\SellingManagerAutoListType $automatedListingRule = null)
    {
        $this->AutomatedListingRule = $automatedListingRule;
        return $this;
    }
    /**
     * Get AutomatedRelistingRule value
     * @return \LewisLarsen\Ebay\StructType\SellingManagerAutoRelistType|null
     */
    public function getAutomatedRelistingRule()
    {
        return $this->AutomatedRelistingRule;
    }
    /**
     * Set AutomatedRelistingRule value
     * @param \LewisLarsen\Ebay\StructType\SellingManagerAutoRelistType $automatedRelistingRule
     * @return \LewisLarsen\Ebay\StructType\GetSellingManagerTemplateAutomationRuleResponseType
     */
    public function setAutomatedRelistingRule(\LewisLarsen\Ebay\StructType\SellingManagerAutoRelistType $automatedRelistingRule = null)
    {
        $this->AutomatedRelistingRule = $automatedRelistingRule;
        return $this;
    }
    /**
     * Get AutomatedSecondChanceOfferRule value
     * @return \LewisLarsen\Ebay\StructType\SellingManagerAutoSecondChanceOfferType|null
     */
    public function getAutomatedSecondChanceOfferRule()
    {
        return $this->AutomatedSecondChanceOfferRule;
    }
    /**
     * Set AutomatedSecondChanceOfferRule value
     * @param \LewisLarsen\Ebay\StructType\SellingManagerAutoSecondChanceOfferType $automatedSecondChanceOfferRule
     * @return \LewisLarsen\Ebay\StructType\GetSellingManagerTemplateAutomationRuleResponseType
     */
    public function setAutomatedSecondChanceOfferRule(\LewisLarsen\Ebay\StructType\SellingManagerAutoSecondChanceOfferType $automatedSecondChanceOfferRule = null)
    {
        $this->AutomatedSecondChanceOfferRule = $automatedSecondChanceOfferRule;
        return $this;
    }
    /**
     * Get Fees value
     * @return \LewisLarsen\Ebay\StructType\FeesType|null
     */
    public function getFees()
    {
        return $this->Fees;
    }
    /**
     * Set Fees value
     * @param \LewisLarsen\Ebay\StructType\FeesType $fees
     * @return \LewisLarsen\Ebay\StructType\GetSellingManagerTemplateAutomationRuleResponseType
     */
    public function setFees(\LewisLarsen\Ebay\StructType\FeesType $fees = null)
    {
        $this->Fees = $fees;
        return $this;
    }
}
