<?php

namespace LewisLarsen\Ebay\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetItemResponseType StructType
 * Meta information extracted from the WSDL
 * - documentation: This type is used to display detailed information about the listing that was retrieved.
 * @subpackage Structs
 */
class GetItemResponseType extends AbstractResponseType
{
    /**
     * The Item
     * Meta information extracted from the WSDL
     * - documentation: This container consists of detailed information about the retrieved listing. The amount of information that is returned is partially controlled by the filters that are set in the call request.
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\ItemType
     */
    public $Item;
    /**
     * Constructor method for GetItemResponseType
     * @uses GetItemResponseType::setItem()
     * @param \LewisLarsen\Ebay\StructType\ItemType $item
     */
    public function __construct(\LewisLarsen\Ebay\StructType\ItemType $item = null)
    {
        $this
            ->setItem($item);
    }
    /**
     * Get Item value
     * @return \LewisLarsen\Ebay\StructType\ItemType|null
     */
    public function getItem()
    {
        return $this->Item;
    }
    /**
     * Set Item value
     * @param \LewisLarsen\Ebay\StructType\ItemType $item
     * @return \LewisLarsen\Ebay\StructType\GetItemResponseType
     */
    public function setItem(\LewisLarsen\Ebay\StructType\ItemType $item = null)
    {
        $this->Item = $item;
        return $this;
    }
}
