<?php

namespace LewisLarsen\Ebay\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetMyMessagesResponseType StructType
 * Meta information extracted from the WSDL
 * - documentation: Conains information about the messages sent to a user. Depending on the detail level, this information can include message counts, resolution and flagged status, message headers, and message text.
 * @subpackage Structs
 */
class GetMyMessagesResponseType extends AbstractResponseType
{
    /**
     * The Summary
     * Meta information extracted from the WSDL
     * - documentation: Summary data for a given user's messages. This includes the numbers of new messages, flagged messages, and total messages. The amount and type of data returned is the same whether or not the request includes specific Message IDs.
     * Always/Conditionally returned logic assumes a detail level of ReturnMessages.
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\MyMessagesSummaryType
     */
    public $Summary;
    /**
     * The Alerts
     * Meta information extracted from the WSDL
     * - documentation: This container is deprecated.
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\ArrayType\MyMessagesAlertArrayType
     */
    public $Alerts;
    /**
     * The Messages
     * Meta information extracted from the WSDL
     * - documentation: This container consists of an array of one or more messages that match the search criteria in the call request.
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\ArrayType\MyMessagesMessageArrayType
     */
    public $Messages;
    /**
     * Constructor method for GetMyMessagesResponseType
     * @uses GetMyMessagesResponseType::setSummary()
     * @uses GetMyMessagesResponseType::setAlerts()
     * @uses GetMyMessagesResponseType::setMessages()
     * @param \LewisLarsen\Ebay\StructType\MyMessagesSummaryType $summary
     * @param \LewisLarsen\Ebay\ArrayType\MyMessagesAlertArrayType $alerts
     * @param \LewisLarsen\Ebay\ArrayType\MyMessagesMessageArrayType $messages
     */
    public function __construct(\LewisLarsen\Ebay\StructType\MyMessagesSummaryType $summary = null, \LewisLarsen\Ebay\ArrayType\MyMessagesAlertArrayType $alerts = null, \LewisLarsen\Ebay\ArrayType\MyMessagesMessageArrayType $messages = null)
    {
        $this
            ->setSummary($summary)
            ->setAlerts($alerts)
            ->setMessages($messages);
    }
    /**
     * Get Summary value
     * @return \LewisLarsen\Ebay\StructType\MyMessagesSummaryType|null
     */
    public function getSummary()
    {
        return $this->Summary;
    }
    /**
     * Set Summary value
     * @param \LewisLarsen\Ebay\StructType\MyMessagesSummaryType $summary
     * @return \LewisLarsen\Ebay\StructType\GetMyMessagesResponseType
     */
    public function setSummary(\LewisLarsen\Ebay\StructType\MyMessagesSummaryType $summary = null)
    {
        $this->Summary = $summary;
        return $this;
    }
    /**
     * Get Alerts value
     * @return \LewisLarsen\Ebay\ArrayType\MyMessagesAlertArrayType|null
     */
    public function getAlerts()
    {
        return $this->Alerts;
    }
    /**
     * Set Alerts value
     * @param \LewisLarsen\Ebay\ArrayType\MyMessagesAlertArrayType $alerts
     * @return \LewisLarsen\Ebay\StructType\GetMyMessagesResponseType
     */
    public function setAlerts(\LewisLarsen\Ebay\ArrayType\MyMessagesAlertArrayType $alerts = null)
    {
        $this->Alerts = $alerts;
        return $this;
    }
    /**
     * Get Messages value
     * @return \LewisLarsen\Ebay\ArrayType\MyMessagesMessageArrayType|null
     */
    public function getMessages()
    {
        return $this->Messages;
    }
    /**
     * Set Messages value
     * @param \LewisLarsen\Ebay\ArrayType\MyMessagesMessageArrayType $messages
     * @return \LewisLarsen\Ebay\StructType\GetMyMessagesResponseType
     */
    public function setMessages(\LewisLarsen\Ebay\ArrayType\MyMessagesMessageArrayType $messages = null)
    {
        $this->Messages = $messages;
        return $this;
    }
}
