<?php

namespace LewisLarsen\Ebay\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Delete ServiceType
 * @subpackage Services
 */
class Delete extends AbstractSoapClientBase
{
    /**
     * Sets the RequesterCredentials SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \LewisLarsen\Ebay\StructType\CustomSecurityHeaderType $requesterCredentials
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderRequesterCredentials(\LewisLarsen\Ebay\StructType\CustomSecurityHeaderType $requesterCredentials, $nameSpace = 'urn:ebay:apis:eBLBaseComponents', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'RequesterCredentials', $requesterCredentials, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named DeleteMyMessages
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: RequesterCredentials
     * - SOAPHeaderNamespaces: urn:ebay:apis:eBLBaseComponents
     * - SOAPHeaderTypes: \LewisLarsen\Ebay\StructType\CustomSecurityHeaderType
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \LewisLarsen\Ebay\StructType\DeleteMyMessagesRequestType $deleteMyMessagesRequest
     * @return \LewisLarsen\Ebay\StructType\DeleteMyMessagesResponseType|bool
     */
    public function DeleteMyMessages(\LewisLarsen\Ebay\StructType\DeleteMyMessagesRequestType $deleteMyMessagesRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->DeleteMyMessages($deleteMyMessagesRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * DeleteSellingManagerInventoryFolder
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: RequesterCredentials
     * - SOAPHeaderNamespaces: urn:ebay:apis:eBLBaseComponents
     * - SOAPHeaderTypes: \LewisLarsen\Ebay\StructType\CustomSecurityHeaderType
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \LewisLarsen\Ebay\StructType\DeleteSellingManagerInventoryFolderRequestType $deleteSellingManagerInventoryFolderRequest
     * @return \LewisLarsen\Ebay\StructType\DeleteSellingManagerInventoryFolderResponseType|bool
     */
    public function DeleteSellingManagerInventoryFolder(\LewisLarsen\Ebay\StructType\DeleteSellingManagerInventoryFolderRequestType $deleteSellingManagerInventoryFolderRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->DeleteSellingManagerInventoryFolder($deleteSellingManagerInventoryFolderRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * DeleteSellingManagerItemAutomationRule
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: RequesterCredentials
     * - SOAPHeaderNamespaces: urn:ebay:apis:eBLBaseComponents
     * - SOAPHeaderTypes: \LewisLarsen\Ebay\StructType\CustomSecurityHeaderType
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \LewisLarsen\Ebay\StructType\DeleteSellingManagerItemAutomationRuleRequestType $deleteSellingManagerItemAutomationRuleRequest
     * @return \LewisLarsen\Ebay\StructType\DeleteSellingManagerItemAutomationRuleResponseType|bool
     */
    public function DeleteSellingManagerItemAutomationRule(\LewisLarsen\Ebay\StructType\DeleteSellingManagerItemAutomationRuleRequestType $deleteSellingManagerItemAutomationRuleRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->DeleteSellingManagerItemAutomationRule($deleteSellingManagerItemAutomationRuleRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named DeleteSellingManagerProduct
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: RequesterCredentials
     * - SOAPHeaderNamespaces: urn:ebay:apis:eBLBaseComponents
     * - SOAPHeaderTypes: \LewisLarsen\Ebay\StructType\CustomSecurityHeaderType
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \LewisLarsen\Ebay\StructType\DeleteSellingManagerProductRequestType $deleteSellingManagerProductRequest
     * @return \LewisLarsen\Ebay\StructType\DeleteSellingManagerProductResponseType|bool
     */
    public function DeleteSellingManagerProduct(\LewisLarsen\Ebay\StructType\DeleteSellingManagerProductRequestType $deleteSellingManagerProductRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->DeleteSellingManagerProduct($deleteSellingManagerProductRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named DeleteSellingManagerTemplate
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: RequesterCredentials
     * - SOAPHeaderNamespaces: urn:ebay:apis:eBLBaseComponents
     * - SOAPHeaderTypes: \LewisLarsen\Ebay\StructType\CustomSecurityHeaderType
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \LewisLarsen\Ebay\StructType\DeleteSellingManagerTemplateRequestType $deleteSellingManagerTemplateRequest
     * @return \LewisLarsen\Ebay\StructType\DeleteSellingManagerTemplateResponseType|bool
     */
    public function DeleteSellingManagerTemplate(\LewisLarsen\Ebay\StructType\DeleteSellingManagerTemplateRequestType $deleteSellingManagerTemplateRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->DeleteSellingManagerTemplate($deleteSellingManagerTemplateRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * DeleteSellingManagerTemplateAutomationRule
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: RequesterCredentials
     * - SOAPHeaderNamespaces: urn:ebay:apis:eBLBaseComponents
     * - SOAPHeaderTypes: \LewisLarsen\Ebay\StructType\CustomSecurityHeaderType
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \LewisLarsen\Ebay\StructType\DeleteSellingManagerTemplateAutomationRuleRequestType $deleteSellingManagerTemplateAutomationRuleRequest
     * @return \LewisLarsen\Ebay\StructType\DeleteSellingManagerTemplateAutomationRuleResponseType|bool
     */
    public function DeleteSellingManagerTemplateAutomationRule(\LewisLarsen\Ebay\StructType\DeleteSellingManagerTemplateAutomationRuleRequestType $deleteSellingManagerTemplateAutomationRuleRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->DeleteSellingManagerTemplateAutomationRule($deleteSellingManagerTemplateAutomationRuleRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \LewisLarsen\Ebay\StructType\DeleteMyMessagesResponseType|\LewisLarsen\Ebay\StructType\DeleteSellingManagerInventoryFolderResponseType|\LewisLarsen\Ebay\StructType\DeleteSellingManagerItemAutomationRuleResponseType|\LewisLarsen\Ebay\StructType\DeleteSellingManagerProductResponseType|\LewisLarsen\Ebay\StructType\DeleteSellingManagerTemplateAutomationRuleResponseType|\LewisLarsen\Ebay\StructType\DeleteSellingManagerTemplateResponseType
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
