<?php

namespace LewisLarsen\Ebay\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SetSellingManagerFeedbackOptionsRequestType StructType
 * Meta information extracted from the WSDL
 * - documentation: Enables Selling Manager Pro subscribers to store standard feedback comments that can be left for their buyers. Selling Manager Pro subscribers can also specify what events, if any, will trigger an automated feedback response to
 * buyers.
 * @subpackage Structs
 */
class SetSellingManagerFeedbackOptionsRequestType extends AbstractRequestType
{
    /**
     * The AutomatedLeaveFeedbackEvent
     * Meta information extracted from the WSDL
     * - documentation: Specifies the event that will trigger automated feedback to the buyer.
     * - minOccurs: 0
     * @var string
     */
    public $AutomatedLeaveFeedbackEvent;
    /**
     * The StoredComments
     * Meta information extracted from the WSDL
     * - documentation: Contains a set of comments from which one can be selected to leave feedback for a buyer. If automated feedback is used, a comment is selected from the set randomly. Stored comments cannot be replaced or edited individually.
     * Submitting a stored comments array replaces all existing stored comments. <br>
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\ArrayType\FeedbackCommentArrayType
     */
    public $StoredComments;
    /**
     * Constructor method for SetSellingManagerFeedbackOptionsRequestType
     * @uses SetSellingManagerFeedbackOptionsRequestType::setAutomatedLeaveFeedbackEvent()
     * @uses SetSellingManagerFeedbackOptionsRequestType::setStoredComments()
     * @param string $automatedLeaveFeedbackEvent
     * @param \LewisLarsen\Ebay\ArrayType\FeedbackCommentArrayType $storedComments
     */
    public function __construct($automatedLeaveFeedbackEvent = null, \LewisLarsen\Ebay\ArrayType\FeedbackCommentArrayType $storedComments = null)
    {
        $this
            ->setAutomatedLeaveFeedbackEvent($automatedLeaveFeedbackEvent)
            ->setStoredComments($storedComments);
    }
    /**
     * Get AutomatedLeaveFeedbackEvent value
     * @return string|null
     */
    public function getAutomatedLeaveFeedbackEvent()
    {
        return $this->AutomatedLeaveFeedbackEvent;
    }
    /**
     * Set AutomatedLeaveFeedbackEvent value
     * @uses \LewisLarsen\Ebay\EnumType\AutomatedLeaveFeedbackEventCodeType::valueIsValid()
     * @uses \LewisLarsen\Ebay\EnumType\AutomatedLeaveFeedbackEventCodeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $automatedLeaveFeedbackEvent
     * @return \LewisLarsen\Ebay\StructType\SetSellingManagerFeedbackOptionsRequestType
     */
    public function setAutomatedLeaveFeedbackEvent($automatedLeaveFeedbackEvent = null)
    {
        // validation for constraint: enumeration
        if (!\LewisLarsen\Ebay\EnumType\AutomatedLeaveFeedbackEventCodeType::valueIsValid($automatedLeaveFeedbackEvent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \LewisLarsen\Ebay\EnumType\AutomatedLeaveFeedbackEventCodeType', is_array($automatedLeaveFeedbackEvent) ? implode(', ', $automatedLeaveFeedbackEvent) : var_export($automatedLeaveFeedbackEvent, true), implode(', ', \LewisLarsen\Ebay\EnumType\AutomatedLeaveFeedbackEventCodeType::getValidValues())), __LINE__);
        }
        $this->AutomatedLeaveFeedbackEvent = $automatedLeaveFeedbackEvent;
        return $this;
    }
    /**
     * Get StoredComments value
     * @return \LewisLarsen\Ebay\ArrayType\FeedbackCommentArrayType|null
     */
    public function getStoredComments()
    {
        return $this->StoredComments;
    }
    /**
     * Set StoredComments value
     * @param \LewisLarsen\Ebay\ArrayType\FeedbackCommentArrayType $storedComments
     * @return \LewisLarsen\Ebay\StructType\SetSellingManagerFeedbackOptionsRequestType
     */
    public function setStoredComments(\LewisLarsen\Ebay\ArrayType\FeedbackCommentArrayType $storedComments = null)
    {
        $this->StoredComments = $storedComments;
        return $this;
    }
}
