<?php

namespace LewisLarsen\Ebay\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetMyeBayRemindersRequestType StructType
 * Meta information extracted from the WSDL
 * - documentation: This is the base request type of the <b>GetMyeBayReminders</b> call. This call returns the total counts for My eBay Buying and/or My eBay Selling Reminders for a user.
 * @subpackage Structs
 */
class GetMyeBayRemindersRequestType extends AbstractRequestType
{
    /**
     * The BuyingReminders
     * Meta information extracted from the WSDL
     * - documentation: This container should be included if the user wishes to retrieve the counts of My eBay Buying Reminders. Counts will only be retrieved for My eBay Buying Reminders that the user received.
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\ReminderCustomizationType
     */
    public $BuyingReminders;
    /**
     * The SellingReminders
     * Meta information extracted from the WSDL
     * - documentation: This container should be included if the user wishes to retrieve the counts of My eBay Selling Reminders. Counts will only be retrieved for My eBay Selling Reminders that the user received.
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\ReminderCustomizationType
     */
    public $SellingReminders;
    /**
     * Constructor method for GetMyeBayRemindersRequestType
     * @uses GetMyeBayRemindersRequestType::setBuyingReminders()
     * @uses GetMyeBayRemindersRequestType::setSellingReminders()
     * @param \LewisLarsen\Ebay\StructType\ReminderCustomizationType $buyingReminders
     * @param \LewisLarsen\Ebay\StructType\ReminderCustomizationType $sellingReminders
     */
    public function __construct(\LewisLarsen\Ebay\StructType\ReminderCustomizationType $buyingReminders = null, \LewisLarsen\Ebay\StructType\ReminderCustomizationType $sellingReminders = null)
    {
        $this
            ->setBuyingReminders($buyingReminders)
            ->setSellingReminders($sellingReminders);
    }
    /**
     * Get BuyingReminders value
     * @return \LewisLarsen\Ebay\StructType\ReminderCustomizationType|null
     */
    public function getBuyingReminders()
    {
        return $this->BuyingReminders;
    }
    /**
     * Set BuyingReminders value
     * @param \LewisLarsen\Ebay\StructType\ReminderCustomizationType $buyingReminders
     * @return \LewisLarsen\Ebay\StructType\GetMyeBayRemindersRequestType
     */
    public function setBuyingReminders(\LewisLarsen\Ebay\StructType\ReminderCustomizationType $buyingReminders = null)
    {
        $this->BuyingReminders = $buyingReminders;
        return $this;
    }
    /**
     * Get SellingReminders value
     * @return \LewisLarsen\Ebay\StructType\ReminderCustomizationType|null
     */
    public function getSellingReminders()
    {
        return $this->SellingReminders;
    }
    /**
     * Set SellingReminders value
     * @param \LewisLarsen\Ebay\StructType\ReminderCustomizationType $sellingReminders
     * @return \LewisLarsen\Ebay\StructType\GetMyeBayRemindersRequestType
     */
    public function setSellingReminders(\LewisLarsen\Ebay\StructType\ReminderCustomizationType $sellingReminders = null)
    {
        $this->SellingReminders = $sellingReminders;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \LewisLarsen\Ebay\StructType\GetMyeBayRemindersRequestType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
