<?php

namespace LewisLarsen\Ebay\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FlatRateInsuranceRangeCostType StructType
 * Meta information extracted from the WSDL
 * - documentation: This type is deprecated, as shipping insurance is no longer applicable or supported in eBay APIs.
 * @subpackage Structs
 */
class FlatRateInsuranceRangeCostType extends AbstractStructBase
{
    /**
     * The FlatRateInsuranceRange
     * Meta information extracted from the WSDL
     * - documentation: This field is deprecated.
     * - minOccurs: 0
     * @var string
     */
    public $FlatRateInsuranceRange;
    /**
     * The InsuranceCost
     * Meta information extracted from the WSDL
     * - documentation: This field is deprecated.
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\AmountType
     */
    public $InsuranceCost;
    /**
     * The any
     * @var \DOMDocument
     */
    public $any;
    /**
     * Constructor method for FlatRateInsuranceRangeCostType
     * @uses FlatRateInsuranceRangeCostType::setFlatRateInsuranceRange()
     * @uses FlatRateInsuranceRangeCostType::setInsuranceCost()
     * @uses FlatRateInsuranceRangeCostType::setAny()
     * @param string $flatRateInsuranceRange
     * @param \LewisLarsen\Ebay\StructType\AmountType $insuranceCost
     * @param \DOMDocument $any
     */
    public function __construct($flatRateInsuranceRange = null, \LewisLarsen\Ebay\StructType\AmountType $insuranceCost = null, \DOMDocument $any = null)
    {
        $this
            ->setFlatRateInsuranceRange($flatRateInsuranceRange)
            ->setInsuranceCost($insuranceCost)
            ->setAny($any);
    }
    /**
     * Get FlatRateInsuranceRange value
     * @return string|null
     */
    public function getFlatRateInsuranceRange()
    {
        return $this->FlatRateInsuranceRange;
    }
    /**
     * Set FlatRateInsuranceRange value
     * @uses \LewisLarsen\Ebay\EnumType\FlatRateInsuranceRangeCodeType::valueIsValid()
     * @uses \LewisLarsen\Ebay\EnumType\FlatRateInsuranceRangeCodeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $flatRateInsuranceRange
     * @return \LewisLarsen\Ebay\StructType\FlatRateInsuranceRangeCostType
     */
    public function setFlatRateInsuranceRange($flatRateInsuranceRange = null)
    {
        // validation for constraint: enumeration
        if (!\LewisLarsen\Ebay\EnumType\FlatRateInsuranceRangeCodeType::valueIsValid($flatRateInsuranceRange)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \LewisLarsen\Ebay\EnumType\FlatRateInsuranceRangeCodeType', is_array($flatRateInsuranceRange) ? implode(', ', $flatRateInsuranceRange) : var_export($flatRateInsuranceRange, true), implode(', ', \LewisLarsen\Ebay\EnumType\FlatRateInsuranceRangeCodeType::getValidValues())), __LINE__);
        }
        $this->FlatRateInsuranceRange = $flatRateInsuranceRange;
        return $this;
    }
    /**
     * Get InsuranceCost value
     * @return \LewisLarsen\Ebay\StructType\AmountType|null
     */
    public function getInsuranceCost()
    {
        return $this->InsuranceCost;
    }
    /**
     * Set InsuranceCost value
     * @param \LewisLarsen\Ebay\StructType\AmountType $insuranceCost
     * @return \LewisLarsen\Ebay\StructType\FlatRateInsuranceRangeCostType
     */
    public function setInsuranceCost(\LewisLarsen\Ebay\StructType\AmountType $insuranceCost = null)
    {
        $this->InsuranceCost = $insuranceCost;
        return $this;
    }
    /**
     * Get any value
     * @uses \DOMDocument::loadXML()
     * @param bool $asString true: returns XML string, false: returns \DOMDocument
     * @return \DOMDocument|null
     */
    public function getAny($asString = true)
    {
        $domDocument = null;
        if (!empty($this->any) && !$asString) {
            $domDocument = new \DOMDocument('1.0', 'UTF-8');
            $domDocument->loadXML($this->any);
        }
        return $asString ? $this->any : $domDocument;
    }
    /**
     * Set any value
     * @uses \DOMDocument::hasChildNodes()
     * @uses \DOMDocument::saveXML()
     * @uses \DOMNode::item()
     * @param \DOMDocument $any
     * @return \LewisLarsen\Ebay\StructType\FlatRateInsuranceRangeCostType
     */
    public function setAny(\DOMDocument $any = null)
    {
        $this->any = ($any instanceof \DOMDocument) && $any->hasChildNodes() ? $any->saveXML($any->childNodes->item(0)) : $any;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \LewisLarsen\Ebay\StructType\FlatRateInsuranceRangeCostType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
