<?php

namespace LewisLarsen\Ebay\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BuyerSatisfactionDashboardType StructType
 * Meta information extracted from the WSDL
 * - documentation: Type defining the <b>BuyerSatisfaction</b> container returned in the <b>GetSellerDashboard</b> response. The <b>BuyerSatisfaction</b> container consists of the seller's buyer satisfaction rating, as well as any alerts related to
 * customer service.
 * @subpackage Structs
 */
class BuyerSatisfactionDashboardType extends AbstractStructBase
{
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - documentation: This field indicates the seller's buyer satisfaction rating. To determine this rating, eBay considers your detailed seller ratings, your overall feedback rating, and whatever buyer protection claims might exist on your account. eBay
     * uses the buyer satisfaction rating to see if you are eligible for certain rewards, or if you need additional guidance to help you give better service.
     * - minOccurs: 0
     * @var string
     */
    public $Status;
    /**
     * The Alert
     * Meta information extracted from the WSDL
     * - documentation: The <b>BuyerSatisfaction.Alert</b> container is only returned if eBay has posted one or more informational or warning messages related to the seller's buyer satisfaction rating.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\SellerDashboardAlertType[]
     */
    public $Alert;
    /**
     * The any
     * @var \DOMDocument
     */
    public $any;
    /**
     * Constructor method for BuyerSatisfactionDashboardType
     * @uses BuyerSatisfactionDashboardType::setStatus()
     * @uses BuyerSatisfactionDashboardType::setAlert()
     * @uses BuyerSatisfactionDashboardType::setAny()
     * @param string $status
     * @param \LewisLarsen\Ebay\StructType\SellerDashboardAlertType[] $alert
     * @param \DOMDocument $any
     */
    public function __construct($status = null, array $alert = array(), \DOMDocument $any = null)
    {
        $this
            ->setStatus($status)
            ->setAlert($alert)
            ->setAny($any);
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @uses \LewisLarsen\Ebay\EnumType\BuyerSatisfactionStatusCodeType::valueIsValid()
     * @uses \LewisLarsen\Ebay\EnumType\BuyerSatisfactionStatusCodeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \LewisLarsen\Ebay\StructType\BuyerSatisfactionDashboardType
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\LewisLarsen\Ebay\EnumType\BuyerSatisfactionStatusCodeType::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \LewisLarsen\Ebay\EnumType\BuyerSatisfactionStatusCodeType', is_array($status) ? implode(', ', $status) : var_export($status, true), implode(', ', \LewisLarsen\Ebay\EnumType\BuyerSatisfactionStatusCodeType::getValidValues())), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get Alert value
     * @return \LewisLarsen\Ebay\StructType\SellerDashboardAlertType[]|null
     */
    public function getAlert()
    {
        return $this->Alert;
    }
    /**
     * This method is responsible for validating the values passed to the setAlert method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAlert method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAlertForArrayConstraintsFromSetAlert(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $buyerSatisfactionDashboardTypeAlertItem) {
            // validation for constraint: itemType
            if (!$buyerSatisfactionDashboardTypeAlertItem instanceof \LewisLarsen\Ebay\StructType\SellerDashboardAlertType) {
                $invalidValues[] = is_object($buyerSatisfactionDashboardTypeAlertItem) ? get_class($buyerSatisfactionDashboardTypeAlertItem) : sprintf('%s(%s)', gettype($buyerSatisfactionDashboardTypeAlertItem), var_export($buyerSatisfactionDashboardTypeAlertItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Alert property can only contain items of type \LewisLarsen\Ebay\StructType\SellerDashboardAlertType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Alert value
     * @throws \InvalidArgumentException
     * @param \LewisLarsen\Ebay\StructType\SellerDashboardAlertType[] $alert
     * @return \LewisLarsen\Ebay\StructType\BuyerSatisfactionDashboardType
     */
    public function setAlert(array $alert = array())
    {
        // validation for constraint: array
        if ('' !== ($alertArrayErrorMessage = self::validateAlertForArrayConstraintsFromSetAlert($alert))) {
            throw new \InvalidArgumentException($alertArrayErrorMessage, __LINE__);
        }
        $this->Alert = $alert;
        return $this;
    }
    /**
     * Add item to Alert value
     * @throws \InvalidArgumentException
     * @param \LewisLarsen\Ebay\StructType\SellerDashboardAlertType $item
     * @return \LewisLarsen\Ebay\StructType\BuyerSatisfactionDashboardType
     */
    public function addToAlert(\LewisLarsen\Ebay\StructType\SellerDashboardAlertType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \LewisLarsen\Ebay\StructType\SellerDashboardAlertType) {
            throw new \InvalidArgumentException(sprintf('The Alert property can only contain items of type \LewisLarsen\Ebay\StructType\SellerDashboardAlertType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Alert[] = $item;
        return $this;
    }
    /**
     * Get any value
     * @uses \DOMDocument::loadXML()
     * @param bool $asString true: returns XML string, false: returns \DOMDocument
     * @return \DOMDocument|null
     */
    public function getAny($asString = true)
    {
        $domDocument = null;
        if (!empty($this->any) && !$asString) {
            $domDocument = new \DOMDocument('1.0', 'UTF-8');
            $domDocument->loadXML($this->any);
        }
        return $asString ? $this->any : $domDocument;
    }
    /**
     * Set any value
     * @uses \DOMDocument::hasChildNodes()
     * @uses \DOMDocument::saveXML()
     * @uses \DOMNode::item()
     * @param \DOMDocument $any
     * @return \LewisLarsen\Ebay\StructType\BuyerSatisfactionDashboardType
     */
    public function setAny(\DOMDocument $any = null)
    {
        $this->any = ($any instanceof \DOMDocument) && $any->hasChildNodes() ? $any->saveXML($any->childNodes->item(0)) : $any;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \LewisLarsen\Ebay\StructType\BuyerSatisfactionDashboardType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
